/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Pair;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.tcbj.api.dto.request.FeeGenerateReqDto;
import com.dtyunxi.tcbj.api.dto.request.LogisticStatisticReqDto;
import com.dtyunxi.tcbj.biz.service.IDailyDeliveryReportStockApportionService;
import com.dtyunxi.tcbj.biz.service.IExpressCostChargingService;
import com.dtyunxi.tcbj.biz.service.IExpressCostCommonService;
import com.dtyunxi.tcbj.biz.service.IExpressCostDetailService;
import com.dtyunxi.tcbj.biz.utils.DateTimeUtils;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.constants.DailyDeliveryFeeModuleEnum;
import com.yunxi.dg.base.center.report.dto.constants.DailyDeliveryReportCostBelongDetailCostTypeEnum;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportCostBelongDetailDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDealDetailDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportStockApportionDto;
import com.yunxi.dg.base.center.report.service.entity.IDailyDeliveryReportDealDetailService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ExpressCostCommonServiceImpl
implements IExpressCostCommonService {
    private static final Logger logger = LoggerFactory.getLogger(ExpressCostCommonServiceImpl.class);
    @Resource
    private IExpressCostDetailService expressCostDetailService;
    @Resource
    private IExpressCostChargingService expressCostChargingService;
    @Resource
    private IDailyDeliveryReportStockApportionService dailyDeliveryReportStockApportionService;
    @Resource
    private IDailyDeliveryReportDealDetailService dailyDeliveryReportDealDetailService;

    @Override
    public void generateInsurance(FeeGenerateReqDto feeGenerateReqDto) {
        logger.info("\u5feb\u9012\u8d39\u8d39\u7528\u91cd\u65b0\u751f\u6210generateInsurance\uff1a{}", (Object)JSON.toJSONString((Object)feeGenerateReqDto));
        String startTime = DateUtil.formatDateTime((Date)feeGenerateReqDto.getStartDate());
        String endTime = DateUtil.formatDateTime((Date)feeGenerateReqDto.getEndDate());
        if (feeGenerateReqDto.getIfRefreshOriginal().booleanValue()) {
            LogisticStatisticReqDto statisticReqDto = new LogisticStatisticReqDto();
            statisticReqDto.setStartTime(startTime);
            statisticReqDto.setEndTime(endTime);
            statisticReqDto.setWarehouseCodeList(feeGenerateReqDto.getOutPhysicsWarehouseCodeList());
            statisticReqDto.setLogisticCodeList(feeGenerateReqDto.getLogisticCompanyCodeList());
            statisticReqDto.setTransportTypeList(feeGenerateReqDto.getTransportTypeList());
            logger.info("\u5feb\u9012\u539f\u59cb\u660e\u7ec6\u5220\u9664\u5e76\u751f\u6210\uff1a{}", (Object)JSON.toJSONString((Object)statisticReqDto));
            this.expressCostDetailService.syncExpressCostData(statisticReqDto);
        }
        DailyDeliveryReportStockApportionDto apportionDto = new DailyDeliveryReportStockApportionDto();
        apportionDto.setBookkeepingMonth(feeGenerateReqDto.getBookkeepingMonth());
        apportionDto.setOrderShippingTimeStart(feeGenerateReqDto.getStartDate());
        apportionDto.setOrderShippingTimeEnd(feeGenerateReqDto.getEndDate());
        apportionDto.setPhysicalWarehouseCodeList(feeGenerateReqDto.getOutPhysicsWarehouseCodeList());
        apportionDto.setTransportStyleList(feeGenerateReqDto.getTransportTypeList());
        apportionDto.setShipmentEnterpriseNameList(feeGenerateReqDto.getOutPhysicsWarehouseNameList());
        apportionDto.setType(DailyDeliveryFeeModuleEnum.EXPRESS_DELIVERY.getCode());
        logger.info("\u5feb\u9012\u8d39\u80a1\u4efd\u5206\u644a\u6570\u636e\u5220\u9664\u4e0e\u751f\u6210\uff1a{}", (Object)JSON.toJSONString((Object)apportionDto));
        this.dailyDeliveryReportStockApportionService.afreshGenerate(apportionDto);
        DailyDeliveryReportDealDetailDto dealDetailDto = new DailyDeliveryReportDealDetailDto();
        dealDetailDto.setFeeModule(DailyDeliveryFeeModuleEnum.EXPRESS_DELIVERY.getCode());
        dealDetailDto.setBookkeepingMonth(feeGenerateReqDto.getBookkeepingMonth());
        logger.info("\u5feb\u9012\u8d39\u4ea4\u6613\u4f59\u91cf\u660e\u7ec6\u751f\u6210\uff1a{}", (Object)JSON.toJSONString((Object)dealDetailDto));
        this.dailyDeliveryReportDealDetailService.buildByFeeModule(dealDetailDto);
        DailyDeliveryReportStockApportionDto autoApportion = new DailyDeliveryReportStockApportionDto();
        autoApportion.setBookkeepingMonth(feeGenerateReqDto.getBookkeepingMonth());
        autoApportion.setOrderShippingTimeStart(feeGenerateReqDto.getStartDate());
        autoApportion.setOrderShippingTimeEnd(feeGenerateReqDto.getEndDate());
        autoApportion.setType(DailyDeliveryFeeModuleEnum.EXPRESS_DELIVERY.getCode());
        logger.info("\u5feb\u9012\u8d39\u81ea\u52a8\u5206\u644a\uff1a{}", (Object)JSON.toJSONString((Object)autoApportion));
        this.dailyDeliveryReportStockApportionService.autoApportion(autoApportion);
    }

    @Override
    public void generateForCostBelongDetail(DailyDeliveryReportCostBelongDetailDto dto) {
        Pair<String, String> datePair = DateTimeUtils.getByMonthStr(dto.getBookkeepingMonth());
        AssertUtil.assertNotNull(datePair, (String)"\u8bb0\u8d26\u6708\u4efd\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5904\u7406");
        LogisticStatisticReqDto statisticReqDto = new LogisticStatisticReqDto();
        statisticReqDto.setStartTime((String)datePair.getKey());
        statisticReqDto.setEndTime((String)datePair.getValue());
        statisticReqDto.setCostTypeList((List)Lists.newArrayList((Object[])new String[]{DailyDeliveryReportCostBelongDetailCostTypeEnum.ARTIFICIAL.getType(), DailyDeliveryReportCostBelongDetailCostTypeEnum.INTERNAL_DEAL.getType()}));
        statisticReqDto.setIfApportion(Integer.valueOf(1));
        statisticReqDto.setStockApportionId(dto.getStockApportionId());
        this.expressCostChargingService.generateExpressCostData(statisticReqDto);
    }
}

