/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.tcbj.api.dto.request.FeeGenerateReqDto;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticDetailChargingDto;
import com.dtyunxi.tcbj.api.dto.request.LogisticStatisticReqDto;
import com.dtyunxi.tcbj.biz.service.IDailyDeliveryReportStockApportionService;
import com.dtyunxi.tcbj.biz.service.IFinLogisticDetailChargingService;
import com.dtyunxi.tcbj.biz.service.IFinLogisticsReportService;
import com.dtyunxi.tcbj.biz.service.ILogisticCommonService;
import com.yunxi.dg.base.center.report.constants.DailyDeliveryFeeModuleEnum;
import com.yunxi.dg.base.center.report.dto.constants.DailyDeliveryReportCostBelongDetailCostTypeEnum;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDealDetailDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportStockApportionDto;
import com.yunxi.dg.base.center.report.service.entity.IDailyDeliveryReportDealDetailService;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LogisticCommonServiceImpl
implements ILogisticCommonService {
    private static final Logger logger = LoggerFactory.getLogger(LogisticCommonServiceImpl.class);
    @Resource
    private IFinLogisticsReportService finLogisticsReportService;
    @Resource
    private IFinLogisticDetailChargingService finLogisticDetailChargingService;
    @Resource
    private IDailyDeliveryReportStockApportionService dailyDeliveryReportStockApportionService;
    @Resource
    private IDailyDeliveryReportDealDetailService dailyDeliveryReportDealDetailService;

    @Override
    public void generateInsurance(FeeGenerateReqDto feeGenerateReqDto) {
        logger.info("\u7269\u6d41\u8d39\u8d39\u7528\u91cd\u65b0\u751f\u6210generateInsurance\uff1a{}", (Object)JSON.toJSONString((Object)feeGenerateReqDto));
        if (feeGenerateReqDto.getIfRefreshOriginal().booleanValue()) {
            LogisticStatisticReqDto logisticStatisticReqDto = new LogisticStatisticReqDto();
            logisticStatisticReqDto.setStartTime(DateUtil.getDateFormat((Date)feeGenerateReqDto.getStartDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            logisticStatisticReqDto.setEndTime(DateUtil.getDateFormat((Date)feeGenerateReqDto.getEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            logisticStatisticReqDto.setWarehouseCodeList(feeGenerateReqDto.getOutPhysicsWarehouseCodeList());
            logisticStatisticReqDto.setTransportTypeList(feeGenerateReqDto.getTransportTypeList());
            logisticStatisticReqDto.setLogisticCodeList(feeGenerateReqDto.getLogisticCompanyCodeList());
            logger.info("\u7269\u6d41\u539f\u59cb\u660e\u7ec6\u5220\u9664\u5e76\u751f\u6210\uff1a{}", (Object)JSON.toJSONString((Object)logisticStatisticReqDto));
            this.finLogisticsReportService.generateLogisticStatisticDataForDailyDeliveryReport(logisticStatisticReqDto);
        }
        if (feeGenerateReqDto.getIfRefreshOriginal().booleanValue()) {
            FinLogisticDetailChargingDto generalChargingReqDto = new FinLogisticDetailChargingDto();
            generalChargingReqDto.setBookkeepingDate(feeGenerateReqDto.getBookkeepingMonth());
            generalChargingReqDto.setBillType(DailyDeliveryReportCostBelongDetailCostTypeEnum.GENERAL.getType());
            logger.info("\u7269\u6d41\u8d39\u8ba1\u8d39\u660e\u7ec6\u5220\u9664\u5e76\u751f\u6210\uff08\u5e38\u89c4\u8ba1\u8d39\uff09\uff1a{}", (Object)JSON.toJSONString((Object)generalChargingReqDto));
            this.finLogisticDetailChargingService.generateLogisticDetailCharging(generalChargingReqDto);
        }
        DailyDeliveryReportStockApportionDto apportionDto = new DailyDeliveryReportStockApportionDto();
        apportionDto.setBookkeepingMonth(feeGenerateReqDto.getBookkeepingMonth());
        apportionDto.setOrderShippingTimeStart(feeGenerateReqDto.getStartDate());
        apportionDto.setOrderShippingTimeEnd(feeGenerateReqDto.getEndDate());
        apportionDto.setPhysicalWarehouseCodeList(feeGenerateReqDto.getOutPhysicsWarehouseCodeList());
        apportionDto.setTransportStyleList(feeGenerateReqDto.getTransportTypeList());
        apportionDto.setShipmentEnterpriseNameList(feeGenerateReqDto.getLogisticCompanyList());
        apportionDto.setType(DailyDeliveryFeeModuleEnum.LOGISTICS_FEE.getCode());
        logger.info("\u7269\u6d41\u8d39\u80a1\u4efd\u5206\u644a\u6570\u636e\u5220\u9664\u4e0e\u751f\u6210\uff1a{}", (Object)JSON.toJSONString((Object)apportionDto));
        this.dailyDeliveryReportStockApportionService.afreshGenerate(apportionDto);
        DailyDeliveryReportDealDetailDto dealDetailDto = new DailyDeliveryReportDealDetailDto();
        dealDetailDto.setFeeModule(DailyDeliveryFeeModuleEnum.LOGISTICS_FEE.getCode());
        dealDetailDto.setBookkeepingMonth(feeGenerateReqDto.getBookkeepingMonth());
        logger.info("\u7269\u6d41\u8d39\u4ea4\u6613\u4f59\u91cf\u660e\u7ec6\u751f\u6210\uff1a{}", (Object)JSON.toJSONString((Object)dealDetailDto));
        this.dailyDeliveryReportDealDetailService.buildByFeeModule(dealDetailDto);
        DailyDeliveryReportStockApportionDto autoApportion = new DailyDeliveryReportStockApportionDto();
        autoApportion.setBookkeepingMonth(feeGenerateReqDto.getBookkeepingMonth());
        autoApportion.setOrderShippingTimeStart(feeGenerateReqDto.getStartDate());
        autoApportion.setOrderShippingTimeEnd(feeGenerateReqDto.getEndDate());
        autoApportion.setPhysicalWarehouseCodeList(feeGenerateReqDto.getOutPhysicsWarehouseCodeList());
        autoApportion.setTransportStyleList(feeGenerateReqDto.getTransportTypeList());
        autoApportion.setShipmentEnterpriseNameList(feeGenerateReqDto.getLogisticCompanyList());
        autoApportion.setType(DailyDeliveryFeeModuleEnum.LOGISTICS_FEE.getCode());
        logger.info("\u7269\u6d41\u8d39\u81ea\u52a8\u5206\u644a\uff1a{}", (Object)JSON.toJSONString((Object)autoApportion));
        this.dailyDeliveryReportStockApportionService.autoApportion(autoApportion);
    }
}

