/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.tcbj.api.dto.request.FeeGenerateReqDto;
import com.dtyunxi.tcbj.api.dto.request.TaskQueryParamsDro;
import com.dtyunxi.tcbj.biz.service.IDailyDeliveryReportStockApportionService;
import com.dtyunxi.tcbj.biz.service.ISortingExpenseCommonService;
import com.dtyunxi.tcbj.biz.service.ISortingExpenseJobService;
import com.dtyunxi.tcbj.biz.service.ISortingExpenseService;
import com.dtyunxi.tcbj.biz.utils.DateTimeUtils;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.constants.DailyDeliveryFeeModuleEnum;
import com.yunxi.dg.base.center.report.dto.constants.DailyDeliveryReportCostBelongDetailCostTypeEnum;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportCostBelongDetailDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDealDetailDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportStockApportionDto;
import com.yunxi.dg.base.center.report.service.entity.IDailyDeliveryReportDealDetailService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SortingExpenseCommonServiceImpl
implements ISortingExpenseCommonService {
    private static final Logger logger = LoggerFactory.getLogger(SortingExpenseCommonServiceImpl.class);
    @Resource
    private ISortingExpenseService sortingExpenseService;
    @Resource
    private ISortingExpenseJobService sortingExpenseJobService;
    @Resource
    private IDailyDeliveryReportStockApportionService dailyDeliveryReportStockApportionService;
    @Resource
    private IDailyDeliveryReportDealDetailService dailyDeliveryReportDealDetailService;

    @Override
    public void generateInsurance(FeeGenerateReqDto feeGenerateReqDto) {
        logger.info("\u5206\u62e3\u8d39\u8d39\u7528\u91cd\u65b0\u751f\u6210generateInsurance\uff1a{}", (Object)JSON.toJSONString((Object)feeGenerateReqDto));
        if (feeGenerateReqDto.getIfRefreshOriginal().booleanValue()) {
            TaskQueryParamsDro queryParamsDro = new TaskQueryParamsDro();
            queryParamsDro.setStartDateStr(DateUtil.formatDateTime((Date)feeGenerateReqDto.getStartDate()));
            queryParamsDro.setEndDateStr(DateUtil.formatDateTime((Date)feeGenerateReqDto.getEndDate()));
            queryParamsDro.setOutPhysicsWarehouseCodeList(feeGenerateReqDto.getOutPhysicsWarehouseCodeList());
            logger.info("\u5206\u62e3\u539f\u59cb\u660e\u7ec6\u5220\u9664\u5e76\u751f\u6210:{}", (Object)JSON.toJSONString((Object)queryParamsDro));
            this.sortingExpenseService.executeJobNew(queryParamsDro);
        }
        if (feeGenerateReqDto.getIfRefreshOriginal().booleanValue()) {
            FeeGenerateReqDto generalGenerateBySortingFee = (FeeGenerateReqDto)BeanUtil.copyProperties((Object)feeGenerateReqDto, FeeGenerateReqDto.class, (String[])new String[0]);
            generalGenerateBySortingFee.setCostType(DailyDeliveryReportCostBelongDetailCostTypeEnum.GENERAL.getType());
            logger.info("\u5206\u62e3\u8ba1\u8d39\u660e\u7ec6\u5220\u9664\u5e76\u751f\u6210\uff08\u5e38\u89c4\u8ba1\u8d39\uff09\uff1a{}", (Object)JSON.toJSONString((Object)generalGenerateBySortingFee));
            this.sortingExpenseJobService.generateBySortingFee(generalGenerateBySortingFee, null);
        }
        DailyDeliveryReportStockApportionDto apportionDto = new DailyDeliveryReportStockApportionDto();
        apportionDto.setBookkeepingMonth(feeGenerateReqDto.getBookkeepingMonth());
        apportionDto.setOrderShippingTimeStart(feeGenerateReqDto.getStartDate());
        apportionDto.setOrderShippingTimeEnd(feeGenerateReqDto.getEndDate());
        apportionDto.setPhysicalWarehouseCodeList(feeGenerateReqDto.getOutPhysicsWarehouseCodeList());
        apportionDto.setTransportStyleList(feeGenerateReqDto.getTransportTypeList());
        apportionDto.setShipmentEnterpriseNameList(feeGenerateReqDto.getLogisticCompanyList());
        apportionDto.setType(DailyDeliveryFeeModuleEnum.SORTING_FEE.getCode());
        logger.info("\u5206\u62e3\u80a1\u4efd\u5206\u644a\u6570\u636e\u5220\u9664\u4e0e\u751f\u6210\uff1a{}", (Object)JSON.toJSONString((Object)apportionDto));
        this.dailyDeliveryReportStockApportionService.afreshGenerate(apportionDto);
        DailyDeliveryReportDealDetailDto dealDetailDto = new DailyDeliveryReportDealDetailDto();
        dealDetailDto.setFeeModule(DailyDeliveryFeeModuleEnum.SORTING_FEE.getCode());
        dealDetailDto.setBookkeepingMonth(feeGenerateReqDto.getBookkeepingMonth());
        logger.info("\u5206\u62e3\u4ea4\u6613\u4f59\u91cf\u660e\u7ec6\u751f\u6210\uff1a{}", (Object)JSON.toJSONString((Object)dealDetailDto));
        this.dailyDeliveryReportDealDetailService.buildByFeeModule(dealDetailDto);
        DailyDeliveryReportStockApportionDto autoApportion = new DailyDeliveryReportStockApportionDto();
        autoApportion.setBookkeepingMonth(feeGenerateReqDto.getBookkeepingMonth());
        autoApportion.setOrderShippingTimeStart(feeGenerateReqDto.getStartDate());
        autoApportion.setOrderShippingTimeEnd(feeGenerateReqDto.getEndDate());
        autoApportion.setType(DailyDeliveryFeeModuleEnum.SORTING_FEE.getCode());
        logger.info("\u5206\u62e3\u81ea\u52a8\u5206\u644a\uff1a{}", (Object)JSON.toJSONString((Object)autoApportion));
        this.dailyDeliveryReportStockApportionService.autoApportion(autoApportion);
        FeeGenerateReqDto internalDealGenerateReqDto = (FeeGenerateReqDto)BeanUtil.copyProperties((Object)feeGenerateReqDto, FeeGenerateReqDto.class, (String[])new String[0]);
        internalDealGenerateReqDto.setCostType(DailyDeliveryReportCostBelongDetailCostTypeEnum.INTERNAL_DEAL.getType());
        logger.info("\u5206\u62e3\u8ba1\u8d39\u660e\u7ec6\u5220\u9664\u5e76\u751f\u6210\uff08\u5185\u90e8\u4ea4\u6613\uff09\uff1a{}", (Object)JSON.toJSONString((Object)internalDealGenerateReqDto));
        this.sortingExpenseJobService.generateBySortingFee(internalDealGenerateReqDto, true);
    }

    @Override
    public void generateForCostBelongDetail(DailyDeliveryReportCostBelongDetailDto dto) {
        FeeGenerateReqDto generateReqDto = (FeeGenerateReqDto)BeanUtil.copyProperties((Object)dto, FeeGenerateReqDto.class, (String[])new String[0]);
        generateReqDto.setCostTypeList((List)Lists.newArrayList((Object[])new String[]{DailyDeliveryReportCostBelongDetailCostTypeEnum.ARTIFICIAL.getType(), DailyDeliveryReportCostBelongDetailCostTypeEnum.INTERNAL_DEAL.getType()}));
        Date startDate = generateReqDto.getStartDate();
        Date endDate = generateReqDto.getEndDate();
        if (ObjectUtil.hasNull((Object[])new Object[]{startDate, endDate})) {
            Pair<Date, Date> datePair = DateTimeUtils.getByMonth(dto.getBookkeepingMonth());
            AssertUtil.assertNotNull(datePair, (String)"\u8bb0\u8d26\u6708\u4efd\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5904\u7406");
            generateReqDto.setStartDate((Date)datePair.getKey());
            generateReqDto.setEndDate((Date)datePair.getValue());
        }
        this.sortingExpenseJobService.generateBySortingFee(generateReqDto, true);
    }
}

