/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.tcbj.api.dto.request.FeeGenerateReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumChargingReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumReqDto;
import com.dtyunxi.tcbj.biz.service.IDailyDeliveryReportStockApportionService;
import com.dtyunxi.tcbj.biz.service.IReInsuranceCommonService;
import com.dtyunxi.tcbj.biz.service.IReInsurancePremiumChargingService;
import com.dtyunxi.tcbj.biz.service.IReInsurancePremiumService;
import com.yunxi.dg.base.center.report.constants.DailyDeliveryFeeModuleEnum;
import com.yunxi.dg.base.center.report.dto.constants.DailyDeliveryReportCostBelongDetailCostTypeEnum;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDealDetailDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportStockApportionDto;
import com.yunxi.dg.base.center.report.service.entity.IDailyDeliveryReportDealDetailService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ReInsuranceCommonServiceImpl
implements IReInsuranceCommonService {
    private static final Logger logger = LoggerFactory.getLogger(ReInsuranceCommonServiceImpl.class);
    @Resource
    private IReInsurancePremiumService reInsurancePremiumService;
    @Resource
    private IReInsurancePremiumChargingService reInsurancePremiumChargingService;
    @Resource
    private IDailyDeliveryReportStockApportionService dailyDeliveryReportStockApportionService;
    @Resource
    private IDailyDeliveryReportDealDetailService dailyDeliveryReportDealDetailService;

    @Override
    public void generateInsurance(FeeGenerateReqDto feeGenerateReqDto) {
        logger.info("\u4fdd\u8d39\u8d39\u7528\u91cd\u65b0\u751f\u6210generateInsurance\uff1a{}", (Object)JSON.toJSONString((Object)feeGenerateReqDto));
        if (feeGenerateReqDto.getIfRefreshOriginal().booleanValue()) {
            ReInsurancePremiumReqDto reInsurancePremiumReqDto = new ReInsurancePremiumReqDto();
            reInsurancePremiumReqDto.setInOutTimeBegin(feeGenerateReqDto.getStartDate());
            reInsurancePremiumReqDto.setInOutTimeEnd(feeGenerateReqDto.getEndDate());
            reInsurancePremiumReqDto.setOutPhysicsWarehouseCodeList(feeGenerateReqDto.getOutPhysicsWarehouseCodeList());
            reInsurancePremiumReqDto.setShippingTypeList(feeGenerateReqDto.getTransportTypeList());
            reInsurancePremiumReqDto.setShippingCompanyList(feeGenerateReqDto.getLogisticCompanyList());
            logger.info("\u4fdd\u8d39\u539f\u59cb\u660e\u7ec6\u5220\u9664\u5e76\u751f\u6210\uff1a{}", (Object)JSON.toJSONString((Object)reInsurancePremiumReqDto));
            this.reInsurancePremiumService.generateInsurancePremiumAfterDel(reInsurancePremiumReqDto);
        }
        if (feeGenerateReqDto.getIfRefreshOriginal().booleanValue()) {
            ReInsurancePremiumChargingReqDto generalChargingReqDto = new ReInsurancePremiumChargingReqDto();
            generalChargingReqDto.setBookkeepingMonth(feeGenerateReqDto.getBookkeepingMonth());
            generalChargingReqDto.setInOutTimeBegin(feeGenerateReqDto.getStartDate());
            generalChargingReqDto.setInOutTimeEnd(feeGenerateReqDto.getEndDate());
            generalChargingReqDto.setOutPhysicsWarehouseCodeList(feeGenerateReqDto.getOutPhysicsWarehouseCodeList());
            generalChargingReqDto.setShippingTypeList(feeGenerateReqDto.getTransportTypeList());
            generalChargingReqDto.setShippingCompanyList(feeGenerateReqDto.getLogisticCompanyList());
            generalChargingReqDto.setBillType(DailyDeliveryReportCostBelongDetailCostTypeEnum.GENERAL.getType());
            logger.info("\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\u5220\u9664\u5e76\u751f\u6210\uff08\u5e38\u89c4\u8ba1\u8d39\uff09\uff1a{}", (Object)JSON.toJSONString((Object)generalChargingReqDto));
            this.reInsurancePremiumChargingService.generateInsurancePremiumCharging(generalChargingReqDto);
        }
        DailyDeliveryReportStockApportionDto apportionDto = new DailyDeliveryReportStockApportionDto();
        apportionDto.setBookkeepingMonth(feeGenerateReqDto.getBookkeepingMonth());
        apportionDto.setOrderShippingTimeStart(feeGenerateReqDto.getStartDate());
        apportionDto.setOrderShippingTimeEnd(feeGenerateReqDto.getEndDate());
        apportionDto.setPhysicalWarehouseCodeList(feeGenerateReqDto.getOutPhysicsWarehouseCodeList());
        apportionDto.setTransportStyleList(feeGenerateReqDto.getTransportTypeList());
        apportionDto.setShipmentEnterpriseNameList(feeGenerateReqDto.getLogisticCompanyList());
        apportionDto.setType(DailyDeliveryFeeModuleEnum.PREMIUM_FEE.getCode());
        logger.info("\u4fdd\u8d39\u80a1\u4efd\u5206\u644a\u6570\u636e\u5220\u9664\u4e0e\u751f\u6210\uff1a{}", (Object)JSON.toJSONString((Object)apportionDto));
        this.dailyDeliveryReportStockApportionService.afreshGenerate(apportionDto);
        DailyDeliveryReportDealDetailDto dealDetailDto = new DailyDeliveryReportDealDetailDto();
        dealDetailDto.setFeeModule(DailyDeliveryFeeModuleEnum.PREMIUM_FEE.getCode());
        dealDetailDto.setBookkeepingMonth(feeGenerateReqDto.getBookkeepingMonth());
        logger.info("\u4fdd\u8d39\u4ea4\u6613\u4f59\u91cf\u660e\u7ec6\u751f\u6210\uff1a{}", (Object)JSON.toJSONString((Object)dealDetailDto));
        this.dailyDeliveryReportDealDetailService.buildByFeeModule(dealDetailDto);
        DailyDeliveryReportStockApportionDto autoApportion = new DailyDeliveryReportStockApportionDto();
        autoApportion.setBookkeepingMonth(feeGenerateReqDto.getBookkeepingMonth());
        autoApportion.setOrderShippingTimeStart(feeGenerateReqDto.getStartDate());
        autoApportion.setOrderShippingTimeEnd(feeGenerateReqDto.getEndDate());
        autoApportion.setType(DailyDeliveryFeeModuleEnum.PREMIUM_FEE.getCode());
        logger.info("\u4fdd\u8d39\u81ea\u52a8\u5206\u644a\uff1a{}", (Object)JSON.toJSONString((Object)autoApportion));
        this.dailyDeliveryReportStockApportionService.autoApportion(autoApportion);
        ReInsurancePremiumChargingReqDto internalDealChargingReqDto = new ReInsurancePremiumChargingReqDto();
        internalDealChargingReqDto.setBookkeepingMonth(feeGenerateReqDto.getBookkeepingMonth());
        internalDealChargingReqDto.setInOutTimeBegin(feeGenerateReqDto.getStartDate());
        internalDealChargingReqDto.setInOutTimeEnd(feeGenerateReqDto.getEndDate());
        internalDealChargingReqDto.setOutPhysicsWarehouseCodeList(feeGenerateReqDto.getOutPhysicsWarehouseCodeList());
        internalDealChargingReqDto.setShippingTypeList(feeGenerateReqDto.getTransportTypeList());
        internalDealChargingReqDto.setShippingCompanyList(feeGenerateReqDto.getLogisticCompanyList());
        internalDealChargingReqDto.setBillType(DailyDeliveryReportCostBelongDetailCostTypeEnum.INTERNAL_DEAL.getType());
        logger.info("\u4fdd\u8d39\u8ba1\u8d39\u660e\u7ec6\u5220\u9664\u5e76\u751f\u6210\uff08\u5185\u90e8\u4ea4\u6613\uff09\uff1a{}", (Object)JSON.toJSONString((Object)internalDealChargingReqDto));
        this.reInsurancePremiumChargingService.generateInsurancePremiumCharging(internalDealChargingReqDto);
    }
}

