/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.tcbj.api.dto.request.CostCenterReqDto;
import com.dtyunxi.tcbj.api.dto.response.CostCenterRespDto;
import com.dtyunxi.tcbj.biz.service.ICostCenterService;
import com.dtyunxi.tcbj.dao.das.CostCenterDas;
import com.dtyunxi.tcbj.dao.eo.CostCenterEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class CostCenterServiceImpl
implements ICostCenterService {
    @Resource
    private CostCenterDas costCenterDas;

    @Override
    public Long addCostCenter(CostCenterReqDto addReqDto) {
        CostCenterEo costCenterEo = new CostCenterEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)costCenterEo);
        this.costCenterDas.insert((BaseEo)costCenterEo);
        return costCenterEo.getId();
    }

    @Override
    public void modifyCostCenter(CostCenterReqDto modifyReqDto) {
        CostCenterEo costCenterEo = new CostCenterEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)costCenterEo);
        this.costCenterDas.updateSelective((BaseEo)costCenterEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCostCenter(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.costCenterDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public CostCenterRespDto queryById(Long id) {
        CostCenterEo costCenterEo = (CostCenterEo)this.costCenterDas.selectByPrimaryKey(id);
        CostCenterRespDto costCenterRespDto = new CostCenterRespDto();
        DtoHelper.eo2Dto((BaseEo)costCenterEo, (BaseVo)costCenterRespDto);
        return costCenterRespDto;
    }

    @Override
    public PageInfo<CostCenterRespDto> queryByPage(CostCenterReqDto reqDto) {
        CostCenterEo costCenterEo = new CostCenterEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)costCenterEo);
        ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
        if (!CollectionUtils.isEmpty((Collection)reqDto.getCostCenterCodes())) {
            filters.add(SqlFilter.in((String)"costCenterCode", (Object)reqDto.getCostCenterCodes()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqDto.getCostCenterNames())) {
            filters.add(SqlFilter.in((String)"costCenterName", (Object)reqDto.getCostCenterNames()));
        }
        if (!StringUtils.isEmpty((Object)reqDto.getCostCenterName())) {
            filters.add(SqlFilter.like((String)"costCenterName", (Object)reqDto.getCostCenterName()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqDto.getWarehouseIds())) {
            filters.add(SqlFilter.in((String)"warehouseId", (Object)reqDto.getWarehouseIds()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqDto.getOrganizationIds())) {
            filters.add(SqlFilter.in((String)"organizationId", (Object)reqDto.getOrganizationIds()));
        }
        costCenterEo.setSqlFilters(filters);
        PageInfo eoPageInfo = this.costCenterDas.selectPage((BaseEo)costCenterEo, reqDto.getPageNum(), reqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CostCenterRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

