/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.request.InventoryCheckEasReqDto;
import com.dtyunxi.tcbj.api.dto.request.InventoryCheckItem;
import com.dtyunxi.tcbj.api.dto.request.InventoryCheckReqDto;
import com.dtyunxi.tcbj.api.dto.response.InventoryCheckRespDto;
import com.dtyunxi.tcbj.biz.service.IInventoryCheckService;
import com.dtyunxi.tcbj.dao.das.LogicInventoryDas;
import com.dtyunxi.tcbj.dao.eo.InventorySharedEo;
import com.dtyunxi.tcbj.dao.eo.InventorySharedItemEo;
import com.dtyunxi.tcbj.dao.eo.InventorySharedWarehouseEo;
import com.dtyunxi.tcbj.dao.eo.LogicInventoryEo;
import com.dtyunxi.tcbj.dao.eo.RelVirtualWarehouseEo;
import com.dtyunxi.tcbj.dao.mapper.InventorySharedItemMapper;
import com.dtyunxi.tcbj.dao.mapper.InventorySharedMapper;
import com.dtyunxi.tcbj.dao.mapper.InventorySharedWarehouseMapper;
import com.dtyunxi.tcbj.dao.mapper.RelVirtualWarehouseMapper;
import com.dtyunxi.yundt.cube.center.data.api.IPcpDictApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.data.api.enums.DictEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.domain.share.IDgChannelInventoryDomain;
import com.yunxi.dg.base.center.report.domain.share.IDgChannelWarehouseDomain;
import com.yunxi.dg.base.center.report.domain.share.IDgVirtualInventoryDomain;
import com.yunxi.dg.base.center.report.domain.share.IDgVirtualWarehouseDomain;
import com.yunxi.dg.base.center.report.eo.share.DgChannelInventoryEo;
import com.yunxi.dg.base.center.report.eo.share.DgChannelWarehouseEo;
import com.yunxi.dg.base.center.report.eo.share.DgVirtualInventoryEo;
import com.yunxi.dg.base.center.report.eo.share.DgVirtualWarehouseEo;
import com.yunxi.dg.base.commons.enums.EnableDisableEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InventoryCheckServiceImpl
implements IInventoryCheckService {
    private static final Logger log = LoggerFactory.getLogger(InventoryCheckServiceImpl.class);
    @Autowired
    LogicInventoryDas logicInventoryDas;
    @Autowired
    IDgVirtualInventoryDomain dgVirtualInventoryDomain;
    @Autowired
    IDgChannelInventoryDomain dgChannelInventoryDomain;
    @Autowired
    IPcpDictApi pcpDictApi;
    @Autowired
    InventorySharedWarehouseMapper inventorySharedWarehouseMapper;
    @Autowired
    InventorySharedMapper inventorySharedMapper;
    @Autowired
    RelVirtualWarehouseMapper relVirtualWarehouseMapper;
    @Autowired
    IDgVirtualWarehouseDomain dgVirtualWarehouseDomain;
    @Autowired
    IDgChannelWarehouseDomain dgChannelWarehouseDomain;
    @Autowired
    InventorySharedItemMapper inventorySharedItemMapper;

    @Override
    public InventoryCheckRespDto check(InventoryCheckReqDto checkReqDto) {
        ServiceContext.getContext().setAttachment("ignoreDataLimit", "1");
        Optional.ofNullable(checkReqDto.getLogicWarehouseCode()).filter(StringUtils::isNotBlank).ifPresent(r -> checkReqDto.getItems().forEach(i -> i.setLogicWarehouseCode(r)));
        InventoryCheckRespDto respDto = null;
        switch (checkReqDto.getCheckType()) {
            case LOGIC_AND_CHANNEL: {
                this.checkLogic(checkReqDto);
                respDto = new InventoryCheckRespDto(checkReqDto.getItems().stream().allMatch(InventoryCheckItem::isCheckResult), checkReqDto.getItems());
                if (!respDto.isCheckResult()) break;
                respDto = this.checkForShare(checkReqDto);
                break;
            }
            case CHANNEL: {
                respDto = this.checkForShare(checkReqDto);
                break;
            }
            case LOGIC: {
                this.checkLogic(checkReqDto);
                respDto = new InventoryCheckRespDto(checkReqDto.getItems().stream().allMatch(InventoryCheckItem::isCheckResult), checkReqDto.getItems());
                break;
            }
        }
        return respDto;
    }

    @Override
    public InventoryCheckRespDto checkForEas(InventoryCheckEasReqDto checkReqDto) {
        String bbCheck;
        log.info("\u5e93\u5b58\u6821\u9a8c\uff0cEAS\u53d1\u8d77\u4e13\u7528\uff1a{}", (Object)JSON.toJSONString((Object)checkReqDto));
        InventoryCheckRespDto respDto = new InventoryCheckRespDto();
        respDto.setCheckResult(true);
        if (checkReqDto.getType().getType().equals(InventoryCheckEasReqDto.Type.BB.getType())) {
            bbCheck = Optional.ofNullable(this.pcpDictApi.queryByGroupCodeAndCode("COMMON_CONFIG", DictEnum.TRANSFER_ORDER_BB.getCode()).getData()).map(DictDto::getValue).orElse("0");
            if (bbCheck.equals("0")) {
                log.info("bb\u8c03\u62e8\uff0c\u65e0\u9700\u6821\u9a8c");
                return respDto;
            }
        } else if (checkReqDto.getType().getType().equals(InventoryCheckEasReqDto.Type.BC.getType()) && (bbCheck = Optional.ofNullable(this.pcpDictApi.queryByGroupCodeAndCode("COMMON_CONFIG", DictEnum.TRANSFER_ORDER_BC.getCode()).getData()).map(DictDto::getValue).orElse("0")).equals("0")) {
            log.info("bc\u8c03\u62e8\uff0c\u65e0\u9700\u6821\u9a8c");
            return respDto;
        }
        InventoryCheckReqDto reqDto = new InventoryCheckReqDto();
        BeanUtils.copyProperties((Object)checkReqDto, (Object)reqDto);
        return this.check(reqDto);
    }

    @Override
    public InventoryCheckRespDto checkForShare(InventoryCheckReqDto checkReqDto) {
        ArrayList items = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)checkReqDto.getItems())) {
            throw new BizException("\u660e\u7ec6\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        String logicWarehouseCode = checkReqDto.getLogicWarehouseCode();
        if (StringUtils.isBlank((CharSequence)logicWarehouseCode)) {
            throw new BizException("\u903b\u8f91\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (InventoryCheckItem item : checkReqDto.getItems()) {
            InventoryCheckItem checkItem = items.stream().filter(o -> StringUtils.equals((CharSequence)o.getLongCode(), (CharSequence)item.getLongCode())).findFirst().orElse(null);
            if (null != checkItem) {
                checkItem.setTargetInventory(BigDecimalUtils.add((BigDecimal)item.getTargetInventory(), (BigDecimal)checkItem.getTargetInventory()));
                continue;
            }
            items.add(item);
        }
        List cargoCodes = items.stream().map(InventoryCheckItem::getLongCode).distinct().collect(Collectors.toList());
        List inventorySharedWarehouseEos = this.inventorySharedWarehouseMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventorySharedWarehouseEo.class).eq(InventorySharedWarehouseEo::getWarehouseCode, (Object)logicWarehouseCode)).eq(InventorySharedWarehouseEo::getStatus, (Object)CsValidFlagEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)inventorySharedWarehouseEos)) {
            log.info("checkForShare \u903b\u8f91\u4ed3\u4f9b\u8d27\u5173\u7cfb\u4e0d\u5b58\u5728");
            return new InventoryCheckRespDto(true, (List)items);
        }
        List shareCodes = inventorySharedWarehouseEos.stream().map(InventorySharedWarehouseEo::getSharedCode).distinct().collect(Collectors.toList());
        List inventorySharedEos = this.inventorySharedMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventorySharedEo.class).in(InventorySharedEo::getSharedCode, shareCodes)).eq(InventorySharedEo::getSharedStatus, (Object)CsValidFlagEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)inventorySharedEos)) {
            log.info("checkForShare \u5173\u8054\u4f9b\u8d27\u7b56\u7565\u4e0d\u5b58\u5728");
            return new InventoryCheckRespDto(true, (List)items);
        }
        List inventorySharedItemEos = this.inventorySharedItemMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventorySharedItemEo.class).in(InventorySharedItemEo::getSharedCode, shareCodes)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        List virtualWarehouseCodes = inventorySharedEos.stream().map(InventorySharedEo::getVirtualWarehouseCode).distinct().collect(Collectors.toList());
        List virtualWarehouseEos = this.dgVirtualWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DgVirtualWarehouseEo.class).in(DgVirtualWarehouseEo::getWarehouseCode, virtualWarehouseCodes)).eq(DgVirtualWarehouseEo::getWarehouseStatus, (Object)CsValidFlagEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)virtualWarehouseEos)) {
            log.info("checkForShare \u6ca1\u6709\u6709\u6548\u4f9b\u8d27\u4ed3");
            return new InventoryCheckRespDto(true, (List)items);
        }
        ServiceContext.getContext().setAttachment("data_limit_authority_selector_ignore", "data_limit_authority_selector_ignore");
        List virtualInventoryEos = this.dgVirtualInventoryDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DgVirtualInventoryEo.class).in(DgVirtualInventoryEo::getWarehouseCode, virtualWarehouseCodes)).in(DgVirtualInventoryEo::getSkuCode, cargoCodes));
        if (CollectionUtils.isEmpty((Collection)virtualInventoryEos)) {
            log.info("checkForShare \u4f9b\u8d27\u4ed3\u5173\u8054\u5e93\u5b58\u4fe1\u606f\u4e0d\u5b58\u5728");
            throw new BizException("\u4f9b\u8d27\u4ed3\u5173\u8054\u5e93\u5b58\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        boolean checkResult = true;
        for (InventoryCheckItem item : items) {
            List sharedCargoCodes;
            List filterShareCodes = inventorySharedWarehouseEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)logicWarehouseCode)).map(InventorySharedWarehouseEo::getSharedCode).distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(filterShareCodes)) {
                item.setCheckResult(true);
                continue;
            }
            List filterInventorySharedItemEos = inventorySharedItemEos.stream().filter(o -> filterShareCodes.contains(o.getSharedCode())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(filterInventorySharedItemEos) && !(sharedCargoCodes = filterInventorySharedItemEos.stream().map(InventorySharedItemEo::getSkuCode).distinct().collect(Collectors.toList())).contains(item.getLongCode())) {
                item.setCheckResult(true);
                continue;
            }
            List filterVirtualWarehouseCodes = inventorySharedEos.stream().filter(o -> filterShareCodes.contains(o.getSharedCode())).map(InventorySharedEo::getVirtualWarehouseCode).distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(filterVirtualWarehouseCodes)) {
                item.setCheckResult(true);
                continue;
            }
            List filterVirtualInventoryEos = virtualInventoryEos.stream().filter(o -> filterVirtualWarehouseCodes.contains(o.getWarehouseCode()) && StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)item.getLongCode())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(filterVirtualInventoryEos)) {
                item.setCheckResult(false);
                item.setCheckReason(String.format("SKU\uff1a%s\uff0c\u4f9b\u8d27\u4ed3\uff1a%s\uff0c\u5e93\u5b58\u4fe1\u606f\u4e0d\u5b58\u5728", item.getLongCode(), filterVirtualWarehouseCodes.get(0)));
                continue;
            }
            BigDecimal checkVirtualInventory = BigDecimal.ZERO;
            for (DgVirtualInventoryEo v : filterVirtualInventoryEos) {
                checkVirtualInventory = BigDecimalUtils.add((BigDecimal)checkVirtualInventory, (BigDecimal)v.getAvailable());
            }
            log.info("virtual check cargoCode: {}, inventory: {}, target: {}", new Object[]{item.getLongCode(), checkVirtualInventory, item.getTargetInventory()});
            if (!BigDecimalUtils.gt((BigDecimal)item.getTargetInventory(), (BigDecimal)checkVirtualInventory).booleanValue()) continue;
            item.setCheckResult(false);
            item.setCheckReason(String.format("%s \u660e\u7ec6\u6240\u9700%s, \u4f9b\u8d27\u4ed3 %s, \u53ef\u7528\u5e93\u5b58 %s", item.getLongCode(), item.getTargetInventory(), filterVirtualWarehouseCodes.get(0), checkVirtualInventory.longValue()));
            checkResult = false;
        }
        if (!checkResult) {
            log.info("virtual \u6821\u9a8c\u7ed3\u679c\u660e\u7ec6\u9879: {}", (Object)JSON.toJSONString((Object)items));
            return new InventoryCheckRespDto(false, (List)items);
        }
        List virtualWarehouseIds = virtualWarehouseEos.stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
        List relVirtualWarehouseEos = this.relVirtualWarehouseMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(RelVirtualWarehouseEo.class).in(RelVirtualWarehouseEo::getVirtualWarehouseId, virtualWarehouseIds)).eq(RelVirtualWarehouseEo::getValidFlag, (Object)CsValidFlagEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isNotEmpty((Collection)relVirtualWarehouseEos)) {
            List channelWarehouseIds = relVirtualWarehouseEos.stream().map(RelVirtualWarehouseEo::getChannelWarehouseId).distinct().collect(Collectors.toList());
            List channelWarehouseEos = this.dgChannelWarehouseDomain.selectByIds(channelWarehouseIds);
            List channelInventoryEos = this.dgChannelInventoryDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DgChannelInventoryEo.class).in(DgChannelInventoryEo::getWarehouseId, channelWarehouseIds)).in(DgChannelInventoryEo::getSkuCode, cargoCodes));
            if (CollectionUtils.isEmpty((Collection)channelInventoryEos)) {
                log.info("checkForShare \u6e20\u9053\u4ed3\u5173\u8054\u5e93\u5b58\u4fe1\u606f\u4e0d\u5b58\u5728");
                throw new BizException("\u6e20\u9053\u4ed3\u5173\u8054\u5e93\u5b58\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            block3: for (InventoryCheckItem item : items) {
                List sharedCargoCodes;
                List filterShareCodes = inventorySharedWarehouseEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)logicWarehouseCode)).map(InventorySharedWarehouseEo::getSharedCode).distinct().collect(Collectors.toList());
                if (CollectionUtils.isEmpty(filterShareCodes)) {
                    item.setCheckResult(true);
                    continue;
                }
                List filterInventorySharedItemEos = inventorySharedItemEos.stream().filter(o -> filterShareCodes.contains(o.getSharedCode())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(filterInventorySharedItemEos) && !(sharedCargoCodes = filterInventorySharedItemEos.stream().map(InventorySharedItemEo::getSkuCode).distinct().collect(Collectors.toList())).contains(item.getLongCode())) {
                    item.setCheckResult(true);
                    continue;
                }
                List filterVirtualWarehouseCodes = inventorySharedEos.stream().filter(o -> filterShareCodes.contains(o.getSharedCode())).map(InventorySharedEo::getVirtualWarehouseCode).distinct().collect(Collectors.toList());
                if (CollectionUtils.isEmpty(filterVirtualWarehouseCodes)) {
                    item.setCheckResult(true);
                    continue;
                }
                List filterVirtualInventoryEos = virtualInventoryEos.stream().filter(o -> filterVirtualWarehouseCodes.contains(o.getWarehouseCode()) && StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)item.getLongCode())).collect(Collectors.toList());
                List filterVirtualWarehouseIds = filterVirtualInventoryEos.stream().map(DgVirtualInventoryEo::getWarehouseId).distinct().collect(Collectors.toList());
                List filterChannelWarehouseIds = relVirtualWarehouseEos.stream().filter(o -> filterVirtualWarehouseIds.contains(o.getVirtualWarehouseId())).map(RelVirtualWarehouseEo::getChannelWarehouseId).distinct().collect(Collectors.toList());
                List filterChannelInventoryEos = channelInventoryEos.stream().filter(o -> filterChannelWarehouseIds.contains(o.getWarehouseId()) && StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)item.getLongCode())).collect(Collectors.toList());
                if (!CollectionUtils.isNotEmpty(filterChannelInventoryEos)) continue;
                for (DgChannelInventoryEo channelInventoryEo : filterChannelInventoryEos) {
                    DgChannelWarehouseEo channelWarehouseEo = channelWarehouseEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)channelInventoryEo.getWarehouseCode())).findFirst().orElse(null);
                    if (null == channelWarehouseEo || CsValidFlagEnum.DISABLE.getCode().equals(channelWarehouseEo.getWarehouseStatus())) continue;
                    log.info("channel check cargoCode: {}, inventory: {}, target: {}", new Object[]{item.getLongCode(), channelInventoryEo.getAvailable(), item.getTargetInventory()});
                    if (!BigDecimalUtils.gt((BigDecimal)item.getTargetInventory(), (BigDecimal)channelInventoryEo.getAvailable()).booleanValue()) continue;
                    item.setCheckResult(false);
                    item.setCheckReason(String.format("%s \u660e\u7ec6\u6240\u9700%s, \u6e20\u9053\u4ed3 %s, \u53ef\u7528\u5e93\u5b58 %s", item.getLongCode(), item.getTargetInventory(), channelInventoryEo.getWarehouseCode(), channelInventoryEo.getAvailable().longValue()));
                    continue block3;
                }
            }
        }
        log.info("channel \u6821\u9a8c\u7ed3\u679c\u660e\u7ec6\u9879: {}", (Object)JSON.toJSONString((Object)items));
        InventoryCheckRespDto inventoryCheckRespDto = new InventoryCheckRespDto(items.stream().allMatch(InventoryCheckItem::isCheckResult), (List)items);
        log.info("\u6821\u9a8c\u7ed3\u679c: {}", (Object)JSON.toJSONString((Object)inventoryCheckRespDto));
        return inventoryCheckRespDto;
    }

    @Override
    public InventoryCheckRespDto batchCheckForShare(InventoryCheckReqDto checkReqDto) {
        List items = checkReqDto.getItems();
        if (CollectionUtils.isEmpty((Collection)items)) {
            throw new BizException("\u68c0\u67e5\u5e93\u5b58\u5b50\u9879\u4e3a\u7a7a");
        }
        List logicWarehouseCodes = items.stream().map(InventoryCheckItem::getLogicWarehouseCode).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(logicWarehouseCodes)) {
            throw new BizException("\u68c0\u67e5\u5e93\u5b58\u5b50\u9879\u4e2d\uff0c\u4e0d\u5b58\u5728\u6709\u6548\u903b\u8f91\u4ed3\u7f16\u7801");
        }
        List cargoCodes = items.stream().map(InventoryCheckItem::getLongCode).distinct().collect(Collectors.toList());
        List inventorySharedWarehouseEos = this.inventorySharedWarehouseMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventorySharedWarehouseEo.class).in(InventorySharedWarehouseEo::getWarehouseCode, logicWarehouseCodes)).eq(InventorySharedWarehouseEo::getStatus, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)inventorySharedWarehouseEos)) {
            log.info("checkForShare \u903b\u8f91\u4ed3\u4f9b\u8d27\u5173\u7cfb\u4e0d\u5b58\u5728");
            return new InventoryCheckRespDto(true, items);
        }
        List shareCodes = inventorySharedWarehouseEos.stream().map(InventorySharedWarehouseEo::getSharedCode).distinct().collect(Collectors.toList());
        List inventorySharedEos = this.inventorySharedMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventorySharedEo.class).in(InventorySharedEo::getSharedCode, shareCodes)).eq(InventorySharedEo::getSharedStatus, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)inventorySharedEos)) {
            log.info("checkForShare \u5173\u8054\u4f9b\u8d27\u7b56\u7565\u4e0d\u5b58\u5728");
            return new InventoryCheckRespDto(true, items);
        }
        List virtualWarehouseCodes = inventorySharedEos.stream().map(InventorySharedEo::getVirtualWarehouseCode).distinct().collect(Collectors.toList());
        List virtualInventoryEos = this.dgVirtualInventoryDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DgVirtualInventoryEo.class).in(DgVirtualInventoryEo::getWarehouseCode, virtualWarehouseCodes)).in(DgVirtualInventoryEo::getSkuCode, cargoCodes));
        if (CollectionUtils.isEmpty((Collection)virtualInventoryEos)) {
            log.info("checkForShare \u4f9b\u8d27\u4ed3\u5173\u8054\u5e93\u5b58\u4fe1\u606f\u4e0d\u5b58\u5728");
            throw new BizException("\u4f9b\u8d27\u4ed3\u5173\u8054\u5e93\u5b58\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        ArrayList filterItems = Lists.newArrayList();
        for (InventoryCheckItem item : items) {
            String logicWarehouseCode = item.getLogicWarehouseCode();
            InventorySharedWarehouseEo inventorySharedWarehouseEo = inventorySharedWarehouseEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)logicWarehouseCode)).findFirst().orElse(null);
            if (null == inventorySharedWarehouseEo) {
                log.info("checkForShare \u903b\u8f91\u4ed3\u4f9b[{}]\u8d27\u5173\u7cfb\u4e0d\u5b58\u5728", (Object)logicWarehouseCode);
                continue;
            }
            InventorySharedEo inventorySharedEo = inventorySharedEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getSharedCode(), (CharSequence)inventorySharedWarehouseEo.getSharedCode())).findFirst().orElse(null);
            if (null == inventorySharedEo) {
                log.info("checkForShare \u5173\u8054\u4f9b\u8d27\u7b56\u7565[{}]\u4e0d\u5b58\u5728", (Object)inventorySharedWarehouseEo.getSharedCode());
                continue;
            }
            item.setVirtualWarehouseCode(inventorySharedEo.getVirtualWarehouseCode());
            DgVirtualInventoryEo virtualInventoryEo = virtualInventoryEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)inventorySharedEo.getVirtualWarehouseCode()) && StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)item.getLongCode())).findFirst().orElse(null);
            if (null == virtualInventoryEo) {
                item.setCheckResult(false);
                item.setCheckReason(String.format("\u4f9b\u8d27\u4ed3[%s]\u5173\u8054\u5e93\u5b58\u4fe1\u606f\u4e0d\u5b58\u5728", inventorySharedEo.getVirtualWarehouseCode()));
                item.setCurInventory(BigDecimal.ZERO);
            } else {
                item.setCurInventory(BigDecimalUtils.check((BigDecimal)virtualInventoryEo.getAvailable()));
            }
            filterItems.add(item);
        }
        for (DgVirtualInventoryEo virtualInventoryEo : virtualInventoryEos) {
            BigDecimal sumNum = BigDecimal.ZERO;
            for (InventoryCheckItem filterItem : filterItems) {
                if (!StringUtils.equals((CharSequence)virtualInventoryEo.getWarehouseCode(), (CharSequence)filterItem.getVirtualWarehouseCode()) || !StringUtils.equals((CharSequence)virtualInventoryEo.getSkuCode(), (CharSequence)filterItem.getLongCode())) continue;
                sumNum = BigDecimalUtils.add((BigDecimal)sumNum, (BigDecimal)filterItem.getTargetInventory());
            }
            if (BigDecimalUtils.eqZero((BigDecimal)sumNum).booleanValue() || !BigDecimalUtils.lt((BigDecimal)virtualInventoryEo.getAvailable(), (BigDecimal)sumNum).booleanValue()) continue;
            for (InventoryCheckItem filterItem : filterItems) {
                if (!StringUtils.equals((CharSequence)virtualInventoryEo.getWarehouseCode(), (CharSequence)filterItem.getVirtualWarehouseCode()) || !StringUtils.equals((CharSequence)virtualInventoryEo.getSkuCode(), (CharSequence)filterItem.getLongCode())) continue;
                filterItem.setCheckResult(false);
                filterItem.setCheckReason(String.format("%s \u660e\u7ec6\u6240\u9700%s, \u4f9b\u8d27\u4ed3 %s, \u53ef\u7528\u5e93\u5b58 %s", filterItem.getLongCode(), filterItem.getTargetInventory(), virtualInventoryEo.getWarehouseCode(), virtualInventoryEo.getAvailable()));
            }
        }
        log.info("batchCheckForShare virtual \u6821\u9a8c\u7ed3\u679c\u660e\u7ec6\u9879: {}", (Object)JSON.toJSONString((Object)items));
        InventoryCheckRespDto inventoryCheckRespDto = new InventoryCheckRespDto(items.stream().allMatch(InventoryCheckItem::isCheckResult), items);
        log.info("virtual \u6821\u9a8c\u7ed3\u679c: {}", (Object)JSON.toJSONString((Object)inventoryCheckRespDto));
        if (!inventoryCheckRespDto.isCheckResult()) {
            return inventoryCheckRespDto;
        }
        List virtualWarehouseIds = virtualInventoryEos.stream().map(DgVirtualInventoryEo::getWarehouseId).distinct().collect(Collectors.toList());
        List relVirtualWarehouseEos = this.relVirtualWarehouseMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(RelVirtualWarehouseEo.class).in(RelVirtualWarehouseEo::getVirtualWarehouseId, virtualWarehouseIds)).eq(RelVirtualWarehouseEo::getValidFlag, (Object)CsValidFlagEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isNotEmpty((Collection)relVirtualWarehouseEos)) {
            List channelWarehouseIds = relVirtualWarehouseEos.stream().map(RelVirtualWarehouseEo::getChannelWarehouseId).distinct().collect(Collectors.toList());
            List virtualWarehouseEos = this.dgVirtualWarehouseDomain.selectByIds(virtualWarehouseIds);
            List channelWarehouseEos = this.dgChannelWarehouseDomain.selectByIds(channelWarehouseIds);
            List channelInventoryEos = this.dgChannelInventoryDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DgChannelInventoryEo.class).in(DgChannelInventoryEo::getWarehouseId, channelWarehouseIds)).in(DgChannelInventoryEo::getSkuCode, cargoCodes));
            if (CollectionUtils.isEmpty((Collection)channelInventoryEos)) {
                log.info("checkForShare \u6e20\u9053\u4ed3\u5173\u8054\u5e93\u5b58\u4fe1\u606f\u4e0d\u5b58\u5728");
                throw new BizException("\u6e20\u9053\u4ed3\u5173\u8054\u5e93\u5b58\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            ArrayList filterCheckChannelItems = Lists.newArrayList();
            for (InventoryCheckItem item : filterItems) {
                String itemVirtualWarehouseCode = item.getVirtualWarehouseCode();
                if (StringUtils.isEmpty((CharSequence)itemVirtualWarehouseCode)) {
                    log.info("\u68c0\u67e5\u9879\u4f9b\u8d27\u4ed3\u7f16\u7801\u4e3a\u7a7a");
                    continue;
                }
                DgVirtualWarehouseEo virtualWarehouseEo = virtualWarehouseEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)itemVirtualWarehouseCode)).findFirst().orElse(null);
                if (null == virtualWarehouseEo) {
                    log.info("\u68c0\u67e5\u9879\u4f9b\u8d27\u4ed3\u7f16\u7801\u6ca1\u6709\u6709\u6548\u4f9b\u8d27\u4ed3\u4fe1\u606f");
                    continue;
                }
                List filterRelVirtualWarehouseEos = relVirtualWarehouseEos.stream().filter(o -> Objects.equals(o.getVirtualWarehouseId(), virtualWarehouseEo.getId())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(filterRelVirtualWarehouseEos)) {
                    log.info("\u68c0\u67e5\u9879\u4f9b\u8d27\u4ed3\u7f16\u7801\u6ca1\u6709\u6709\u6548\u4f9b\u8d27\u4ed3->\u6e20\u9053\u4ed3\u5173\u7cfb");
                    continue;
                }
                List filterChannelWarehouseIds = filterRelVirtualWarehouseEos.stream().map(RelVirtualWarehouseEo::getChannelWarehouseId).distinct().collect(Collectors.toList());
                List filterChannelWarehouseEos = channelWarehouseEos.stream().filter(o -> filterChannelWarehouseIds.contains(o.getId())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(filterChannelWarehouseEos)) {
                    log.info("\u68c0\u67e5\u9879\u4f9b\u8d27\u4ed3\u7f16\u7801\u6ca1\u6709\u6709\u6548\u6e20\u9053\u4ed3\u4fe1\u606f");
                    continue;
                }
                List filterChannelWarehouseCodes = filterChannelWarehouseEos.stream().map(DgChannelWarehouseEo::getWarehouseCode).distinct().collect(Collectors.toList());
                item.setChannelWarehouseCodes(filterChannelWarehouseCodes);
                filterCheckChannelItems.add(item);
            }
            for (DgChannelInventoryEo channelInventoryEo : channelInventoryEos) {
                BigDecimal sumNum = BigDecimal.ZERO;
                for (InventoryCheckItem filterItem : filterCheckChannelItems) {
                    if (CollectionUtils.isEmpty((Collection)filterItem.getChannelWarehouseCodes()) || !filterItem.getChannelWarehouseCodes().contains(channelInventoryEo.getWarehouseCode()) || !StringUtils.equals((CharSequence)channelInventoryEo.getSkuCode(), (CharSequence)filterItem.getLongCode())) continue;
                    sumNum = BigDecimalUtils.add((BigDecimal)sumNum, (BigDecimal)filterItem.getTargetInventory());
                }
                if (BigDecimalUtils.eqZero((BigDecimal)sumNum).booleanValue() || !BigDecimalUtils.lt((BigDecimal)channelInventoryEo.getAvailable(), (BigDecimal)sumNum).booleanValue()) continue;
                for (InventoryCheckItem filterItem : filterCheckChannelItems) {
                    if (!filterItem.getChannelWarehouseCodes().contains(channelInventoryEo.getWarehouseCode()) || !StringUtils.equals((CharSequence)channelInventoryEo.getSkuCode(), (CharSequence)filterItem.getLongCode())) continue;
                    filterItem.setCheckResult(false);
                    String checkReason = "";
                    if (StringUtils.isNotBlank((CharSequence)filterItem.getCheckReason())) {
                        checkReason = filterItem.getCheckReason() + ";";
                    }
                    filterItem.setCheckReason(checkReason + String.format("%s \u660e\u7ec6\u6240\u9700%s, \u6e20\u9053\u4ed3 %s, \u53ef\u7528\u5e93\u5b58 %s", filterItem.getLongCode(), filterItem.getTargetInventory(), channelInventoryEo.getWarehouseCode(), channelInventoryEo.getAvailable()));
                }
            }
        }
        log.info("batchCheckForShare channel \u6821\u9a8c\u7ed3\u679c\u660e\u7ec6\u9879: {}", (Object)JSON.toJSONString((Object)items));
        inventoryCheckRespDto = new InventoryCheckRespDto(items.stream().allMatch(InventoryCheckItem::isCheckResult), items);
        log.info("channel \u6821\u9a8c\u7ed3\u679c: {}", (Object)JSON.toJSONString((Object)inventoryCheckRespDto));
        return inventoryCheckRespDto;
    }

    private void checkLogic(InventoryCheckReqDto checkReqDto) {
        List logicWarehouseCodes = checkReqDto.getItems().stream().map(InventoryCheckItem::getLogicWarehouseCode).distinct().collect(Collectors.toList());
        List skuCodes = checkReqDto.getItems().stream().map(InventoryCheckItem::getLongCode).distinct().collect(Collectors.toList());
        List batches = checkReqDto.getItems().stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getBatch())).map(InventoryCheckItem::getBatch).distinct().collect(Collectors.toList());
        ExtQueryChainWrapper filter = (ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicInventoryDas.filter().select(new String[]{"warehouse_code", "sku_code", "batch", "available"}).in((Object)"warehouse_code", logicWarehouseCodes)).in((Object)"sku_code", skuCodes)).in(CollectionUtils.isNotEmpty(batches), (Object)"batch", batches)).eq((Object)"dr", (Object)YesNoHelper.NO);
        List list = filter.list();
        this.compareLogic(list, checkReqDto.getItems());
    }

    private void compareLogic(List<LogicInventoryEo> list, List<InventoryCheckItem> items) {
        for (InventoryCheckItem item : items) {
            BigDecimal sumNum = BigDecimal.ZERO;
            for (LogicInventoryEo i : list) {
                if (!StringUtils.isBlank((CharSequence)item.getBatch()) && (!StringUtils.equals((CharSequence)i.getBatch(), (CharSequence)item.getBatch()) || !StringUtils.equals((CharSequence)i.getWarehouseCode(), (CharSequence)item.getLogicWarehouseCode()) || !StringUtils.equals((CharSequence)i.getSkuCode(), (CharSequence)item.getLongCode()))) continue;
                sumNum = BigDecimalUtils.add((BigDecimal)sumNum, (BigDecimal)i.getAvailable());
            }
            item.setCurInventory(sumNum);
            if (!BigDecimalUtils.lt((BigDecimal)sumNum, (BigDecimal)item.getTargetInventory()).booleanValue()) continue;
            item.setCheckReason(this.getMsg(item));
            item.setCheckResult(false);
        }
    }

    private String getMsg(InventoryCheckItem item) {
        String msg;
        if (StringUtils.isNotBlank((CharSequence)item.getBatch())) {
            String batchMsg = "%s \u6279\u6b21 %s,\u660e\u7ec6\u6240\u9700%s, \u903b\u8f91\u4ed3%s \u53ef\u7528\u5e93\u5b58 %s";
            msg = String.format(batchMsg, item.getLongCode(), item.getBatch(), item.getTargetInventory(), item.getLogicWarehouseCode(), item.getCurInventory());
        } else {
            String MSG = "%s \u660e\u7ec6\u6240\u9700%s, %s \u53ef\u7528\u5e93\u5b58 %s";
            msg = String.format(MSG, item.getLongCode(), item.getTargetInventory(), item.getLogicWarehouseCode(), item.getCurInventory());
        }
        return msg;
    }
}

