/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.request.ConsignmentOrderReqDto;
import com.dtyunxi.tcbj.api.dto.response.ConsignmentOrderQueryVo;
import com.dtyunxi.tcbj.api.dto.response.ConsignmentOrderReportReDto;
import com.dtyunxi.tcbj.api.dto.response.ConsignmentOrderReportRespDto;
import com.dtyunxi.tcbj.api.dto.response.ConsignmentOrderRespDto;
import com.dtyunxi.tcbj.biz.service.IConsignmentOrderService;
import com.dtyunxi.tcbj.dao.das.ConsignmentOrderAddressDas;
import com.dtyunxi.tcbj.dao.das.ConsignmentOrderDas;
import com.dtyunxi.tcbj.dao.eo.ConsignmentOrderAddressEo;
import com.dtyunxi.tcbj.dao.eo.ConsignmentOrderDeliveryInfoEo;
import com.dtyunxi.tcbj.dao.eo.ConsignmentOrderEo;
import com.dtyunxi.tcbj.dao.mapper.ConsignmentOrderDeliveryInfoMapper;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.ConsignmentOrderDeliveryInfoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.constant.ConsignmentConstant;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConsignmentOrderServiceImpl
implements IConsignmentOrderService {
    @Resource
    private ConsignmentOrderDas consignmentOrderDas;
    @Resource
    private ConsignmentOrderAddressDas consignmentOrderAddressDas;
    @Autowired
    ConsignmentOrderDeliveryInfoMapper consignmentOrderDeliveryInfoMapper;

    @Override
    public Long addConsignmentOrder(ConsignmentOrderReqDto addReqDto) {
        ConsignmentOrderEo consignmentOrderEo = new ConsignmentOrderEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)consignmentOrderEo);
        this.consignmentOrderDas.insert((BaseEo)consignmentOrderEo);
        return consignmentOrderEo.getId();
    }

    @Override
    public void modifyConsignmentOrder(ConsignmentOrderReqDto modifyReqDto) {
        ConsignmentOrderEo consignmentOrderEo = new ConsignmentOrderEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)consignmentOrderEo);
        this.consignmentOrderDas.updateSelective((BaseEo)consignmentOrderEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeConsignmentOrder(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.consignmentOrderDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ConsignmentOrderRespDto queryById(Long id) {
        ConsignmentOrderEo consignmentOrderEo = (ConsignmentOrderEo)this.consignmentOrderDas.selectByPrimaryKey(id);
        ConsignmentOrderRespDto consignmentOrderRespDto = new ConsignmentOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)consignmentOrderEo, (BaseVo)consignmentOrderRespDto);
        return consignmentOrderRespDto;
    }

    @Override
    public PageInfo<ConsignmentOrderRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ConsignmentOrderReqDto consignmentOrderReqDto = (ConsignmentOrderReqDto)JSON.parseObject((String)filter, ConsignmentOrderReqDto.class);
        ConsignmentOrderEo consignmentOrderEo = new ConsignmentOrderEo();
        DtoHelper.dto2Eo((BaseVo)consignmentOrderReqDto, (BaseEo)consignmentOrderEo);
        PageInfo eoPageInfo = this.consignmentOrderDas.selectPage((BaseEo)consignmentOrderEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ConsignmentOrderRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<ConsignmentOrderReportRespDto> queryWaybillListPage(ConsignmentOrderReportReDto dto) {
        List transferConsignmentOrderEos;
        List consignmentNoList;
        if (StringUtils.isNotBlank((CharSequence)dto.getPhysicsWarehouseName())) {
            List addressEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.consignmentOrderAddressDas.filter().like((Object)"physics_warehouse_name", (Object)dto.getPhysicsWarehouseName())).eq((Object)"address_type", (Object)"delivery")).list();
            if (CollectionUtil.isNotEmpty((Collection)addressEos)) {
                consignmentNoList = addressEos.stream().map(ConsignmentOrderAddressEo::getConsignmentNo).collect(Collectors.toList());
                dto.setConsignmentNoList(consignmentNoList);
            } else {
                return new PageInfo();
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getTransportPhysicsWarehouseName())) {
            List physicsEos = ((ExtQueryChainWrapper)this.consignmentOrderDas.filter().like((Object)"physics_warehouse_name", (Object)dto.getTransportPhysicsWarehouseName())).list();
            if (CollectionUtil.isNotEmpty((Collection)physicsEos)) {
                consignmentNoList = physicsEos.stream().map(ConsignmentOrderEo::getConsignmentNo).collect(Collectors.toList());
                dto.setTransferConsignmentNoList(consignmentNoList);
            } else {
                return new PageInfo();
            }
        }
        PageInfo pageInfo = this.consignmentOrderDas.queryWaybillListPage(dto);
        List consignmentNos = pageInfo.getList().stream().map(ConsignmentOrderQueryVo::getConsignmentNo).collect(Collectors.toList());
        List transferConsignmentNos = pageInfo.getList().stream().map(ConsignmentOrderQueryVo::getTransferConsignmentNo).collect(Collectors.toList());
        HashMap transferEoMap = new HashMap();
        HashMap deliveryAddressEoMap = new HashMap();
        HashMap receiveAddressEoMap = new HashMap();
        if (CollectionUtil.isNotEmpty(consignmentNos)) {
            Map orderAddressEoMap;
            List deliveryEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.consignmentOrderAddressDas.filter().in((Object)"consignment_no", consignmentNos)).eq((Object)"address_type", (Object)"delivery")).list();
            List receiveEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.consignmentOrderAddressDas.filter().in((Object)"consignment_no", consignmentNos)).eq((Object)"address_type", (Object)"receive")).list();
            if (CollectionUtil.isNotEmpty((Collection)deliveryEoList)) {
                orderAddressEoMap = deliveryEoList.stream().collect(Collectors.toMap(ConsignmentOrderAddressEo::getConsignmentNo, Function.identity(), (k1, k2) -> k1));
                deliveryAddressEoMap.putAll(orderAddressEoMap);
            }
            if (CollectionUtil.isNotEmpty((Collection)receiveEoList)) {
                orderAddressEoMap = receiveEoList.stream().collect(Collectors.toMap(ConsignmentOrderAddressEo::getConsignmentNo, Function.identity(), (k1, k2) -> k1));
                receiveAddressEoMap.putAll(orderAddressEoMap);
            }
        }
        if (CollectionUtil.isNotEmpty(transferConsignmentNos) && CollectionUtil.isNotEmpty((Collection)(transferConsignmentOrderEos = ((ExtQueryChainWrapper)this.consignmentOrderDas.filter().in((Object)"consignment_no", transferConsignmentNos)).list()))) {
            Map orderEoMap = transferConsignmentOrderEos.stream().collect(Collectors.toMap(ConsignmentOrderEo::getConsignmentNo, Function.identity(), (k1, k2) -> k1));
            transferEoMap.putAll(orderEoMap);
        }
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List dtoList = pageInfo.getList().stream().map(o -> {
            StringBuilder stringBuilder;
            ConsignmentOrderReportRespDto vo = new ConsignmentOrderReportRespDto();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            if (StringUtils.isNotBlank((CharSequence)o.getTransferConsignmentNo())) {
                vo.setIfTransport("\u662f");
            } else {
                vo.setIfTransport("\u5426");
            }
            if (o.getConsignmentType() != null) {
                vo.setConsignmentTypeName((String)ConsignmentConstant.CONSIGNMENT_TYPE.valueMap.get(o.getConsignmentType()));
            }
            if (o.getOrderStatus() != null) {
                vo.setOrderStatusName((String)ConsignmentConstant.ORDER_STATUS.valueMap.get(o.getOrderStatus()));
            }
            if (deliveryAddressEoMap.containsKey(o.getConsignmentNo())) {
                ConsignmentOrderAddressEo addressEo = (ConsignmentOrderAddressEo)deliveryAddressEoMap.get(o.getConsignmentNo());
                vo.setPhysicsWarehouseName(addressEo.getPhysicsWarehouseName());
                vo.setPhysicsWarehouseCode(addressEo.getPhysicsWarehouseCode());
                stringBuilder = new StringBuilder();
                vo.setPhysicsProvinceAddress(String.valueOf(stringBuilder.append(addressEo.getProvinceName()).append(addressEo.getCityName()).append(addressEo.getDistrictName())).replace("null", ""));
                vo.setPhysicsDetailAddress(addressEo.getDetailAddress());
                vo.setPhysicsContacts(addressEo.getPerson());
                vo.setPhysicsPhone(addressEo.getPhone());
            }
            if (receiveAddressEoMap.containsKey(o.getConsignmentNo())) {
                ConsignmentOrderAddressEo receiveAddressEo = (ConsignmentOrderAddressEo)receiveAddressEoMap.get(o.getConsignmentNo());
                vo.setWaybillPerson(receiveAddressEo.getPerson());
                vo.setWaybillPhone(receiveAddressEo.getPhone());
                stringBuilder = new StringBuilder();
                vo.setWaybillProvinceAddress(String.valueOf(stringBuilder.append(receiveAddressEo.getProvinceName()).append(receiveAddressEo.getCityName()).append(receiveAddressEo.getDistrictName())).replace("null", ""));
                vo.setWaybillDetailAddress(receiveAddressEo.getDetailAddress());
            }
            if (StringUtils.isNotBlank((CharSequence)o.getTransferConsignmentNo()) && transferEoMap.containsKey(o.getTransferConsignmentNo())) {
                ConsignmentOrderEo eo = (ConsignmentOrderEo)transferEoMap.get(o.getTransferConsignmentNo());
                vo.setTransportPhysicsWarehouseCode(eo.getPhysicsWarehouseCode());
                vo.setTransportPhysicsWarehouseName(eo.getPhysicsWarehouseName());
            }
            return vo;
        }).collect(Collectors.toList());
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<ConsignmentOrderDeliveryInfoRespDto> queryDeliveryInfoByBusinessNoList(List<String> businessNoList) {
        if (CollectionUtil.isEmpty(businessNoList)) {
            return Lists.newArrayList();
        }
        List consignmentOrderDeliveryInfoEos = this.consignmentOrderDeliveryInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ConsignmentOrderDeliveryInfoEo.class).in(ConsignmentOrderDeliveryInfoEo::getBusinessNo, businessNoList)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtil.isEmpty((Collection)consignmentOrderDeliveryInfoEos)) {
            return Lists.newArrayList();
        }
        ArrayList respDtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)respDtoList, (Collection)consignmentOrderDeliveryInfoEos, ConsignmentOrderDeliveryInfoRespDto.class);
        return respDtoList;
    }
}

