/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.constant.ReInsuranceBillTypeEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.BusinessTypeEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.InsuranceBusinessTypeEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.InsuranceFlagEnum;
import com.dtyunxi.tcbj.api.dto.request.FeeReportPlaceUpdateReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsuranceBillReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumReqDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsuranceBillCountDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsuranceBillRespDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsuranceBillSumDto;
import com.dtyunxi.tcbj.biz.service.IReInsuranceBillService;
import com.dtyunxi.tcbj.biz.service.IReInsurancePremiumChargingService;
import com.dtyunxi.tcbj.dao.das.OutNoticeOrderDas;
import com.dtyunxi.tcbj.dao.das.ReInsuranceBillDas;
import com.dtyunxi.tcbj.dao.das.ReInsurancePremiumDas;
import com.dtyunxi.tcbj.dao.das.ReTransferOrderDas;
import com.dtyunxi.tcbj.dao.eo.CsTransferOrderEo;
import com.dtyunxi.tcbj.dao.eo.ReInsuranceBillEo;
import com.dtyunxi.tcbj.dao.eo.ReInsurancePremiumEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.github.pagehelper.PageInfo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReInsuranceBillServiceImpl
implements IReInsuranceBillService {
    private static final Logger logger = LoggerFactory.getLogger(ReInsuranceBillServiceImpl.class);
    @Resource
    private ReInsuranceBillDas reInsuranceBillDas;
    @Resource
    private ReInsurancePremiumDas premiumDas;
    @Resource
    private ReTransferOrderDas reTransferOrderDas;
    @Resource
    private OutNoticeOrderDas outNoticeOrderDas;
    @Resource
    private IReInsurancePremiumChargingService premiumDetailService;

    @Override
    public Long addReInsuranceBill(ReInsuranceBillReqDto addReqDto) {
        ReInsuranceBillEo reInsuranceBillEo = new ReInsuranceBillEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)reInsuranceBillEo);
        this.reInsuranceBillDas.insert((BaseEo)reInsuranceBillEo);
        return reInsuranceBillEo.getId();
    }

    @Override
    public void batchAddReInsuranceBill(List<ReInsuranceBillReqDto> reqDtoList) {
        logger.info("\u6279\u91cf\u65b0\u589e\u4fdd\u8d39\u8d26\u5355\uff1a{}", (Object)JSON.toJSONString(reqDtoList));
        List reInsuranceBillEoList = BeanUtil.copyToList(reqDtoList, ReInsuranceBillEo.class);
        this.reInsuranceBillDas.insertBatch(reInsuranceBillEoList);
    }

    @Override
    public void modifyReInsuranceBill(ReInsuranceBillReqDto modifyReqDto) {
        ReInsuranceBillEo reInsuranceBillEo = new ReInsuranceBillEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)reInsuranceBillEo);
        this.reInsuranceBillDas.updateSelective((BaseEo)reInsuranceBillEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeReInsuranceBill(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.reInsuranceBillDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ReInsuranceBillRespDto queryById(Long id) {
        ReInsuranceBillEo reInsuranceBillEo = (ReInsuranceBillEo)this.reInsuranceBillDas.selectByPrimaryKey(id);
        ReInsuranceBillRespDto reInsuranceBillRespDto = new ReInsuranceBillRespDto();
        DtoHelper.eo2Dto((BaseEo)reInsuranceBillEo, (BaseVo)reInsuranceBillRespDto);
        return reInsuranceBillRespDto;
    }

    @Override
    public PageInfo<ReInsuranceBillRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        List eos;
        logger.info("\u4fdd\u8d39\u8d26\u5355\u5206\u9875\u67e5\u8be2\uff1a{}", (Object)filter);
        ReInsuranceBillReqDto reInsuranceBillReqDto = (ReInsuranceBillReqDto)JSON.parseObject((String)filter, ReInsuranceBillReqDto.class);
        this.buildReqDate(reInsuranceBillReqDto);
        reInsuranceBillReqDto.setPageNum(pageNum);
        reInsuranceBillReqDto.setPageSize(pageSize);
        logger.info("\u4fdd\u8d39\u8d26\u5355\u5206\u9875\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)reInsuranceBillReqDto);
        PageInfo eoPageInfo = this.reInsuranceBillDas.queryByPage(reInsuranceBillReqDto);
        logger.info("\u4fdd\u8d39\u8d26\u5355\u5206\u9875\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)eoPageInfo);
        List relevanceNos = eoPageInfo.getList().stream().map(ReInsuranceBillRespDto::getRelevanceNo).collect(Collectors.toList());
        HashMap<String, String> map = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(relevanceNos) && CollectionUtils.isNotEmpty((Collection)(eos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.reTransferOrderDas.filter().in((Object)"transfer_order_no", relevanceNos)).isNotNull((Object)"pre_order_no")).list()))) {
            Map<String, String> stringMap = eos.stream().collect(Collectors.toMap(CsTransferOrderEo::getTransferOrderNo, CsTransferOrderEo::getPreOrderNo, (k1, k2) -> k1));
            map.putAll(stringMap);
        }
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List dtoList = eoPageInfo.getList().stream().map(billEo -> {
            ReInsuranceBillRespDto e = new ReInsuranceBillRespDto();
            CubeBeanUtils.copyProperties((Object)e, (Object)billEo, (boolean)false, (String[])new String[0]);
            e.setBillType(ReInsuranceBillTypeEnum.getNameByCode((String)e.getBillType()));
            e.setFlagName(InsuranceFlagEnum.getValueByCode((Integer)e.getFlag()));
            e.setShippingTypeName(e.getShippingType());
            e.setBusinessTypeName(BusinessTypeEnum.getDescByCode((String)e.getBusinessType()));
            if (InsuranceBusinessTypeEnum.getByCode((String)e.getBusinessType()) != null) {
                e.setBusinessTypeName(InsuranceBusinessTypeEnum.getByCode((String)e.getBusinessType()).getDesc());
            }
            if (StringUtils.isNotBlank((CharSequence)billEo.getRelevanceNo()) && StringUtils.isBlank((CharSequence)billEo.getExternalOrderNo()) && map.containsKey(billEo.getRelevanceNo())) {
                e.setExternalOrderNo((String)map.get(billEo.getRelevanceNo()));
            }
            return e;
        }).collect(Collectors.toList());
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<ReInsuranceBillCountDto> queryBillingCount(ReInsuranceBillReqDto reInsuranceBillReqDto) {
        logger.info("\u4fdd\u8d39\u8d26\u5355\u7edf\u8ba1\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)reInsuranceBillReqDto));
        this.buildReqDate(reInsuranceBillReqDto);
        return this.reInsuranceBillDas.queryBillingCount(reInsuranceBillReqDto);
    }

    @Override
    public ReInsuranceBillSumDto queryBillingSum(ReInsuranceBillReqDto reInsuranceBillReqDto) {
        this.buildReqDate(reInsuranceBillReqDto);
        return this.reInsuranceBillDas.queryBillingSum(reInsuranceBillReqDto);
    }

    private void buildReqDate(ReInsuranceBillReqDto reqDto) {
        if (ObjectUtils.isNotEmpty((Object)reqDto) && ObjectUtils.isNotEmpty((Object)reqDto.getInOutTimeBegin()) && ObjectUtils.isNotEmpty((Object)reqDto.getInOutTimeEnd())) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String begin = dateFormat.format(reqDto.getInOutTimeBegin()) + " 00:00:00";
            String end = dateFormat.format(reqDto.getInOutTimeEnd()) + " 23:59:59";
            try {
                Date timeBegin = simpleDateFormat.parse(begin);
                Date timeEnd = simpleDateFormat.parse(end);
                reqDto.setInOutTimeBegin(timeBegin);
                reqDto.setInOutTimeEnd(timeEnd);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    @Transactional
    public Void addInsurePremiumAndBill(ReInsuranceBillEo reInsuranceBillEo, List<ReInsurancePremiumEo> premiumEoList) {
        this.reInsuranceBillDas.insert((BaseEo)reInsuranceBillEo);
        premiumEoList.forEach(eo -> eo.setBillId(reInsuranceBillEo.getId()));
        this.premiumDas.insertBatch(premiumEoList);
        return null;
    }

    @Override
    public void addInsurePremiumAndBill(List<ReInsuranceBillEo> billEoList) {
        this.reInsuranceBillDas.insertBatch(billEoList);
        billEoList.forEach(bill -> {
            if (CollectionUtils.isNotEmpty((Collection)bill.getPremiumEoList())) {
                bill.getPremiumEoList().forEach(eo -> eo.setBillId(bill.getId()));
                this.premiumDas.insertBatch(bill.getPremiumEoList());
            }
        });
    }

    @Override
    @Transactional
    public Void updateInsurePremiumAndBill(ReInsuranceBillEo reInsuranceBillEo, List<ReInsurancePremiumEo> premiumEoList) {
        this.reInsuranceBillDas.updateSelective((BaseEo)reInsuranceBillEo);
        for (ReInsurancePremiumEo premiumEo : premiumEoList) {
            this.premiumDas.updateSelective((BaseEo)premiumEo);
        }
        return null;
    }

    @Override
    public ReInsuranceBillCountDto queryPremiumCount(ReInsurancePremiumReqDto reInsurancePremiumReqDto) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (ObjectUtils.isNotEmpty((Object)reInsurancePremiumReqDto.getInOutTimeBegin()) && ObjectUtils.isNotEmpty((Object)reInsurancePremiumReqDto.getInOutTimeEnd())) {
            String begin = dateFormat.format(reInsurancePremiumReqDto.getInOutTimeBegin()) + " 00:00:00";
            String end = dateFormat.format(reInsurancePremiumReqDto.getInOutTimeEnd()) + " 23:59:59";
            try {
                Date timeBegin = simpleDateFormat.parse(begin);
                Date timeEnd = simpleDateFormat.parse(end);
                reInsurancePremiumReqDto.setInOutTimeBegin(timeBegin);
                reInsurancePremiumReqDto.setInOutTimeEnd(timeEnd);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return this.reInsuranceBillDas.queryPremiumCount(reInsurancePremiumReqDto);
    }

    @Override
    public Integer updatePlaceStatus(FeeReportPlaceUpdateReqDto updateReqDto) {
        AssertUtil.assertNotEmpty((Collection)updateReqDto.getModuleRecordIdList(), (String)"\u4fdd\u8d39\u8d26\u5355\u62a5\u8868\u8bb0\u5f55id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotNull((Object)updateReqDto.getPlacedFlag(), (String)"\u5f52\u6863\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        ReInsuranceBillEo updateEo = new ReInsuranceBillEo();
        updateEo.setPlacedFlag(updateReqDto.getPlacedFlag());
        List reInsuranceBillEos = this.reInsuranceBillDas.getMapper().selectBatchIds((Collection)updateReqDto.getModuleRecordIdList());
        List list = reInsuranceBillEos.stream().filter(e -> e.getPlacedFlag() == null || e.getPlacedFlag() == 0).map(BaseEo::getId).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(list)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"id", list);
            return this.reInsuranceBillDas.getMapper().update((Object)updateEo, (Wrapper)queryWrapper);
        }
        logger.info("\u5f53\u524d\u5f52\u6863\u65e5\u671f\u5185\u7684\u6570\u636e\u5df2\u5168\u90e8\u5f52\u6863");
        return null;
    }

    @Override
    public void logicDelete(ReInsuranceBillReqDto reqDto) {
        logger.info("\u903b\u8f91\u5220\u9664\u4fdd\u8d39\u8d26\u5355\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtil.isFalse((ObjectUtils.isEmpty((Object)reqDto.getInOutTimeBegin()) || ObjectUtils.isEmpty((Object)reqDto.getInOutTimeEnd()) ? 1 : 0) != 0, (String)"\u8bf7\u9009\u62e9\u65f6\u95f4\u8303\u56f4");
        List billEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.reInsuranceBillDas.filter().between((Object)"in_out_time", (Object)reqDto.getInOutTimeBegin(), (Object)reqDto.getInOutTimeEnd())).eq((Object)"dr", (Object)0)).list();
        if (CollectionUtils.isNotEmpty((Collection)billEoList)) {
            List ids = billEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
            this.reInsuranceBillDas.logicDeleteByIdsBatch(ids);
        }
    }
}

