/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.config;

import com.dtyunxi.yundt.cube.center.data.api.IPcpDictApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SapPullRateLimitProperties {
    private static final Logger logger = LoggerFactory.getLogger(SapPullRateLimitProperties.class);
    private static final String DICT_CODE_ENABLED = "SAP_PULL_RATE_LIMIT_ENABLED";
    private static final String DICT_CODE_MAX_ORDERS_PER_HOUR = "SAP_PULL_RATE_LIMIT_MAX_ORDERS_PER_HOUR";
    @Resource
    private IPcpDictApi pcpDictApi;
    private Boolean enabled = true;
    private Integer maxOrdersPerHour = 125;

    @PostConstruct
    public void init() {
        this.refreshFromDict();
    }

    public void refreshFromDict() {
        try {
            String enabledValue = Optional.ofNullable(this.pcpDictApi.queryByGroupCodeAndCode("COMMON_CONFIG", DICT_CODE_ENABLED).getData()).map(DictDto::getValue).orElse("1");
            this.enabled = "1".equals(enabledValue) || "true".equalsIgnoreCase(enabledValue);
            logger.info("\u4ece\u5b57\u5178\u8bfb\u53d6\u9650\u6d41\u5f00\u5173: {} -> {}", (Object)DICT_CODE_ENABLED, (Object)this.enabled);
            String maxOrdersValue = Optional.ofNullable(this.pcpDictApi.queryByGroupCodeAndCode("COMMON_CONFIG", DICT_CODE_MAX_ORDERS_PER_HOUR).getData()).map(DictDto::getValue).orElse("125");
            try {
                this.maxOrdersPerHour = Integer.parseInt(maxOrdersValue);
                logger.info("\u4ece\u5b57\u5178\u8bfb\u53d6\u6bcf\u5c0f\u65f6\u6700\u5927\u53ef\u62c9\u5355\u91cf: {} -> {}", (Object)DICT_CODE_MAX_ORDERS_PER_HOUR, (Object)this.maxOrdersPerHour);
            }
            catch (NumberFormatException e) {
                logger.error("\u5b57\u5178\u503c\u683c\u5f0f\u9519\u8bef\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c125: {}", (Object)maxOrdersValue, (Object)e);
                this.maxOrdersPerHour = 125;
            }
        }
        catch (Exception e) {
            logger.error("\u4ece\u5b57\u5178\u8bfb\u53d6\u914d\u7f6e\u5931\u8d25\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c", (Throwable)e);
            this.enabled = true;
            this.maxOrdersPerHour = 125;
        }
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Integer getMaxOrdersPerHour() {
        return this.maxOrdersPerHour;
    }

    public void setMaxOrdersPerHour(Integer maxOrdersPerHour) {
        this.maxOrdersPerHour = maxOrdersPerHour;
    }

    public String toString() {
        return "SapPullRateLimitProperties{enabled=" + this.enabled + ", maxOrdersPerHour=" + this.maxOrdersPerHour + '}';
    }
}

