/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.biz.config.SapPullRateLimitProperties;
import com.dtyunxi.tcbj.biz.service.ISapPullRateLimitService;
import com.dtyunxi.tcbj.dao.eo.SaleOrderApportionEo;
import com.dtyunxi.tcbj.dao.mapper.SaleOrderApportionMapper;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SapPullRateLimitServiceImpl
implements ISapPullRateLimitService {
    private static final Logger logger = LoggerFactory.getLogger(SapPullRateLimitServiceImpl.class);
    @Resource
    private SapPullRateLimitProperties rateLimitProperties;
    @Resource
    private SaleOrderApportionMapper saleOrderApportionMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void executeRateLimit() {
        if (!this.rateLimitProperties.getEnabled().booleanValue()) {
            logger.info("SAP\u62c9\u5355\u9650\u6d41\u63a7\u5236\u5df2\u5173\u95ed\uff0c\u8df3\u8fc7\u672c\u6b21\u8c03\u5ea6");
            return;
        }
        int maxOrdersPerHour = this.rateLimitProperties.getMaxOrdersPerHour();
        int exposedCountInLastHour = this.getExposedCountInLastHour();
        int remainingQuotaByHour = this.calculateRemainingQuota();
        int maxOrdersForTwoHours = maxOrdersPerHour * 2;
        int currentExposedOrdersCount = this.getExposedOrdersCount();
        logger.info("SAP\u62c9\u5355\u9650\u6d41\u63a7\u5236 - \u914d\u7f6e: \u6bcf\u5c0f\u65f6\u6700\u5927{}\u5355, 2\u5c0f\u65f6\u6700\u5927{}\u5355", (Object)maxOrdersPerHour, (Object)maxOrdersForTwoHours);
        logger.info("SAP\u62c9\u5355\u9650\u6d41\u63a7\u5236 - \u6700\u8fd160\u5206\u949f\u5df2\u66b4\u9732: {}\u5355, \u5f53\u524d\u5df2\u53ef\u62c9\u5355\u603b\u6570: {}\u5355", (Object)exposedCountInLastHour, (Object)currentExposedOrdersCount);
        if (currentExposedOrdersCount > maxOrdersForTwoHours) {
            int exceedingCount = currentExposedOrdersCount - maxOrdersForTwoHours;
            logger.warn("SAP\u62c9\u5355\u9650\u6d41\u63a7\u5236 - \u5f53\u524d\u5df2\u53ef\u62c9\u5355\u603b\u6570({})\u8d85\u8fc72\u5c0f\u65f6\u914d\u7f6e\u91cf({})\uff0c\u8d85\u51fa{}\u5355\uff0c\u5f00\u59cb\u6536\u56de\u8d85\u51fa\u90e8\u5206", new Object[]{currentExposedOrdersCount, maxOrdersForTwoHours, exceedingCount});
            List exceedingOrders = this.saleOrderApportionMapper.selectExposedOrdersExceedingLimit(exceedingCount);
            if (CollectionUtil.isNotEmpty((Collection)exceedingOrders)) {
                List<Long> exceedingOrderIds = exceedingOrders.stream().map(BaseEo::getId).collect(Collectors.toList());
                int revokedCount = this.revokeExposureStatus(exceedingOrderIds);
                logger.info("SAP\u62c9\u5355\u9650\u6d41\u63a7\u5236 - \u5df2\u6536\u56de{}\u5355\u8d85\u51fa\u90e8\u5206\u7684\u66b4\u9732\u72b6\u6001\uff0c\u5355\u636eID\u5217\u8868: {}", (Object)revokedCount, exceedingOrderIds);
                currentExposedOrdersCount = this.getExposedOrdersCount();
                logger.info("SAP\u62c9\u5355\u9650\u6d41\u63a7\u5236 - \u6536\u56de\u540e\u5f53\u524d\u5df2\u53ef\u62c9\u5355\u603b\u6570: {}\u5355, 2\u5c0f\u65f6\u914d\u7f6e\u91cf: {}\u5355", (Object)currentExposedOrdersCount, (Object)maxOrdersForTwoHours);
            }
        }
        if (currentExposedOrdersCount >= maxOrdersForTwoHours) {
            logger.info("SAP\u62c9\u5355\u9650\u6d41\u63a7\u5236 - \u5f53\u524d\u5df2\u53ef\u62c9\u5355\u603b\u6570({})\u5df2\u8fbe\u52302\u5c0f\u65f6\u914d\u7f6e\u91cf({})\uff0c\u4e0d\u518d\u66b4\u9732\u65b0\u5355\u636e", (Object)currentExposedOrdersCount, (Object)maxOrdersForTwoHours);
            return;
        }
        int remainingQuotaByTwoHours = maxOrdersForTwoHours - currentExposedOrdersCount;
        int actualRemainingQuota = Math.min(remainingQuotaByHour, remainingQuotaByTwoHours);
        logger.info("SAP\u62c9\u5355\u9650\u6d41\u63a7\u5236 - \u5269\u4f59\u989d\u5ea6(60\u5206\u949f): {}\u5355, \u5269\u4f59\u989d\u5ea6(2\u5c0f\u65f6): {}\u5355, \u5b9e\u9645\u53ef\u7528\u989d\u5ea6: {}\u5355", new Object[]{remainingQuotaByHour, remainingQuotaByTwoHours, actualRemainingQuota});
        if (actualRemainingQuota <= 0) {
            logger.info("SAP\u62c9\u5355\u9650\u6d41\u63a7\u5236 - \u5b9e\u9645\u53ef\u7528\u989d\u5ea6\u5df2\u7528\u5b8c\uff0c\u8df3\u8fc7\u672c\u6b21\u8c03\u5ea6");
            return;
        }
        List pendingOrders = this.saleOrderApportionMapper.selectPendingOrdersForExposure(actualRemainingQuota);
        if (CollectionUtil.isEmpty((Collection)pendingOrders)) {
            logger.info("SAP\u62c9\u5355\u9650\u6d41\u63a7\u5236 - \u6ca1\u6709\u5f85\u66b4\u9732\u7684\u5355\u636e");
            return;
        }
        List<Long> orderIds = pendingOrders.stream().map(BaseEo::getId).collect(Collectors.toList());
        int exposedCountResult = this.exposeOrders(orderIds);
        logger.info("SAP\u62c9\u5355\u9650\u6d41\u63a7\u5236 - \u672c\u6b21\u66b4\u9732\u5355\u636e\u6570\u91cf: {}, \u5355\u636eID\u5217\u8868: {}", (Object)exposedCountResult, orderIds);
        logger.info("SAP\u62c9\u5355\u9650\u6d41\u63a7\u5236 - \u66b4\u9732\u540e\u72b6\u6001: \u5f53\u524d\u5df2\u53ef\u62c9\u5355\u603b\u6570: {}\u5355, 2\u5c0f\u65f6\u914d\u7f6e\u91cf: {}\u5355", (Object)(currentExposedOrdersCount + exposedCountResult), (Object)maxOrdersForTwoHours);
        this.logOrderTypeStatistics(pendingOrders);
    }

    @Override
    public int calculateRemainingQuota() {
        int maxOrdersPerHour = this.rateLimitProperties.getMaxOrdersPerHour();
        int exposedCount = this.getExposedCountInLastHour();
        return Math.max(0, maxOrdersPerHour - exposedCount);
    }

    @Override
    public int getExposedCountInLastHour() {
        return this.saleOrderApportionMapper.countExposedInLastHour();
    }

    @Override
    public int getExposedOrdersCount() {
        return this.saleOrderApportionMapper.countExposedOrders();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int exposeOrders(List<Long> orderIds) {
        if (CollectionUtil.isEmpty(orderIds)) {
            return 0;
        }
        Date now = new Date();
        return this.saleOrderApportionMapper.batchUpdateExposureStatus(orderIds, now);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void manualTrigger() {
        logger.info("SAP\u62c9\u5355\u9650\u6d41\u63a7\u5236 - \u624b\u52a8\u89e6\u53d1\u6267\u884c");
        this.executeRateLimit();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int revokeExposureStatus(List<Long> orderIds) {
        if (CollectionUtil.isEmpty(orderIds)) {
            return 0;
        }
        return this.saleOrderApportionMapper.batchRevokeExposureStatus(orderIds);
    }

    private void logOrderTypeStatistics(List<SaleOrderApportionEo> orders) {
        if (CollectionUtil.isEmpty(orders)) {
            return;
        }
        Map<String, Long> typeCountMap = orders.stream().collect(Collectors.groupingBy(order -> order.getType() != null ? order.getType() : "UNKNOWN", Collectors.counting()));
        logger.info("SAP\u62c9\u5355\u9650\u6d41\u63a7\u5236 - \u672c\u6b21\u66b4\u9732\u5355\u636e\u7c7b\u578b\u5206\u5e03: {}", typeCountMap);
    }
}

