/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.utils;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.StrUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.springframework.lang.NonNull;

public class DateTimeUtils {
    public static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HHmmss");
    public static final DateTimeFormatter LONG_TIME_FORMATTER = DateTimeFormatter.ofPattern("HHmmssSSS");
    public static final DateTimeFormatter YEAR_MONTH_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM");
    public static final DateTimeFormatter SHORT_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyMMdd");
    public static final DateTimeFormatter LONG_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter SHORT_DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyMMddHHmmss");
    public static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter LONG_DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss SSS");
    public static final DateTimeFormatter LONG_DATETIME = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    public static final String FORMAT_YMD = "yyyy-MM-dd";
    public static final String FORMAT_YMD_YMD = "yyyyMMdd";

    public static String getDateStr(int day) {
        LocalDate yesterday = LocalDate.now().plusDays(day);
        return yesterday.format(LONG_DATE_FORMATTER) + "000000";
    }

    public static LocalDate getCurrentLocalDate() {
        return LocalDate.now();
    }

    public static LocalTime getCurrentLocalTime() {
        return LocalTime.now();
    }

    public static LocalDateTime getCurrentLocalDateTime() {
        return LocalDateTime.now();
    }

    public static String getCurrentDateStr() {
        return LocalDate.now().format(DATE_FORMATTER);
    }

    public static String getCurrentShortDateStr() {
        return LocalDate.now().format(SHORT_DATE_FORMATTER);
    }

    public static String getCurrentLongDateStr() {
        return LocalDate.now().format(LONG_DATE_FORMATTER);
    }

    public static String getCurrentMonthStr() {
        return LocalDate.now().format(YEAR_MONTH_FORMATTER);
    }

    public static String getCurrentDateTimeStr() {
        return LocalDateTime.now().format(DATETIME_FORMATTER);
    }

    public static String getCurrentLongDateTimeStr() {
        return LocalDateTime.now().format(LONG_DATETIME_FORMATTER);
    }

    public static String getCurrentShortDateTimeStr() {
        return LocalDateTime.now().format(SHORT_DATETIME_FORMATTER);
    }

    public static String getCurrentTimeStr() {
        return LocalTime.now().format(TIME_FORMATTER);
    }

    public static String getLongCurrentTimeStr() {
        return LocalTime.now().format(LONG_TIME_FORMATTER);
    }

    public static String getCurrentDateStr(String pattern) {
        return LocalDate.now().format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String getCurrentDateTimeStr(String pattern) {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String getCurrentTimeStr(String pattern) {
        return LocalTime.now().format(DateTimeFormatter.ofPattern(pattern));
    }

    public static LocalDate parseLocalDate(String dateStr, String pattern) {
        return LocalDate.parse(dateStr, DateTimeFormatter.ofPattern(pattern));
    }

    public static LocalDateTime parseLocalDateTime(String dateTimeStr, String pattern) {
        return LocalDateTime.parse(dateTimeStr, DateTimeFormatter.ofPattern(pattern));
    }

    public static LocalTime parseLocalTime(String timeStr, String pattern) {
        return LocalTime.parse(timeStr, DateTimeFormatter.ofPattern(pattern));
    }

    public static String formatLocalDate(LocalDate date, String pattern) {
        return date.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String formatLocalDateTime(LocalDateTime datetime, String pattern) {
        return datetime.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String formatLocalTime(LocalTime time, String pattern) {
        return time.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static LocalDate parseLocalLongDate(String dateStr) {
        return LocalDate.parse(dateStr, LONG_DATE_FORMATTER);
    }

    public static LocalDate parseLocalDate(String dateStr) {
        return LocalDate.parse(dateStr, DATE_FORMATTER);
    }

    public static LocalDateTime parseLocalDateTime(String dateTimeStr) {
        return LocalDateTime.parse(dateTimeStr, DATETIME_FORMATTER);
    }

    public static LocalDateTime parseLongLocalDateTime(String longDateTimeStr) {
        return LocalDateTime.parse(longDateTimeStr, LONG_DATETIME_FORMATTER);
    }

    public static Date formatLocalDateTimeToDate(String dateTime, String pattern) {
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime localDateTime = DateTimeUtils.parseLocalDateTime(dateTime, pattern);
        ZonedDateTime zdt = localDateTime.atZone(zoneId);
        return Date.from(zdt.toInstant());
    }

    public static Date formatLocalDateToDate(String date, String pattern) {
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDate localDate = DateTimeUtils.parseLocalDate(date, pattern);
        Instant instant = localDate.atStartOfDay().atZone(zoneId).toInstant();
        Date from = Date.from(instant);
        return from;
    }

    public static LocalTime parseLocalTime(String timeStr) {
        return LocalTime.parse(timeStr, TIME_FORMATTER);
    }

    public static String formatLocalDate(LocalDate date) {
        return date.format(DATE_FORMATTER);
    }

    public static String formatLocalDateTime(LocalDateTime datetime) {
        return datetime.format(DATETIME_FORMATTER);
    }

    public static String formatLocalTime(LocalTime time) {
        return time.format(TIME_FORMATTER);
    }

    public static long periodHours(LocalDateTime startDateTime, LocalDateTime endDateTime) {
        return Duration.between(startDateTime, endDateTime).get(ChronoUnit.SECONDS);
    }

    public static long periodDays(LocalDate startDate, LocalDate endDate) {
        return startDate.until(endDate, ChronoUnit.DAYS);
    }

    public static long periodWeeks(LocalDate startDate, LocalDate endDate) {
        return startDate.until(endDate, ChronoUnit.WEEKS);
    }

    public static long periodMonths(LocalDate startDate, LocalDate endDate) {
        return startDate.until(endDate, ChronoUnit.MONTHS);
    }

    public static long periodYears(LocalDate startDate, LocalDate endDate) {
        return startDate.until(endDate, ChronoUnit.YEARS);
    }

    public static boolean isToday(LocalDate date) {
        return DateTimeUtils.getCurrentLocalDate().equals(date);
    }

    public static Long toEpochMilli(LocalDateTime dateTime) {
        return dateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static boolean isLeapYear(LocalDate localDate) {
        return localDate.isLeapYear();
    }

    public static String getDateString(int day) {
        LocalDate yesterday = LocalDate.now().plusDays(day);
        return yesterday.format(DATE_FORMATTER);
    }

    public static Date stringToDate(String date, String time) {
        LocalDate localDate = LocalDate.parse(date, DATE_FORMATTER);
        LocalTime localTime = LocalTime.parse(time, TIME_FORMATTER);
        LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        return Date.from(instant);
    }

    public static String formatDate(Date date, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(date);
    }

    public static Date formatDate(String date, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        try {
            return dateFormat.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getDateTimeStr(Date date) {
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        return localDateTime.format(DATETIME_FORMATTER);
    }

    public static String getDateTime(Date date) {
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        return localDateTime.format(DATE_FORMATTER);
    }

    public static String getMonth(Date date) {
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        return localDateTime.getMonth().getValue() + "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDayBegin(String time) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DateTimeUtils.parseDate(time));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        DateTimeFormatter dateTimeFormatter = DATETIME_FORMATTER;
        synchronized (dateTimeFormatter) {
            return DateTimeUtils.getDateTimeStr(cal.getTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDayEnd(String time) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DateTimeUtils.parseDate(time));
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        DateTimeFormatter dateTimeFormatter = DATETIME_FORMATTER;
        synchronized (dateTimeFormatter) {
            return DateTimeUtils.getDateTimeStr(cal.getTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDelayDay(Integer hours) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        long hoursTimes = (long)hours.intValue() * 60L * 60L * 1000L;
        long nowTimes = System.currentTimeMillis();
        cal.setTimeInMillis(nowTimes - hoursTimes);
        DateTimeFormatter dateTimeFormatter = DATETIME_FORMATTER;
        synchronized (dateTimeFormatter) {
            return DateTimeUtils.getDateTimeStr(cal.getTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDay(String time, Integer hours) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateTimeUtils.parseDateTime(time));
        long hoursTimes = (long)hours.intValue() * 60L * 60L * 1000L;
        cal.setTimeInMillis(cal.getTimeInMillis() - hoursTimes);
        DateTimeFormatter dateTimeFormatter = DATETIME_FORMATTER;
        synchronized (dateTimeFormatter) {
            return DateTimeUtils.getDateTimeStr(cal.getTime());
        }
    }

    public static Date parseDate(String s) {
        Date date = null;
        try {
            date = new SimpleDateFormat(FORMAT_YMD).parse(s);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    public static Date parseDate(String s, String format) {
        Date date = null;
        try {
            date = new SimpleDateFormat(format).parse(s);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    public static Date parseDateTime(String s) {
        Date date = null;
        try {
            date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(s);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    public static boolean getNowSubAppointedTime(Date appointedTime, int before) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, before);
        Date beforeTime = calendar.getTime();
        return beforeTime.after(appointedTime);
    }

    public static Map<String, String> getPastDate(int past) {
        Calendar lastCalendar = Calendar.getInstance();
        lastCalendar.add(12, -5);
        Date lastDate = lastCalendar.getTime();
        Calendar calendar = Calendar.getInstance();
        calendar.set(6, calendar.get(6) - past);
        Date firstDate = calendar.getTime();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("lastDate", format.format(lastDate));
        map.put("firstDate", format.format(firstDate));
        return map;
    }

    public static boolean isGreaterThanTime(@NonNull Date targetTime, @NonNull Integer minute) {
        Calendar newTime = Calendar.getInstance();
        Date beforeTime = newTime.getTime();
        newTime.setTime(targetTime);
        newTime.add(12, minute);
        Date afterTime = newTime.getTime();
        return beforeTime.after(afterTime);
    }

    public static String getYesterdayTime() {
        return LocalDateTime.now().plusDays(-1L).format(DATE_FORMATTER);
    }

    public static String getBeforeFirstMonthDate() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        String format1 = format.format(calendar.getTime());
        return format1;
    }

    public static String getBeforeLastMonthDate() {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar calendar = Calendar.getInstance();
        int month = calendar.get(2);
        calendar.set(2, month - 1);
        calendar.set(5, calendar.getActualMaximum(5));
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        String format = sf.format(calendar.getTime());
        return format;
    }

    public static String getHHMMByMm(Long mm) {
        return LocalTime.MIN.plus(Duration.ofMinutes(mm)).toString();
    }

    public static String getDayByMm(Long time) {
        return time / 24L / 60L + "\u5929" + time / 60L % 24L + "\u5c0f\u65f6" + time % 60L + "\u5206\u949f";
    }

    public static Pair<Date, Date> getByMonth(String month) {
        if (StrUtil.isBlank((CharSequence)month)) {
            return null;
        }
        YearMonth yearMonthObject = YearMonth.parse(month);
        LocalDateTime startOfMonth = yearMonthObject.atDay(1).atStartOfDay();
        LocalDateTime endOfMonth = yearMonthObject.atEndOfMonth().atTime(23, 59, 59);
        Date startDate = Date.from(startOfMonth.atZone(ZoneId.systemDefault()).toInstant());
        Date endDate = Date.from(endOfMonth.atZone(ZoneId.systemDefault()).toInstant());
        return Pair.of((Object)startDate, (Object)endDate);
    }

    public static Pair<String, String> getByMonthStr(String month) {
        Pair<Date, Date> datePair = DateTimeUtils.getByMonth(month);
        if (datePair == null) {
            return null;
        }
        return Pair.of((Object)DateUtil.formatDateTime((Date)((Date)datePair.getKey())), (Object)DateUtil.formatDateTime((Date)((Date)datePair.getValue())));
    }
}

