/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.request.FeeGenerateReqDto;
import com.dtyunxi.tcbj.api.exception.ExampleExceptionCode;
import com.dtyunxi.tcbj.biz.service.ISortingExpenseChargingService;
import com.dtyunxi.tcbj.biz.service.ISortingExpenseJobService;
import com.dtyunxi.tcbj.biz.utils.DateTimeUtils;
import com.dtyunxi.tcbj.dao.das.ISortingExpenseDetailDas;
import com.dtyunxi.tcbj.dao.das.SortingExpenseDas;
import com.dtyunxi.tcbj.dao.eo.SortingExpenseChargingEo;
import com.dtyunxi.tcbj.dao.eo.SortingExpenseEo;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.yunxi.dg.base.center.report.constants.DailyDeliveryFeeModuleEnum;
import com.yunxi.dg.base.center.report.domain.entity.IDailyDeliveryReportStockApportionDomain;
import com.yunxi.dg.base.center.report.dto.constants.DailyDeliveryReportCostBelongDetailCostTypeEnum;
import com.yunxi.dg.base.center.report.dto.constants.DailyDeliveryReportStockApportionStatusEnum;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportCostBelongDetailDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportStockApportionDto;
import com.yunxi.dg.base.center.report.eo.DailyDeliveryReportStockApportionEo;
import com.yunxi.dg.base.center.report.service.entity.IDailyDeliveryReportCostBelongDetailService;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SortingExpenseJobServiceImpl
implements ISortingExpenseJobService {
    private final Logger LOGGER = LoggerFactory.getLogger(SortingExpenseJobServiceImpl.class);
    @Resource
    private ISortingExpenseDetailDas das;
    @Resource
    private SortingExpenseDas sortingExpenseDas;
    @Resource
    private ISortingExpenseChargingService sortingExpenseChargingService;
    @Resource
    private ISortingExpenseDetailDas sortingExpenseDetailDas;
    @Resource
    private IDailyDeliveryReportCostBelongDetailService costBelongDetailService;
    @Resource
    private IDailyDeliveryReportStockApportionDomain reportStockApportionDomain;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void generateBySortingFee(DailyDeliveryReportStockApportionDto reqDto) {
        this.LOGGER.info("\u5206\u62e3\u8d39\u7528\u751f\u6210\u80a1\u4efd\u5206\u644a\u6570\u636e\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        String bookkeepingMonth = reqDto.getBookkeepingMonth();
        Pair<String, String> datePair = DateTimeUtils.getByMonthStr(bookkeepingMonth);
        List detailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.sortingExpenseDas.filter().between((Object)"out_warehouse_time", datePair.getKey(), datePair.getValue())).eq((Object)"if_apportion", (Object)1)).in(CollectionUtil.isNotEmpty((Collection)reqDto.getPhysicalWarehouseCodeList()), (Object)"out_physics_warehouse_code", (Collection)reqDto.getPhysicalWarehouseCodeList())).in(CollectionUtil.isNotEmpty((Collection)reqDto.getTransportStyleList()), (Object)"transport_style", (Collection)reqDto.getTransportStyleList())).and(StringUtils.isNotBlank((CharSequence)reqDto.getGenerateOrderNo()), wrapper -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.eq(StringUtils.isNotBlank((CharSequence)reqDto.getGenerateOrderNo()), (Object)"out_document_no", (Object)reqDto.getGenerateOrderNo())).or()).eq(StringUtils.isNotBlank((CharSequence)reqDto.getGenerateOrderNo()), (Object)"consignment_no", (Object)reqDto.getGenerateOrderNo());
        })).list();
        if (CollUtil.isEmpty((Collection)detailEos)) {
            this.LOGGER.info("\u5206\u62e3\u8d39\u7528\u65e0\u5339\u914d\u6570\u636e");
            return;
        }
        List apportionDtos = detailEos.stream().map(detailEo -> {
            DailyDeliveryReportStockApportionEo apportionDto = new DailyDeliveryReportStockApportionEo();
            apportionDto.setBookkeepingMonth(DateTimeUtils.formatDate(detailEo.getOutWarehouseTime(), "yyyy-MM"));
            apportionDto.setReportId(detailEo.getLinkDailyReportId());
            apportionDto.setFeeId(detailEo.getId());
            apportionDto.setDetailId(detailEo.getReportDetailId());
            apportionDto.setType(DailyDeliveryFeeModuleEnum.SORTING_FEE.getCode());
            apportionDto.setApportionStatus("NOT_APPORTION");
            apportionDto.setApportionTotal(detailEo.getDoneQuantity());
            apportionDto.setApportionAlready(BigDecimal.ZERO);
            return apportionDto;
        }).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(apportionDtos)) {
            this.reportStockApportionDomain.insertBatch(apportionDtos);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void generateBySortingFee(FeeGenerateReqDto reqDto) {
        this.generateBySortingFee(reqDto, true);
    }

    @Override
    public void generateBySortingFee(FeeGenerateReqDto reqDto, Boolean generateNotApportion) {
        this.LOGGER.info("\u751f\u6210\u5206\u62e3\u8d39\u8ba1\u8d39\u660e\u7ec6\u8bf7\u6c42\u53c2\u6570\uff1a{}  {}", (Object)JSON.toJSONString((Object)reqDto), (Object)generateNotApportion);
        AssertUtil.isFalse((ObjectUtils.isEmpty((Object)reqDto.getStartDate()) || ObjectUtils.isEmpty((Object)reqDto.getEndDate()) ? 1 : 0) != 0, (String)"\u8bf7\u4f20\u5165\u5f00\u59cb\u7ed3\u675f\u65f6\u95f4");
        if (ObjectUtils.isNotEmpty((Object)reqDto.getStockApportionId())) {
            reqDto.setCostType(DailyDeliveryReportCostBelongDetailCostTypeEnum.ARTIFICIAL.getType());
        }
        if (StringUtils.isBlank((CharSequence)reqDto.getCostType())) {
            reqDto.setCostTypeList(null);
        } else if (reqDto.getCostType().equals(DailyDeliveryReportCostBelongDetailCostTypeEnum.GENERAL.getType())) {
            reqDto.setCostTypeList(Arrays.asList(DailyDeliveryReportCostBelongDetailCostTypeEnum.GENERAL.getType()));
        } else {
            reqDto.setCostTypeList(Arrays.asList(DailyDeliveryReportCostBelongDetailCostTypeEnum.INTERNAL_DEAL.getType(), DailyDeliveryReportCostBelongDetailCostTypeEnum.ARTIFICIAL.getType()));
        }
        List costTypeList = reqDto.getCostTypeList();
        List chargingEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.sortingExpenseDetailDas.filter().ge(Objects.nonNull(reqDto.getStartDate()), (Object)"out_warehouse_time", (Object)reqDto.getStartDate())).le(Objects.nonNull(reqDto.getEndDate()), (Object)"out_warehouse_time", (Object)reqDto.getEndDate())).in(CollUtil.isNotEmpty((Collection)reqDto.getOutPhysicsWarehouseCodeList()), (Object)"out_physics_warehouse_code", (Collection)reqDto.getOutPhysicsWarehouseCodeList())).in(CollUtil.isNotEmpty((Collection)reqDto.getLogisticCompanyCodeList()), (Object)"shipment_enterprise_code", (Collection)reqDto.getLogisticCompanyCodeList())).in(CollUtil.isNotEmpty((Collection)reqDto.getTransportTypeList()), (Object)"transport_style", (Collection)reqDto.getTransportTypeList())).in(CollUtil.isNotEmpty((Collection)costTypeList), (Object)"cost_type", (Collection)costTypeList)).eq(ObjectUtil.isNotEmpty((Object)reqDto.getStockApportionId()), (Object)"id", (Object)reqDto.getStockApportionId())).and(StringUtils.isNotBlank((CharSequence)reqDto.getGenerateOrderNo()), wrapper -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.eq(StringUtils.isNotBlank((CharSequence)reqDto.getGenerateOrderNo()), (Object)"out_document_no", (Object)reqDto.getGenerateOrderNo())).or()).eq(StringUtils.isNotBlank((CharSequence)reqDto.getGenerateOrderNo()), (Object)"consignment_no", (Object)reqDto.getGenerateOrderNo());
        })).list();
        if (CollUtil.isNotEmpty((Collection)chargingEos)) {
            boolean exists = chargingEos.stream().anyMatch(chargingEo -> Objects.equals(chargingEo.getPlacedFlag(), 1));
            if (exists) {
                throw new BizException(ExampleExceptionCode.PLACED_FLAG_EXC.getCode(), "\u6570\u636e\u5df2\u5f52\u6863\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c");
            }
            List delIds = chargingEos.stream().map(BaseEo::getId).collect(Collectors.toList());
            this.LOGGER.info("\u5220\u9664\u65e7\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(delIds));
            this.sortingExpenseDetailDas.logicDeleteByIdsBatch(delIds);
        }
        if (StringUtils.isBlank((CharSequence)reqDto.getCostType()) || reqDto.getCostType().equals(DailyDeliveryReportCostBelongDetailCostTypeEnum.GENERAL.getType())) {
            this.LOGGER.info("\u751f\u6210\u5206\u62e3\u8ba1\u8d39\u5e38\u89c4\u8ba1\u8d39");
            List sortingExpenseList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.sortingExpenseDas.filter().ge(Objects.nonNull(reqDto.getStartDate()), (Object)"out_warehouse_time", (Object)reqDto.getStartDate())).le(Objects.nonNull(reqDto.getEndDate()), (Object)"out_warehouse_time", (Object)reqDto.getEndDate())).in(CollUtil.isNotEmpty((Collection)reqDto.getOutPhysicsWarehouseCodeList()), (Object)"out_physics_warehouse_code", (Collection)reqDto.getOutPhysicsWarehouseCodeList())).in(CollUtil.isNotEmpty((Collection)reqDto.getLogisticCompanyCodeList()), (Object)"shipment_enterprise_code", (Collection)reqDto.getLogisticCompanyCodeList())).in(CollUtil.isNotEmpty((Collection)reqDto.getTransportTypeList()), (Object)"transport_style", (Collection)reqDto.getTransportTypeList())).eq((Object)"if_apportion", (Object)0)).eq((Object)"billing_fee_flag", (Object)1)).and(StringUtils.isNotBlank((CharSequence)reqDto.getGenerateOrderNo()), wrapper -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.eq(StringUtils.isNotBlank((CharSequence)reqDto.getGenerateOrderNo()), (Object)"out_document_no", (Object)reqDto.getGenerateOrderNo())).or()).eq(StringUtils.isNotBlank((CharSequence)reqDto.getGenerateOrderNo()), (Object)"consignment_no", (Object)reqDto.getGenerateOrderNo());
            })).list();
            if (CollUtil.isNotEmpty((Collection)sortingExpenseList)) {
                this.LOGGER.info("\u751f\u6210\u5206\u62e3\u8ba1\u8d39\u5e38\u89c4\u8ba1\u8d39\u6570\u636e {} \u6761", (Object)sortingExpenseList.size());
                List expenseChargingEos = sortingExpenseList.stream().map(expenseEo -> {
                    SortingExpenseChargingEo detailEo = new SortingExpenseChargingEo();
                    BeanUtil.copyProperties((Object)expenseEo, (Object)detailEo, (String[])new String[]{"id"});
                    detailEo.setFeeId(expenseEo.getId());
                    detailEo.setBillingOrgCode(expenseEo.getExpenseOrganizationId());
                    detailEo.setBillingOrgName(expenseEo.getExpenseOrganizationName());
                    detailEo.setAllocationQuantity(expenseEo.getDoneQuantity());
                    detailEo.setApportionFee(expenseEo.getSortingNum());
                    detailEo.setCostType(DailyDeliveryReportCostBelongDetailCostTypeEnum.GENERAL.getType());
                    return detailEo;
                }).collect(Collectors.toList());
                this.das.insertBatch(expenseChargingEos);
            }
        }
        if (StringUtils.isBlank((CharSequence)reqDto.getCostType()) || !reqDto.getCostType().equals(DailyDeliveryReportCostBelongDetailCostTypeEnum.GENERAL.getType())) {
            this.LOGGER.info("\u5206\u62e3\u8ba1\u8d39\u5185\u90e8\u4ea4\u6613/\u4eba\u5de5\u5206\u644a");
            DailyDeliveryReportCostBelongDetailDto queryDto = new DailyDeliveryReportCostBelongDetailDto();
            queryDto.setBookkeepingMonth(reqDto.getBookkeepingMonth());
            queryDto.setType(DailyDeliveryFeeModuleEnum.SORTING_FEE.getCode());
            queryDto.setPhysicalWarehouseCodeList(reqDto.getOutPhysicsWarehouseCodeList());
            queryDto.setShipmentEnterpriseCodeList(reqDto.getLogisticCompanyCodeList());
            queryDto.setTransportStyleList(reqDto.getTransportTypeList());
            queryDto.setApportionStatus(DailyDeliveryReportStockApportionStatusEnum.ALREADY_APPORTION.getType());
            queryDto.setStockApportionId(reqDto.getStockApportionId());
            queryDto.setGenerateOrderNo(reqDto.getGenerateOrderNo());
            this.LOGGER.info("\u67e5\u8be2\u8ba1\u8d39\u5f52\u5c5e\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)queryDto));
            List costBelongDetailDtoList = this.costBelongDetailService.queryList(queryDto);
            if (CollectionUtils.isEmpty((Collection)costBelongDetailDtoList)) {
                this.LOGGER.info("\u65e0\u8ba1\u8d39\u5f52\u5c5e\u660e\u7ec6\u6570\u636e");
                return;
            }
            Map<Long, List<DailyDeliveryReportCostBelongDetailDto>> costBelongDetailDtoMap = costBelongDetailDtoList.stream().filter(f -> ObjectUtils.isNotEmpty((Object)f.getFeeId())).collect(Collectors.groupingBy(DailyDeliveryReportCostBelongDetailDto::getFeeId));
            List feeIds = costBelongDetailDtoList.stream().map(DailyDeliveryReportCostBelongDetailDto::getFeeId).distinct().collect(Collectors.toList());
            AssertUtil.isFalse((boolean)CollectionUtil.isEmpty(feeIds), (String)"\u7f3a\u5c11\u5173\u8054\u8d39\u7528ID\u4fe1\u606f");
            this.LOGGER.info("\u67e5\u8be2\u5206\u62e3\u5355\u636e\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(feeIds));
            List sortingExpenseEos = ((ExtQueryChainWrapper)this.sortingExpenseDas.filter().in((Object)"id", feeIds)).list();
            if (CollectionUtil.isEmpty((Collection)sortingExpenseEos)) {
                this.LOGGER.info("\u627e\u4e0d\u5230\u5206\u62e3\u5355\u636e\u4fe1\u606f");
                return;
            }
            ArrayList expenseEos = Lists.newArrayList();
            for (SortingExpenseEo sortingExpenseEo : sortingExpenseEos) {
                this.LOGGER.info("\u904d\u5386\u5206\u644a\u8ba1\u8d39\uff1a{}", (Object)JSON.toJSONString((Object)sortingExpenseEo));
                List<DailyDeliveryReportCostBelongDetailDto> costBelongDetailDtos = costBelongDetailDtoMap.get(sortingExpenseEo.getId());
                if (CollectionUtil.isEmpty(costBelongDetailDtos)) {
                    this.LOGGER.info("\u5339\u914d\u4e0d\u5230\u5f52\u5c5e\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)sortingExpenseEo));
                    continue;
                }
                this.LOGGER.info("\u5339\u914d\u5f52\u5c5e\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString(costBelongDetailDtos));
                BigDecimal alreadyApportionFee = BigDecimal.ZERO;
                for (DailyDeliveryReportCostBelongDetailDto belongDetail : costBelongDetailDtos) {
                    Long num;
                    SortingExpenseChargingEo expenseEo2 = (SortingExpenseChargingEo)BeanUtil.copyProperties((Object)sortingExpenseEo, SortingExpenseChargingEo.class, (String[])new String[]{"id", "createTime", "createPerson", "updateTime", "updatePerson"});
                    expenseEo2.setFeeId(sortingExpenseEo.getId());
                    expenseEo2.setCostType(belongDetail.getCostType());
                    expenseEo2.setAllocationQuantity(belongDetail.getApportionNum());
                    expenseEo2.setExpenseOrganizationId(belongDetail.getCostOrgCode());
                    expenseEo2.setExpenseOrganizationName(belongDetail.getCostOrgName());
                    expenseEo2.setBillingOrgName(belongDetail.getCostOrgCode());
                    expenseEo2.setBillingOrgName(belongDetail.getCostOrgName());
                    expenseEo2.setApportionFee(BigDecimal.ZERO);
                    Long bigR = expenseEo2.getBigRatio() == null ? 1L : expenseEo2.getBigRatio();
                    Long smallR = expenseEo2.getSmallRatio() == null ? 1L : expenseEo2.getSmallRatio();
                    Long boxNum = num = Long.valueOf(ObjectUtils.isNotEmpty((Object)expenseEo2.getAllocationQuantity()) ? expenseEo2.getAllocationQuantity().longValue() : 0L);
                    Long bigNum = 0L;
                    Long smallNum = 0L;
                    if (expenseEo2.getBigRatio() != null && bigR != 0L) {
                        bigNum = num / bigR;
                        expenseEo2.setBigBoxNum(BigDecimal.valueOf(bigNum));
                        boxNum = num % bigR;
                    }
                    if (expenseEo2.getSmallRatio() != null && smallR != 0L) {
                        smallNum = boxNum / smallR;
                        expenseEo2.setSmallBoxNum(BigDecimal.valueOf(smallNum));
                        boxNum = boxNum % smallR;
                    }
                    expenseEo2.setBoxNum(BigDecimal.valueOf(boxNum));
                    if (ObjectUtils.isNotEmpty((Object)expenseEo2.getSortingNum()) && ObjectUtils.isNotEmpty((Object)expenseEo2.getDoneQuantity())) {
                        boolean isLast;
                        boolean bl = isLast = costBelongDetailDtos.indexOf(belongDetail) == costBelongDetailDtos.size() - 1;
                        if (isLast) {
                            expenseEo2.setApportionFee(expenseEo2.getSortingNum().subtract(alreadyApportionFee));
                        } else {
                            BigDecimal divide = expenseEo2.getSortingNum().multiply(expenseEo2.getAllocationQuantity()).divide(expenseEo2.getDoneQuantity(), 2, RoundingMode.HALF_UP);
                            expenseEo2.setApportionFee(divide);
                            alreadyApportionFee = alreadyApportionFee.add(divide);
                        }
                    }
                    expenseEos.add(expenseEo2);
                }
            }
            this.LOGGER.info("\u4fdd\u5b58\u8ba1\u8d39\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)expenseEos));
            this.das.insertBatch((List)expenseEos);
        }
    }

    private BigDecimal apportionSortingExpense(SortingExpenseEo sortingExpenseEo, DailyDeliveryReportCostBelongDetailDto costBelongDetailDto) {
        if (Objects.isNull(sortingExpenseEo) || Objects.isNull(costBelongDetailDto)) {
            return BigDecimal.ZERO;
        }
        BigDecimal doneQuantity = sortingExpenseEo.getDoneQuantity();
        BigDecimal sortingNum = sortingExpenseEo.getSortingNum();
        if (BigDecimalUtils.leZero((BigDecimal)doneQuantity).booleanValue() || BigDecimalUtils.leZero((BigDecimal)sortingNum).booleanValue()) {
            return BigDecimal.ZERO;
        }
        BigDecimal apportionNum = costBelongDetailDto.getApportionNum();
        if (BigDecimalUtils.leZero((BigDecimal)apportionNum).booleanValue()) {
            return BigDecimal.ZERO;
        }
        BigDecimal sortingTotal = NumberUtil.mul((Number)sortingNum, (Number)apportionNum);
        return NumberUtil.div((Number)sortingTotal, (Number)doneQuantity, (int)2);
    }
}

