/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.query.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.tcbj.api.dto.request.AccountBillStatisticsReqDto;
import com.dtyunxi.tcbj.api.dto.request.CreditStatementStatisticsReqDto;
import com.dtyunxi.tcbj.api.dto.request.FreeGiftSummaryReqDto;
import com.dtyunxi.tcbj.api.dto.request.PromotionalActivitiesStatisticsReqDto;
import com.dtyunxi.tcbj.api.dto.request.RebateDetailReqDto;
import com.dtyunxi.tcbj.api.dto.response.AccountBillStatisticsRespDto;
import com.dtyunxi.tcbj.api.dto.response.CreditStatementStatisticsRespDto;
import com.dtyunxi.tcbj.api.dto.response.FreeGiftSummaryRespDto;
import com.dtyunxi.tcbj.api.dto.response.PromotionalActivitiesStatisticsRespDto;
import com.dtyunxi.tcbj.api.dto.response.RebateDetailRespDto;
import com.dtyunxi.tcbj.api.dto.response.ReportBaseRespDto;
import com.dtyunxi.tcbj.biz.service.IReportCommonService;
import com.dtyunxi.tcbj.biz.service.query.IBrandReportQueryService;
import com.dtyunxi.tcbj.biz.service.query.IDistributorReportQueryService;
import com.dtyunxi.tcbj.dao.das.CsCustomerDas;
import com.dtyunxi.tcbj.dao.eo.CsCustomerEo;
import com.dtyunxi.tcbj.dao.eo.SellerEo;
import com.dtyunxi.tcbj.dao.mapper.CsCustomerMapper;
import com.dtyunxi.tcbj.dao.mapper.SellerMapper;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BrandReportQueryServiceImpl
implements IBrandReportQueryService {
    private static final Logger logger = LoggerFactory.getLogger(BrandReportQueryServiceImpl.class);
    @Resource
    private IDistributorReportQueryService distributorReportQueryService;
    @Resource
    private SellerMapper sellerMapper;
    @Resource
    private CsCustomerMapper csCustomerMapper;
    @Resource
    private IReportCommonService reportCommonService;
    @Resource
    private CsCustomerDas csCustomerDas;

    @Override
    public PageInfo<FreeGiftSummaryRespDto> freeGiftSummaryStatistics(FreeGiftSummaryReqDto freeGiftSummaryReqDto) {
        List<CustomerRespDto> childCustomerList;
        logger.info("\u514d\u8d39\u8d60\u54c1\u6c47\u603b-\u54c1\u724c\u540e\u7ba1\uff1a{}", (Object)JSON.toJSONString((Object)freeGiftSummaryReqDto));
        String orgId = null;
        if (CollectionUtils.isNotEmpty((Collection)freeGiftSummaryReqDto.getOrganizationIds())) {
            orgId = ((Long)freeGiftSummaryReqDto.getOrganizationIds().get(0)).toString();
        }
        if (CollectionUtils.isEmpty(childCustomerList = this.getCurIds(orgId, freeGiftSummaryReqDto.getBrandCustomerName()))) {
            logger.info("\u65e0\u6cd5\u83b7\u53d6\u54c1\u724c\u65b9\u4e0b\u7684\u7ecf\u9500\u5546");
            return new PageInfo();
        }
        List orgIds = childCustomerList.stream().map(CustomerRespDto::getOrgInfoId).collect(Collectors.toList());
        freeGiftSummaryReqDto.setOrganizationIds(orgIds);
        PageInfo<FreeGiftSummaryRespDto> pageInfo = this.distributorReportQueryService.freeGiftSummaryStatistics(freeGiftSummaryReqDto);
        Map<Long, CustomerRespDto> childCustomerMap = childCustomerList.stream().collect(Collectors.toMap(CustomerRespDto::getOrgInfoId, t -> t, (last, next) -> next));
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            pageInfo.getList().forEach(freeGift -> {
                CustomerRespDto customer = (CustomerRespDto)childCustomerMap.get(freeGift.getMerchantId());
                if (ObjectUtils.isNotEmpty((Object)customer)) {
                    freeGift.setBrandCustomerName(customer.getName());
                }
            });
        }
        return pageInfo;
    }

    private Map<Long, String> getBrandInfo(List<Long> customerIds) {
        List csCustomerEos = ((List)Optional.ofNullable(((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)new LambdaQueryChainWrapper((BaseMapper)this.csCustomerMapper).select(new SFunction[]{BaseEo::getId, CsCustomerEo::getMerchantId}).eq(BaseEo::getDr, (Object)0)).in(BaseEo::getId, customerIds)).list()).orElse(new ArrayList())).stream().filter(customerEo -> null != customerEo.getMerchantId()).collect(Collectors.toList());
        List orgInfoIds = csCustomerEos.stream().map(CsCustomerEo::getMerchantId).collect(Collectors.toList());
        Map<Long, Long> customerIdToOrgInfoIdMap = csCustomerEos.stream().collect(Collectors.toMap(BaseEo::getId, CsCustomerEo::getMerchantId, (old, now) -> old));
        List sellerEos = Optional.ofNullable(((LambdaQueryChainWrapper)new LambdaQueryChainWrapper((BaseMapper)this.sellerMapper).in(SellerEo::getOrganizationId, orgInfoIds)).list()).orElse(new ArrayList());
        Map<Long, String> orgIdToSellerNameMap = sellerEos.stream().collect(Collectors.toMap(SellerEo::getOrganizationId, SellerEo::getName, (old, now) -> old));
        HashMap<Long, String> customerIdToSellerNameMap = new HashMap<Long, String>(customerIds.size());
        customerIds.forEach(customerId -> {
            Long orgId = (Long)customerIdToOrgInfoIdMap.get(customerId);
            String sellerName = (String)orgIdToSellerNameMap.get(orgId);
            customerIdToSellerNameMap.put((Long)customerId, sellerName);
        });
        return customerIdToSellerNameMap;
    }

    @Override
    public PageInfo<RebateDetailRespDto> discountStatistics(RebateDetailReqDto rebateDetailReqDto) {
        List<CustomerRespDto> childCustomerList;
        logger.info("\u6298\u6263\u6c47\u603b-\u54c1\u724c\u540e\u7ba1\uff1a{}", (Object)JSON.toJSONString((Object)rebateDetailReqDto));
        String orgId = null;
        if (CollectionUtils.isNotEmpty((Collection)rebateDetailReqDto.getOrganizationIds())) {
            orgId = ((Long)rebateDetailReqDto.getOrganizationIds().get(0)).toString();
        }
        if (CollectionUtils.isEmpty(childCustomerList = this.getCurIds(orgId, rebateDetailReqDto.getBrandCustomerName()))) {
            logger.info("\u65e0\u6cd5\u83b7\u53d6\u54c1\u724c\u65b9\u4e0b\u7684\u7ecf\u9500\u5546");
            return new PageInfo();
        }
        List orgIds = childCustomerList.stream().map(CustomerRespDto::getOrgInfoId).collect(Collectors.toList());
        rebateDetailReqDto.setOrganizationIds(orgIds);
        PageInfo<RebateDetailRespDto> pageInfo = this.distributorReportQueryService.discountStatistics(rebateDetailReqDto);
        Map<Long, CustomerRespDto> childCustomerMap = childCustomerList.stream().collect(Collectors.toMap(CustomerRespDto::getOrgInfoId, t -> t, (last, next) -> next));
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            pageInfo.getList().forEach(freeGift -> {
                CustomerRespDto customer = (CustomerRespDto)childCustomerMap.get(freeGift.getMerchantId());
                if (ObjectUtils.isNotEmpty((Object)customer)) {
                    freeGift.setBrandCustomerName(customer.getName());
                }
            });
        }
        return pageInfo;
    }

    @Override
    public PageInfo<CreditStatementStatisticsRespDto> creditStatementStatistics(CreditStatementStatisticsReqDto creditStatementStatisticsReqDto) {
        List<CustomerRespDto> childCustomerList;
        logger.info("\u6388\u4fe1\u8d26\u5355\u6c47\u603b-\u54c1\u724c\u540e\u7ba1\uff1a{}", (Object)JSON.toJSONString((Object)creditStatementStatisticsReqDto));
        String orgId = null;
        if (CollectionUtils.isNotEmpty((Collection)creditStatementStatisticsReqDto.getOrganizationIds())) {
            orgId = ((Long)creditStatementStatisticsReqDto.getOrganizationIds().get(0)).toString();
        }
        if (CollectionUtils.isEmpty(childCustomerList = this.getCurIds(orgId, creditStatementStatisticsReqDto.getBrandCustomerName()))) {
            logger.info("\u65e0\u6cd5\u83b7\u53d6\u54c1\u724c\u65b9\u4e0b\u7684\u7ecf\u9500\u5546");
            return new PageInfo();
        }
        List orgIds = childCustomerList.stream().map(CustomerRespDto::getOrgInfoId).collect(Collectors.toList());
        creditStatementStatisticsReqDto.setOrganizationIds(orgIds);
        PageInfo<CreditStatementStatisticsRespDto> pageInfo = this.distributorReportQueryService.creditStatementStatistics(creditStatementStatisticsReqDto);
        Map<Long, CustomerRespDto> childCustomerMap = childCustomerList.stream().collect(Collectors.toMap(CustomerRespDto::getOrgInfoId, t -> t, (last, next) -> next));
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            pageInfo.getList().forEach(freeGift -> {
                CustomerRespDto customer = (CustomerRespDto)childCustomerMap.get(freeGift.getMerchantId());
                if (ObjectUtils.isNotEmpty((Object)customer)) {
                    freeGift.setBrandCustomerName(customer.getName());
                }
            });
        }
        return pageInfo;
    }

    @Override
    public PageInfo<AccountBillStatisticsRespDto> accountBillStatistics(AccountBillStatisticsReqDto accountBillStatisticsReqDto) {
        List<CustomerRespDto> childCustomerList;
        logger.info("\u8d26\u671f\u6c47\u603b-\u54c1\u724c\u540e\u7ba1\uff1a{}", (Object)JSON.toJSONString((Object)accountBillStatisticsReqDto));
        String orgId = null;
        if (CollectionUtils.isNotEmpty((Collection)accountBillStatisticsReqDto.getOrganizationIds())) {
            orgId = ((Long)accountBillStatisticsReqDto.getOrganizationIds().get(0)).toString();
        }
        if (CollectionUtils.isEmpty(childCustomerList = this.getCurIds(orgId, accountBillStatisticsReqDto.getBrandCustomerName()))) {
            logger.info("\u65e0\u6cd5\u83b7\u53d6\u54c1\u724c\u65b9\u4e0b\u7684\u7ecf\u9500\u5546");
            return new PageInfo();
        }
        List orgIds = childCustomerList.stream().map(CustomerRespDto::getOrgInfoId).collect(Collectors.toList());
        accountBillStatisticsReqDto.setOrganizationIds(orgIds);
        PageInfo<AccountBillStatisticsRespDto> pageInfo = this.distributorReportQueryService.accountBillStatistics(accountBillStatisticsReqDto);
        Map<Long, CustomerRespDto> childCustomerMap = childCustomerList.stream().collect(Collectors.toMap(CustomerRespDto::getOrgInfoId, t -> t, (last, next) -> next));
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            pageInfo.getList().forEach(freeGift -> {
                CustomerRespDto customer = (CustomerRespDto)childCustomerMap.get(freeGift.getMerchantId());
                if (ObjectUtils.isNotEmpty((Object)customer)) {
                    freeGift.setBrandCustomerName(customer.getName());
                }
            });
        }
        return pageInfo;
    }

    @Override
    public PageInfo<PromotionalActivitiesStatisticsRespDto> activityStatistics(PromotionalActivitiesStatisticsReqDto promotionalActivitiesStatisticsReqDto) {
        List<CustomerRespDto> customerList;
        logger.info("\u4fc3\u9500\u6d3b\u52a8\u6c47\u603b-\u54c1\u724c\u540e\u7ba1\uff1a{}", (Object)JSON.toJSONString((Object)promotionalActivitiesStatisticsReqDto));
        String orgId = null;
        if (CollectionUtils.isNotEmpty((Collection)promotionalActivitiesStatisticsReqDto.getOrganizationIds())) {
            orgId = ((Long)promotionalActivitiesStatisticsReqDto.getOrganizationIds().get(0)).toString();
        }
        if (CollectionUtils.isEmpty(customerList = this.getCurIds(orgId, promotionalActivitiesStatisticsReqDto.getBrandCustomerName()))) {
            return new PageInfo();
        }
        List cusIds = customerList.stream().map(CustomerRespDto::getOrgInfoId).collect(Collectors.toList());
        promotionalActivitiesStatisticsReqDto.setOrganizationIds(cusIds);
        PageInfo<PromotionalActivitiesStatisticsRespDto> pageInfo = this.distributorReportQueryService.activityStatistics(promotionalActivitiesStatisticsReqDto);
        List list = pageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return pageInfo;
        }
        List<Long> customerIds = list.stream().map(ReportBaseRespDto::getCustomerId).collect(Collectors.toList());
        Map<Long, String> brandNameMap = this.getBrandInfo(customerIds);
        list.forEach(activitiesStatisticsRespDto -> {
            String sellerName = (String)brandNameMap.get(activitiesStatisticsRespDto.getCustomerId());
            activitiesStatisticsRespDto.setBrandCustomerName(sellerName);
            activitiesStatisticsRespDto.setDealerCustomerName(activitiesStatisticsRespDto.getCustomerName());
        });
        pageInfo.setList(list);
        return pageInfo;
    }

    private List<CustomerRespDto> getCurIds(String orgId, String searchName) {
        if (ObjectUtils.isEmpty((Object)orgId) && ObjectUtils.isEmpty((Object)(orgId = this.reportCommonService.getCurrentOrgId()))) {
            throw new BizException("-1", "\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7ec4\u7ec7\u4fe1\u606f");
        }
        List childCustomerList = this.csCustomerDas.getChildCustomer(Long.valueOf(orgId), searchName);
        if (CollectionUtils.isEmpty((Collection)childCustomerList)) {
            logger.info("\u65e0\u6cd5\u83b7\u53d6\u54c1\u724c\u65b9\u4e0b\u7684\u7ecf\u9500\u5546");
            return null;
        }
        return childCustomerList;
    }
}

