/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.apiimpl;

import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.IStorageChargeApportionApi;
import com.dtyunxi.tcbj.api.dto.request.StorageChargeApportionReqDto;
import com.dtyunxi.tcbj.api.dto.request.UpdatePullStatusReqDto;
import com.dtyunxi.tcbj.biz.service.ISapPullRateLimitService;
import com.dtyunxi.tcbj.biz.service.IStorageChargeApportionService;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StorageChargeApportionApiImpl
implements IStorageChargeApportionApi {
    private static final Logger log = LoggerFactory.getLogger(StorageChargeApportionApiImpl.class);
    @Resource
    private IStorageChargeApportionService storageChargeApportionService;
    @Resource
    private ISapPullRateLimitService sapPullRateLimitService;
    @Autowired
    ILockService lockService;

    public RestResponse<Void> storageChargeApportion(StorageChargeApportionReqDto storageChargeApportionReqDto) {
        Mutex mutex = this.lockService.lock("StorageChargeApportionApiImpl#storageChargeApportion", storageChargeApportionReqDto.getId() + "", 600, 605, TimeUnit.SECONDS);
        try {
            this.storageChargeApportionService.storageChargeApportion(storageChargeApportionReqDto);
        }
        finally {
            this.lockService.unlock(mutex);
        }
        return RestResponse.VOID;
    }

    public RestResponse<Void> updatePullStatus(UpdatePullStatusReqDto updatePullStatusReqDto) {
        log.info("\u5f00\u59cb\u66f4\u65b0\u53ef\u62c9\u5355\u72b6\u6001\uff1abusinessType={}, businessOrderNo={}, sapDocumentNo={}", new Object[]{updatePullStatusReqDto.getBusinessType(), updatePullStatusReqDto.getBusinessOrderNo(), updatePullStatusReqDto.getSapDocumentNo()});
        try {
            ArrayList<String> documentNos = new ArrayList<String>();
            documentNos.add(updatePullStatusReqDto.getSapDocumentNo());
            int updatedCount = this.sapPullRateLimitService.setPulledStatusByDocumentNos(documentNos);
            log.info("\u5df2\u66f4\u65b0{}\u6761\u5206\u644a\u5355\u636e\u4e3a\u5df2\u62c9\u5355\u72b6\u6001\uff1abusinessType={}, businessOrderNo={}, sapDocumentNo={}", new Object[]{updatedCount, updatePullStatusReqDto.getBusinessType(), updatePullStatusReqDto.getBusinessOrderNo(), updatePullStatusReqDto.getSapDocumentNo()});
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u53ef\u62c9\u5355\u72b6\u6001\u5931\u8d25\uff1abusinessType={}, businessOrderNo={}, error={}", new Object[]{updatePullStatusReqDto.getBusinessType(), updatePullStatusReqDto.getBusinessOrderNo(), e.getMessage(), e});
            throw e;
        }
        return RestResponse.VOID;
    }
}

