/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.util;

import com.dtyunxi.yundt.cube.center.data.api.IPcpDictApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DictConfigUtil {
    private static final Logger logger = LoggerFactory.getLogger(DictConfigUtil.class);
    public static final String DICT_CODE_ENABLED = "SAP_PULL_RATE_LIMIT_ENABLED";
    public static final String DICT_CODE_MAX_ORDERS_PER_HOUR = "SAP_PULL_RATE_LIMIT_MAX_ORDERS_PER_HOUR";
    @Resource
    private IPcpDictApi pcpDictApi;

    public String getDictValue(String dictCode) {
        try {
            return Optional.ofNullable(this.pcpDictApi.queryByGroupCodeAndCode("COMMON_CONFIG", dictCode).getData()).map(DictDto::getValue).orElse(null);
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u5b57\u5178\u503c\u5931\u8d25: {}", (Object)dictCode, (Object)e);
            return null;
        }
    }

    public boolean updateDictValue(String dictCode, String dictValue) {
        try {
            DictDto dictDto = (DictDto)this.pcpDictApi.queryByGroupCodeAndCode("COMMON_CONFIG", dictCode).getData();
            if (dictDto == null) {
                logger.warn("\u5b57\u5178\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u66f4\u65b0: {}", (Object)dictCode);
                logger.info("\u8bf7\u5728\u5b57\u5178\u7ba1\u7406\u754c\u9762\u624b\u52a8\u521b\u5efa\u5b57\u5178\uff1a");
                logger.info("  \u7ec4\u7f16\u7801: {}", (Object)"COMMON_CONFIG");
                logger.info("  \u5b57\u5178\u7f16\u7801: {}", (Object)dictCode);
                logger.info("  \u5b57\u5178\u503c: {}", (Object)dictValue);
                return false;
            }
            if (dictValue.equals(dictDto.getValue())) {
                logger.info("\u5b57\u5178\u503c\u672a\u53d8\u5316\uff0c\u65e0\u9700\u66f4\u65b0: {} = {}", (Object)dictCode, (Object)dictValue);
                return true;
            }
            logger.info("\u5b57\u5178\u503c\u9700\u8981\u66f4\u65b0: {} = {} -> {}", new Object[]{dictCode, dictDto.getValue(), dictValue});
            logger.info("\u8bf7\u5728\u5b57\u5178\u7ba1\u7406\u754c\u9762\u624b\u52a8\u66f4\u65b0\u5b57\u5178\uff1a");
            logger.info("  \u7ec4\u7f16\u7801: {}", (Object)"COMMON_CONFIG");
            logger.info("  \u5b57\u5178\u7f16\u7801: {}", (Object)dictCode);
            logger.info("  \u65b0\u5b57\u5178\u503c: {}", (Object)dictValue);
            return false;
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u5b57\u5178\u503c\u5931\u8d25: {} = {}", new Object[]{dictCode, dictValue, e});
            return false;
        }
    }

    public boolean updateSapPullRateLimitConfig(Boolean enabled, Integer maxOrdersPerHour) {
        String maxOrdersValue;
        String enabledValue;
        boolean result;
        boolean success = true;
        if (enabled != null && !(result = this.updateDictValue(DICT_CODE_ENABLED, enabledValue = enabled != false ? "1" : "0"))) {
            success = false;
        }
        if (maxOrdersPerHour != null && !(result = this.updateDictValue(DICT_CODE_MAX_ORDERS_PER_HOUR, maxOrdersValue = String.valueOf(maxOrdersPerHour)))) {
            success = false;
        }
        return success;
    }
}

