/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.config;

import com.dtyunxi.yundt.cube.center.data.api.IPcpDictApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SapPullRateLimitProperties {
    private static final Logger logger = LoggerFactory.getLogger(SapPullRateLimitProperties.class);
    private static final String DICT_CODE_ENABLED = "SAP_PULL_RATE_LIMIT_ENABLED";
    private static final String DICT_CODE_MAX_ORDERS_PER_HOUR = "SAP_PULL_RATE_LIMIT_MAX_ORDERS_PER_HOUR";
    @Resource
    private IPcpDictApi pcpDictApi;
    private static final long CACHE_EXPIRY_MS = 5000L;
    private volatile Boolean cachedEnabled;
    private volatile long cachedEnabledTimestamp;
    private volatile Integer cachedMaxOrdersPerHour;
    private volatile long cachedMaxOrdersPerHourTimestamp;
    private Boolean enabled;
    private Integer maxOrdersPerHour;

    public void refreshFromDict() {
        this.cachedEnabled = null;
        this.cachedEnabledTimestamp = 0L;
        this.cachedMaxOrdersPerHour = null;
        this.cachedMaxOrdersPerHourTimestamp = 0L;
        logger.info("\u5df2\u6e05\u7a7a\u914d\u7f6e\u7f13\u5b58\uff0c\u4e0b\u6b21\u8c03\u7528\u65f6\u5c06\u91cd\u65b0\u4ece\u5b57\u5178\u83b7\u53d6\u6700\u65b0\u914d\u7f6e");
    }

    public Boolean getEnabled() {
        long currentTime = System.currentTimeMillis();
        if (this.cachedEnabled != null && currentTime - this.cachedEnabledTimestamp < 5000L) {
            return this.cachedEnabled;
        }
        try {
            String enabledValue = Optional.ofNullable(this.pcpDictApi.queryByGroupCodeAndCode("COMMON_CONFIG", DICT_CODE_ENABLED).getData()).map(DictDto::getValue).orElse("1");
            this.cachedEnabled = "1".equals(enabledValue) || "true".equalsIgnoreCase(enabledValue);
            this.cachedEnabledTimestamp = currentTime;
            logger.debug("\u4ece\u5b57\u5178\u8bfb\u53d6\u9650\u6d41\u5f00\u5173: {} -> {}", (Object)DICT_CODE_ENABLED, (Object)this.cachedEnabled);
            return this.cachedEnabled;
        }
        catch (Exception e) {
            logger.error("\u4ece\u5b57\u5178\u8bfb\u53d6\u9650\u6d41\u5f00\u5173\u5931\u8d25\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503ctrue", (Throwable)e);
            this.cachedEnabled = true;
            this.cachedEnabledTimestamp = currentTime;
            return this.cachedEnabled;
        }
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Integer getMaxOrdersPerHour() {
        long currentTime = System.currentTimeMillis();
        if (this.cachedMaxOrdersPerHour != null && currentTime - this.cachedMaxOrdersPerHourTimestamp < 5000L) {
            return this.cachedMaxOrdersPerHour;
        }
        try {
            String maxOrdersValue = Optional.ofNullable(this.pcpDictApi.queryByGroupCodeAndCode("COMMON_CONFIG", DICT_CODE_MAX_ORDERS_PER_HOUR).getData()).map(DictDto::getValue).orElse("125");
            this.cachedMaxOrdersPerHour = Integer.parseInt(maxOrdersValue);
            this.cachedMaxOrdersPerHourTimestamp = currentTime;
            logger.debug("\u4ece\u5b57\u5178\u8bfb\u53d6\u6bcf\u5c0f\u65f6\u6700\u5927\u53ef\u62c9\u5355\u91cf: {} -> {}", (Object)DICT_CODE_MAX_ORDERS_PER_HOUR, (Object)this.cachedMaxOrdersPerHour);
            return this.cachedMaxOrdersPerHour;
        }
        catch (NumberFormatException e) {
            logger.error("\u5b57\u5178\u503c\u683c\u5f0f\u9519\u8bef\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c125: {}", (Object)e.getMessage(), (Object)e);
            this.cachedMaxOrdersPerHour = 125;
            this.cachedMaxOrdersPerHourTimestamp = currentTime;
            return this.cachedMaxOrdersPerHour;
        }
        catch (Exception e) {
            logger.error("\u4ece\u5b57\u5178\u8bfb\u53d6\u6bcf\u5c0f\u65f6\u6700\u5927\u53ef\u62c9\u5355\u91cf\u5931\u8d25\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c125", (Throwable)e);
            this.cachedMaxOrdersPerHour = 125;
            this.cachedMaxOrdersPerHourTimestamp = currentTime;
            return this.cachedMaxOrdersPerHour;
        }
    }

    public void setMaxOrdersPerHour(Integer maxOrdersPerHour) {
        this.maxOrdersPerHour = maxOrdersPerHour;
    }

    public String toString() {
        return "SapPullRateLimitProperties{enabled=" + this.enabled + ", maxOrdersPerHour=" + this.maxOrdersPerHour + '}';
    }
}

