/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.request.QualityInspectionDataReqDto;
import com.dtyunxi.tcbj.api.dto.request.QualityInspectionSubmitDataReqDto;
import com.dtyunxi.tcbj.api.dto.response.QualityInspectionDataRespDto;
import com.dtyunxi.tcbj.biz.service.IQualityInspectionDataService;
import com.dtyunxi.tcbj.dao.das.ItemsDas;
import com.dtyunxi.tcbj.dao.das.QualityInspectionDataDas;
import com.dtyunxi.tcbj.dao.das.QualityInspectionSubmitDataDas;
import com.dtyunxi.tcbj.dao.eo.ItemEo;
import com.dtyunxi.tcbj.dao.eo.QualityInspectionDataEo;
import com.dtyunxi.tcbj.dao.eo.QualityInspectionSubmitDataEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class QualityInspectionDataServiceImpl
implements IQualityInspectionDataService {
    private static final Logger log = LoggerFactory.getLogger(QualityInspectionDataServiceImpl.class);
    @Resource
    private QualityInspectionDataDas qualityInspectionDataDas;
    @Resource
    private QualityInspectionSubmitDataDas qualityInspectionSubmitDataDas;
    @Resource
    private ICommonsMqService commonsMqService;
    @Autowired
    private ItemsDas itemsDas;

    @Override
    public Long addQualityInspectionData(QualityInspectionDataReqDto addReqDto) {
        QualityInspectionDataEo qualityInspectionDataEo = new QualityInspectionDataEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)qualityInspectionDataEo);
        this.qualityInspectionDataDas.insert((BaseEo)qualityInspectionDataEo);
        return qualityInspectionDataEo.getId();
    }

    @Override
    public void modifyQualityInspectionData(QualityInspectionDataReqDto modifyReqDto) {
        QualityInspectionDataEo qualityInspectionDataEo = new QualityInspectionDataEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)qualityInspectionDataEo);
        this.qualityInspectionDataDas.updateSelective((BaseEo)qualityInspectionDataEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeQualityInspectionData(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.qualityInspectionDataDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public QualityInspectionDataRespDto queryById(Long id) {
        QualityInspectionDataEo qualityInspectionDataEo = (QualityInspectionDataEo)this.qualityInspectionDataDas.selectByPrimaryKey(id);
        QualityInspectionDataRespDto qualityInspectionDataRespDto = new QualityInspectionDataRespDto();
        DtoHelper.eo2Dto((BaseEo)qualityInspectionDataEo, (BaseVo)qualityInspectionDataRespDto);
        return qualityInspectionDataRespDto;
    }

    @Override
    public PageInfo<QualityInspectionDataRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        QualityInspectionDataReqDto qualityInspectionDataReqDto = (QualityInspectionDataReqDto)JSON.parseObject((String)filter, QualityInspectionDataReqDto.class);
        QualityInspectionDataEo qualityInspectionDataEo = new QualityInspectionDataEo();
        DtoHelper.dto2Eo((BaseVo)qualityInspectionDataReqDto, (BaseEo)qualityInspectionDataEo);
        PageInfo eoPageInfo = this.qualityInspectionDataDas.selectPage((BaseEo)qualityInspectionDataEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, QualityInspectionDataRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void batchSave(List<QualityInspectionDataReqDto> list) {
        log.info("\u8d28\u68c0\u6570\u636e\u6279\u91cf\u4fdd\u5b58\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(list));
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        Map reqMap = list.stream().collect(Collectors.toMap(QualityInspectionDataReqDto::getExternalId, Function.identity(), (k1, k2) -> k1));
        Map queryEoMap = ((ExtQueryChainWrapper)this.qualityInspectionDataDas.filter().in((Object)"external_id", (Collection)Lists.newArrayList(reqMap.keySet()))).list(Integer.valueOf(list.size())).stream().collect(Collectors.toMap(QualityInspectionDataEo::getExternalId, Function.identity(), (k1, k2) -> k1));
        List longCodes = list.stream().map(QualityInspectionDataReqDto::getLongCode).distinct().collect(Collectors.toList());
        List itemEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemsDas.filter().in((Object)"long_code", longCodes)).or(o -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)o.in((Object)"old_long_code", (Collection)longCodes);
        })).list();
        Map longCodeMap = Optional.ofNullable(itemEoList).map(m -> m.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getLongCode())).collect(Collectors.toMap(ItemEo::getLongCode, Function.identity(), (o, o1) -> o))).orElse(new HashMap());
        Map oldLongCodeMap = Optional.ofNullable(itemEoList).map(m -> m.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getOldLongCode())).collect(Collectors.toMap(ItemEo::getOldLongCode, Function.identity(), (o, o1) -> o))).orElse(new HashMap());
        ArrayList updateEoList = Lists.newArrayList();
        ArrayList insterEoList = Lists.newArrayList();
        Object userCode = ServiceContext.getContext().get("yes.req.userCode");
        reqMap.forEach((k, v) -> {
            ItemEo itemEo;
            QualityInspectionDataEo eo = new QualityInspectionDataEo();
            DtoHelper.dto2Eo((BaseVo)v, (BaseEo)eo);
            if (StringUtils.isNotBlank((CharSequence)eo.getReportTime())) {
                eo.setReportTime(this.dateFm(eo.getReportTime()));
            }
            if (ObjectUtil.isNotEmpty(longCodeMap.get(v.getLongCode()))) {
                itemEo = (ItemEo)longCodeMap.get(v.getLongCode());
                eo.setLongCode(itemEo.getLongCode());
                eo.setOldLongCode(itemEo.getOldLongCode());
            } else if (ObjectUtil.isNotEmpty(oldLongCodeMap.get(v.getLongCode()))) {
                itemEo = (ItemEo)oldLongCodeMap.get(v.getLongCode());
                eo.setLongCode(itemEo.getLongCode());
                eo.setOldLongCode(itemEo.getOldLongCode());
            } else {
                log.error("\u8d28\u68c0\u63d0\u5355\u6570\u636e\u65b0\u589e\u6216\u7f16\u8f91\uff0c\u5339\u914d\u4e0d\u5230\u57fa\u7840\u5546\u54c1\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)v));
            }
            if (queryEoMap.containsKey(k)) {
                QualityInspectionDataEo dataEo = (QualityInspectionDataEo)queryEoMap.get(k);
                if (Objects.equals(dataEo.getSource(), 2)) {
                    eo = dataEo;
                    eo.setReportResult(v.getReportResult());
                }
                eo.setId(dataEo.getId());
                if (userCode != null) {
                    eo.setUpdatePerson(String.valueOf(userCode));
                }
                updateEoList.add(eo);
            } else {
                if (userCode != null) {
                    eo.setUpdatePerson(String.valueOf(userCode));
                    eo.setCreatePerson(String.valueOf(userCode));
                }
                insterEoList.add(eo);
            }
        });
        if (CollectionUtil.isNotEmpty((Collection)updateEoList)) {
            updateEoList.forEach(i -> this.qualityInspectionDataDas.updateSelective((BaseEo)i));
        }
        if (CollectionUtil.isNotEmpty((Collection)insterEoList)) {
            this.qualityInspectionDataDas.insertBatch((List)insterEoList);
        }
    }

    @Override
    public void importBatchSave(List<QualityInspectionDataReqDto> list) {
        log.info("\u5bfc\u5165\u8d28\u68c0\u6570\u636e\u6279\u91cf\u4fdd\u5b58\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(list));
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        Map reqMap = list.stream().collect(Collectors.toMap(QualityInspectionDataReqDto::getExternalId, Function.identity(), (k1, k2) -> k1));
        Map queryEoMap = ((ExtQueryChainWrapper)this.qualityInspectionDataDas.filter().in((Object)"external_id", (Collection)Lists.newArrayList(reqMap.keySet()))).list(Integer.valueOf(list.size())).stream().collect(Collectors.toMap(QualityInspectionDataEo::getExternalId, Function.identity(), (k1, k2) -> k1));
        ArrayList updateEoList = Lists.newArrayList();
        ArrayList insterEoList = Lists.newArrayList();
        Object userCode = ServiceContext.getContext().get("yes.req.userCode");
        reqMap.forEach((k, v) -> {
            QualityInspectionDataEo eo = new QualityInspectionDataEo();
            DtoHelper.dto2Eo((BaseVo)v, (BaseEo)eo);
            eo.setSource(Integer.valueOf(2));
            if (queryEoMap.containsKey(k)) {
                QualityInspectionDataEo dataEo = (QualityInspectionDataEo)queryEoMap.get(k);
                if (Objects.equals(dataEo.getSource(), 2)) {
                    eo = dataEo;
                    eo.setReportResult(v.getReportResult());
                }
                eo.setId(dataEo.getId());
                if (userCode != null) {
                    eo.setUpdatePerson(String.valueOf(userCode));
                }
                updateEoList.add(eo);
            } else {
                if (userCode != null) {
                    eo.setUpdatePerson(String.valueOf(userCode));
                    eo.setCreatePerson(String.valueOf(userCode));
                }
                insterEoList.add(eo);
            }
        });
        if (CollectionUtil.isNotEmpty((Collection)updateEoList)) {
            updateEoList.forEach(i -> this.qualityInspectionDataDas.updateSelective((BaseEo)i));
        }
        if (CollectionUtil.isNotEmpty((Collection)insterEoList)) {
            this.qualityInspectionDataDas.insertBatch((List)insterEoList);
        }
        for (QualityInspectionDataReqDto dto : list) {
            MessageVo messageVo = new MessageVo();
            messageVo.setData((Object)JSON.toJSONString((Object)dto));
            this.commonsMqService.sendSingleMessage("IMPORT_QUALITY_INSPECTION_REPORT", (Object)messageVo);
        }
    }

    @Override
    public List<QualityInspectionDataRespDto> queryByList(List<QualityInspectionDataReqDto> queryList) {
        ArrayList dtoList = Lists.newArrayList();
        if (CollectionUtil.isEmpty(queryList)) {
            return dtoList;
        }
        List eoList = this.qualityInspectionDataDas.queryList(queryList);
        DtoHelper.eoList2DtoList((Collection)eoList, (Collection)dtoList, QualityInspectionDataRespDto.class);
        return dtoList;
    }

    @Override
    public void batchUpdate(List<QualityInspectionDataReqDto> list) {
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        list.stream().forEach(i -> {
            QualityInspectionDataEo eo = new QualityInspectionDataEo();
            eo.setId(i.getId());
            eo.setReportResult(i.getReportResult());
            this.qualityInspectionDataDas.updateSelective((BaseEo)eo);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSubmitDataCU(List<QualityInspectionSubmitDataReqDto> list) {
        List submitDataEos;
        log.info("\u8d28\u68c0\u63d0\u5355\u6570\u636e\u65b0\u589e\u6216\u7f16\u8f91\uff1a{}", (Object)JSON.toJSONString(list));
        List orderNos = list.stream().map(QualityInspectionSubmitDataReqDto::getOrderNo).collect(Collectors.toList());
        Map<Object, Object> submitDataMap = new HashMap();
        if (CollectionUtil.isNotEmpty(orderNos) && CollectionUtil.isNotEmpty((Collection)(submitDataEos = ((ExtQueryChainWrapper)this.qualityInspectionSubmitDataDas.filter().in((Object)"order_no", orderNos)).list()))) {
            submitDataMap = submitDataEos.stream().collect(Collectors.toMap(QualityInspectionSubmitDataEo::getOrderNo, Function.identity(), (k1, k2) -> k1));
        }
        for (QualityInspectionSubmitDataReqDto dto : list) {
            QualityInspectionSubmitDataEo eo = new QualityInspectionSubmitDataEo();
            DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)eo);
            if (StringUtils.isNotBlank((CharSequence)dto.getOrderNo()) && ObjectUtil.isNotEmpty((Object)submitDataMap.get(dto.getOrderNo()))) {
                eo.setId(((QualityInspectionSubmitDataEo)submitDataMap.get(dto.getOrderNo())).getId());
                this.qualityInspectionSubmitDataDas.updateSelective((BaseEo)eo);
                continue;
            }
            this.qualityInspectionSubmitDataDas.insert((BaseEo)eo);
        }
    }

    @Override
    public List<QualityInspectionSubmitDataReqDto> queryListByNotAcceptDate() {
        return this.qualityInspectionSubmitDataDas.queryListByNotAcceptDate();
    }

    private String dateFm(String input) {
        try {
            String normalizedTime = input.replace(" ", "+");
            DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
            OffsetDateTime dateTime = OffsetDateTime.parse(normalizedTime, inputFormatter);
            DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            return dateTime.format(outputFormatter);
        }
        catch (Exception e) {
            log.error("dateFm\u8f6c\u6362\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            return input;
        }
    }
}

