/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.SaleOrderMergeDataDto;
import com.dtyunxi.tcbj.api.dto.constant.enums.ApportionOrderEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.DeliveryResultOrderTypeEnum;
import com.dtyunxi.tcbj.api.dto.request.DeliveryResultOrderReqDto;
import com.dtyunxi.tcbj.api.dto.request.SaleOrderApportionReqDto;
import com.dtyunxi.tcbj.api.dto.request.SaleOrderReqDto;
import com.dtyunxi.tcbj.api.dto.request.SaleOrderResultReqDto;
import com.dtyunxi.tcbj.api.dto.response.DeliveryResultOrderDetailRespDto;
import com.dtyunxi.tcbj.api.dto.response.DeliveryResultOrderRespDto;
import com.dtyunxi.tcbj.api.dto.response.SaleOrderApportionRespDto;
import com.dtyunxi.tcbj.api.dto.response.SaleOrderResultOfFinanceDetailRespDto;
import com.dtyunxi.tcbj.api.dto.response.SaleOrderResultOfFinanceRespDto;
import com.dtyunxi.tcbj.api.dto.response.SaleResultOrderDetailRespDto;
import com.dtyunxi.tcbj.api.dto.response.SaleResultOrderRespDto;
import com.dtyunxi.tcbj.biz.config.SapPullRateLimitProperties;
import com.dtyunxi.tcbj.biz.service.IDeliveryResultOrderService;
import com.dtyunxi.tcbj.biz.service.ISaleOrderApportionService;
import com.dtyunxi.tcbj.biz.service.ISaleOrderMergeDataService;
import com.dtyunxi.tcbj.biz.service.ISaleOrderService;
import com.dtyunxi.tcbj.center.openapi.common.eas.constant.EASExtendKeyEnum;
import com.dtyunxi.tcbj.dao.das.DeliveryResultOrderDas;
import com.dtyunxi.tcbj.dao.das.DeliveryResultOrderDetailDas;
import com.dtyunxi.tcbj.dao.das.SaleOrderApportionDas;
import com.dtyunxi.tcbj.dao.das.SaleOrderApportionDetailDas;
import com.dtyunxi.tcbj.dao.das.SaleOrderDas;
import com.dtyunxi.tcbj.dao.eo.DeliveryResultOrderDetailEo;
import com.dtyunxi.tcbj.dao.eo.DeliveryResultOrderEo;
import com.dtyunxi.tcbj.dao.eo.SaleOrderApportionDetailEo;
import com.dtyunxi.tcbj.dao.vo.DeliveryResultOrderRespVo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderApi;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderTypeEnum;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeliveryResultOrderServiceImpl
implements IDeliveryResultOrderService {
    private static Logger logger = LoggerFactory.getLogger(DeliveryResultOrderServiceImpl.class);
    @Value(value="${apportion.retryCount:5}")
    private Integer retryCount;
    @Resource
    private SapPullRateLimitProperties sapPullRateLimitProperties;
    @Resource
    private ISaleOrderApportionService saleOrderApportionService;
    @Resource
    private DeliveryResultOrderDas deliveryResultOrderDas;
    @Resource
    private SaleOrderDas saleOrderDas;
    @Resource
    private SaleOrderApportionDetailDas saleOrderApportionDetailDas;
    @Resource
    private DeliveryResultOrderDetailDas deliveryResultOrderDetailDas;
    @Resource
    private ISaleOrderService saleOrderService;
    @Resource
    private ICsTransferOrderApi csTransferOrderQueryApi;
    @Resource
    private SaleOrderApportionDas saleOrderApportionDas;
    @Resource
    private ISaleOrderMergeDataService saleOrderMergeDataService;

    @Override
    public Long addDeliveryResultOrder(DeliveryResultOrderReqDto addReqDto) {
        DeliveryResultOrderEo deliveryResultOrderEo = new DeliveryResultOrderEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)deliveryResultOrderEo);
        this.deliveryResultOrderDas.insert((BaseEo)deliveryResultOrderEo);
        return deliveryResultOrderEo.getId();
    }

    @Override
    public void modifyDeliveryResultOrder(DeliveryResultOrderReqDto modifyReqDto) {
        DeliveryResultOrderEo deliveryResultOrderEo = new DeliveryResultOrderEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)deliveryResultOrderEo);
        this.deliveryResultOrderDas.updateSelective((BaseEo)deliveryResultOrderEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeDeliveryResultOrder(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.deliveryResultOrderDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public DeliveryResultOrderRespDto queryById(Long id) {
        DeliveryResultOrderEo deliveryResultOrderEo = (DeliveryResultOrderEo)this.deliveryResultOrderDas.selectByPrimaryKey(id);
        DeliveryResultOrderRespDto deliveryResultOrderRespDto = new DeliveryResultOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)deliveryResultOrderEo, (BaseVo)deliveryResultOrderRespDto);
        return deliveryResultOrderRespDto;
    }

    @Override
    public PageInfo<DeliveryResultOrderRespDto> queryByPage(DeliveryResultOrderReqDto filter) {
        Page deliveryNoticOrderRespVos = this.deliveryResultOrderDas.queryByPage(filter);
        PageInfo respDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)respDtoPageInfo, (Object)deliveryNoticOrderRespVos, (String[])new String[]{"list", "navigatepageNums"});
        List deliveryResultOrderRespVoList = deliveryNoticOrderRespVos.getResult();
        if (CollectionUtils.isNotEmpty((Collection)deliveryResultOrderRespVoList)) {
            ArrayList respDto = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)respDto, (Collection)deliveryResultOrderRespVoList, DeliveryResultOrderRespDto.class);
            List documentNos = respDto.stream().map(DeliveryResultOrderRespDto::getDocumentNo).collect(Collectors.toList());
            HashMap<String, BigDecimal> noTotalSkuMap = new HashMap<String, BigDecimal>(documentNos.size());
            noTotalSkuMap.putAll(this.deliveryResultOrderDas.queryTotalSkuListByDocumentNoList(documentNos).stream().collect(Collectors.toMap(DeliveryResultOrderRespVo::getDocumentNo, DeliveryResultOrderRespVo::getTotalSku, (o, o1) -> o)));
            respDto.forEach(o -> {
                if (ObjectUtil.isNotEmpty((Object)o.getDocumentNo())) {
                    o.setTotalSku(noTotalSkuMap.get(String.valueOf(o.getDocumentNo())) == null ? null : new BigDecimal(String.valueOf(noTotalSkuMap.get(String.valueOf(o.getDocumentNo())))));
                }
                if (StringUtils.isNotBlank((CharSequence)o.getSellerRemark()) && StringUtils.isNotBlank((CharSequence)o.getRemarkNo())) {
                    o.setRemark(String.format("\u5546\u5bb6\u5907\u6ce8:\u3010%s\u3011,\u8ba2\u5355\u5907\u6ce8:\u3010%s\u3011", o.getSellerRemark(), o.getRemarkNo()));
                } else if (StringUtils.isNotBlank((CharSequence)o.getRemarkNo())) {
                    o.setRemark(String.format("\u8ba2\u5355\u5907\u6ce8:\u3010%s\u3011", o.getRemarkNo()));
                } else if (StringUtils.isNotBlank((CharSequence)o.getSellerRemark())) {
                    o.setRemark(String.format("\u5546\u5bb6\u5907\u6ce8:\u3010%s\u3011", o.getSellerRemark()));
                } else {
                    o.setRemark(o.getDeliveryRemark());
                }
            });
            respDtoPageInfo.setList((List)respDto);
        }
        return respDtoPageInfo;
    }

    @Override
    public List<DeliveryResultOrderRespDto> queryByWarehouse(List<String> warehouseCodes, Date detailDate, DeliveryResultOrderTypeEnum deliveryResultOrderTypeEnum) {
        Assert.notNull(warehouseCodes, (String)"0001", (String)"\u6307\u5b9a\u4ed3\u5e93\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)detailDate, (String)"0001", (String)"\u6307\u5b9a\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)deliveryResultOrderTypeEnum, (String)"0001", (String)"\u8ba2\u5355\u7c7b\u578b\u4e0d\u5408\u6cd5");
        DeliveryResultOrderEo deliveryResultOrderEo = new DeliveryResultOrderEo();
        deliveryResultOrderEo.setOrderType(deliveryResultOrderTypeEnum.getKey());
        ArrayList sqlFilters = Lists.newArrayList();
        if (deliveryResultOrderTypeEnum.equals((Object)DeliveryResultOrderTypeEnum.RECEIVE)) {
            sqlFilters.add(SqlFilter.in((String)"receive_logic_warehouse_code", warehouseCodes));
        }
        if (deliveryResultOrderTypeEnum.equals((Object)DeliveryResultOrderTypeEnum.DELIVERY)) {
            sqlFilters.add(SqlFilter.in((String)"delivery_logic_warehouse_code", warehouseCodes));
        }
        sqlFilters.add(SqlFilter.lt((String)"create_time", (Object)detailDate));
        sqlFilters.add(SqlFilter.ge((String)"create_time", (Object)DateUtil.offsetDay((Date)detailDate, (int)-1)));
        deliveryResultOrderEo.setSqlFilters((List)sqlFilters);
        List collect = this.deliveryResultOrderDas.select((BaseEo)deliveryResultOrderEo);
        if (CollectionUtils.isNotEmpty((Collection)collect)) {
            ArrayList deliveryResultOrderRespDtos = Lists.newArrayList();
            DtoHelper.eoList2DtoList((Collection)collect, (Collection)deliveryResultOrderRespDtos, DeliveryResultOrderRespDto.class);
            List documentNos = collect.stream().map(c -> c.getDocumentNo()).collect(Collectors.toList());
            DeliveryResultOrderDetailEo deliveryResultOrderDetailEo = new DeliveryResultOrderDetailEo();
            deliveryResultOrderDetailEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"document_no", documentNos)}));
            List deliveryResultOrderDetailEos = this.deliveryResultOrderDetailDas.select((BaseEo)deliveryResultOrderDetailEo);
            Assert.notNull((Object)deliveryResultOrderDetailEos, (String)"0001", (String)"\u5165\u5e93\u5355\u660e\u7ec6\u5b58\u5728\u5f02\u5e38");
            ArrayList deliveryResultOrderDetailRespDtos = Lists.newArrayList();
            DtoHelper.eoList2DtoList((Collection)deliveryResultOrderDetailEos, (Collection)deliveryResultOrderDetailRespDtos, DeliveryResultOrderDetailRespDto.class);
            Map<String, List<DeliveryResultOrderDetailRespDto>> mapGroupByDocumentNo = deliveryResultOrderDetailRespDtos.stream().collect(Collectors.groupingBy(DeliveryResultOrderDetailRespDto::getDocumentNo));
            deliveryResultOrderRespDtos.forEach(c -> {
                List orDefault = mapGroupByDocumentNo.getOrDefault(c.getDocumentNo(), null);
                Assert.notNull((Object)orDefault, (String)"0001", (String)(c.getDocumentNo() + "\u5165\u5e93\u5355\u660e\u7ec6\u5b58\u5728\u5f02\u5e38"));
                c.setResultOrderDetailRespDtoList(orDefault);
            });
            return deliveryResultOrderRespDtos;
        }
        return null;
    }

    @Override
    public PageInfo<SaleOrderResultOfFinanceRespDto> querySaleOrderResultInfoPage(SaleOrderResultReqDto reqDto) {
        PageInfo saleResultOrderRespDtoPageInfo;
        logger.info("\u8d22\u52a1\u4e2d\u53f0\u6839\u636e\u5165\u53c2\u67e5\u8be2\u51fa/\u5165\u5e93\u7ed3\u679c\u5355\u53ca\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        logger.info("\u5206\u9875\u67e5\u8be2\u9500\u552e\u7ed3\u679c\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        int pageNum = Objects.isNull(reqDto.getPageNum()) ? 1 : reqDto.getPageNum();
        int pageSize = Objects.isNull(reqDto.getPageSize()) ? 10 : reqDto.getPageSize();
        reqDto.setPageNum(Integer.valueOf(pageNum));
        reqDto.setPageSize(Integer.valueOf(pageSize));
        if (reqDto.getSaleType().equals("SALE_RED")) {
            logger.info("\u9500\u552e\u7ea2\u5355\u7ed3\u679c");
            saleResultOrderRespDtoPageInfo = this.saleOrderDas.querySaleRedOrderDeliverResultPageNew(reqDto);
        } else {
            logger.info("\u9500\u552e\u5355\u7ed3\u679c");
            saleResultOrderRespDtoPageInfo = this.saleOrderDas.querySaleOrderDeliverResultPageNew(reqDto);
        }
        if (ObjectUtils.isNotEmpty((Object)saleResultOrderRespDtoPageInfo) && CollectionUtils.isNotEmpty((Collection)saleResultOrderRespDtoPageInfo.getList())) {
            this.disposeResultData((PageInfo<SaleOrderResultOfFinanceRespDto>)saleResultOrderRespDtoPageInfo, reqDto.getSaleType());
            List documentNos = saleResultOrderRespDtoPageInfo.getList().stream().map(SaleOrderResultOfFinanceRespDto::getDocumentNo).collect(Collectors.toList());
            List saleResultOrderDetailList = this.saleOrderDas.querySaleOrTransferOrderResultDetailList(documentNos, reqDto.getSaleType());
            this.disposeResultDetailData(saleResultOrderDetailList, true);
            if (CollectionUtils.isNotEmpty((Collection)saleResultOrderDetailList)) {
                Map saleResultOrderMap = saleResultOrderRespDtoPageInfo.getList().stream().collect(Collectors.toMap(SaleOrderResultOfFinanceRespDto::getDocumentNo, Function.identity(), (k1, k2) -> k1));
                saleResultOrderDetailList.forEach(detail -> {
                    SaleOrderResultOfFinanceRespDto saleResultOrderRespDto = (SaleOrderResultOfFinanceRespDto)saleResultOrderMap.get(detail.getDocumentNo());
                    if (ObjectUtils.isNotEmpty((Object)saleResultOrderRespDto)) {
                        saleResultOrderRespDto.getDetails().add(detail);
                    }
                });
            }
        }
        return saleResultOrderRespDtoPageInfo;
    }

    @Override
    public PageInfo<SaleOrderResultOfFinanceRespDto> sapQuerySaleOrderResultInfoPage(SaleOrderResultReqDto reqDto) {
        PageInfo saleResultOrderRespDtoPageInfo;
        logger.info("SAP\u67e5\u8be2\u6536\u53d1\u8d27\u7ed3\u679c\u4fe1\u606fIMPL\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        if (reqDto.getSaleType().equals("SALE_RED")) {
            logger.info("\u9500\u552e\u7ea2\u5355\u7ed3\u679c");
            saleResultOrderRespDtoPageInfo = this.saleOrderDas.querySaleRedOrderDeliverResultPageNew(reqDto);
        } else {
            logger.info("\u9500\u552e\u5355\u7ed3\u679c");
            saleResultOrderRespDtoPageInfo = this.saleOrderDas.querySaleOrderDeliverResultPageNew(reqDto);
        }
        if (ObjectUtils.isNotEmpty((Object)saleResultOrderRespDtoPageInfo) && CollectionUtils.isNotEmpty((Collection)saleResultOrderRespDtoPageInfo.getList())) {
            this.disposeResultData((PageInfo<SaleOrderResultOfFinanceRespDto>)saleResultOrderRespDtoPageInfo, reqDto.getSaleType());
            List documentNos = saleResultOrderRespDtoPageInfo.getList().stream().map(SaleOrderResultOfFinanceRespDto::getDocumentNo).collect(Collectors.toList());
            List saleResultOrderDetailList = this.saleOrderDas.querySaleOrTransferOrderResultDetailList(documentNos, reqDto.getSaleType());
            this.disposeResultDetailData(saleResultOrderDetailList, true);
            if (CollectionUtils.isNotEmpty((Collection)saleResultOrderDetailList)) {
                Map saleResultOrderMap = saleResultOrderRespDtoPageInfo.getList().stream().collect(Collectors.toMap(SaleOrderResultOfFinanceRespDto::getDocumentNo, Function.identity(), (k1, k2) -> k1));
                saleResultOrderDetailList.forEach(detail -> {
                    SaleOrderResultOfFinanceRespDto saleResultOrderRespDto = (SaleOrderResultOfFinanceRespDto)saleResultOrderMap.get(detail.getDocumentNo());
                    if (ObjectUtils.isNotEmpty((Object)saleResultOrderRespDto)) {
                        saleResultOrderRespDto.getDetails().add(detail);
                    }
                });
            }
        }
        return saleResultOrderRespDtoPageInfo;
    }

    @Override
    public PageInfo<SaleResultOrderRespDto> querySaleReceiveDeliveryResultInfoPage(SaleOrderResultReqDto reqDto) {
        List businessTypes;
        logger.info("\u9500\u552e\u5355\u6536\u53d1\u7ed3\u679c\u5206\u9875\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        int pageNum = Objects.isNull(reqDto.getPageNum()) ? 1 : reqDto.getPageNum();
        int pageSize = Objects.isNull(reqDto.getPageSize()) ? 10 : reqDto.getPageSize();
        reqDto.setPageNum(Integer.valueOf(pageNum));
        reqDto.setPageSize(Integer.valueOf(pageSize));
        if (StringUtils.isNotBlank((CharSequence)reqDto.getBusinessType()) && (businessTypes = Arrays.stream(reqDto.getBusinessType().replace("\uff0c", ",").split(",")).collect(Collectors.toList())).size() > 1) {
            reqDto.setBusinessTypes(businessTypes);
            reqDto.setBusinessType(null);
        }
        ArrayList strings = Lists.newArrayList((Object[])new String[]{SaleOrderTypeEnum.AGENCY_ORDER.getType(), SaleOrderTypeEnum.INTEGRAL_ORDER.getType(), SaleOrderTypeEnum.CUSTOMER_REFUNDING_ORDER.getType(), SaleOrderTypeEnum.COMPENSATION_ORDER.getType(), SaleOrderTypeEnum.INTERNAL_DISTRIBUTION.getType(), SaleOrderTypeEnum.SECONDARY_DISTRIBUTION.getType()});
        reqDto.setBaseBusinessTypes((List)strings);
        PageInfo saleResultOrderRespDtoPageInfo = this.deliveryResultOrderDas.querySaleReceiveDeliveryResultInfoPage(reqDto);
        if (CollectionUtils.isNotEmpty((Collection)saleResultOrderRespDtoPageInfo.getList())) {
            this.querySubTenant((PageInfo<SaleResultOrderRespDto>)saleResultOrderRespDtoPageInfo);
            List<String> nos = saleResultOrderRespDtoPageInfo.getList().stream().map(SaleResultOrderRespDto::getDocumentNo).collect(Collectors.toList());
            List<SaleOrderResultOfFinanceDetailRespDto> saleResultOrderDetailList = this.queryOrderDetailApportion(nos);
            if (CollectionUtils.isNotEmpty(saleResultOrderDetailList)) {
                Map saleResultOrderMap = saleResultOrderRespDtoPageInfo.getList().stream().collect(Collectors.toMap(SaleResultOrderRespDto::getDocumentNo, Function.identity(), (k1, k2) -> k1));
                saleResultOrderDetailList.forEach(detail -> {
                    SaleResultOrderRespDto saleResultOrderRespDto = (SaleResultOrderRespDto)saleResultOrderMap.get(detail.getDocumentNo());
                    if (ObjectUtils.isNotEmpty((Object)saleResultOrderRespDto)) {
                        SaleResultOrderDetailRespDto dto = new SaleResultOrderDetailRespDto();
                        dto.setId(ObjectUtils.isNotEmpty((Object)detail.getDetailItemId()) ? detail.getDetailItemId().toString() : null);
                        dto.setTradeOrderItemId(detail.getDetailItemId());
                        dto.setDocumentNo(detail.getDocumentNo());
                        dto.setCargoCode(detail.getCargoCode());
                        dto.setLongCode(detail.getLongCode());
                        dto.setBatch(detail.getBatch());
                        dto.setProduceTime(detail.getProduceTime());
                        dto.setExpireTime(detail.getExpireTime());
                        dto.setQuantity(ObjectUtil.isNotEmpty((Object)detail.getQuantity()) ? BigDecimal.valueOf(detail.getQuantity().intValue()) : null);
                        dto.setTaxRate(detail.getTaxRate());
                        dto.setTaxPrice(detail.getSalePrice());
                        dto.setTaxLastMoney(detail.getPayableAmount());
                        dto.setActualTaxPrice(detail.getTransactionPrice());
                        dto.setActualTotalPrice(detail.getActuallyAmount());
                        dto.setDiscountAmount(detail.getDiscountAmount());
                        saleResultOrderRespDto.getDetails().add(dto);
                    }
                });
            }
        }
        return saleResultOrderRespDtoPageInfo;
    }

    @Override
    public PageInfo<SaleResultOrderRespDto> querySaleReceiveDeliveryResultInfoPageExt(SaleOrderResultReqDto reqDto) {
        logger.info("\u8fdb\u9500\u5b58\u62c9\u5355querySaleReceiveDeliveryResultInfoPageExt\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        SaleOrderMergeDataDto saleOrderMergeDataDto = (SaleOrderMergeDataDto)BeanUtil.copyProperties((Object)reqDto, SaleOrderMergeDataDto.class, (String[])new String[0]);
        if (StringUtils.isNotBlank((CharSequence)reqDto.getExternalOrderNo())) {
            saleOrderMergeDataDto.setPlatformOrder(reqDto.getExternalOrderNo());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getPlatformOrderNo())) {
            saleOrderMergeDataDto.setPlatformOrder(reqDto.getPlatformOrderNo());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getCreateStartTime())) {
            saleOrderMergeDataDto.setCreateTimeStart(com.dtyunxi.cube.utils.DateUtil.parseDate((String)reqDto.getCreateStartTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getCreateEndTime())) {
            saleOrderMergeDataDto.setCreateTimeEnd(com.dtyunxi.cube.utils.DateUtil.parseDate((String)reqDto.getCreateEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        PageInfo<SaleOrderMergeDataDto> saleOrderMergeDataDtoPageInfo = this.saleOrderMergeDataService.queryPage(saleOrderMergeDataDto);
        PageInfo reusltPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)reusltPageInfo, saleOrderMergeDataDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (CollectionUtil.isEmpty((Collection)saleOrderMergeDataDtoPageInfo.getList())) {
            return reusltPageInfo;
        }
        List saleResultOrderRespDtoList = saleOrderMergeDataDtoPageInfo.getList().stream().map(m -> {
            SaleResultOrderRespDto respDto = new SaleResultOrderRespDto();
            respDto.setPlatformOrderNo(m.getPlatformOrder());
            respDto.setRelevanceNo(m.getSaleOrder());
            respDto.setMergeOrder(m.getMergeOrder());
            respDto.setCreateTime(m.getCreateTime());
            return respDto;
        }).collect(Collectors.toList());
        ArrayList saleOrderNos = Lists.newArrayList();
        saleOrderMergeDataDtoPageInfo.getList().forEach(data -> {
            String[] split = data.getSaleOrder().split(",");
            saleOrderNos.addAll(Arrays.asList(split));
        });
        SaleOrderResultReqDto resultReqDto = new SaleOrderResultReqDto();
        resultReqDto.setSaleOrderNos((List)saleOrderNos);
        resultReqDto.setPageNum(Integer.valueOf(1));
        resultReqDto.setPageSize(Integer.valueOf(5000));
        PageInfo<SaleResultOrderRespDto> saleResultOrderRespDtoPageInfo = this.querySaleReceiveDeliveryResultInfoPage(resultReqDto);
        Map saleResultOrderRespDtoMap = Optional.ofNullable(saleResultOrderRespDtoPageInfo.getList()).map(m -> m.stream().collect(Collectors.toMap(SaleResultOrderRespDto::getRelevanceNo, Function.identity(), (o, o1) -> o))).orElse(new HashMap());
        for (SaleResultOrderRespDto result : saleResultOrderRespDtoList) {
            List<String> relevanceNoList = Arrays.asList(result.getRelevanceNo().split(","));
            boolean ext = false;
            ArrayList<SaleResultOrderRespDto> mergeList = new ArrayList<SaleResultOrderRespDto>();
            for (String relevanceNo : relevanceNoList) {
                SaleResultOrderRespDto resultOrderRespDto = (SaleResultOrderRespDto)saleResultOrderRespDtoMap.get(relevanceNo);
                if (ObjectUtils.isEmpty((Object)resultOrderRespDto)) {
                    result.setPrompt(relevanceNo + " \u5355\u672a\u627e\u5230\u5206\u644a\u6570\u636e\u5355\u636e");
                    ext = true;
                    break;
                }
                if (CollectionUtils.isEmpty((Collection)resultOrderRespDto.getDetails())) {
                    result.setPrompt(relevanceNo + " \u5355\u672a\u627e\u5230\u5206\u644a\u6570\u636e\u660e\u7ec6");
                    ext = true;
                    break;
                }
                mergeList.add(resultOrderRespDto);
            }
            if (ext) break;
            BeanUtil.copyProperties(mergeList.get(0), (Object)result, (String[])new String[]{"relevanceNo", "mergeOrder", "createTime"});
            if (mergeList.size() == 1) {
                result.setDetails(((SaleResultOrderRespDto)mergeList.get(0)).getDetails());
                continue;
            }
            List detailRespDtoList = mergeList.stream().flatMap(order -> order.getDetails().stream()).collect(Collectors.toList());
            Map<String, List<SaleResultOrderDetailRespDto>> detailRespDtoMap = detailRespDtoList.stream().collect(Collectors.groupingBy(g -> g.getLongCode() + g.getBatch() + g.getIfGift()));
            ArrayList detail = new ArrayList();
            detailRespDtoMap.forEach((s, list) -> {
                SaleResultOrderDetailRespDto detailRespDto = (SaleResultOrderDetailRespDto)list.get(0);
                detailRespDto.setQuantity(list.stream().map(SaleResultOrderDetailRespDto::getQuantity).filter(ObjectUtil::isNotEmpty).reduce(BigDecimal.ZERO, BigDecimal::add));
                detailRespDto.setTaxLastMoney(list.stream().map(SaleResultOrderDetailRespDto::getTaxLastMoney).filter(ObjectUtil::isNotEmpty).reduce(BigDecimal.ZERO, BigDecimal::add));
                detailRespDto.setActualTotalPrice(list.stream().map(SaleResultOrderDetailRespDto::getActualTotalPrice).filter(ObjectUtil::isNotEmpty).reduce(BigDecimal.ZERO, BigDecimal::add));
                detailRespDto.setDiscountAmount(list.stream().map(SaleResultOrderDetailRespDto::getDiscountAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
                detailRespDto.setActuallyAmount(list.stream().map(SaleResultOrderDetailRespDto::getActuallyAmount).filter(ObjectUtil::isNotEmpty).reduce(BigDecimal.ZERO, BigDecimal::add));
                detailRespDto.setPayableAmount(list.stream().map(SaleResultOrderDetailRespDto::getPayableAmount).filter(ObjectUtil::isNotEmpty).reduce(BigDecimal.ZERO, BigDecimal::add));
                detail.add(detailRespDto);
            });
            result.setDetails(detail);
        }
        reusltPageInfo.setList(saleResultOrderRespDtoList);
        return reusltPageInfo;
    }

    private void querySubTenant(PageInfo<SaleResultOrderRespDto> pageInfo) {
        List subTenantList;
        logger.info("\u67e5\u8be2\u4e0b\u7ea7\u79df\u6237");
        ArrayList codes = new ArrayList();
        pageInfo.getList().forEach(info -> {
            List shippingList;
            if (StringUtils.isNotBlank((CharSequence)info.getExtension())) {
                Map map = (Map)JSON.parseObject((String)info.getExtension(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                if (info.getBusinessType().equals(SaleOrderTypeEnum.COMPENSATION_ORDER.getType())) {
                    info.setThirdCustomerId((String)map.get("thirdPartyActualId"));
                    info.setDealerId((String)map.get("thirdPartyActualId"));
                    codes.add(map.get("thirdPartyActualId"));
                } else {
                    info.setThirdCustomerId((String)map.get("thirdPartyId"));
                    info.setDealerId((String)map.get("thirdPartyId"));
                    codes.add(map.get("thirdPartyId"));
                }
                info.setProviderId((String)map.get("thirdOrgID"));
                info.setSecondTenantId((String)map.get("disDelearId"));
                codes.add(map.get("disDelearId"));
            }
            if (StringUtils.isNotBlank((CharSequence)info.getShippingJson()) && CollectionUtil.isNotEmpty((Collection)(shippingList = JSON.parseArray((String)info.getShippingJson(), CsWmsShippingInfoReqDto.class)))) {
                info.setShippingCode(((CsWmsShippingInfoReqDto)shippingList.get(0)).getConsignNo());
            }
        });
        logger.info("codes\uff1a{}", (Object)JSON.toJSONString(codes));
        if (CollectionUtil.isNotEmpty(codes) && CollectionUtil.isNotEmpty((Collection)(subTenantList = this.deliveryResultOrderDas.querySubTenant(codes)))) {
            Map<String, String> collect = subTenantList.stream().collect(Collectors.toMap(SaleResultOrderRespDto::getTenantId, SaleResultOrderRespDto::getSecondTenantId, (k1, k2) -> k1));
            pageInfo.getList().forEach(info -> {
                if (StringUtils.isNotBlank((CharSequence)info.getSecondTenantId())) {
                    info.setSecondTenantId((String)collect.get(info.getSecondTenantId()));
                }
                if (StringUtils.isNotBlank((CharSequence)info.getThirdCustomerId())) {
                    info.setTenantId((String)collect.get(info.getThirdCustomerId()));
                }
            });
        }
    }

    private void disposeResultData(PageInfo<SaleOrderResultOfFinanceRespDto> pageInfo, String saleType) {
        logger.info("\u8865\u5145\u7ed3\u679c\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(pageInfo));
        if (CollectionUtil.isNotEmpty((Collection)pageInfo.getList())) {
            pageInfo.getList().forEach(dto -> {
                if (StringUtils.isNotBlank((CharSequence)dto.getExtension())) {
                    Map extensionMap = (Map)JSON.parseObject((String)dto.getExtension(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                    if (dto.getBusinessType().equals("internal_deal_return") || dto.getBusinessType().equals("internal_deal") || dto.getBusinessType().equals("route_internal_deal") || dto.getBusinessType().equals("sale_return_internal_deal")) {
                        dto.setSaleOrganizationCode((String)extensionMap.get("saleOrganizationCode"));
                        dto.setCustomerCode((String)extensionMap.get("saleCustomerCode"));
                        dto.setEasSaleOrderNo((String)extensionMap.get("sapPlatformOrderNo"));
                        dto.setItemTotalAmount((String)extensionMap.get("itemTotalAmount"));
                    }
                    if (ObjectUtil.isNotEmpty((Object)extensionMap)) {
                        if (saleType.equals("SALE")) {
                            dto.setMarketChannel(dto.getSaleChannel());
                            if (StringUtils.isNotBlank((CharSequence)((CharSequence)extensionMap.get("subdivisionplatform")))) {
                                dto.setSaleChannel((String)extensionMap.get("subdivisionplatform"));
                            }
                            if (StringUtils.isNotBlank((CharSequence)((CharSequence)extensionMap.get("maiyouEasNo")))) {
                                dto.setMaiyouEasNo((String)extensionMap.get("maiyouEasNo"));
                            }
                            if (StringUtils.isNotBlank((CharSequence)((CharSequence)extensionMap.get("maiyouCspNo")))) {
                                dto.setMaiyouCspNo((String)extensionMap.get("maiyouCspNo"));
                            }
                            dto.setCostCenter((String)extensionMap.get("costCenter"));
                            dto.setBudgetCode((String)extensionMap.get("budgetCode"));
                            dto.setBillingCustomerName((String)extensionMap.get("billingCustomerName"));
                            dto.setBillingCustomerCode((String)extensionMap.get("billingCustomerCode"));
                        } else {
                            dto.setSaleChannel((String)extensionMap.get("subdivisionplatform"));
                            dto.setMarketChannel((String)extensionMap.get("marketChannel"));
                            dto.setProvince((String)extensionMap.get("province"));
                            dto.setCity((String)extensionMap.get("city"));
                            dto.setOffice((String)extensionMap.get("office"));
                            dto.setLinkman((String)extensionMap.get("contactPersonName"));
                            dto.setPhone((String)extensionMap.get("contactPhone"));
                            dto.setRemark((String)extensionMap.get("remark"));
                            dto.setDescription((String)extensionMap.get("description"));
                        }
                    }
                }
                dto.setExtension(null);
            });
        }
    }

    private void disposeResultDetailData(List<SaleOrderResultOfFinanceDetailRespDto> list, boolean ifClear) {
        if (CollectionUtil.isNotEmpty(list)) {
            logger.info("\u8865\u5145\u7ed3\u679c\u660e\u7ec6\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(list));
            list.forEach(dto -> {
                if (StringUtils.isNotBlank((CharSequence)dto.getExtension())) {
                    Map extensionMap = (Map)JSON.parseObject((String)dto.getExtension(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                    dto.setCspLineNo((String)extensionMap.get(EASExtendKeyEnum.CSP_LINE_NO.code));
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)extensionMap.get(EASExtendKeyEnum.ENTRY_ID.code)))) {
                        dto.setSourceBillEntryId((String)extensionMap.get(EASExtendKeyEnum.ENTRY_ID.code));
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)extensionMap.get(EASExtendKeyEnum.ENTRY_ID2.code)))) {
                        dto.setSourceBillEntryId((String)extensionMap.get(EASExtendKeyEnum.ENTRY_ID2.code));
                    }
                    if (ObjectUtils.isEmpty((Object)dto.getTaxPrice())) {
                        dto.setTaxPrice(ObjectUtil.isNotEmpty(extensionMap.get("price")) ? new BigDecimal((String)extensionMap.get("price")) : null);
                    }
                    if (ObjectUtils.isEmpty((Object)dto.getSalePrice())) {
                        dto.setSalePrice(ObjectUtil.isNotEmpty(extensionMap.get("salePrice")) ? new BigDecimal((String)extensionMap.get("salePrice")) : null);
                    }
                    if (ObjectUtils.isEmpty((Object)dto.getActuallyAmount())) {
                        dto.setActuallyAmount(ObjectUtil.isNotEmpty(extensionMap.get("actuallyAmount")) ? new BigDecimal((String)extensionMap.get("actuallyAmount")) : null);
                    }
                    if (ObjectUtils.isEmpty((Object)dto.getPayableAmount())) {
                        dto.setPayableAmount(ObjectUtil.isNotEmpty(extensionMap.get("payableAmount")) ? new BigDecimal((String)extensionMap.get("payableAmount")) : null);
                    }
                    if (ObjectUtils.isEmpty((Object)dto.getDiscountAmount())) {
                        dto.setDiscountAmount(ObjectUtil.isNotEmpty(extensionMap.get("discountAmount")) ? new BigDecimal((String)extensionMap.get("discountAmount")) : null);
                    }
                    if (ObjectUtils.isEmpty((Object)dto.getTaxRate())) {
                        dto.setTaxRate(ObjectUtil.isNotEmpty(extensionMap.get("taxRate")) ? new BigDecimal((String)extensionMap.get("taxRate")) : null);
                    }
                    if (ObjectUtils.isEmpty((Object)dto.getProjectNo())) {
                        dto.setProjectNo((String)extensionMap.get(EASExtendKeyEnum.INTERNAL_DEAL_DETAIL_PROJECT_NO.code));
                    }
                    if (ObjectUtils.isEmpty((Object)dto.getIfOnline())) {
                        dto.setIfOnline(ObjectUtil.isNotEmpty(extensionMap.get(EASExtendKeyEnum.INTERNAL_DEAL_DETAIL_IF_ONLINE.code)) ? Integer.valueOf(new BigDecimal((String)extensionMap.get(EASExtendKeyEnum.INTERNAL_DEAL_DETAIL_IF_ONLINE.code)).intValue()) : null);
                    }
                    if (ObjectUtils.isEmpty((Object)dto.getTrackPlan())) {
                        dto.setTrackPlan((String)extensionMap.get(EASExtendKeyEnum.INTERNAL_DEAL_DETAIL_TRACK_PLAN.code));
                    }
                    if (ifClear) {
                        dto.setExtension(null);
                    }
                }
            });
        } else {
            logger.info("\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        }
    }

    @Override
    public void saleOrderDetailApportion(String saleOrder) {
        logger.info("\u9500\u552e\u8ba2\u5355\u5206\u644a\u7ed3\u679c\u660e\u7ec6\uff1a{}", (Object)saleOrder);
        this.orderDetailApportionBase(saleOrder, ApportionOrderEnum.SALE.getCode());
    }

    @Override
    public void orderDetailApportionBase(String orderNo, String type) {
        logger.info("\u8ba2\u5355\u5206\u644a\u7ed3\u679c\u660e\u7ec6\uff1a{}\uff0c{}", (Object)orderNo, (Object)type);
        List<SaleOrderResultOfFinanceDetailRespDto> list = new ArrayList<SaleOrderResultOfFinanceDetailRespDto>();
        SaleOrderApportionRespDto saleOrderApportionRespDto = null;
        try {
            saleOrderApportionRespDto = this.saleOrderApportionService.addSaleOrderApportion(orderNo, type);
            if (ObjectUtil.isEmpty((Object)saleOrderApportionRespDto)) {
                throw new BizException("-1", "\u65b0\u589e\u5355\u636e\u5931\u8d25");
            }
            String orderType = "out";
            List<SaleOrderResultOfFinanceDetailRespDto> sourceDetails = new ArrayList();
            if (ObjectUtil.isEmpty((Object)ApportionOrderEnum.getByCode((String)type))) {
                throw new BizException("-1", "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7c7b\u578b\uff1a" + type);
            }
            switch (Objects.requireNonNull(ApportionOrderEnum.getByCode((String)type))) {
                case SALE: {
                    sourceDetails = this.saleOrderDas.querySaleDetails(orderNo);
                    break;
                }
                case SALE_REFUND: {
                    sourceDetails = this.saleOrderDas.querySaleRefundDetails(orderNo);
                    orderType = "in";
                    break;
                }
                case INTERNAL_DEAL: 
                case ROUTE_INTERNAL_DEAL: {
                    sourceDetails = this.saleOrderDas.queryTransferDetails(orderNo);
                    this.disposeResultDetailData(sourceDetails, false);
                    orderType = "out";
                    break;
                }
                case INTERNAL_DEAL_RETURN: 
                case SALE_RETURN_INTERNAL_DEAL: {
                    sourceDetails = this.saleOrderDas.queryTransferDetails(orderNo);
                    this.disposeResultDetailData(sourceDetails, false);
                    orderType = "in";
                    break;
                }
                case SALE_TRANSFER: {
                    CsTransferOrderRespDto transferOrder = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderQueryApi.queryByTransferOrderNo(orderNo));
                    sourceDetails = this.saleOrderDas.querySaleDetails(transferOrder.getSaleOrderNo());
                    if (!CollectionUtil.isNotEmpty(sourceDetails)) break;
                    sourceDetails.forEach(d -> {
                        d.setOrderNo(transferOrder.getTransferOrderNo());
                        d.setPlatformOrderNo(transferOrder.getPreOrderNo());
                    });
                    break;
                }
                default: {
                    logger.info("\u672a\u5904\u7406\u7684\u7c7b\u578b");
                }
            }
            if (CollectionUtil.isEmpty(sourceDetails)) {
                throw new BizException("-1", "\u627e\u4e0d\u5230\u6e90\u5355\u660e\u7ec6");
            }
            List resultDetails = this.saleOrderDas.queryResultDetails(orderNo, orderType);
            if (CollectionUtil.isEmpty((Collection)resultDetails)) {
                throw new BizException("-1", "\u627e\u4e0d\u5230\u7ed3\u679c\u5355\u660e\u7ec6");
            }
            list = this.saleOrderDetailApportion(orderNo, type, sourceDetails, resultDetails);
        }
        catch (Exception e) {
            SaleOrderResultOfFinanceDetailRespDto dto = new SaleOrderResultOfFinanceDetailRespDto();
            dto.setOrderNo(orderNo);
            dto.setType(type);
            dto.setExtension(e.getMessage());
            list.add(dto);
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (CollectionUtil.isNotEmpty(list)) {
            SaleOrderApportionDetailEo delParams = new SaleOrderApportionDetailEo();
            delParams.setOrderNo(orderNo);
            this.saleOrderApportionDetailDas.logicDelete((BaseEo)delParams);
            ArrayList eoList = new ArrayList();
            CubeBeanUtils.copyCollection(eoList, list, SaleOrderApportionDetailEo.class);
            this.saleOrderApportionDetailDas.insertBatch(eoList);
            if (ObjectUtil.isNotEmpty((Object)saleOrderApportionRespDto) && StringUtils.isNotBlank((CharSequence)((SaleOrderApportionDetailEo)eoList.get(0)).getDocumentNo())) {
                this.updateSaleOrderApportion(saleOrderApportionRespDto, ((SaleOrderApportionDetailEo)eoList.get(0)).getDocumentNo());
            }
            return;
        }
        logger.info("\u65e0\u5206\u644a\u6570\u636e");
    }

    private void updateSaleOrderApportion(SaleOrderApportionRespDto saleOrderApportionRespDto, String documentNo) {
        logger.info("\u5206\u644a\u5b8c\u6210\u66f4\u65b0\u5206\u644a\u5355\u636e\uff1a{}", (Object)JSON.toJSONString((Object)saleOrderApportionRespDto));
        SaleOrderApportionReqDto updateDto = new SaleOrderApportionReqDto();
        Date futureDate = new Date();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("pullable", (Object)0);
        String jsonString = jsonObject.toJSONString();
        if (saleOrderApportionRespDto.getType().equals(ApportionOrderEnum.SALE.getCode()) && StringUtils.isNotBlank((CharSequence)saleOrderApportionRespDto.getOrderMainNo())) {
            updateDto.setId(saleOrderApportionRespDto.getId());
            updateDto.setIfPull(Integer.valueOf(1));
            updateDto.setOrderNo(saleOrderApportionRespDto.getOrderNo());
            updateDto.setDocumentNo(documentNo);
            updateDto.setExtension(jsonString);
            this.saleOrderApportionService.modifySaleOrderApportion(updateDto);
            SaleOrderReqDto reqDto = new SaleOrderReqDto();
            reqDto.setOrderNo(saleOrderApportionRespDto.getOrderNo());
            if (this.saleOrderService.verifySaleOrderEntireReceiveDelivery(reqDto).booleanValue()) {
                this.saleOrderApportionService.openPullDateByMain(saleOrderApportionRespDto.getOrderMainNo(), futureDate);
            }
        } else if (saleOrderApportionRespDto.getType().equals(ApportionOrderEnum.SALE_REFUND.getCode())) {
            SaleOrderApportionRespDto refundOrder = this.saleOrderApportionDas.queryRefundSale(saleOrderApportionRespDto.getOrderNo());
            updateDto.setId(saleOrderApportionRespDto.getId());
            updateDto.setOrderNo(saleOrderApportionRespDto.getOrderNo());
            updateDto.setDocumentNo(documentNo);
            updateDto.setIfPull(Integer.valueOf(1));
            updateDto.setExtension(jsonString);
            if (this.saleOrderService.verifySaleRefundApportionResult(saleOrderApportionRespDto.getOrderNo()).booleanValue() && StringUtils.isNotBlank((CharSequence)refundOrder.getSapOrderNo())) {
                updateDto.setOpenPullDate(futureDate);
            }
            this.saleOrderApportionService.modifySaleOrderApportion(updateDto);
        } else {
            updateDto.setId(saleOrderApportionRespDto.getId());
            updateDto.setOrderNo(saleOrderApportionRespDto.getOrderNo());
            updateDto.setDocumentNo(documentNo);
            updateDto.setIfPull(Integer.valueOf(1));
            updateDto.setOpenPullDate(futureDate);
            updateDto.setExtension(jsonString);
            this.saleOrderApportionService.modifySaleOrderApportion(updateDto);
        }
    }

    @Override
    public List<SaleOrderResultOfFinanceDetailRespDto> queryOrderDetailApportion(List<String> documentNos) {
        logger.info("\u9500\u552e\u7ed3\u679c\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString(documentNos));
        if (CollectionUtils.isNotEmpty(documentNos)) {
            return this.saleOrderDas.querySaleOrTransferOrderResultDetailList(documentNos, null);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<SaleOrderResultOfFinanceDetailRespDto> queryOrderDetailApportionBySaleOrderNo(List<String> saleOrderNos) {
        logger.info("\u9500\u552e\u7ed3\u679c\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString(saleOrderNos));
        return this.saleOrderDas.querySaleOrTransferOrderResultDetailListBySaleOrder(saleOrderNos, null);
    }

    @Override
    public void orderDetailApportionRetry() {
        logger.info("\u9500\u552e\u7ed3\u679c\u5206\u644a\u91cd\u8bd5\uff0c\u5f53\u524d\u8bbe\u7f6e\u6b21\u6570\u4e3a\uff1a{}", (Object)this.retryCount);
        List detailRespDtoList = this.saleOrderApportionDetailDas.orderDetailApportionRetryQuery(this.retryCount);
        if (CollectionUtils.isNotEmpty((Collection)detailRespDtoList)) {
            logger.info("\u5f85\u91cd\u8bd5\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)detailRespDtoList));
            detailRespDtoList.forEach(dto -> {
                logger.info("\u5206\u644a\u91cd\u8bd5\uff1a{}", (Object)JSON.toJSONString((Object)dto));
                this.orderDetailApportionBase(dto.getOrderNo(), dto.getType());
            });
            return;
        }
        logger.info("\u65e0\u9700\u8981\u91cd\u8bd5\u7684\u8bb0\u5f55\uff1a{}", (Object)JSON.toJSONString((Object)detailRespDtoList));
    }

    private List<SaleOrderResultOfFinanceDetailRespDto> saleOrderDetailApportion(String saleOrder, String type, List<SaleOrderResultOfFinanceDetailRespDto> orderDetails, List<SaleOrderResultOfFinanceDetailRespDto> resultDetails) {
        logger.info("\u9500\u552e\u7ed3\u679c\u660e\u7ec6\u91d1\u989d\u5206\u644a\uff1a{}", (Object)saleOrder);
        logger.info("orderDetails\uff1a{}", (Object)JSON.toJSONString(orderDetails));
        logger.info("resultDetails\uff1a{}", (Object)JSON.toJSONString(resultDetails));
        ArrayList<SaleOrderResultOfFinanceDetailRespDto> apportionDetails = new ArrayList<SaleOrderResultOfFinanceDetailRespDto>();
        orderDetails.forEach(orderDetail -> {
            ArrayList<SaleOrderResultOfFinanceDetailRespDto> list = new ArrayList<SaleOrderResultOfFinanceDetailRespDto>();
            resultDetails.stream().filter(resultDetail -> {
                if (orderDetail.getLongCode().equals(resultDetail.getLongCode()) && orderDetail.getQuantity() > 0 && resultDetail.getQuantity() > 0) {
                    SaleOrderResultOfFinanceDetailRespDto dto = this.buildFinanceDetailDto(type, (SaleOrderResultOfFinanceDetailRespDto)orderDetail, (SaleOrderResultOfFinanceDetailRespDto)resultDetail);
                    logger.info("\u5f53\u524d\u5904\u7406\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)dto));
                    if (orderDetail.getQuantity() <= resultDetail.getQuantity()) {
                        dto.setQuantity(orderDetail.getQuantity());
                        resultDetail.setQuantity(Integer.valueOf(resultDetail.getQuantity() - orderDetail.getQuantity()));
                        orderDetail.setQuantity(Integer.valueOf(0));
                    } else {
                        dto.setQuantity(resultDetail.getQuantity());
                        orderDetail.setQuantity(Integer.valueOf(orderDetail.getQuantity() - resultDetail.getQuantity()));
                        resultDetail.setQuantity(Integer.valueOf(0));
                    }
                    list.add(dto);
                    return orderDetail.getQuantity() == 0;
                }
                return false;
            }).findAny();
            if (CollectionUtil.isNotEmpty(list)) {
                apportionDetails.addAll(this.amountApportion(list));
            }
        });
        return apportionDetails;
    }

    private List<SaleOrderResultOfFinanceDetailRespDto> amountApportion(List<SaleOrderResultOfFinanceDetailRespDto> details) {
        BigDecimal transactionPrice;
        logger.info("\u91d1\u989d\u5206\u644a\uff1a{}", (Object)JSON.toJSONString(details));
        int sum = details.stream().mapToInt(SaleOrderResultOfFinanceDetailRespDto::getQuantity).sum();
        BigDecimal actuallyAmount = details.get(0).getActuallyAmount();
        if (actuallyAmount == null) {
            actuallyAmount = BigDecimal.ZERO;
        }
        if ((transactionPrice = details.get(0).getTransactionPrice()) == null) {
            transactionPrice = BigDecimal.ZERO;
        }
        BigDecimal discountAmount = details.get(0).getDiscountAmount();
        BigDecimal discountAmountSingle = BigDecimal.ZERO;
        if (ObjectUtil.isNotEmpty((Object)discountAmount)) {
            discountAmountSingle = discountAmount.divide(new BigDecimal(sum), 4, 4);
        }
        BigDecimal totalScore = details.get(0).getTotalScore();
        BigDecimal totalScoreSingle = BigDecimal.ZERO;
        if (ObjectUtil.isNotEmpty((Object)totalScore)) {
            totalScoreSingle = totalScore.divide(new BigDecimal(sum), 4, 4);
        }
        BigDecimal payableAmount = details.get(0).getPayableAmount();
        BigDecimal payableAmountSingle = BigDecimal.ZERO;
        if (ObjectUtil.isNotEmpty((Object)payableAmount)) {
            payableAmountSingle = payableAmount.divide(new BigDecimal(sum), 4, 4);
        }
        BigDecimal myBeforeDisAmt = Optional.ofNullable(details.get(0).getMyBeforeDisAmt()).orElse(BigDecimal.ZERO);
        BigDecimal myBeforeDisAmtPrice = myBeforeDisAmt.divide(new BigDecimal(sum), 4, RoundingMode.HALF_UP);
        BigDecimal myPromotionDis = Optional.ofNullable(details.get(0).getMyPromotionDis()).orElse(BigDecimal.ZERO);
        BigDecimal myPromotionDisPrice = myPromotionDis.divide(new BigDecimal(sum), 4, RoundingMode.HALF_UP);
        BigDecimal mySaleReturnDis = Optional.ofNullable(details.get(0).getMySaleReturnDis()).orElse(BigDecimal.ZERO);
        BigDecimal mySaleReturnDisPrice = mySaleReturnDis.divide(new BigDecimal(sum), 4, RoundingMode.HALF_UP);
        if (details.size() == 1) {
            details.get(0).setDiscountAmountSingle(discountAmountSingle);
            return details;
        }
        logger.info("\u91d1\u989d\uff1a{}\uff0c{}", (Object)actuallyAmount, (Object)discountAmount);
        logger.info("\u91d1\u989d\u5206\u644a\uff1a{}\uff0c{}", (Object)actuallyAmount, (Object)discountAmount);
        for (int i = 0; i < details.size(); ++i) {
            if (i == details.size() - 1) {
                logger.info("\u6700\u540e\u4e00\u9879\uff1a{}\uff0c{}", (Object)actuallyAmount, (Object)discountAmount);
                logger.info("\u6700\u540e\u4e00\u98792\uff1a{}\uff0c{}", (Object)actuallyAmount, (Object)discountAmount);
                details.get(i).setTransactionPrice(transactionPrice);
                details.get(i).setActuallyAmount(actuallyAmount);
                details.get(i).setDiscountAmountSingle(discountAmountSingle);
                details.get(i).setDiscountAmount(discountAmount);
                details.get(i).setTotalScoreSingle(totalScoreSingle);
                details.get(i).setTotalScore(totalScore);
                details.get(i).setPayableAmountSingle(payableAmountSingle);
                details.get(i).setPayableAmount(payableAmount);
                details.get(i).setMyBeforeDisAmt(myBeforeDisAmt);
                details.get(i).setMyPromotionDis(myPromotionDis);
                details.get(i).setMySaleReturnDis(mySaleReturnDis);
                break;
            }
            details.get(i).setTransactionPrice(transactionPrice);
            if (transactionPrice.compareTo(BigDecimal.ZERO) == 0) {
                details.get(i).setActuallyAmount(actuallyAmount);
                logger.info("\u5206\u644a\u5b9e\u4ed8\u91d1\u989d\u4e3a1");
            } else {
                details.get(i).setActuallyAmount(transactionPrice.multiply(new BigDecimal(details.get(i).getQuantity())));
                actuallyAmount = actuallyAmount.subtract(details.get(i).getActuallyAmount());
                logger.info("\u5206\u644a\u5b9e\u4ed8\u91d1\u989d\uff1a{},{}", (Object)details.get(i).getActuallyAmount(), (Object)actuallyAmount);
            }
            details.get(i).setDiscountAmountSingle(discountAmountSingle);
            if (discountAmountSingle.compareTo(BigDecimal.ZERO) == 0) {
                details.get(i).setDiscountAmount(discountAmount);
                logger.info("\u5206\u644a\u6298\u6263\u91d1\u989d\u4e3a1");
            } else {
                details.get(i).setDiscountAmount(discountAmountSingle.multiply(new BigDecimal(details.get(i).getQuantity())));
                discountAmount = discountAmount.subtract(details.get(i).getDiscountAmount());
                logger.info("\u5206\u644a\u6298\u6263\u91d1\u989d\uff1a{},{}", (Object)details.get(i).getDiscountAmount(), (Object)discountAmount);
            }
            details.get(i).setTotalScoreSingle(totalScoreSingle);
            if (totalScoreSingle.compareTo(BigDecimal.ZERO) == 0) {
                details.get(i).setTotalScore(totalScore);
            } else {
                details.get(i).setTotalScore(totalScoreSingle.multiply(new BigDecimal(details.get(i).getQuantity())));
                totalScore = totalScore.subtract(details.get(i).getTotalScore());
                logger.info("\u79ef\u5206\u5206\u644a\uff1a{},{}", (Object)details.get(i).getTotalScore(), (Object)totalScore);
            }
            details.get(i).setPayableAmountSingle(payableAmountSingle);
            if (payableAmountSingle.compareTo(BigDecimal.ZERO) == 0) {
                details.get(i).setPayableAmount(payableAmount);
            } else {
                details.get(i).setPayableAmount(payableAmountSingle.multiply(new BigDecimal(details.get(i).getQuantity())));
                payableAmount = payableAmount.subtract(details.get(i).getPayableAmount());
                logger.info("\u5206\u644a\u5e94\u4ed8\u91d1\u989d\uff1a{},{}", (Object)details.get(i).getPayableAmount(), (Object)payableAmount);
            }
            details.get(i).setMyBeforeDisAmt(myBeforeDisAmtPrice.multiply(new BigDecimal(details.get(i).getQuantity())));
            myBeforeDisAmt = myBeforeDisAmt.subtract(details.get(i).getMyBeforeDisAmt());
            logger.info("\u6298\u524d\u4ef7\u7a0e\u5408\u8ba1\uff1a{},{}", (Object)details.get(i).getMyBeforeDisAmt(), (Object)myBeforeDisAmt);
            details.get(i).setMyPromotionDis(myPromotionDisPrice.multiply(new BigDecimal(details.get(i).getQuantity())));
            myPromotionDis = myPromotionDis.subtract(details.get(i).getMyPromotionDis());
            logger.info("\u4fc3\u9500\u6d3b\u52a8\u6298\u6263\uff1a{},{}", (Object)details.get(i).getMyPromotionDis(), (Object)myPromotionDis);
            details.get(i).setMySaleReturnDis(mySaleReturnDisPrice.multiply(new BigDecimal(details.get(i).getQuantity())));
            mySaleReturnDis = mySaleReturnDis.subtract(details.get(i).getMySaleReturnDis());
            logger.info("\u9500\u552e\u8fd4\u5229\u6298\u6263\uff1a{},{}", (Object)details.get(i).getMySaleReturnDis(), (Object)mySaleReturnDis);
        }
        logger.info("details\uff1a{}", (Object)JSON.toJSONString(details));
        return details;
    }

    private SaleOrderResultOfFinanceDetailRespDto buildFinanceDetailDto(String type, SaleOrderResultOfFinanceDetailRespDto dto, SaleOrderResultOfFinanceDetailRespDto resultDto) {
        logger.info("\u6784\u5efa\u5206\u644a\u660e\u7ec6Dto\uff1a{}\uff0c{}\uff0c{}", new Object[]{type, JSON.toJSONString((Object)dto), JSON.toJSONString((Object)resultDto)});
        SaleOrderResultOfFinanceDetailRespDto respDto = new SaleOrderResultOfFinanceDetailRespDto();
        BeanUtils.copyProperties((Object)dto, (Object)respDto);
        respDto.setBatch(resultDto.getBatch());
        respDto.setWarehouseCode(resultDto.getWarehouseCode());
        respDto.setProduceTime(resultDto.getProduceTime());
        respDto.setExpireTime(resultDto.getExpireTime());
        respDto.setDocumentNo(resultDto.getDocumentNo());
        respDto.setQuantity(Integer.valueOf(0));
        respDto.setType(type);
        respDto.setSourceBillEntryId(this.getExtensionValue(dto.getExtension(), "sourceBillEntryId"));
        if (StringUtils.isBlank((CharSequence)respDto.getSourceBillEntryId())) {
            respDto.setSourceBillEntryId(this.getExtensionValue(dto.getExtension(), "sapLineNo"));
        }
        return respDto;
    }

    @Override
    public List<DeliveryResultOrderRespDto> queryDeliveryResultOrder(DeliveryResultOrderReqDto reqDto) {
        DeliveryResultOrderEo deliveryResultOrderEo = new DeliveryResultOrderEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)deliveryResultOrderEo);
        ArrayList sqlFilters = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getRelevanceNos())) {
            sqlFilters.add(SqlFilter.in((String)"relevance_no", (Object)reqDto.getRelevanceNos()));
        }
        deliveryResultOrderEo.setSqlFilters((List)sqlFilters);
        List collect = this.deliveryResultOrderDas.select((BaseEo)deliveryResultOrderEo);
        if (CollectionUtils.isNotEmpty((Collection)collect)) {
            ArrayList deliveryResultOrderRespDtos = Lists.newArrayList();
            DtoHelper.eoList2DtoList((Collection)collect, (Collection)deliveryResultOrderRespDtos, DeliveryResultOrderRespDto.class);
            List documentNos = collect.stream().map(c -> c.getDocumentNo()).collect(Collectors.toList());
            DeliveryResultOrderDetailEo deliveryResultOrderDetailEo = new DeliveryResultOrderDetailEo();
            deliveryResultOrderDetailEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"document_no", documentNos)}));
            List deliveryResultOrderDetailEos = this.deliveryResultOrderDetailDas.select((BaseEo)deliveryResultOrderDetailEo);
            Assert.notNull((Object)deliveryResultOrderDetailEos, (String)"0001", (String)"\u5165\u5e93\u5355\u660e\u7ec6\u5b58\u5728\u5f02\u5e38");
            ArrayList deliveryResultOrderDetailRespDtos = Lists.newArrayList();
            DtoHelper.eoList2DtoList((Collection)deliveryResultOrderDetailEos, (Collection)deliveryResultOrderDetailRespDtos, DeliveryResultOrderDetailRespDto.class);
            Map<String, List<DeliveryResultOrderDetailRespDto>> mapGroupByDocumentNo = deliveryResultOrderDetailRespDtos.stream().collect(Collectors.groupingBy(DeliveryResultOrderDetailRespDto::getDocumentNo));
            deliveryResultOrderRespDtos.forEach(c -> {
                List orDefault = mapGroupByDocumentNo.getOrDefault(c.getDocumentNo(), null);
                Assert.notNull((Object)orDefault, (String)"0001", (String)(c.getDocumentNo() + "\u5165\u5e93\u5355\u660e\u7ec6\u5b58\u5728\u5f02\u5e38"));
                c.setResultOrderDetailRespDtoList(orDefault);
            });
            return deliveryResultOrderRespDtos;
        }
        return null;
    }

    @Override
    public List<SaleOrderResultOfFinanceDetailRespDto> easTransferOrderApportion(String transferOrderNo, String documentNo) {
        List transferOrderDetails = this.saleOrderDas.queryTransferDetails(transferOrderNo);
        if (CollectionUtil.isEmpty((Collection)transferOrderDetails)) {
            throw new BizException("-1", "\u5206\u644a\u5931\u8d25\uff1a\u627e\u4e0d\u5230\u4e1a\u52a1\u5355\u636e\u660e\u7ec6\u6570\u636e");
        }
        List resultDetails = this.saleOrderDas.queryResultDetails2(documentNo);
        if (CollectionUtil.isEmpty((Collection)resultDetails)) {
            throw new BizException("-1", "\u5206\u644a\u5931\u8d25\uff1a\u627e\u4e0d\u5230\u7ed3\u679c\u5355\u636e\u660e\u7ec6");
        }
        ArrayList<SaleOrderResultOfFinanceDetailRespDto> apportionDetails = new ArrayList<SaleOrderResultOfFinanceDetailRespDto>();
        transferOrderDetails.forEach(orderDetail -> {
            ArrayList list = new ArrayList();
            resultDetails.stream().filter(resultDetail -> {
                if (orderDetail.getLongCode().equals(resultDetail.getLongCode()) && orderDetail.getQuantity() > 0 && resultDetail.getQuantity() > 0) {
                    SaleOrderResultOfFinanceDetailRespDto dto = this.buildFinanceDetailDto(null, (SaleOrderResultOfFinanceDetailRespDto)orderDetail, (SaleOrderResultOfFinanceDetailRespDto)resultDetail);
                    logger.info("\u5f53\u524d\u5904\u7406\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)dto));
                    if (orderDetail.getQuantity() <= resultDetail.getQuantity()) {
                        dto.setQuantity(orderDetail.getQuantity());
                        resultDetail.setQuantity(Integer.valueOf(resultDetail.getQuantity() - orderDetail.getQuantity()));
                        orderDetail.setQuantity(Integer.valueOf(0));
                    } else {
                        dto.setQuantity(resultDetail.getQuantity());
                        orderDetail.setQuantity(Integer.valueOf(orderDetail.getQuantity() - resultDetail.getQuantity()));
                        resultDetail.setQuantity(Integer.valueOf(0));
                    }
                    list.add(dto);
                    return orderDetail.getQuantity() == 0;
                }
                return false;
            }).findAny();
            if (CollectionUtil.isNotEmpty(list)) {
                apportionDetails.addAll(list);
            }
            if (orderDetail.getQuantity() != 0) {
                logger.info("\u5206\u644a\u4e0d\u8db3\uff1a{}", (Object)orderDetail.getLongCode());
            }
        });
        return apportionDetails;
    }

    private String getExtensionValue(String extension, String key) {
        Map map;
        Object obj;
        logger.info("\u83b7\u53d6\u6269\u5c55\u5b57\u6bb5\u6307\u5b9a\u5185\u5bb9\uff1a{}=={}", (Object)key, (Object)JSON.toJSONString((Object)extension));
        if (StringUtils.isNotBlank((CharSequence)extension) && ObjectUtil.isNotEmpty(obj = (map = (Map)JSON.parseObject((String)extension, Map.class)).get(key))) {
            return obj.toString();
        }
        return "";
    }
}

