/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.job;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.tcbj.api.dto.request.LogisticStatisticReqDto;
import com.dtyunxi.tcbj.biz.service.IFinLogisticsReportService;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service(value="LogisticsReportJob")
@Scope(value="prototype")
public class LogisticsReportJob
extends SingleTupleScheduleEvent {
    private static final Logger logger = LoggerFactory.getLogger(LogisticsReportJob.class);
    private final SimpleDateFormat startFormat = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
    private final SimpleDateFormat endFormat = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
    @Resource
    private IFinLogisticsReportService finLogisticsReportService;

    public void before(TaskMsg taskMsg) {
    }

    public boolean execute(TaskMsg taskMsg) {
        try {
            MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
            logger.error("\u7269\u6d41\u8d39\u7528\u62a5\u8868\u751f\u6210\u8c03\u5ea6\u6267\u884c\uff1a{}", (Object)taskMsg.getContent());
            LogisticStatisticReqDto logisticStatisticReqDto = new LogisticStatisticReqDto();
            if (StringUtils.isNotBlank((CharSequence)taskMsg.getContent())) {
                logisticStatisticReqDto = (LogisticStatisticReqDto)JSON.parseObject((String)taskMsg.getContent(), LogisticStatisticReqDto.class);
            }
            if (ObjectUtils.isEmpty((Object)logisticStatisticReqDto.getStartTime()) || ObjectUtils.isEmpty((Object)logisticStatisticReqDto.getEndTime())) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(new Date());
                cal.add(5, -1);
                Date time = cal.getTime();
                logisticStatisticReqDto.setStartTime(this.startFormat.format(time));
                logisticStatisticReqDto.setEndTime(this.endFormat.format(time));
            }
            this.finLogisticsReportService.statisticDataNew(logisticStatisticReqDto);
        }
        catch (Exception e) {
            logger.error("\u7269\u6d41\u8d39\u7528\u62a5\u8868\u751f\u6210\u8c03\u5ea6\u6267\u884c\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return true;
        }
        return true;
    }

    public void after(TaskMsg taskMsg) {
    }
}

