/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.finance.api.dto.request.logistic.RuleWeightDto;
import com.dtyunxi.finance.api.dto.request.logistic.SeasonWeightDto;
import com.dtyunxi.finance.api.dto.request.logistic.TemplateWeightDto;
import com.dtyunxi.finance.api.dto.response.logistic.AppointAreaQueryRespDto;
import com.dtyunxi.finance.api.dto.response.logistic.LogisticRecordQueryRespDto;
import com.dtyunxi.finance.api.dto.response.logistic.OilLinkQueryRespDto;
import com.dtyunxi.finance.api.exception.ChargeModeEnum;
import com.dtyunxi.finance.api.exception.SeasonTypeEnum;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticsReportDto;
import com.dtyunxi.tcbj.biz.service.LogisticBaseService;
import com.dtyunxi.tcbj.biz.utils.BigDecimalUtil;
import com.dtyunxi.tcbj.biz.utils.DateTimeUtils;
import com.dtyunxi.tcbj.biz.utils.LbsUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="gateway#3")
public class LogisticWeightServiceImpl
extends LogisticBaseService<FinLogisticsReportDto> {
    private static final Logger log = LoggerFactory.getLogger(LogisticWeightServiceImpl.class);
    @Resource
    private LbsUtil lbsUtil;

    @Override
    protected FinLogisticsReportDto handle(FinLogisticsReportDto request) {
        FinLogisticsReportDto reportDto = new FinLogisticsReportDto();
        BeanUtils.copyProperties((Object)request, (Object)reportDto);
        reportDto.setUnloadAmount(null);
        reportDto.setDeliveryAmount(null);
        LogisticRecordQueryRespDto respDto = request.getLogisticsTemplate();
        if (null != respDto && null != respDto.getId()) {
            reportDto.setChargeMode(respDto.getChargeMode().toString());
            reportDto.setCalUnitName(ChargeModeEnum.WEIGHT.getDefaultUnitName());
            reportDto.setTransportAmount(BigDecimal.ZERO);
            OilLinkQueryRespDto linkQueryRespDto = request.getOilLinkQueryRespDto();
            BigDecimal oilPriceRange = null;
            if (linkQueryRespDto != null && linkQueryRespDto.getAmount() != null && respDto.getContractOilPrice() != null && respDto.getContractOilPrice().compareTo(BigDecimal.ZERO) > 0) {
                oilPriceRange = linkQueryRespDto.getAmount().subtract(respDto.getContractOilPrice()).divide(respDto.getContractOilPrice(), 4, RoundingMode.DOWN);
            } else if (linkQueryRespDto != null) {
                BigDecimal amount = linkQueryRespDto.getAmount();
                if (amount == null) {
                    this.setAbnormalCauses(reportDto, "\u6cb9\u4ef7\u8054\u52a8\u8bbe\u7f6e\u4e2d\u5355\u4ef7\u4e3a\u7a7a");
                    reportDto.setStatus(Integer.valueOf(1));
                    log.info("\u672a\u8ba1\u7b97\u6cb9\u4ef7\u53d8\u5316\u5e45\u5ea6scope\u7684\u62a5\u8868\u6570\u636e:{}", (Object)JSON.toJSONString((Object)respDto));
                    return reportDto;
                }
            } else {
                this.setAbnormalCauses(reportDto, "\u6cb9\u4ef7\u8054\u52a8\u8bbe\u7f6e\u4e3a\u7a7a");
                reportDto.setStatus(Integer.valueOf(1));
                return reportDto;
            }
            BigDecimal scope = null;
            if (oilPriceRange != null) {
                reportDto.setRangeOilPrice(super.getRangeOilPrice(oilPriceRange));
                scope = super.setOilChangeData(oilPriceRange);
                reportDto.setAdjustOilPrice(scope);
            }
            if (scope == null && respDto.getContractOilPrice() != null) {
                this.setAbnormalCauses(reportDto, "\u672a\u5339\u914d\u5230\u6cb9\u4ef7\u6d6e\u52a8\u9636\u68af");
                reportDto.setStatus(Integer.valueOf(1));
            }
            List ruleWeightDtoList = JSONObject.parseArray((String)respDto.getParams(), RuleWeightDto.class);
            List weightDtoList = ruleWeightDtoList.stream().sorted(Comparator.comparing(RuleWeightDto::getSort)).collect(Collectors.toList());
            AppointAreaQueryRespDto areaQueryRespDto = request.getAppointAreaQueryRespDto();
            if (areaQueryRespDto != null && StringUtils.isNotBlank((CharSequence)areaQueryRespDto.getParams())) {
                if (SeasonTypeEnum.COMMON.getType().equals(respDto.getSeasonType())) {
                    SeasonWeightDto seasonWeightDto = (SeasonWeightDto)JSONObject.parseObject((String)areaQueryRespDto.getParams(), SeasonWeightDto.class);
                    if (request.getWeight().compareTo(new BigDecimal(((RuleWeightDto)weightDtoList.get(0)).getStart())) > 0 && new BigDecimal(((RuleWeightDto)weightDtoList.get(0)).getEnd() == null ? "0" : ((RuleWeightDto)weightDtoList.get(0)).getEnd()).compareTo(request.getWeight()) > 0) {
                        reportDto.setTransportPrice(seasonWeightDto.getWeight01());
                        reportDto.setTransportAmount(BigDecimalUtil.mul(seasonWeightDto.getWeight01(), request.getWeight()));
                    } else if (request.getWeight().compareTo(new BigDecimal(((RuleWeightDto)weightDtoList.get(1)).getStart())) > 0 && new BigDecimal(((RuleWeightDto)weightDtoList.get(1)).getEnd()).compareTo(request.getWeight()) > 0) {
                        reportDto.setTransportPrice(seasonWeightDto.getWeight02());
                        reportDto.setTransportAmount(BigDecimalUtil.mul(seasonWeightDto.getWeight02(), request.getWeight()));
                    } else if (request.getWeight().compareTo(new BigDecimal(((RuleWeightDto)weightDtoList.get(1)).getEnd())) > 0) {
                        reportDto.setTransportPrice(seasonWeightDto.getWeight03());
                        reportDto.setTransportAmount(BigDecimalUtil.mul(seasonWeightDto.getWeight03(), request.getWeight()));
                    }
                } else {
                    TemplateWeightDto templateWeightDto = (TemplateWeightDto)JSONObject.parseObject((String)areaQueryRespDto.getParams(), TemplateWeightDto.class);
                    String moth = DateTimeUtils.getMonth(request.getOutboundTime());
                    if (respDto.getOffSeason().contains(moth)) {
                        if (request.getWeight().compareTo(new BigDecimal(((RuleWeightDto)weightDtoList.get(0)).getStart())) > 0 && new BigDecimal(((RuleWeightDto)weightDtoList.get(0)).getEnd()).compareTo(request.getWeight()) > 0) {
                            reportDto.setTransportPrice(templateWeightDto.getOff().getWeight01());
                            reportDto.setTransportAmount(BigDecimalUtil.mul(templateWeightDto.getOff().getWeight01(), request.getWeight()));
                        } else if (request.getWeight().compareTo(new BigDecimal(((RuleWeightDto)weightDtoList.get(1)).getStart())) > 0 && new BigDecimal(((RuleWeightDto)weightDtoList.get(1)).getEnd()).compareTo(request.getWeight()) > 0) {
                            reportDto.setTransportPrice(templateWeightDto.getOff().getWeight02());
                            reportDto.setTransportAmount(BigDecimalUtil.mul(templateWeightDto.getOff().getWeight02(), request.getWeight()));
                        } else if (request.getWeight().compareTo(new BigDecimal(((RuleWeightDto)weightDtoList.get(1)).getEnd())) > 0) {
                            reportDto.setTransportPrice(templateWeightDto.getOff().getWeight03());
                            reportDto.setTransportAmount(BigDecimalUtil.mul(templateWeightDto.getOff().getWeight03(), request.getWeight()));
                        }
                        reportDto.setMinCharge(BigDecimal.ZERO);
                    } else if (respDto.getPeakSeason().contains(moth)) {
                        if (request.getWeight().compareTo(new BigDecimal(((RuleWeightDto)weightDtoList.get(0)).getStart())) > 0 && new BigDecimal(((RuleWeightDto)weightDtoList.get(0)).getEnd()).compareTo(request.getWeight()) > 0) {
                            reportDto.setTransportPrice(templateWeightDto.getPeak().getWeight01());
                            reportDto.setTransportAmount(BigDecimalUtil.mul(templateWeightDto.getPeak().getWeight01(), request.getWeight()));
                        } else if (request.getWeight().compareTo(new BigDecimal(((RuleWeightDto)weightDtoList.get(1)).getStart())) > 0 && new BigDecimal(((RuleWeightDto)weightDtoList.get(1)).getEnd()).compareTo(request.getWeight()) > 0) {
                            reportDto.setTransportPrice(templateWeightDto.getOff().getWeight02());
                            reportDto.setTransportAmount(BigDecimalUtil.mul(templateWeightDto.getPeak().getWeight02(), request.getWeight()));
                        } else if (request.getWeight().compareTo(new BigDecimal(((RuleWeightDto)weightDtoList.get(1)).getEnd())) > 0) {
                            reportDto.setTransportPrice(templateWeightDto.getOff().getWeight03());
                            reportDto.setTransportAmount(BigDecimalUtil.mul(templateWeightDto.getPeak().getWeight03(), request.getWeight()));
                        }
                        reportDto.setMinCharge(BigDecimal.ZERO);
                    } else {
                        reportDto.setTransportPrice(BigDecimal.ZERO);
                        reportDto.setTransportAmount(BigDecimal.ZERO);
                        reportDto.setMinCharge(BigDecimal.ZERO);
                    }
                }
            } else {
                this.setAbnormalCauses(reportDto, "\u672a\u5339\u914d\u5230\u7269\u6d41\u8fd0\u8d39\u6a21\u677f\u533a\u57df");
                reportDto.setStatus(Integer.valueOf(1));
            }
            reportDto.setDeliveryAmount(null == respDto.getDeliveryPrice() ? BigDecimal.ZERO : respDto.getDeliveryPrice());
            reportDto.setUnloadAmount(BigDecimalUtil.mul(request.getVolume(), null == respDto.getUnloadPrice() ? BigDecimal.ZERO : respDto.getUnloadPrice()));
            if (scope != null && reportDto.getTransportAmount() != null) {
                reportDto.setOilPrice(BigDecimalUtil.mul(scope, reportDto.getTransportAmount()));
            }
        } else {
            String address = request.getProvince();
            String city = request.getCity();
            String area = request.getArea();
            if (StringUtils.isNotBlank((CharSequence)city)) {
                address = address + city;
            }
            if (StringUtils.isNotBlank((CharSequence)area)) {
                address = address + area;
            }
            this.setAbnormalCauses(reportDto, String.format("\u6839\u636e\u7701\u5e02\u533a\u3010%s\u3011\u672a\u5339\u914d\u5230\u7269\u6d41\u8fd0\u8d39\u6a21\u677f\u533a\u57df", address));
            reportDto.setStatus(Integer.valueOf(1));
        }
        if (Objects.equals(reportDto.getStatus(), 0)) {
            BigDecimal totalTransportAmount = BigDecimal.ZERO;
            totalTransportAmount = reportDto.getOilPrice() != null && reportDto.getOilPrice().compareTo(BigDecimal.ZERO) > 0 ? totalTransportAmount.add(reportDto.getOilPrice()) : totalTransportAmount.add(reportDto.getTransportAmount());
            if (reportDto.getDeliveryAmount() != null) {
                totalTransportAmount = totalTransportAmount.add(reportDto.getDeliveryAmount());
            }
            if (reportDto.getUnloadAmount() != null) {
                totalTransportAmount = totalTransportAmount.add(reportDto.getUnloadAmount());
            }
            if (reportDto.getSpecialAmount() != null) {
                totalTransportAmount = totalTransportAmount.add(reportDto.getSpecialAmount());
            }
            reportDto.setTotalTransportAmount(totalTransportAmount);
        }
        return reportDto;
    }
}

