/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.dao.das;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.tcbj.api.dto.InsuranceItemVo;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumExceptionDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumReqDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsuranceBillCountDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsurancePremiumRespDto;
import com.dtyunxi.tcbj.dao.Constants.CsShipmentLogisticsTypeEnum;
import com.dtyunxi.tcbj.dao.das.base.AbstractBaseDas;
import com.dtyunxi.tcbj.dao.eo.ConsignmentOrderAddressEo;
import com.dtyunxi.tcbj.dao.eo.LogicWarehouseEo;
import com.dtyunxi.tcbj.dao.eo.OutResultOrderDetailEo;
import com.dtyunxi.tcbj.dao.eo.OutResultOrderEo;
import com.dtyunxi.tcbj.dao.eo.ReInsuranceBillEo;
import com.dtyunxi.tcbj.dao.eo.ReInsurancePremiumEo;
import com.dtyunxi.tcbj.dao.mapper.ReInsurancePremiumMapper;
import com.dtyunxi.tcbj.dao.vo.CostBelongVo;
import com.dtyunxi.tcbj.dao.vo.InsuranceCustomerInfoVo;
import com.dtyunxi.tcbj.dao.vo.InsuranceFeeVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDetailCombineDto;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDto;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ReInsurancePremiumDas
extends AbstractBaseDas<ReInsurancePremiumEo, String> {
    private Logger logger = LoggerFactory.getLogger(ReInsurancePremiumDas.class);
    @Resource
    private ReInsurancePremiumMapper insurancePremiumMapper;

    public Long getOutResultNoCountByDate(String calDateBegin, String calDateEnd) {
        return this.insurancePremiumMapper.getOutResultNoCountByDate(calDateBegin, calDateEnd);
    }

    public Long getDailyDeliveryReportCountByDate(String calDateBegin, String calDateEnd) {
        return this.insurancePremiumMapper.getDailyDeliveryReportCountByDate(calDateBegin, calDateEnd);
    }

    public InsuranceItemVo getPcpItemByLongCode(String longCode, Map<String, InsuranceItemVo> itemMap) {
        InsuranceItemVo result;
        if (ObjectUtil.isNotEmpty((Object)itemMap.get(longCode))) {
            result = itemMap.get(longCode);
        } else {
            InsuranceItemVo itemVo = this.insurancePremiumMapper.getItemInfo(longCode);
            itemMap.put(longCode, itemVo);
            result = itemVo;
        }
        return result;
    }

    public List<InsuranceItemVo> getPcpItemByLongCode(List<String> longCodes) {
        return this.insurancePremiumMapper.getItemInfoList(longCodes);
    }

    public LogicWarehouseEo getWarehouseOrgId(String warehouseCode, Map<String, LogicWarehouseEo> warehouseMap) {
        LogicWarehouseEo result;
        if (ObjectUtil.isNotEmpty((Object)((Object)warehouseMap.get(warehouseCode)))) {
            result = warehouseMap.get(warehouseCode);
        } else {
            LogicWarehouseEo warehouseEo = this.insurancePremiumMapper.getWarehouseOrgId(warehouseCode);
            warehouseMap.put(warehouseCode, warehouseEo);
            result = warehouseEo;
        }
        return result;
    }

    public Long getUseAmountConfig() {
        return this.insurancePremiumMapper.getUseAmountConfig();
    }

    public CostBelongVo getCostBelong(String outLogicWarehouseCode, String inLogicWarehouseCode, Map<String, CostBelongVo> costBelongMaps) {
        CostBelongVo result;
        String key = outLogicWarehouseCode + "_" + inLogicWarehouseCode;
        if (ObjectUtil.isNotEmpty((Object)costBelongMaps.get(key))) {
            result = costBelongMaps.get(key);
        } else {
            CostBelongVo costBelong = this.insurancePremiumMapper.getCostBelong(outLogicWarehouseCode, inLogicWarehouseCode);
            System.out.println("\u7ed3\u679c:" + costBelong);
            costBelongMaps.put(key, costBelong);
            result = costBelong;
        }
        return result;
    }

    public List<InsuranceFeeVo> getInsureFee(String calDate, String shippingCompanyCode, String shippingTypeName, Map<String, List<InsuranceFeeVo>> insureMaps, String shippingCompanyName) {
        String key = calDate.substring(0, 10) + "_" + shippingCompanyCode + "_" + shippingCompanyName + "_" + shippingTypeName;
        Integer shippingTypeCode = CsShipmentLogisticsTypeEnum.formDesc(shippingTypeName);
        if (CollectionUtils.isNotEmpty((Collection)insureMaps.get(key))) {
            return insureMaps.get(key);
        }
        if (shippingTypeCode != null) {
            List<InsuranceFeeVo> insurances = this.insurancePremiumMapper.getInsurance(calDate, shippingCompanyCode, String.valueOf(shippingTypeCode), shippingCompanyName);
            insureMaps.put(key, insurances);
            return insurances;
        }
        return null;
    }

    public List<OutResultOrderEo> getOutResultNoListByDate(String calDateBegin, String calDateEnd, Integer pageNum, Integer pageSize) {
        return this.insurancePremiumMapper.getOutResultNoListByDate(calDateBegin, calDateEnd, pageNum, pageSize);
    }

    public PageInfo<DailyDeliveryReportDto> getDailyDeliveryReportEoListByDate(DailyDeliveryReportDto reportDto) {
        PageHelper.startPage((int)reportDto.getPageNum(), (int)reportDto.getPageSize());
        return new PageInfo(this.insurancePremiumMapper.getDailyDeliveryReportEoListByDate(reportDto));
    }

    public List<OutResultOrderDetailEo> getOutResultOrderDetail(String documentNo) {
        return this.insurancePremiumMapper.getOutResultOrderDetail(documentNo);
    }

    public List<DailyDeliveryReportDetailCombineDto> getDailyDeliveryReportDetail(Long id) {
        List<DailyDeliveryReportDetailCombineDto> d = this.insurancePremiumMapper.getdetailById(id);
        this.logger.info("\u62a5\u8868\u660e\u7ec6\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(d));
        return d;
    }

    public List<DailyDeliveryReportDetailCombineDto> getDailyDeliveryReportDetail(List<Long> ids) {
        return this.insurancePremiumMapper.getdetailByIds(ids);
    }

    public List<OutResultOrderDetailEo> getOutResultOrderDetailNotInPremium(String documentNo) {
        return this.insurancePremiumMapper.getOutResultOrderDetailNotInPremium(documentNo);
    }

    public Integer getInsuranceCountByDate(String calDateBegin, String calDateEnd, ReInsurancePremiumExceptionDto exceptionDto) {
        return this.insurancePremiumMapper.getInsuranceCountByDate(calDateBegin, calDateEnd, exceptionDto);
    }

    public List<ReInsuranceBillEo> getInsuranceBillListByDate(ReInsurancePremiumExceptionDto exceptionDto, String calDateBegin, String calDateEnd, Integer pageNum, Integer pageSize) {
        return this.insurancePremiumMapper.getInsuranceBillListByDate(exceptionDto, calDateBegin, calDateEnd, pageNum, pageSize);
    }

    public List<ReInsurancePremiumEo> getReInsurancePremiumEo(String documentNo) {
        return this.insurancePremiumMapper.getReInsurancePremiumEo(documentNo);
    }

    public String getShipCompanyName(String code) {
        return this.insurancePremiumMapper.getShipCompanyName(code);
    }

    public InsuranceCustomerInfoVo getOrderSalesOutData(String saleOrderNo) {
        return this.insurancePremiumMapper.getOrderSalesOutData(saleOrderNo);
    }

    public InsuranceCustomerInfoVo getOtherOutData(String relevanceNo) {
        return this.insurancePremiumMapper.getOtherOutData(relevanceNo);
    }

    public InsuranceCustomerInfoVo getOutResourceAndPurchaseRefundData(String relevanceNo) {
        return this.insurancePremiumMapper.getOutResourceAndPurchaseRefundData(relevanceNo);
    }

    public InsuranceCustomerInfoVo getAllotOutData(String relevanceNo, Map<String, InsuranceCustomerInfoVo> physicsWareMap) {
        InsuranceCustomerInfoVo customerInfoVo = this.insurancePremiumMapper.getAllotOutData(relevanceNo);
        if (customerInfoVo != null && StringUtils.isNotBlank((CharSequence)customerInfoVo.getWarehouseCode())) {
            InsuranceCustomerInfoVo addressAndEndPlaceVo = physicsWareMap.get(customerInfoVo.getWarehouseCode());
            if (addressAndEndPlaceVo == null) {
                addressAndEndPlaceVo = this.insurancePremiumMapper.getAllotOutEndPlaceAddress(customerInfoVo.getWarehouseCode());
                physicsWareMap.put(customerInfoVo.getWarehouseCode(), addressAndEndPlaceVo);
            }
            if (addressAndEndPlaceVo != null) {
                customerInfoVo.setEndPlace(addressAndEndPlaceVo.getEndPlace());
                customerInfoVo.setCustomerAddress(addressAndEndPlaceVo.getCustomerAddress());
            }
        }
        return customerInfoVo;
    }

    public String getStartPlace(String outLogicWarehouseCode, Map<String, String> startPlaceMap) {
        String startPlace = startPlaceMap.get(outLogicWarehouseCode);
        if (startPlace == null) {
            startPlace = this.insurancePremiumMapper.getStartPlace(outLogicWarehouseCode);
            startPlaceMap.put(outLogicWarehouseCode, StringUtils.isEmpty((CharSequence)startPlace) ? "" : startPlace);
        }
        return startPlace;
    }

    public PageInfo<ReInsurancePremiumRespDto> queryByPage(ReInsurancePremiumReqDto reInsurancePremiumReqDto) {
        PageHelper.startPage((int)reInsurancePremiumReqDto.getPageNum(), (int)reInsurancePremiumReqDto.getPageSize());
        this.logger.info("\u4fdd\u8d39\u660e\u7ec6\u5206\u9875\u67e5\u8be2SQL\u524d\u5165\u53c2{}", (Object)reInsurancePremiumReqDto);
        List<ReInsurancePremiumRespDto> reInsurancePremiumRespDtos = this.insurancePremiumMapper.queryByPage(reInsurancePremiumReqDto);
        for (ReInsurancePremiumRespDto dto : reInsurancePremiumRespDtos) {
            dto.setQuantity(dto.getTotalQuantity());
        }
        return new PageInfo(reInsurancePremiumRespDtos);
    }

    public ReInsuranceBillCountDto queryFlagCount(ReInsurancePremiumReqDto reqDto) {
        this.logger.info("\u4fdd\u8d39\u660e\u7ec6\u7edf\u8ba1\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        return this.insurancePremiumMapper.queryFlagCount(reqDto);
    }

    public ConsignmentOrderAddressEo queryAddress(String documentNo) {
        return this.insurancePremiumMapper.queryAddress(documentNo);
    }

    public Long clearByDate(String calDateBegin, String calDateEnd) {
        Long i = this.insurancePremiumMapper.clearPByDate(calDateBegin, calDateEnd);
        Long j = this.insurancePremiumMapper.clearBByDate(calDateBegin, calDateEnd);
        this.logger.info("\u660e\u7ec6\u5f52\u6863{}\u6761,\u8d26\u5355\u5f52\u6863{}\u6761", (Object)i, (Object)j);
        return i + j;
    }

    public Long queryPlaced(String calDateBegin, String calDateEnd) {
        Long pcount = this.insurancePremiumMapper.queryPPlaced(calDateBegin, calDateEnd);
        Long bcount = this.insurancePremiumMapper.queryBPlaced(calDateBegin, calDateEnd);
        return pcount + bcount;
    }
}

