/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.dao.das;

import com.dtyunxi.tcbj.api.dto.request.OrderItemProductRankingReqDto;
import com.dtyunxi.tcbj.api.dto.request.OrderSaleProgressReqDto;
import com.dtyunxi.tcbj.api.dto.response.OrderItemProductRankingRespDto;
import com.dtyunxi.tcbj.api.dto.response.OrderSaleProgressRespDto;
import com.dtyunxi.tcbj.dao.das.base.AbstractBaseDas;
import com.dtyunxi.tcbj.dao.eo.OrderEo;
import com.dtyunxi.tcbj.dao.mapper.OrderMapper;
import com.dtyunxi.tcbj.dao.vo.OrderCountAmountVo;
import com.dtyunxi.tcbj.dao.vo.OrderQueryVo;
import com.dtyunxi.tcbj.dao.vo.ReceivablesQueryVo;
import com.dtyunxi.tcbj.dao.vo.ReceivablesVo;
import com.dtyunxi.tcbj.dao.vo.TerminalAmountVo;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OrderDas
extends AbstractBaseDas<OrderEo, String> {
    @Resource
    private OrderMapper orderMapper;

    public List<OrderSaleProgressRespDto> saleProgressStatistics(OrderSaleProgressReqDto orderSaleProgressReqDto) {
        return this.orderMapper.saleProgressStatistics(orderSaleProgressReqDto);
    }

    public List<OrderItemProductRankingRespDto> productRankingStatistics(OrderItemProductRankingReqDto orderItemProductRankingReqDto) {
        return this.orderMapper.productRankingStatistics(orderItemProductRankingReqDto);
    }

    public List<TerminalAmountVo> selectTerminalAmount(List<Long> customerIds, String date) {
        ReceivablesQueryVo vo = new ReceivablesQueryVo();
        vo.setToDay(date);
        vo.setCustomerIdList(customerIds);
        return this.orderMapper.selectTerminalAmount(vo);
    }

    public List<ReceivablesVo> selectTerminalAmountByDay(List<Long> customerIds, String day) {
        ReceivablesQueryVo vo = new ReceivablesQueryVo();
        vo.setToDay(day);
        vo.setCustomerIdList(customerIds);
        return this.orderMapper.selectTerminalAmountByDay(vo);
    }

    public List<OrderCountAmountVo> selectOrderAmountByStatus(OrderQueryVo vo) {
        return this.orderMapper.selectOrderAmountByStatus(vo);
    }

    public List<OrderEo> queryByOrderNos(List<String> orderNos) {
        return this.orderMapper.queryByOrderNos(orderNos);
    }
}

