-- SAP拉单限流 - extension字段兼容性处理
-- 确保现有数据能够正常使用新的拉单状态逻辑

-- 1. 为extension字段为空的记录设置默认值
UPDATE sale_order_apportion
SET extension = '{}'
WHERE dr = 0
  AND (extension IS NULL OR extension = '');

-- 2. 为if_pull=0且没有pullStatus的记录设置默认pullStatus（正常状态）
UPDATE sale_order_apportion
SET extension = JSON_SET(COALESCE(extension, '{}'), '$.pullStatus', 2)
WHERE dr = 0
  AND if_pull = 0
  AND (JSON_EXTRACT(extension, '$.pullStatus') IS NULL);

-- 3. 可选：如果需要将某些已拉过单的记录标记为pullStatus=2
-- （需要根据业务逻辑确定哪些记录是已拉过单的）
-- UPDATE sale_order_apportion
-- SET extension = JSON_SET(COALESCE(extension, '{}'), '$.pullStatus', 2)
-- WHERE dr = 0
--   AND if_pull = 0
--   AND document_no IS NOT NULL
--   AND [其他已拉过单的条件];

-- 验证脚本
-- SELECT
--     COUNT(CASE WHEN extension IS NULL OR extension = '' THEN 1 END) as null_extension_count,
--     COUNT(CASE WHEN JSON_EXTRACT(extension, '$.pullStatus') IS NULL THEN 1 END) as null_pull_status_count,
--     COUNT(CASE WHEN JSON_EXTRACT(extension, '$.pullStatus') = 0 THEN 1 END) as normal_status_count,
--     COUNT(CASE WHEN JSON_EXTRACT(extension, '$.pullStatus') = 1 THEN 1 END) as limit_status_count,
--     COUNT(CASE WHEN JSON_EXTRACT(extension, '$.pullStatus') = 2 THEN 1 END) as pulled_status_count
-- FROM sale_order_apportion
-- WHERE dr = 0;
