/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.api.config;

import java.math.BigDecimal;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Service;

@Service
@Configuration
@ConfigurationProperties(prefix="poundage")
public class PaymentWayConfig {
    private Map<String, BigDecimal> poundageRateMap;
    private static final BigDecimal defaultPoundageRate = new BigDecimal("0.0025");

    public BigDecimal getPoundageRate(String payPartnerCode, String payTypeCode) {
        String key = payPartnerCode + payTypeCode;
        return this.poundage(key);
    }

    private BigDecimal poundage(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return defaultPoundageRate;
        }
        if (ObjectUtils.isEmpty(this.poundageRateMap) || ObjectUtils.isEmpty((Object)this.poundageRateMap.get(key))) {
            return defaultPoundageRate;
        }
        return this.poundageRateMap.get(key);
    }

    public Map<String, BigDecimal> getPoundageRateMap() {
        return this.poundageRateMap;
    }

    public void setPoundageRateMap(Map<String, BigDecimal> poundageRateMap) {
        this.poundageRateMap = poundageRateMap;
    }
}

