/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.auth.config;

import com.dtyunxi.tcbj.app.open.biz.auth.check.CheckExecutorImpl;
import com.dtyunxi.tcbj.app.open.biz.auth.check.HmacParamCheckImpl;
import com.dtyunxi.tcbj.app.open.biz.auth.check.ICheck;
import com.dtyunxi.tcbj.app.open.biz.auth.check.ICheckExecutor;
import com.dtyunxi.tcbj.app.open.biz.auth.check.PcpAdapterCheckImpl;
import com.dtyunxi.tcbj.app.open.biz.auth.config.ThirdAuthProperties;
import com.dtyunxi.tcbj.app.open.biz.auth.filter.ContentRepeatableFilter;
import com.dtyunxi.tcbj.app.open.biz.auth.interceptor.ThirdAuthInterceptor;
import com.dtyunxi.tcbj.app.open.biz.auth.interceptor.ThirdAuthInterceptorRegister;
import com.dtyunxi.tcbj.app.open.biz.auth.match.IMatch;
import com.dtyunxi.tcbj.app.open.biz.auth.match.PathMatchImpl;
import com.dtyunxi.tcbj.app.open.biz.auth.sign.SignHelper;
import com.dtyunxi.tcbj.app.open.biz.auth.sign.base.BaseShaSignHelper;
import com.dtyunxi.tcbj.app.open.biz.auth.sign.base.PcpAdapterSignHelper;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(name={"openapi.third.auth.enable"}, havingValue="1")
@Configuration
@EnableConfigurationProperties(value={ThirdAuthProperties.class})
public class ThirdAuthAutoConfiguration {
    @Bean
    public IMatch patchMatch(ThirdAuthProperties properties) {
        return new PathMatchImpl(properties);
    }

    @Bean
    public SignHelper shaSignHelper() {
        return new BaseShaSignHelper();
    }

    @Bean
    public SignHelper pcpAdapterSignHelper() {
        return new PcpAdapterSignHelper();
    }

    @Bean
    public ICheck hmacParamCheck(SignHelper shaSignHelper) {
        return new HmacParamCheckImpl(shaSignHelper);
    }

    @Bean
    public ICheck pcpAdapterCheck(SignHelper pcpAdapterSignHelper) {
        return new PcpAdapterCheckImpl(pcpAdapterSignHelper);
    }

    @Bean
    public ICheckExecutor checkExecutor() {
        return new CheckExecutorImpl();
    }

    @Bean
    public ThirdAuthInterceptor thirdAuthInterceptor() {
        return new ThirdAuthInterceptor();
    }

    @Bean
    public ThirdAuthInterceptorRegister thirdAuthInterceptorRegister(ThirdAuthInterceptor thirdAuthInterceptor) {
        return new ThirdAuthInterceptorRegister(thirdAuthInterceptor);
    }

    @Bean
    public FilterRegistrationBean someFilterRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter(this.contentRepeatableFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("contentRepeatableFilter");
        return registration;
    }

    @Bean(name={"contentRepeatableFilter"})
    public Filter contentRepeatableFilter() {
        return new ContentRepeatableFilter();
    }
}

