/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.auth.match;

import com.dtyunxi.tcbj.app.open.biz.auth.ResultBo;
import com.dtyunxi.tcbj.app.open.biz.auth.config.ThirdAuthProperties;
import com.dtyunxi.tcbj.app.open.biz.auth.match.IMatch;
import com.dtyunxi.tcbj.app.open.biz.auth.match.MatchBo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class PathMatchImpl
implements IMatch {
    private final List<Pattern> wildcards;
    private final Map<String, Boolean> precisionMap = new HashMap<String, Boolean>(10);

    public PathMatchImpl(ThirdAuthProperties properties) {
        List<String> apiPaths = properties.getTargetList();
        this.wildcards = new ArrayList<Pattern>(apiPaths.size());
        String urlFragmentWildcard = "((/[a-zA-Z0-9-|_]+)|(/\\{[a-zA-Z0-9-|_]+\\}))";
        String multiWildcard = "(" + urlFragmentWildcard + ")+";
        String r1 = "/**";
        String r2 = "/*";
        apiPaths.forEach(path -> {
            if (path.contains(r1)) {
                path = path.replace(r1, multiWildcard);
                path = path.replace(r2, urlFragmentWildcard);
                this.wildcards.add(Pattern.compile(path));
            } else if (path.contains(r2)) {
                path = path.replace(r2, urlFragmentWildcard);
                this.wildcards.add(Pattern.compile(path));
            } else {
                this.precisionMap.put((String)path, true);
            }
        });
    }

    @Override
    public ResultBo match(MatchBo matchBo) {
        if (this.precisionMap.isEmpty()) {
            return ResultBo.failData("");
        }
        return ResultBo.build(this.precisionMap.containsKey(matchBo.getPath()) || this.wildcards.stream().anyMatch(pattern -> pattern.matcher(matchBo.getPath()).matches()));
    }
}

