/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.dto.RequestBaseData;
import com.dtyunxi.tcbj.app.open.biz.service.ISapCenterHandleService;
import com.dtyunxi.tcbj.center.openapi.api.enums.SapModelTypeEnum;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsCustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.IEasCustomerOrgRelationApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerTypeQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EasCustomerOrgRelationReqDto;
import com.dtyunxi.yundt.cube.center.user.api.IOrganizationExtApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvAddReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvOpRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SapCenterHandleCustomerServiceImpl
implements ISapCenterHandleService {
    private static final Logger logger = LoggerFactory.getLogger(SapCenterHandleCustomerServiceImpl.class);
    @Resource
    private ICustomerApi customerApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICustomerTypeQueryApi customerTypeQueryApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private RequestBaseData requestBaseData;
    @Resource
    private IOrganizationExtApi organizationExtApi;
    @Value(value="${level.name}")
    private String level;
    @Value(value="${customer.orgIdUrl}")
    private String orgIdUrl;
    @Value(value="${customerLevel.max}")
    private Long customerLevelMax;
    @Value(value="${customerLevel.min}")
    private Long customerLevelMin;
    private static final Long DEFAULT_ORG_PARENT_ID = 1252411810853067012L;
    private static final Long CUSTOMER_STATUS_ID = 1256288005151458333L;
    private static final Long CUSTOMER_TYPE_ID = 1283393536750893057L;
    @Resource
    private IEasCustomerOrgRelationApi easCustomerOrgRelationApi;
    @Resource
    private ICommonsMqService commonsMqService;

    @Override
    public String getModelType() {
        return SapModelTypeEnum.CUSTOMER.getValue();
    }

    @Override
    public void handle(Map<String, Object> reqDto) {
        logger.info("\u5ba2\u6237\u6570\u636e\u540c\u6b65\u5f00\u59cb\uff1a{}", (Object)JSON.toJSONString(reqDto));
        CustomerReqDto customerReqDto = this.toPcpCustomerData(reqDto);
        this.addCustomerOrg(customerReqDto);
        this.addCustomer(customerReqDto);
        this.addSapCustomerOrgRelation(customerReqDto);
    }

    private CustomerReqDto toPcpCustomerData(Map<String, Object> reqDto) {
        JSONObject data = (JSONObject)JSON.toJSON(reqDto);
        JSONObject customerData = data.getJSONObject("HEADER");
        CustomerReqDto customerReqDto = new CustomerReqDto();
        customerReqDto.setCode(customerData.getString("PARTNER"));
        customerReqDto.setName(customerData.getString("NAME_ORG1"));
        customerReqDto.setAliasname(customerData.getString("BU_SORT1"));
        customerReqDto.setOldCode(customerData.getString("BU_SORT2"));
        customerReqDto.setEasCode(customerReqDto.getCode());
        customerReqDto.setThirdPartyId(customerReqDto.getCode());
        customerReqDto.setThirdParentPartyId("CN01");
        customerReqDto.setType(Integer.valueOf(2));
        customerReqDto.setCustomerTypeId(CUSTOMER_TYPE_ID);
        customerReqDto.setLevelId(this.getCustomerLevel(null));
        customerReqDto.setStatusId(CUSTOMER_STATUS_ID);
        customerReqDto.setTenantId(this.requestBaseData.getTenantId());
        customerReqDto.setInstanceId(this.requestBaseData.getInstanceId());
        return customerReqDto;
    }

    private void addCustomer(CustomerReqDto customerReqDto) {
        logger.info("addCustomer\uff1a{}", (Object)JSONObject.toJSONString((Object)customerReqDto));
        RestResponse restResponse = this.customerQueryApi.queryCustomerListByCodes((List)Lists.newArrayList((Object[])new String[]{customerReqDto.getThirdPartyId()}));
        logger.info("\u67e5\u8be2\u5ba2\u6237\u662f\u5426\u5b58\u5728\uff1a{}", (Object)JSONObject.toJSONString((Object)restResponse));
        WmsCustomerReqDto wmsCustomerReqDto = new WmsCustomerReqDto();
        if (ObjectUtil.isNotEmpty((Object)restResponse.getData())) {
            List customerRespDtos = (List)restResponse.getData();
            logger.info("\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u4e0d\u4e3a\u7a7a\uff0c\u66f4\u65b0\u5ba2\u6237\u4fe1\u606f\uff01");
            customerReqDto.setId(((CustomerRespDto)customerRespDtos.get(0)).getId());
            customerReqDto.setUpdatePerson("SAP");
            RestResponse customerRespone = this.customerApi.update(customerReqDto);
            logger.info("\u4fee\u6539\u5ba2\u6237\uff1a{}", (Object)JSONObject.toJSONString((Object)customerRespone));
            CubeBeanUtils.copyProperties((Object)wmsCustomerReqDto, (Object)customerReqDto, (String[])new String[0]);
        } else {
            customerReqDto.setAuditStatus("AUDIT_PASS");
            customerReqDto.setCreatePerson("SAP");
            customerReqDto.setUpdatePerson("SAP");
            RestResponse customerRespone = this.customerApi.add(customerReqDto);
            customerReqDto.setId((Long)customerRespone.getData());
            logger.info("\u65b0\u589e\u5ba2\u6237\uff1a{}", (Object)JSONObject.toJSONString((Object)customerRespone));
            CubeBeanUtils.copyProperties((Object)wmsCustomerReqDto, (Object)customerReqDto, (String[])new String[0]);
            wmsCustomerReqDto.setId(null);
        }
        MessageVo messageVo = new MessageVo();
        messageVo.setData(JSONObject.toJSON((Object)wmsCustomerReqDto));
    }

    private void addSapCustomerOrgRelation(CustomerReqDto customerReqDto) {
        try {
            logger.info("addSapCustomerOrgRelation\uff1a{}", (Object)JSON.toJSONString((Object)customerReqDto));
            ArrayList<EasCustomerOrgRelationReqDto> list = new ArrayList<EasCustomerOrgRelationReqDto>();
            EasCustomerOrgRelationReqDto dto = new EasCustomerOrgRelationReqDto();
            dto.setCustomerCode(customerReqDto.getCode());
            dto.setTenantCode(customerReqDto.getThirdParentPartyId());
            list.add(dto);
            this.easCustomerOrgRelationApi.syncEasCustomerOrgRelation(list);
        }
        catch (Exception e) {
            logger.info("\u8bb0\u5f55\u5173\u7cfb\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    private void addCustomerOrg(CustomerReqDto customerReqDto) {
        String orgCode = customerReqDto.getCode();
        String orgName = customerReqDto.getName();
        logger.info("addCustomerOrg {} {}", (Object)orgCode, (Object)orgName);
        OrgAdvQueryReqDto orgAdvQueryReqDto = new OrgAdvQueryReqDto();
        orgAdvQueryReqDto.setCode(orgCode);
        OrganizationDto organization = (OrganizationDto)RestResponseHelper.extractData((RestResponse)this.organizationQueryApi.queryOneByOrgCode(null, orgCode));
        if (organization == null) {
            OrgAdvAddReqDto orgAdvAddReqDto = new OrgAdvAddReqDto();
            orgAdvAddReqDto.setCode(orgCode);
            orgAdvAddReqDto.setName(orgName);
            orgAdvAddReqDto.setType("2");
            orgAdvAddReqDto.setTenantId(this.requestBaseData.getTenantId());
            orgAdvAddReqDto.setInstanceId(this.requestBaseData.getInstanceId());
            orgAdvAddReqDto.setParentId(DEFAULT_ORG_PARENT_ID);
            Long orgId = ((OrgAdvOpRespDto)this.organizationExtApi.add(orgAdvAddReqDto).getData()).getOrgId();
            customerReqDto.setOrgInfoId(orgId);
        } else {
            customerReqDto.setOrgInfoId(organization.getId());
        }
    }

    private Long getCustomerLevel(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            return this.customerLevelMin;
        }
        switch (type) {
            case "1P\u7ecf\u9500\u5546": {
                return this.customerLevelMin;
            }
            case "\u79df\u6237": {
                return this.customerLevelMax;
            }
        }
        return this.customerLevelMax;
    }
}

