/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.dto.MaterialNewDto;
import com.dtyunxi.tcbj.app.open.biz.dto.RequestBaseData;
import com.dtyunxi.tcbj.app.open.biz.service.ICenterHandleService;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ModelInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.DataDistributeRespDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.ModelCodeEnum;
import com.dtyunxi.yundt.cube.center.item.api.IItemSycnExtApi;
import com.dtyunxi.yundt.cube.center.item.api.base.IBrandApi;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemApi;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemSkuApi;
import com.dtyunxi.yundt.cube.center.item.api.base.IPropApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemBundleReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemChangeApplyDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemPriceReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.TagReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BrandRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.UnitRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IBrandQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IPropQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IUnitQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemProValue;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="CenterHandleMaterialNewServiceImpl")
public class CenterHandleMaterialNewServiceImpl
implements ICenterHandleService {
    private static Logger logger = LoggerFactory.getLogger(CenterHandleMaterialNewServiceImpl.class);
    @Resource
    private IBrandQueryApi brandQueryApi;
    @Resource
    private IItemQueryApi iItemQueryApi;
    @Resource
    private IPropQueryApi propQueryApi;
    @Resource
    private RequestBaseData requestBaseData;
    @Resource
    private IPropApi propApi;
    @Resource
    private IItemSycnExtApi iItemSycnExtApi;
    @Resource
    private IItemApi iItemApi;
    @Resource
    private IItemSkuQueryApi iItemSkuQueryApi;
    @Resource
    private IItemSkuApi iItemSkuApi;
    @Autowired
    private IUnitQueryApi unitQueryApi;
    @Resource
    private IBrandApi brandApi;

    @Override
    public String getModelType() {
        return ModelCodeEnum.NEW_MATERIAL.name();
    }

    @Override
    public List<DataDistributeRespDto> handle(ModelInfoReqDto modelInfoReqDto) {
        ArrayList dataDistributeRespDtoList = Lists.newArrayList();
        logger.info("\u540c\u6b65\u7269\u6599\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)modelInfoReqDto));
        List materialNewDtoList = JSONObject.parseArray((String)modelInfoReqDto.getDataStr(), MaterialNewDto.class);
        if (CollectionUtils.isEmpty((Collection)materialNewDtoList)) {
            logger.info("\u540c\u6b65\u7269\u6599\u6570\u636e\u7ed3\u675f\uff1a\u65e0\u6570\u636e");
            return dataDistributeRespDtoList;
        }
        int success = 0;
        int fail = 0;
        for (MaterialNewDto material : materialNewDtoList) {
            try {
                logger.info("\u5904\u7406\u5546\u54c1\uff1a{}", (Object)JSON.toJSONString((Object)material));
                material.setCreatePerson(modelInfoReqDto.getCreatePerson());
                material.setUpdatePerson(modelInfoReqDto.getUpdatePerson());
                Long itemId = this.buildItem(material);
                material.setItemId(itemId);
                this.buildItemSku(material);
                ++success;
            }
            catch (Exception e) {
                ++fail;
                logger.info("\u540c\u6b65\u5546\u54c1\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)material));
                logger.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
        }
        logger.info("\u540c\u6b65\u7269\u6599\u6570\u636e\u7ed3\u675f\uff0c\u672c\u6b21\u540c\u6b65\u603b\u8ba1\uff1a{}\uff0c\u6210\u529f\uff1a{}\uff0c\u5931\u8d25\uff1a{}", new Object[]{materialNewDtoList.size(), success, fail});
        return dataDistributeRespDtoList;
    }

    private Long buildItem(MaterialNewDto material) {
        logger.info("\u6784\u5efa\u5546\u54c1\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)material));
        ItemChangeApplyDto changApply = new ItemChangeApplyDto();
        ItemRespDto itemRespDto = (ItemRespDto)RestResponseHelper.extractData((RestResponse)this.iItemQueryApi.queryByItemCode(material.getCode()));
        logger.info("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)itemRespDto));
        BrandRespDto brand = this.getBrand(material);
        if (ObjectUtil.isNotEmpty((Object)itemRespDto) && ObjectUtil.isNotEmpty((Object)itemRespDto.getId())) {
            ItemReqDto itemReqDto = new ItemReqDto();
            itemReqDto.setName(material.getName());
            itemReqDto.setId(itemRespDto.getId());
            itemReqDto.setBrandId(brand.getId());
            itemReqDto.setBrand(brand.getName());
            itemReqDto.setAttrs(this.assembleAttr(material));
            itemReqDto.setUpdatePerson(material.getUpdatePerson());
            itemReqDto.setSubType(this.getType(material));
            logger.info("\u66f4\u65b0\u5546\u54c1\uff1a{}", (Object)JSON.toJSONString((Object)itemReqDto));
            HashMap<String, String> extFields = new HashMap<String, String>();
            extFields.put("saleChannel", "smallB");
            itemReqDto.setExtFields(extFields);
            this.iItemApi.modifyItem(itemReqDto);
            return itemRespDto.getId();
        }
        changApply.setBrandId(brand.getId());
        changApply.setBrand(brand.getName());
        changApply.setStatus(Integer.valueOf(0));
        changApply.setItemCode(material.getCode());
        changApply.setItemName(material.getName());
        changApply.setDisplayName(material.getName());
        changApply.setDirId(Long.valueOf(1288630386802423099L));
        changApply.setDirName("\u9ed8\u8ba4\u7c7b\u76ee");
        changApply.setLongCode(material.getLongCode());
        changApply.setType(Integer.valueOf(1));
        changApply.setSubType(this.getType(material));
        changApply.setAttrs(this.assembleAttr(material));
        changApply.setSellerId(Long.valueOf(0L));
        changApply.setCreatePerson(material.getCreatePerson());
        changApply.setDosageForm(material.getFormulation());
        changApply.setTenantId(this.requestBaseData.getTenantId());
        changApply.setInstanceId(this.requestBaseData.getInstanceId());
        logger.info("=================> \u65b0\u589e\u5546\u54c1\u5165\u53c2 : {}", (Object)JSONObject.toJSONString((Object)changApply));
        changApply.setSaleChannel("smallB");
        Long id = (Long)this.iItemApi.addItem(changApply).getData();
        if (ObjectUtil.isEmpty((Object)id)) {
            logger.info("\u521b\u5efa\u5546\u54c1\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)changApply));
            throw new BizException("-1", "\u521b\u5efa\u5546\u54c1\u5931\u8d25");
        }
        return id;
    }

    private void buildItemSku(MaterialNewDto material) {
        logger.info("\u6784\u5efa\u5546\u54c1SKU\uff1a{}", (Object)JSON.toJSONString((Object)material));
        ItemBundleReqDto itemBundleReqDto = new ItemBundleReqDto();
        List skuRespDtos = (List)this.iItemSkuQueryApi.queryBySkuCode((List)Lists.newArrayList((Object[])new String[]{material.getLongCode()})).getData();
        logger.info("\u67e5\u8be2\u5546\u54c1sku\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)skuRespDtos));
        if (CollectionUtil.isNotEmpty((Collection)skuRespDtos)) {
            ItemSkuRespDto itemSkuRespDto = (ItemSkuRespDto)skuRespDtos.get(0);
            if (ObjectUtils.isEmpty((Object)itemSkuRespDto.getId())) {
                logger.error("\u67e5\u8be2\u5546\u54c1sku\u4fe1\u606f\u5f02\u5e38\uff0c\u6ca1\u6709\u8fd4\u56deID");
                return;
            }
            ItemBundleReqDto itemBundle = new ItemBundleReqDto();
            itemBundle.setId(itemSkuRespDto.getId());
            itemBundle.setBarCode(material.getBrandCode());
            itemBundle.setGrossWeight(StringUtils.isEmpty((CharSequence)material.getGrossWeight()) ? null : BigDecimal.valueOf(Double.parseDouble(material.getGrossWeight())));
            itemBundle.setNetWeight(StringUtils.isEmpty((CharSequence)material.getNetWeight()) ? null : BigDecimal.valueOf(Double.parseDouble(material.getNetWeight())));
            itemBundle.setMinPackage(StringUtils.isEmpty((CharSequence)material.getMinPackNum()) ? null : Integer.valueOf((int)Double.parseDouble(material.getMinPackNum())));
            itemBundle.setAttr("{\"\u9ed8\u8ba4\":\"" + material.getModel() + "\"}");
            itemBundle.setUnit(this.createItemUnit(material.getBaseUnit()));
            itemBundle.setUpdatePerson(material.getUpdatePerson());
            ArrayList<ItemBundleReqDto> list = new ArrayList<ItemBundleReqDto>();
            list.add(itemBundle);
            logger.info("\u66f4\u65b0\u5546\u54c1sku\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(list));
            this.iItemSkuApi.modifyItemSku(list);
        } else {
            itemBundleReqDto.setItemId(material.getItemId());
            itemBundleReqDto.setBarCode(material.getBrandCode());
            itemBundleReqDto.setVolumeUnit(material.getVolume());
            itemBundleReqDto.setGrossWeight(StringUtils.isEmpty((CharSequence)material.getGrossWeight()) ? null : BigDecimal.valueOf(Double.parseDouble(material.getGrossWeight())));
            itemBundleReqDto.setNetWeight(StringUtils.isEmpty((CharSequence)material.getNetWeight()) ? null : BigDecimal.valueOf(Double.parseDouble(material.getNetWeight())));
            itemBundleReqDto.setMinPackage(StringUtils.isEmpty((CharSequence)material.getMinPackNum()) ? null : Integer.valueOf((int)Double.parseDouble(material.getMinPackNum())));
            itemBundleReqDto.setAttr("{\"\u9ed8\u8ba4\":\"" + material.getModel() + "\"}");
            itemBundleReqDto.setUnit(this.createItemUnit(material.getBaseUnit()));
            itemBundleReqDto.setMinPackage(Integer.valueOf(1));
            itemBundleReqDto.setCargoCode(material.getLongCode());
            itemBundleReqDto.setCode(material.getLongCode());
            itemBundleReqDto.setCreatePerson("\u7cfb\u7edf\u7528\u6237");
            itemBundleReqDto.setTenantId(this.requestBaseData.getTenantId());
            itemBundleReqDto.setInstanceId(this.requestBaseData.getInstanceId());
            logger.info("=================> \u65b0\u589e\u5546\u54c1sku\u5165\u53c2 : {}", (Object)JSONObject.toJSONString((Object)itemBundleReqDto));
            ArrayList prices = Lists.newArrayList();
            ItemPriceReqDto itemPriceReqDto = new ItemPriceReqDto();
            itemPriceReqDto.setName("\u5212\u7ebf\u4ef7");
            itemPriceReqDto.setCurrency("\u5143");
            itemPriceReqDto.setPrice(new BigDecimal("99999.90"));
            itemPriceReqDto.setPriceType("PRICE");
            prices.add(itemPriceReqDto);
            itemPriceReqDto = new ItemPriceReqDto();
            itemPriceReqDto.setName("\u552e\u4ef7");
            itemPriceReqDto.setCurrency("\u5143");
            itemPriceReqDto.setPrice(new BigDecimal("99999.90"));
            itemPriceReqDto.setPriceType("RETAIL_PRICE");
            prices.add(itemPriceReqDto);
            itemBundleReqDto.setPrices((List)prices);
            this.iItemSkuApi.addItemSku((List)Lists.newArrayList((Object[])new ItemBundleReqDto[]{itemBundleReqDto}));
        }
    }

    private BrandRespDto getBrand(MaterialNewDto material) {
        Long id = null;
        String filter = "{\"code\":\"" + material.getBrandCode() + "\"}";
        PageInfo dtoPageInfo = (PageInfo)this.brandQueryApi.queryByPage(filter, Integer.valueOf(1), Integer.valueOf(10)).getData();
        logger.info("\u67e5\u8be2\u54c1\u724c\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)dtoPageInfo.getList()));
        if (CollectionUtil.isEmpty((Collection)dtoPageInfo.getList())) {
            TagReqDto.BrandReqDto brandReqDto = new TagReqDto.BrandReqDto();
            brandReqDto.setCode(material.getBrandCode());
            brandReqDto.setName(material.getBrandName());
            brandReqDto.setStatus(Integer.valueOf(1));
            brandReqDto.setCreatePerson(material.getCreatePerson());
            brandReqDto.setTenantId(this.requestBaseData.getTenantId());
            brandReqDto.setInstanceId(this.requestBaseData.getInstanceId());
            id = (Long)this.brandApi.addBrand(brandReqDto).getData();
            BrandRespDto brandRespDto = new BrandRespDto();
            brandRespDto.setId(id);
            brandRespDto.setCode(material.getBrandCode());
            brandRespDto.setName(material.getBrandName());
            return brandRespDto;
        }
        return (BrandRespDto)dtoPageInfo.getList().get(0);
    }

    private Integer getType(MaterialNewDto materialNewDto) {
        switch (materialNewDto.getType()) {
            case "PRODUCT": {
                return 1;
            }
            case "MATERIAL": {
                return 3;
            }
            case "GIFT": {
                return 2;
            }
        }
        return 1;
    }

    private String assembleAttr(MaterialNewDto materialNewDto) {
        String fmodle = materialNewDto.getModel();
        if (StringUtils.isEmpty((CharSequence)fmodle)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\"backDirList\":[1288630386802423099],\"propList\":[{\"extFields\":{},\"id\":");
        ItemProValue itemProValue = new ItemProValue();
        itemProValue.setName(fmodle);
        itemProValue.setPropNameId(Long.valueOf(1291088791304623272L));
        this.iItemSycnExtApi.addProValue(itemProValue);
        String name = "\"name\":\"\u9ed8\u8ba4\",";
        String propValueList = "\"propValueList\":[\"" + fmodle + "\"]}]}";
        stringBuilder.append(name);
        stringBuilder.append(propValueList);
        logger.info("\u7ec4\u88c5\u5c5e\u6027\uff1a{}", (Object)JSONObject.toJSONString((Object)stringBuilder.toString()));
        return stringBuilder.toString();
    }

    private String createItemUnit(String unitName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", unitName);
        List list = ((PageInfo)this.unitQueryApi.queryByPage(JSONObject.toJSONString(map), Integer.valueOf(1), Integer.valueOf(10)).getData()).getList();
        return CollectionUtil.isNotEmpty((Collection)list) ? ((UnitRespDto)list.get(0)).getId().toString() : null;
    }
}

