/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.tcbj.app.open.biz.service.IExternalService;
import com.dtyunxi.tcbj.app.open.biz.service.impl.ExternalInPutServiceImpl;
import com.dtyunxi.tcbj.app.open.biz.service.impl.ExternalOutServiceImpl;
import com.dtyunxi.tcbj.app.open.dao.das.ExternalApiInLogDas;
import com.dtyunxi.tcbj.app.open.dao.das.ExternalApiRequestLogDas;
import com.dtyunxi.tcbj.app.open.dao.eo.ExternalApiInLogEo;
import com.dtyunxi.tcbj.app.open.dao.eo.ExternalApiRequestLogEo;
import com.dtyunxi.util.SpringBeanUtil;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@DS(value="master")
@Service
public class ExternalServiceImpl
implements IExternalService {
    private static final Logger log = LoggerFactory.getLogger(ExternalServiceImpl.class);
    @Resource
    private ExternalApiInLogDas apiInLogDas;
    @Resource
    private ExternalApiRequestLogDas apiRequestLogDas;

    @Override
    public void retryApiInLogJob() {
        List apiInLogEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.apiInLogDas.filter().gt((Object)"retrys", (Object)0)).orderByDesc((Object)"create_time")).list();
        List<Long> ids = this.retryInLogEo(apiInLogEos, false);
        this.updateInLogRetrys(ids);
    }

    @Override
    public void retryApiInByIds(List<Long> ids) {
        List apiInLogEos = this.apiInLogDas.selectByIds(ids);
        this.retryInLogEo(apiInLogEos, true);
    }

    @Override
    public void retryApiRequestLogJob() {
        List apiRequestLogEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.apiRequestLogDas.filter().gt((Object)"retrys", (Object)0)).orderByDesc((Object)"create_time")).list();
        List<Long> ids = this.retryRequestLogEo(apiRequestLogEos, false);
        this.updateRequestLogRetrys(ids);
    }

    @Override
    public void retryApiRequestByIds(List<Long> ids) {
        List apiRequestLogEos = this.apiRequestLogDas.selectByIds(ids);
        this.retryRequestLogEo(apiRequestLogEos, true);
    }

    private List<Long> retryInLogEo(List<ExternalApiInLogEo> apiInLogEos, boolean isThrow) {
        if (CollUtil.isEmpty(apiInLogEos)) {
            return null;
        }
        ArrayList ids = Lists.newArrayList();
        for (ExternalApiInLogEo apiInLogEo : apiInLogEos) {
            String param;
            String sign = apiInLogEo.getSign();
            if (StringUtils.isBlank((CharSequence)sign) || StringUtils.isBlank((CharSequence)(param = apiInLogEo.getRequestParam()))) continue;
            try {
                Map dto = (Map)JSON.parseObject((String)param, Map.class);
                dto.put("sendLogId", Convert.toStr((Object)apiInLogEo.getId()));
                this.invokeByMethod(sign, dto, ExternalInPutServiceImpl.class);
                ids.add(apiInLogEo.getId());
            }
            catch (Exception e) {
                if (isThrow) {
                    throw e;
                }
                log.error("\u6267\u884c\u5b9e\u73b0\u7c7b\u65b9\u6cd5\u5f02\u5e38 methodName:{}", (Object)sign);
                log.error("\u6267\u884c\u5b9e\u73b0\u7c7b\u65b9\u6cd5\u5f02\u5e38", (Throwable)e);
            }
        }
        return ids;
    }

    private List<Long> retryRequestLogEo(List<ExternalApiRequestLogEo> apiRequestLogEos, boolean isThrow) {
        if (CollUtil.isEmpty(apiRequestLogEos)) {
            return null;
        }
        ArrayList ids = Lists.newArrayList();
        for (ExternalApiRequestLogEo apiRequestLogEo : apiRequestLogEos) {
            String param;
            String sign = apiRequestLogEo.getSign();
            if (StringUtils.isBlank((CharSequence)sign) || StringUtils.isBlank((CharSequence)(param = apiRequestLogEo.getRequestParam()))) continue;
            try {
                Map dto = (Map)JSON.parseObject((String)param, Map.class);
                dto.put("sendLogId", Convert.toStr((Object)apiRequestLogEo.getId()));
                this.invokeByMethod(sign, dto, ExternalOutServiceImpl.class);
                ids.add(apiRequestLogEo.getId());
            }
            catch (Exception e) {
                if (isThrow) {
                    throw e;
                }
                log.error("\u6267\u884c\u5b9e\u73b0\u7c7b\u65b9\u6cd5\u5f02\u5e38 methodName:{}", (Object)sign);
                log.error("\u6267\u884c\u5b9e\u73b0\u7c7b\u65b9\u6cd5\u5f02\u5e38", (Throwable)e);
            }
        }
        return ids;
    }

    private void invokeByMethod(String methodName, Map<String, Object> dto, Class<?> clazz) {
        ApplicationContext applicationContext = SpringBeanUtil.getApplicationContext();
        Method method = clazz.getDeclaredMethod(methodName, Map.class);
        method.invoke(applicationContext.getBean(clazz), dto);
    }

    private void updateInLogRetrys(List<Long> ids) {
        this.apiInLogDas.updateRetrysByIds(ids);
    }

    private void updateRequestLogRetrys(List<Long> ids) {
        this.apiRequestLogDas.updateRetrysByIds(ids);
    }
}

