/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.dto.RequestBaseData;
import com.dtyunxi.tcbj.app.open.biz.enums.CustomerMaterialRelEnum;
import com.dtyunxi.tcbj.app.open.biz.enums.DataDistributeRespEnum;
import com.dtyunxi.tcbj.app.open.biz.service.ICenterHandleService;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ModelInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.DataDistributeRespDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.ModelCodeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.IItemAuthApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.ItemAuthRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.query.IItemAuthQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="centerHandleNewCustomerMaterialRelServiceImpl")
public class CenterHandleNewCustomerMaterialRelServiceImpl
implements ICenterHandleService {
    private static Logger logger = LoggerFactory.getLogger(CenterHandleNewCustomerMaterialRelServiceImpl.class);
    @Resource
    private ICustomerApi customerApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private IItemAuthApi itemAuthApi;
    @Resource
    private IItemAuthQueryApi itemAuthQueryApi;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private RequestBaseData requestBaseData;
    @Resource
    private IItemSkuQueryApi iItemSkuQueryApi;
    DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public String getModelType() {
        return ModelCodeEnum.NEW_CUSTOMER_MATERIAL_REL.name();
    }

    @Override
    public List<DataDistributeRespDto> handle(ModelInfoReqDto modelInfoReqDto) {
        ArrayList targetIds;
        long startTime = System.currentTimeMillis();
        logger.info("\u5ba2\u6237\u7269\u6599\u5173\u7cfb\u6570\u636e\u5206\u53d1:{}", (Object)modelInfoReqDto.getDataStr());
        Date date = new Date();
        List maps = JSONArray.parseArray((String)modelInfoReqDto.getDataStr(), Map.class);
        List<Object> responseList = new ArrayList<DataDistributeRespDto>();
        ArrayList itemCodes = new ArrayList();
        ArrayList thirdPartyIds = new ArrayList();
        for (Map map : maps) {
            itemCodes.add(map.get(CustomerMaterialRelEnum.PRODUCT_ID_EASNO.name()));
            thirdPartyIds.add(map.get(CustomerMaterialRelEnum.PARTNER_ID.name()));
        }
        RestResponse itemRespDtoRest = this.itemQueryApi.queryByItemLongCodes(itemCodes);
        if (CollectionUtils.isEmpty((Collection)((Collection)itemRespDtoRest.getData()))) {
            logger.info("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a");
            responseList.add(this.dataResp("-1", DataDistributeRespEnum.FAILURE.getCode(), "\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a"));
            return responseList;
        }
        ArrayList itemAuthReqDtoList = Lists.newArrayList();
        HashMap itemListMap = new HashMap();
        HashMap itemCodeSkuIdMap = new HashMap();
        ((List)itemRespDtoRest.getData()).forEach(itemRespDto -> {
            itemListMap.put(itemRespDto.getLongCode(), itemRespDto.getId());
            itemCodeSkuIdMap.put(itemRespDto.getLongCode(), itemRespDto.getSkuId());
        });
        RestResponse customerRespDtoRest = this.customerQueryApi.queryByThirdPartyIds(thirdPartyIds);
        HashMap customerListMap = CollectionUtils.isNotEmpty((Collection)((Collection)customerRespDtoRest.getData())) ? ((List)customerRespDtoRest.getData()).stream().collect(Collectors.toMap(CustomerRespDto::getThirdPartyId, BaseRespDto::getId, (last, next) -> next)) : new HashMap();
        HashMap itemAuthRespMap = new HashMap();
        List<Object> list = targetIds = CollectionUtils.isNotEmpty((Collection)((Collection)customerRespDtoRest.getData())) ? ((List)customerRespDtoRest.getData()).stream().map(t -> t.getId()).collect(Collectors.toList()) : new ArrayList();
        if (CollectionUtils.isEmpty(targetIds)) {
            logger.info("\u5ba2\u6237id\u4e3a\u7a7a");
            return Lists.newArrayList();
        }
        for (Map map : maps) {
            Long targetId = (Long)customerListMap.get(map.get(CustomerMaterialRelEnum.PARTNER_ID.name()));
            Long businessId = (Long)itemCodeSkuIdMap.get(map.get(CustomerMaterialRelEnum.PRODUCT_ID_EASNO.name()));
            ItemAuthReqDto itemAuthReqDto = new ItemAuthReqDto();
            itemAuthReqDto.setTargetType(Integer.valueOf(1));
            itemAuthReqDto.setTargetId(targetId);
            itemAuthReqDto.setBusinessType("SKU");
            itemAuthReqDto.setBusinessId(businessId);
            itemAuthReqDto.setStatus(Integer.valueOf(1));
            itemAuthReqDto.setInstanceId(this.requestBaseData.getInstanceId());
            itemAuthReqDto.setTenantId(this.requestBaseData.getTenantId());
            itemAuthReqDtoList.add(itemAuthReqDto);
        }
        if (CollectionUtils.isNotEmpty((Collection)itemAuthReqDtoList)) {
            this.itemAuthApi.batchNewAddItemAuth((List)itemAuthReqDtoList);
            return Lists.newArrayList();
        }
        HashMap finalItemAuthRespMap = itemAuthRespMap;
        List futures = maps.stream().map(orMap -> CompletableFuture.supplyAsync(() -> {
            Map map = orMap;
            StringBuilder resultReason = new StringBuilder();
            if (!itemListMap.containsKey(map.get(CustomerMaterialRelEnum.PRODUCT_ID_EASNO.name()))) {
                resultReason.append(" \u6ca1\u6709\u5bf9\u5e94\u7684\u5546\u54c1\u4fe1\u606f");
            } else if (!itemCodeSkuIdMap.containsKey(map.get(CustomerMaterialRelEnum.PRODUCT_ID_EASNO.name()))) {
                resultReason.append(" \u5546\u54c1id\uff1a" + itemListMap.get(map.get(CustomerMaterialRelEnum.PRODUCT_ID_EASNO.name())) + " \u6ca1\u6709\u5bf9\u5e94\u7684\u5546\u54c1SKU");
            }
            if (!customerListMap.containsKey(map.get(CustomerMaterialRelEnum.PARTNER_ID.name()))) {
                resultReason.append(" \u6ca1\u6709\u5bf9\u5e94\u7684\u5ba2\u6237\u4fe1\u606f");
            }
            if (resultReason.length() > 0) {
                String reason = "\u7269\u6599\u957f\u7f16\u7801\uff1a" + (String)map.get(CustomerMaterialRelEnum.PRODUCT_ID_EASNO.name()) + ",\u6839\u636e\u5ba2\u6237id\uff1a" + (String)map.get(CustomerMaterialRelEnum.PARTNER_ID.name()) + resultReason;
                return this.dataResp((String)map.get(CustomerMaterialRelEnum.CIDP_TASK_UUID.name()), DataDistributeRespEnum.FAILURE.getCode(), reason);
            }
            boolean ifAdd = true;
            Long id = null;
            int status = 1;
            Long targetId = (Long)customerListMap.get(map.get(CustomerMaterialRelEnum.PARTNER_ID.name()));
            Long businessId = (Long)itemCodeSkuIdMap.get(map.get(CustomerMaterialRelEnum.PRODUCT_ID_EASNO.name()));
            String invalidDate = null;
            if (map.get(CustomerMaterialRelEnum.INVALID_DATE.name()) != null) {
                logger.info("INVALID_DATE:{}", map.get(CustomerMaterialRelEnum.INVALID_DATE.name()));
                invalidDate = String.valueOf(map.get(CustomerMaterialRelEnum.INVALID_DATE.name()));
            }
            if (!modelInfoReqDto.getAdd().booleanValue()) {
                if (this.isValid(date, invalidDate)) {
                    if (finalItemAuthRespMap.containsKey(targetId + "-" + businessId)) {
                        ifAdd = false;
                        id = ((ItemAuthRespDto)finalItemAuthRespMap.get(targetId + "-" + businessId)).getId();
                    }
                } else {
                    if (finalItemAuthRespMap.containsKey(targetId + "-" + businessId)) {
                        ifAdd = false;
                        id = ((ItemAuthRespDto)finalItemAuthRespMap.get(targetId + "-" + businessId)).getId();
                    }
                    status = 0;
                }
            }
            Date authEndTime = null;
            if (StringUtils.isNotEmpty(invalidDate)) {
                authEndTime = new Date(Long.parseLong(invalidDate));
            }
            if (ifAdd) {
                ItemAuthReqDto itemAuthReqDto = new ItemAuthReqDto();
                itemAuthReqDto.setTargetType(Integer.valueOf(1));
                itemAuthReqDto.setTargetId(targetId);
                itemAuthReqDto.setBusinessType("SKU");
                itemAuthReqDto.setBusinessId(businessId);
                itemAuthReqDto.setStatus(Integer.valueOf(status));
                itemAuthReqDto.setAuthEndTime(authEndTime);
                itemAuthReqDto.setInstanceId(this.requestBaseData.getInstanceId());
                itemAuthReqDto.setTenantId(this.requestBaseData.getTenantId());
                itemAuthReqDtoList.add(itemAuthReqDto);
                return null;
            }
            ItemAuthReqDto itemAuthReqDto = new ItemAuthReqDto();
            itemAuthReqDto.setId(id);
            itemAuthReqDto.setStatus(Integer.valueOf(status));
            itemAuthReqDto.setAuthEndTime(authEndTime);
            try {
                this.itemAuthApi.modifyItemAuth(itemAuthReqDto);
                return this.dataResp((String)map.get(CustomerMaterialRelEnum.CIDP_TASK_UUID.name()), DataDistributeRespEnum.SUCCESS.getCode(), DataDistributeRespEnum.SUCCESS.getValue());
            }
            catch (Exception e) {
                logger.info("\u4fee\u6539\u5546\u54c1\u6388\u6743\u4fe1\u606f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                return this.dataResp((String)map.get(CustomerMaterialRelEnum.CIDP_TASK_UUID.name()), DataDistributeRespEnum.FAILURE.getCode(), e.getMessage());
            }
        })).collect(Collectors.toList());
        responseList = futures.stream().map(rep -> {
            try {
                return (DataDistributeRespDto)rep.get();
            }
            catch (Exception e) {
                e.printStackTrace();
                DataDistributeRespDto dataDistributeRespDto = new DataDistributeRespDto();
                dataDistributeRespDto.setType(DataDistributeRespEnum.FAILURE.getCode());
                dataDistributeRespDto.setReason(e.getMessage());
                return dataDistributeRespDto;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty((Collection)itemAuthReqDtoList)) {
            try {
                this.itemAuthApi.batchAddItemAuth((List)itemAuthReqDtoList);
                responseList.add(this.dataResp("1", DataDistributeRespEnum.SUCCESS.getCode(), DataDistributeRespEnum.SUCCESS.getValue()));
            }
            catch (Exception e) {
                responseList.add(this.dataResp("-1", DataDistributeRespEnum.FAILURE.getCode(), e.getMessage()));
                logger.info("\u6279\u91cf\u65b0\u589e\u5546\u54c1\u6388\u6743\u4fe1\u606f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            }
        }
        logger.info("\u7269\u6599\u5ba2\u6237\u7ef4\u62a4\u8fd4\u56de\u7ed3\u679c:{}, \u8017\u65f6:{}", (Object)JSONObject.toJSONString(responseList), (Object)((System.currentTimeMillis() - startTime) / 1000L));
        return responseList;
    }

    private DataDistributeRespDto dataResp(String taskId, String type, String reason) {
        DataDistributeRespDto dataDistributeRespDto = new DataDistributeRespDto();
        dataDistributeRespDto.setTask_id(taskId);
        dataDistributeRespDto.setType(type);
        dataDistributeRespDto.setReason(reason);
        return dataDistributeRespDto;
    }

    private boolean isValid(Date date, String invalidDate) {
        logger.info("\u5f53\u524d\u540c\u6b65\u65f6\u95f4\uff1a" + date.toString() + "\u7ed3\u675f\u65f6\u95f4\uff1a" + invalidDate);
        boolean mark = false;
        if (StringUtils.isEmpty((CharSequence)invalidDate)) {
            mark = true;
            return mark;
        }
        if (Long.parseLong(invalidDate) > date.getTime()) {
            mark = true;
        }
        return mark;
    }
}

