/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.auth.sign.base;

import cn.hutool.crypto.digest.MD5;
import com.dtyunxi.tcbj.app.open.biz.auth.sign.base.BaseSignHelper;
import com.dtyunxi.tcbj.app.open.biz.auth.sign.dto.BasicSignDto;
import com.dtyunxi.tcbj.app.open.biz.auth.sign.dto.SignBaseDto;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;

public class BaseShaSignHelper
implements BaseSignHelper {
    @Override
    public <Sign extends SignBaseDto> String sign(Sign signDto) {
        BasicSignDto qw = (BasicSignDto)signDto;
        Map<String, String> signMap = this.buildData(qw);
        StringBuilder sb = new StringBuilder();
        signMap.forEach((k, v) -> sb.append((String)k).append("=").append((String)v).append("&"));
        sb.setLength(sb.length() - 1);
        return new HmacUtils(HmacAlgorithms.HMAC_SHA_256, signDto.getAppSecret()).hmacHex(sb.toString());
    }

    private Map<String, String> buildData(BasicSignDto sign) {
        TreeMap<String, String> signMap = new TreeMap<String, String>();
        signMap.put("X-Yx-Timestamp", sign.getTimestamp());
        signMap.put("X-Nonce", sign.getNonce());
        signMap.put("Application-Key", sign.getAppKey());
        signMap.put("Application-Secret", sign.getAppSecret());
        this.setData(sign, signMap);
        return signMap;
    }

    private void setData(BasicSignDto sign, Map<String, String> signMap) {
        Optional.ofNullable(sign.getReqParam()).filter(req -> !req.isEmpty()).ifPresent(req -> signMap.put("md5", MD5.create().digestHex16(req.toJSONString())));
    }
}

