/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.auth.check;

import com.dtyunxi.tcbj.app.open.biz.auth.ResultBo;
import com.dtyunxi.tcbj.app.open.biz.auth.ServletDataUtils;
import com.dtyunxi.tcbj.app.open.biz.auth.check.ICheck;
import com.dtyunxi.tcbj.app.open.biz.auth.config.ThirdAuthProperties;
import com.dtyunxi.tcbj.app.open.biz.auth.sign.SignHelper;
import com.dtyunxi.tcbj.app.open.biz.auth.sign.dto.BasicSignDto;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class PcpAdapterCheckImpl
implements ICheck {
    private final SignHelper signHelper;
    private static final String KEYWORD = "sign";
    private static final String TIMESTAMP = "timestamp";
    @Resource
    private ThirdAuthProperties properties;

    public PcpAdapterCheckImpl(SignHelper signHelper) {
        this.signHelper = signHelper;
    }

    @Override
    public boolean supports(HttpServletRequest request) {
        if (StringUtils.isEmpty((String)request.getQueryString())) {
            return false;
        }
        return Optional.of(ServletDataUtils.urlParse(request.getQueryString())).map(data -> data.getString(KEYWORD)).map(StringUtils::isNotBlank).orElse(false);
    }

    @Override
    public ResultBo check(HttpServletRequest request) {
        return ResultBo.build(this.doCheck(request));
    }

    private Boolean doCheck(HttpServletRequest request) {
        return Optional.ofNullable(request.getQueryString()).map(ServletDataUtils::urlParse).map(data -> {
            if (StringUtils.isBlank((String)data.getString(KEYWORD))) {
                return false;
            }
            BasicSignDto basicSignDto = new BasicSignDto();
            basicSignDto.setTimestamp(data.getString(TIMESTAMP));
            basicSignDto.setAppKey(this.properties.getPcpKey());
            basicSignDto.setAppSecret(this.properties.getAppKeyMap().get(this.properties.getPcpKey()));
            return this.signHelper.sign(basicSignDto).equals(data.getString(KEYWORD));
        }).orElse(false);
    }
}

