/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.portal.svr.service.impl.identity;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.TokenUtil;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.portal.svr.service.identity.TokenVerificationPortalService;
import com.dtyunxi.yundt.cube.center.identity.api.ITokenApi;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserLoginReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.SsoRespDto;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TokenVerificationPortalServiceImpl
implements TokenVerificationPortalService {
    private static final Logger log = LoggerFactory.getLogger(TokenVerificationPortalServiceImpl.class);
    @Value(value="${user.password}")
    private String password;
    @Value(value="${token.secretKey}")
    private String tokenSecretKey;
    @Value(value="${token.validTime}")
    private String tokenValidTime;
    @Resource
    private ITokenApi tokenApi;
    @Autowired
    private ICacheService cacheService;

    @Override
    public SsoRespDto login(String userName) {
        try {
            ServiceContext.getContext().set("yes.req.tenantId", (Object)"1");
            ServiceContext.getContext().set("yes.req.instanceId", (Object)"2");
            UserLoginReqDto userLoginReqDto = new UserLoginReqDto();
            userLoginReqDto.setPassword(this.password);
            userLoginReqDto.setUserName(userName);
            userLoginReqDto.setLoginType(Integer.valueOf(1));
            RestResponse ssoRespDtoRestResponse = this.tokenApi.ssoLogin(userLoginReqDto);
            int expirySeconds = Integer.parseInt(this.tokenValidTime);
            HashMap<String, Object> userTokenMap = new HashMap<String, Object>();
            userTokenMap.put("instanceId", 2);
            userTokenMap.put("tenantId", 1);
            userTokenMap.put("loginName", userName);
            String token = TokenUtil.generate((String)this.tokenSecretKey, (int)expirySeconds, userTokenMap);
            log.info("\u6253\u5370token");
            this.cacheToken(userLoginReqDto, this.getTokenKey(userTokenMap), token, expirySeconds);
            SsoRespDto data = (SsoRespDto)ssoRespDtoRestResponse.getData();
            if (data == null) {
                log.info("\u767b\u5165\u5931\u8d25");
                throw new BizException("\u767b\u9646\u5931\u8d25");
            }
            return data;
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6token\u5931\u8d25:{}", (Throwable)e);
            throw new BizException("\u83b7\u53d6token\u5931\u8d25");
        }
    }

    private String getTokenKey(Map<String, Object> map) {
        String key = "token#" + map.get("id");
        return key;
    }

    private void cacheToken(UserLoginReqDto userLoginReqDto, String tokenKey, String token, int expirySeconds) {
        if (StringUtils.isNotBlank((CharSequence)userLoginReqDto.getLoginSource())) {
            this.cacheService.setCache(tokenKey + "-" + userLoginReqDto.getLoginSource(), (Object)token, expirySeconds);
        } else {
            this.cacheService.setCache(tokenKey, (Object)token, expirySeconds);
        }
        if (StringUtils.isNotBlank((CharSequence)userLoginReqDto.getAppKey())) {
            this.cacheService.setCache(token, (Object)Sets.newHashSet((Object[])new String[]{userLoginReqDto.getAppKey()}), expirySeconds);
        }
    }
}

