/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.control.biz.service.impl;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.control.api.dto.constant.OrderAmountCalculateTypeEnum;
import com.dtyunxi.tcbj.center.control.api.dto.request.CustomerControlBaseReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlInventoryItemRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlInventoryRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlOrderRespDto;
import com.dtyunxi.tcbj.center.control.api.query.IControlInventoryQueryApi;
import com.dtyunxi.tcbj.center.control.api.query.IControlOrderQueryApi;
import com.dtyunxi.tcbj.module.control.biz.BizExceptionCode;
import com.dtyunxi.tcbj.module.control.biz.dto.request.OrderItemReqDto;
import com.dtyunxi.tcbj.module.control.biz.dto.request.VerifyInventoryReqDto;
import com.dtyunxi.tcbj.module.control.biz.dto.request.VerifyReqDto;
import com.dtyunxi.tcbj.module.control.biz.handler.VerifyResultHandler;
import com.dtyunxi.tcbj.module.control.biz.service.IVerifyService;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ITcbjInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjAvilableReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.TcbjAvilableRespDto;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class VerifyServiceImpl
implements IVerifyService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IControlOrderQueryApi orderQueryApi;
    @Resource
    private IControlInventoryQueryApi inventoryQueryApi;
    @Resource
    private ITcbjInventoryApi inventoryApi;
    @Resource
    private HttpServletRequest request;

    public String getHeaderOrgId() {
        String organizationId = this.request.getHeader("yes-req-cus-b2b-organizationId");
        this.logger.info("\u83b7\u53d6\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        return organizationId;
    }

    @Override
    public ControlOrderRespDto verifyControlRule(VerifyReqDto reqDto) {
        this.logger.info("\u3010\u8ba2\u5355\u7ba1\u63a7\u6821\u9a8c\u3011\u8bf7\u6c42\u6821\u9a8c\u7684\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)((Object)reqDto)));
        String orgIdStr = this.getHeaderOrgId();
        Assert.notNull((Object)orgIdStr, (String)"\u79df\u6237Id\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (Object[])new Object[0]);
        CustomerControlBaseReqDto baseReqDto = new CustomerControlBaseReqDto();
        baseReqDto.setCustomerId(reqDto.getCustomerId());
        baseReqDto.setCustomerAreaCodeList(Collections.singletonList(reqDto.getCustomerAreaCode()));
        baseReqDto.setOrgId(Long.valueOf(orgIdStr));
        RestResponse respDtoRestResponse = this.orderQueryApi.queryRuleByCustomer(baseReqDto);
        ControlOrderRespDto orderRespDto = (ControlOrderRespDto)RestResponseHelper.extractData((RestResponse)respDtoRestResponse);
        if (Objects.nonNull(orderRespDto)) {
            this.logger.info("\u3010\u8ba2\u5355\u7ba1\u63a7\u6821\u9a8c\u3011\u5b58\u5728\u7ba1\u63a7\u89c4\u5219\uff1a{}", (Object)JSON.toJSONString((Object)orderRespDto));
            BigDecimal minAmount = orderRespDto.getMinAmount();
            if (OrderAmountCalculateTypeEnum.SUPPLY_AMOUNT.getType().equals(orderRespDto.getCalculateType())) {
                if (minAmount.compareTo(reqDto.getSupplyAmount()) > 0) {
                    this.logger.info("\u3010\u8ba2\u5355\u7ba1\u63a7\u6821\u9a8c\u3011\u89c4\u5219\u6821\u9a8c\u4e0d\u901a\u8fc7");
                    return VerifyResultHandler.verifyResult(orderRespDto);
                }
            } else if (minAmount.compareTo(reqDto.getItemPayAmount()) > 0) {
                this.logger.info("\u3010\u8ba2\u5355\u7ba1\u63a7\u6821\u9a8c\u3011\u89c4\u5219\u6821\u9a8c\u4e0d\u901a\u8fc7");
                return VerifyResultHandler.verifyResult(orderRespDto);
            }
        }
        return null;
    }

    @Override
    public ControlInventoryRespDto verifyInventoryRule(VerifyInventoryReqDto reqDto) {
        this.logger.info("\u3010\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u6821\u9a8c\u3011\u8bf7\u6c42\u6821\u9a8c\u7684\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)((Object)reqDto)));
        List itemIdList = Optional.ofNullable(reqDto.getItemList()).orElseGet(Collections::emptyList).stream().map(OrderItemReqDto::getItemId).collect(Collectors.toList());
        RestResponse restResponse = this.inventoryQueryApi.queryRuleByCustomer(reqDto.getCustomerId(), reqDto.getCustomerAreaCode(), itemIdList);
        List inventoryItemRespDtoList = (List)RestResponseHelper.extractData((RestResponse)restResponse);
        if (CollectionUtils.isEmpty((Collection)inventoryItemRespDtoList)) {
            this.logger.info("\u3010\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u6821\u9a8c\u3011\u65e0\u7ba1\u63a7\u89c4\u5219");
            return null;
        }
        List itemCodeList = inventoryItemRespDtoList.stream().map(ControlInventoryItemRespDto::getItemCode).collect(Collectors.toList());
        TcbjAvilableReqDto param = new TcbjAvilableReqDto();
        RestResponse avilableResp = this.inventoryApi.avilableYingXiaoYun(param);
        List avilableRespDtoList = (List)RestResponseHelper.extractData((RestResponse)avilableResp);
        Map itemReqDtoMap = reqDto.getItemList().stream().collect(Collectors.toMap(OrderItemReqDto::getItemCode, Function.identity()));
        Map controlInventoryItemMap = inventoryItemRespDtoList.stream().collect(Collectors.toMap(ControlInventoryItemRespDto::getItemCode, Function.identity()));
        for (TcbjAvilableRespDto avilableRespDto : avilableRespDtoList) {
            OrderItemReqDto orderItemReqDto = (OrderItemReqDto)itemReqDtoMap.get(avilableRespDto.getCargoCode());
            ControlInventoryItemRespDto inventoryItemRespDto = (ControlInventoryItemRespDto)controlInventoryItemMap.get(avilableRespDto.getCargoCode());
            boolean result = avilableRespDto.getAvailable() - (double)orderItemReqDto.getItemNum().intValue() < (double)inventoryItemRespDto.getFloorInventoryCount().intValue();
            if (!result) continue;
            this.logger.info("\u3010\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u6821\u9a8c\u3011\u5f53\u524d\u8ba2\u5355\u7684\u5546\u54c1\u4ee5\u8d85\u51fa\u5b89\u5168\u5e93\u5b58\uff0c\u4e2d\u65ad\u7528\u6237\u7684\u4e0b\u5355\u64cd\u4f5c\u3002\u4e0b\u5355\u7684\u5546\u54c1\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)orderItemReqDto));
            throw new BizException(BizExceptionCode.INVENTORY_NOT_ENOUGH.getCode(), String.format(BizExceptionCode.INVENTORY_NOT_ENOUGH.getMsg(), orderItemReqDto.getItemName()));
        }
        this.logger.info("\u3010\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u6821\u9a8c\u3011\u89c4\u5219\u6821\u9a8c\u901a\u8fc7");
        return null;
    }
}

