/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.module.export.biz.BizExceptionCode;
import com.dtyunxi.tcbj.module.export.biz.constant.ExportTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.impl.ExportService;
import com.dtyunxi.tcbj.module.export.biz.utils.ThreadPoolUtil;
import com.dtyunxi.tcbj.module.export.biz.vo.inventory.InventoryPageVo;
import com.dtyunxi.tcbj.module.export.biz.vo.inventory.InventoryTotalPageVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsInventoryExposedQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsLogicInventoryTotalQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryPageQueryReqDto;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="inventoryExportService")
public class InventoryExportService {
    private static final Logger logger = LoggerFactory.getLogger(InventoryExportService.class);
    @Resource
    private ICsInventoryExposedQueryApi csInventoryExposedQueryApi;
    @Resource
    private ICsLogicInventoryTotalQueryApi logicInventoryTotalQueryApi;
    @Resource
    private ExportService exportService;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IContext context;

    public RestResponse<Object> exportInventoryPage(CsInventoryPageQueryReqDto reqDto) {
        reqDto.setPageNum(Integer.valueOf(1));
        reqDto.setPageSize(Integer.valueOf(1000000));
        String fileName = "\u5e93\u5b58\u5217\u8868_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
        Long userId = this.context.userId();
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(userId));
        Long id = this.exportService.initNew(orgId, fileName, ExportTypeEnum.INVENTORY);
        try {
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csInventoryExposedQueryApi.queryInventoryPage(reqDto));
            if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                List list = pageInfo.getList();
                ArrayList rList = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)rList, (Collection)pageInfo.getList(), InventoryPageVo.class);
                String excelName = "cube/" + fileName;
                try {
                    String exportUrl = EasyPoiExportUtil.getExportUrl((List)rList, InventoryPageVo.class, null, (String)excelName, (String)"xls");
                    this.exportService.success(id, exportUrl);
                    return new RestResponse("0", "\u5bfc\u51fa\u5e93\u5b58\u5217\u8868\u6210\u529f");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("\u5bfc\u51fa\u5e93\u5b58\u5217\u8868-\u9519\u8bef:{}", (Object)e.toString());
                    this.exportService.fail(id, "\u5bfc\u51fa\u5e93\u5b58\u5217\u8868-\u9519\u8bef1:" + e);
                    return new RestResponse(BizExceptionCode.INVENTORY_EXPORT_ERROR.getCode(), BizExceptionCode.INVENTORY_EXPORT_ERROR.getMsg());
                }
            }
            this.exportService.fail(id, "\u5bfc\u51fa\u5e93\u5b58\u5217\u8868,\u6570\u636e\u4e3a\u7a7a");
            return new RestResponse(BizExceptionCode.INVENTORY_EXPORT_EMPTY.getCode(), BizExceptionCode.INVENTORY_EXPORT_EMPTY.getMsg());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
            this.exportService.fail(id, "\u5bfc\u51fa\u5e93\u5b58\u5217\u8868-\u9519\u8bef2:" + e);
            return new RestResponse(BizExceptionCode.INVENTORY_EXPORT_QUERY_ERROR.getCode(), BizExceptionCode.INVENTORY_EXPORT_QUERY_ERROR.getMsg());
        }
    }

    public RestResponse<Object> exportInventoryTotalPage(CsInventoryPageQueryReqDto reqDto) {
        reqDto.setPageNum(Integer.valueOf(1));
        reqDto.setPageSize(Integer.valueOf(1000000));
        String fileName = "\u603b\u5e93\u5b58\u5217\u8868_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
        Long userId = this.context.userId();
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(userId));
        Long id = this.exportService.initNew(orgId, fileName, ExportTypeEnum.INVENTORY_TOTAL);
        try {
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.logicInventoryTotalQueryApi.queryWarehouseInventoryPageInfo(reqDto));
            if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                ArrayList rList = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)rList, (Collection)pageInfo.getList(), InventoryTotalPageVo.class);
                String excelName = "cube/" + fileName;
                try {
                    String exportUrl = EasyPoiExportUtil.getExportUrl((List)rList, InventoryTotalPageVo.class, null, (String)excelName, (String)"xls");
                    this.exportService.success(id, exportUrl);
                    return new RestResponse("0", "\u5bfc\u51fa\u603b\u5e93\u5b58\u5217\u8868\u6210\u529f");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("\u5bfc\u51fa\u603b\u5e93\u5b58\u5217\u8868-\u9519\u8bef:{}", (Object)e.toString());
                    this.exportService.fail(id, "\u5bfc\u51fa\u603b\u5e93\u5b58\u5217\u8868-\u9519\u8bef1:" + e);
                    return new RestResponse(BizExceptionCode.INVENTORY_EXPORT_ERROR.getCode(), BizExceptionCode.INVENTORY_EXPORT_ERROR.getMsg());
                }
            }
            this.exportService.fail(id, "\u5bfc\u51fa\u603b\u5e93\u5b58\u5217\u8868,\u6570\u636e\u4e3a\u7a7a");
            return new RestResponse(BizExceptionCode.INVENTORY_EXPORT_EMPTY.getCode(), BizExceptionCode.INVENTORY_EXPORT_EMPTY.getMsg());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
            this.exportService.fail(id, "\u5bfc\u51fa\u603b\u5e93\u5b58\u5217\u8868-\u9519\u8bef2:" + e);
            return new RestResponse(BizExceptionCode.INVENTORY_EXPORT_QUERY_ERROR.getCode(), BizExceptionCode.INVENTORY_EXPORT_QUERY_ERROR.getMsg());
        }
    }

    public RestResponse<Object> exportInventoryPageThread(CsInventoryPageQueryReqDto reqDto) {
        reqDto.setPageNum(Integer.valueOf(1));
        reqDto.setPageSize(Integer.valueOf(1000000));
        String fileName = "\u5e93\u5b58\u5217\u8868_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
        Long userId = this.context.userId();
        Long instanceId = this.context.instanceId();
        Long tenantId = this.context.tenantId();
        Long applicationId = this.context.applicationId();
        String userCode = this.context.userName();
        String customerid = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.customerid");
        String organizationid = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationid");
        logger.info("\u3010web\u7ebf\u7a0b\u5e93\u5b58\u5bfc\u51fa\u4e0a\u4e0b\u6587={}\uff0ckeys={}\uff0cattachments={}\uff0ccustomerid = {}\uff0corganizationid = {}\u3011", new Object[]{ServiceContext.getContext().getKeys(), ServiceContext.getContext().getAttachments(), customerid, organizationid});
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(userId));
        Long id = this.exportService.initNew(orgId, fileName, ExportTypeEnum.INVENTORY);
        ThreadPoolUtil.executorService.submit(() -> {
            try {
                ServiceContext.getContext().set("yes.req.userId", (Object)userId.toString());
                ServiceContext.getContext().set("yes.req.instanceId", (Object)instanceId.toString());
                ServiceContext.getContext().set("yes.req.tenantId", (Object)tenantId.toString());
                ServiceContext.getContext().set("yes.req.applicationId", (Object)applicationId.toString());
                ServiceContext.getContext().set("yes.req.userCode", (Object)userCode);
                if (StringUtils.isNotBlank((CharSequence)customerid)) {
                    ServiceContext.getContext().setAttachment("yes.req.cus.b2b.customerid", customerid);
                }
                if (StringUtils.isNotBlank((CharSequence)organizationid)) {
                    ServiceContext.getContext().setAttachment("yes.req.cus.b2b.organizationid", organizationid);
                }
                logger.info("\u3010web\u7ebf\u7a0b\u5e93\u5b58\u5bfc\u51fa\u4e0a\u4e0b\u6587={}\uff0ckeys={}\uff0cattachments={}\uff0ccustomerid = {}\uff0corganizationid = {}\u3011", new Object[]{ServiceContext.getContext().getKeys(), ServiceContext.getContext().getAttachments(), customerid, organizationid});
                logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\uff1afileName:{},reqDto:{}", (Object)fileName, (Object)JSONObject.toJSONString((Object)reqDto));
                PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csInventoryExposedQueryApi.queryInventoryPage(reqDto));
                if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                    List list = pageInfo.getList();
                    ArrayList rList = Lists.newArrayList();
                    CubeBeanUtils.copyCollection((Collection)rList, (Collection)pageInfo.getList(), InventoryPageVo.class);
                    String excelName = "cube/" + fileName;
                    try {
                        String exportUrl = EasyPoiExportUtil.getExportUrl((List)rList, InventoryPageVo.class, null, (String)excelName, (String)"xls");
                        this.exportService.success(id, exportUrl);
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("\u5bfc\u51fa\u5e93\u5b58\u5217\u8868-\u9519\u8bef:{}", (Object)e.toString());
                        this.exportService.fail(id, "\u5bfc\u51fa\u5e93\u5b58\u5217\u8868-\u9519\u8bef1:" + e);
                        return;
                    }
                }
                this.exportService.fail(id, "\u5bfc\u51fa\u5e93\u5b58\u5217\u8868,\u6570\u636e\u4e3a\u7a7a");
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(e.getMessage(), (Throwable)e);
                this.exportService.fail(id, "\u5bfc\u51fa\u5e93\u5b58\u5217\u8868-\u9519\u8bef2:" + e);
                return;
            }
        });
        return new RestResponse("0", "\u5bfc\u51fa\u5e93\u5b58\u5217\u8868\u6210\u529f");
    }
}

