/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.utils;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.util.SpringBeanUtil;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyEasyPoiExportUtil {
    private static final Logger logger = LoggerFactory.getLogger(EasyPoiExportUtil.class);
    private static IObjectStorageService objectStorageService;
    private static String bucketName;

    public static String commonInit() {
        if (objectStorageService == null) {
            objectStorageService = (IObjectStorageService)SpringBeanUtil.getBean(IObjectStorageService.class);
        }
        if (bucketName == null) {
            bucketName = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.bucketName");
        }
        return SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.endpoint");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String getExportUrl(List<T> excelRespDtos, Class<T> tClass, String title, String excelName, String suffix) {
        String url;
        String downloadUrl = MyEasyPoiExportUtil.commonInit();
        if (CollectionUtils.isEmpty(excelRespDtos)) {
            excelRespDtos = Lists.newArrayList();
        }
        ByteArrayOutputStream fos = null;
        String fileName = excelName + "." + suffix;
        ExportParams params = new ExportParams(title, "", "xls".equalsIgnoreCase(suffix) ? ExcelType.HSSF : ExcelType.XSSF);
        try {
            Workbook workbook = ExcelExportUtil.exportBigExcel((ExportParams)params, tClass, (Collection)excelRespDtos);
            url = MyEasyPoiExportUtil.getFileUrl(title, downloadUrl, workbook, fos, fileName);
        }
        finally {
            ExcelExportUtil.closeExportBigExcel();
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String getExportUrlForMap(List<T> excelRespDtos, List<ExcelExportEntity> excelParams, String title, String excelName, String suffix) {
        String url;
        String downloadUrl = MyEasyPoiExportUtil.commonInit();
        if (CollectionUtils.isEmpty(excelRespDtos)) {
            excelRespDtos = Lists.newArrayList();
        }
        ByteArrayOutputStream fos = null;
        String fileName = excelName + "." + suffix;
        ExportParams params = new ExportParams(title, "", "xls".equalsIgnoreCase(suffix) ? ExcelType.HSSF : ExcelType.XSSF);
        try {
            Workbook workbook = ExcelExportUtil.exportBigExcel((ExportParams)params, excelParams, (Collection)excelRespDtos);
            url = MyEasyPoiExportUtil.getFileUrl(title, downloadUrl, workbook, fos, fileName);
        }
        catch (Throwable throwable) {
            logger.info("ExportParams\u503c:{},excelParams\u503c:{},\u5bfc\u51fa\u6570\u636e\u957f\u5ea6:{}", new Object[]{params, excelParams, excelRespDtos});
            ExcelExportUtil.closeExportBigExcel();
            throw throwable;
        }
        logger.info("ExportParams\u503c:{},excelParams\u503c:{},\u5bfc\u51fa\u6570\u636e\u957f\u5ea6:{}", new Object[]{params, excelParams, excelRespDtos});
        ExcelExportUtil.closeExportBigExcel();
        return url;
    }

    public static String getFileUrl(String title, String downloadUrl, Workbook workbook, ByteArrayOutputStream fos, String fileName) {
        String url;
        try {
            fos = new ByteArrayOutputStream();
            workbook.write((OutputStream)fos);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fos.toByteArray());
            objectStorageService.put(bucketName, fileName, (InputStream)byteArrayInputStream);
            url = downloadUrl + "/" + fileName;
        }
        catch (IOException var14) {
            logger.error(title + "\u5bfc\u51faexcel\u5f02\u5e38", (Object)var14.getMessage(), (Object)var14);
            throw new BusinessRuntimeException(title + "\u5bfc\u51faexcel\u5f02\u5e38");
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException var13) {
                logger.error("\u5173\u95ed\u6d41\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Throwable)var13);
            }
        }
        return url;
    }

    public static String getBigFileUrl(String title, String downloadUrl, Workbook workbook, String fileName) {
        String url;
        FileOutputStream fileOutputStream = null;
        FileInputStream fileInputStream = null;
        File file = null;
        try {
            String localAddress = System.getProperty("user.dir") + File.separator + fileName;
            file = new File(localAddress);
            File parentFile = file.getParentFile();
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            fileOutputStream = new FileOutputStream(localAddress);
            workbook.write((OutputStream)fileOutputStream);
            fileInputStream = new FileInputStream(file);
            objectStorageService.put(bucketName, fileName, (InputStream)fileInputStream);
            url = downloadUrl + "/" + fileName;
        }
        catch (IOException var14) {
            logger.error(title + "\u5bfc\u51faexcel\u5f02\u5e38", (Object)var14.getMessage(), (Object)var14);
            throw new BusinessRuntimeException(title + "\u5bfc\u51faexcel\u5f02\u5e38");
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (file != null && file.exists()) {
                    file.delete();
                }
            }
            catch (IOException var13) {
                logger.error("\u5173\u95ed\u6d41\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Throwable)var13);
            }
        }
        return url;
    }

    public static <T> Workbook getExportUrlForLocalTest(List<T> excelRespDtos, List<ExcelExportEntity> excelParams, String title, String excelName, String suffix) {
        if (objectStorageService == null) {
            objectStorageService = (IObjectStorageService)SpringBeanUtil.getBean(IObjectStorageService.class);
        }
        if (bucketName == null) {
            bucketName = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.bucketName");
        }
        String downloadUrl = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.endpoint");
        if (CollectionUtils.isEmpty(excelRespDtos)) {
            excelRespDtos = Lists.newArrayList();
        }
        Object fos = null;
        String fileName = excelName + "." + suffix;
        ExportParams params = new ExportParams(title, "", "xls".equalsIgnoreCase(suffix) ? ExcelType.HSSF : ExcelType.XSSF);
        Workbook workbook = ExcelExportUtil.exportBigExcel((ExportParams)params, excelParams, (Collection)excelRespDtos);
        return workbook;
    }

    public static String exportByMap(String fileName, ExportParams params, List<ExcelExportEntity> entityList, List<Map<String, Object>> list) {
        if (objectStorageService == null) {
            objectStorageService = (IObjectStorageService)SpringBeanUtil.getBean(IObjectStorageService.class);
        }
        if (bucketName == null) {
            bucketName = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.bucketName");
        }
        String downloadUrl = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.endpoint");
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)params, entityList, list);
        return MyEasyPoiExportUtil.getFileUrl(fileName, downloadUrl, workbook, null, fileName);
    }
}

