/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.module.export.biz.constant.ExportTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.impl.BaseExportService;
import com.dtyunxi.tcbj.module.export.biz.impl.ExportService;
import com.dtyunxi.tcbj.module.export.biz.utils.ThreadPoolUtil;
import com.dtyunxi.tcbj.module.export.biz.vo.rebate.GiftBalanceAdvanceExportVo;
import com.dtyunxi.tcbj.module.export.biz.vo.rebate.GiftBalanceExportVo;
import com.dtyunxi.tcbj.module.export.biz.vo.rebate.GiftBalanceStatementExportVo;
import com.dtyunxi.tcbj.module.export.biz.vo.rebate.RebateBalanceExportVo;
import com.dtyunxi.tcbj.module.export.biz.vo.rebate.RebateFlowExportVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.RebateTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.BalanceQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.RebateDetailQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.GivePriceTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.GiveTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.SwitchEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.TradeTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums.AdvanceStatusEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.enums.SendBackEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceAdvanceQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceStatementQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.BalanceListRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.BalanceStatementListRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.query.IGiftBalanceAdvanceQueryApi;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.query.IGiftBalanceQueryApi;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.query.IGiftBalanceStatementQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.rebate.api.dto.response.BalanceExtRespDto;
import com.yx.tcbj.center.rebate.api.dto.response.RebateDetailExtRespDto;
import com.yx.tcbj.center.rebate.api.query.IBalanceQueryV2Api;
import com.yx.tcbj.center.rebate.api.query.IRebateDetailQueryV2Api;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="rebateExportService")
public class RebateExportService {
    @Resource
    private IGiftBalanceQueryApi giftBalanceQueryApi;
    @Resource
    private IGiftBalanceStatementQueryApi giftBalanceStatementQueryApi;
    @Resource
    private IGiftBalanceAdvanceQueryApi giftBalanceAdvanceQueryApi;
    @Resource
    private ExportService exportService;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IContext context;
    @Resource
    private IRebateDetailQueryV2Api iRebateDetailQueryV2Api;
    @Resource
    private IBalanceQueryV2Api balanceQueryV2Api;
    private static final Logger logger = LoggerFactory.getLogger(RebateExportService.class);

    public RestResponse<Object> exportGiftBalance(com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceQueryReqDto reqDto) {
        String fileName = "\u989d\u5ea6\u8d26\u6237_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
        Long userId = this.context.userId();
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(userId));
        Long id = this.exportService.initNew(orgId, fileName, ExportTypeEnum.GIFT_BALANCE);
        Map attachments = ServiceContext.getContext().getAttachments();
        ThreadPoolUtil.executorService.submit(() -> {
            this.context.userId(userId);
            reqDto.setUserId(userId);
            attachments.forEach((k, v) -> ServiceContext.getContext().setAttachment(k, v));
            reqDto.setOrganizationId(orgId);
            try {
                logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\uff1a{},orgId:{},userId:{},reqDto:{}", new Object[]{fileName, orgId, userId, JSONObject.toJSONString((Object)reqDto)});
                PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.giftBalanceQueryApi.queryPage(reqDto));
                if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                    List list = pageInfo.getList();
                    ArrayList rList = Lists.newArrayList();
                    for (BalanceListRespDto balance : list) {
                        GiftBalanceExportVo giftBalanceExportVo = new GiftBalanceExportVo();
                        giftBalanceExportVo.setCustomerCode(balance.getCustomerCode());
                        giftBalanceExportVo.setCustomerName(balance.getCustomerName());
                        giftBalanceExportVo.setBalance(balance.getBalance());
                        giftBalanceExportVo.setFreezeBalance(balance.getFreezeBalance());
                        giftBalanceExportVo.setUsableBalance(balance.getUsableBalance());
                        String giveFlagName = StringUtils.isNotEmpty((CharSequence)balance.getGiveFlag()) ? (balance.getGiveFlag().equals(SwitchEnum.ON.getCode()) ? SwitchEnum.ON.getName() : SwitchEnum.OFF.getName()) : null;
                        giftBalanceExportVo.setGiveFlag(giveFlagName);
                        giftBalanceExportVo.setGiveType(GiveTypeEnum.toName((String)balance.getGiveType()));
                        giftBalanceExportVo.setGivePriceType(GivePriceTypeEnum.toName((String)balance.getGivePriceType()));
                        giftBalanceExportVo.setGiveProportion(balance.getGiveProportion());
                        if (balance.getQuantityScaleAmount() != null && balance.getQuantityScaleSum() != null) {
                            giftBalanceExportVo.setQuantityScale(balance.getQuantityScaleAmount().toString() + ":" + balance.getQuantityScaleSum().toString());
                        }
                        rList.add(giftBalanceExportVo);
                    }
                    String excelName = "cube/" + fileName;
                    try {
                        String exportUrl = EasyPoiExportUtil.getExportUrl((List)rList, GiftBalanceExportVo.class, null, (String)excelName, (String)"xls");
                        this.exportService.success(id, exportUrl);
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("\u5bfc\u51fa\u989d\u5ea6\u8d26\u6237-\u9519\u8bef:{}", (Object)e.toString());
                        this.exportService.fail(id, "\u5bfc\u51fa\u989d\u5ea6\u8d26\u6237-\u9519\u8bef1:" + e);
                        return;
                    }
                }
                this.exportService.fail(id, "\u5bfc\u51fa\u989d\u5ea6\u8d26\u6237,\u6570\u636e\u4e3a\u7a7a");
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(e.getMessage(), (Throwable)e);
                this.exportService.fail(id, "\u5bfc\u51fa\u989d\u5ea6\u8d26\u6237-\u9519\u8bef2:" + e);
                return;
            }
        });
        return new RestResponse("0", "\u5bfc\u51fa\u989d\u5ea6\u8d26\u6237\u6210\u529f");
    }

    public RestResponse<Object> exportGiftBalanceStatement(BalanceStatementQueryReqDto reqDto) {
        reqDto.setOrganizationId((Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryCurrentUserOrgId()));
        String exportTypeName = ExportTypeEnum.GIFT_BALANCE_STATEMENT.getName();
        BaseExportService baseExportService = new BaseExportService(exportTypeName, ExportTypeEnum.GIFT_BALANCE_STATEMENT);
        baseExportService.executor(req -> {
            try {
                ArrayList rList = Lists.newArrayList();
                Long total = null;
                double num = 0.0;
                Integer pageNum = 1;
                Integer pageSize = 5000;
                while (total == null || (double)pageNum.intValue() < num) {
                    reqDto.setPageNum(pageNum.intValue());
                    reqDto.setPageSize(pageSize.intValue());
                    logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u67e5\u8be2{}\u53c2\u6570:{},UUID:{}", new Object[]{exportTypeName, JSONObject.toJSONString((Object)reqDto), baseExportService.getId()});
                    PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.giftBalanceStatementQueryApi.queryPage(reqDto));
                    if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                        logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u67e5\u8be2{}\u7ed3\u679c:{},UUID:{}", new Object[]{exportTypeName, pageInfo.getList().size(), baseExportService.getId()});
                    }
                    if (total == null) {
                        total = pageInfo.getTotal();
                        num = Math.ceil(Double.valueOf(total.longValue()) / (double)pageSize.intValue());
                        logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u521d\u59cb\u5316UUID:{},\u67e5\u8be2{}\u603b\u6570:{},\u4e00\u5171\u9700\u8981\u5206\u6279:{}\u6b21", new Object[]{exportTypeName, baseExportService.getId(), total, num});
                    }
                    pageNum = pageNum + 1;
                    if (!CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) continue;
                    for (BalanceStatementListRespDto balanceStatementListRespDto : pageInfo.getList()) {
                        GiftBalanceStatementExportVo vo = new GiftBalanceStatementExportVo();
                        CubeBeanUtils.copyProperties((Object)vo, (Object)balanceStatementListRespDto, (String[])new String[0]);
                        vo.setTradeTime(DateUtil.getDateFormat((Date)balanceStatementListRespDto.getTradeTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                        vo.setTradeType(TradeTypeEnum.toName((String)vo.getTradeType()));
                        vo.setIncomeExpenditure(Objects.equals(vo.getIncomeExpenditure(), "02") ? "\u652f\u51fa" : "\u6536\u5165");
                        rList.add(vo);
                    }
                    pageInfo.getList().clear();
                }
                logger.info(exportTypeName + "\u5217\u8868\u67e5\u8be2\u6570\u636e\u8f6c\u6362\u7ed3\u679c\u5927\u5c0f:{},UUID:{}", (Object)rList.size(), (Object)baseExportService.getId());
                if (CollectionUtils.isNotEmpty((Collection)rList)) {
                    baseExportService.exportUrl(rList, GiftBalanceStatementExportVo.class);
                } else {
                    this.exportService.fail(baseExportService.getId(), "\u5bfc\u51fa" + exportTypeName + "\u5217\u8868,\u6570\u636e\u4e3a\u7a7a");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u5bfc\u51fa{}\u5217\u8868-\u9519\u8bef:{}", (Object)exportTypeName, (Object)e.toString());
                this.exportService.fail(baseExportService.getId(), "\u5bfc\u51fa" + exportTypeName + "\u5217\u8868\u9519\u8bef\u3010" + e.getMessage() + "\u3011");
            }
            return null;
        }, null);
        return new RestResponse("0", "\u5bfc\u51fa" + exportTypeName + "\u6210\u529f");
    }

    public RestResponse<Object> exportGiftBalanceAdvance(BalanceAdvanceQueryReqDto reqDto) {
        String fileName = "\u9884\u652f\u989d\u5ea6_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
        Long id = this.exportService.init(fileName, ExportTypeEnum.GIFT_BALANCE_ADVANCE);
        Long uesrId = this.context.userId();
        reqDto.setUserId(uesrId);
        String organization = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationid");
        ThreadPoolUtil.executorService.submit(() -> {
            this.context.userId(uesrId);
            if (Objects.nonNull(organization)) {
                ServiceContext.getContext().setAttachment("yes.req.cus.b2b.organizationid", organization.toString());
            }
            logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\uff1a{}", (Object)fileName);
            try {
                PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.giftBalanceAdvanceQueryApi.queryPage(reqDto));
                if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                    List list = pageInfo.getList();
                    ArrayList rList = Lists.newArrayList();
                    CubeBeanUtils.copyCollection((Collection)rList, (Collection)list, GiftBalanceAdvanceExportVo.class);
                    rList.stream().forEach(e -> {
                        e.setSendBack(SendBackEnum.toName((String)e.getSendBack()));
                        e.setStatus(AdvanceStatusEnum.toName((String)e.getStatus()));
                    });
                    String excelName = "cube/" + fileName;
                    try {
                        String exportUrl = EasyPoiExportUtil.getExportUrl((List)rList, GiftBalanceAdvanceExportVo.class, null, (String)excelName, (String)"xls");
                        this.exportService.success(id, exportUrl);
                        return;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                        logger.error("\u5bfc\u51fa\u9884\u652f\u989d\u5ea6-\u9519\u8bef:{}", (Object)e2.toString());
                        this.exportService.fail(id, "\u5bfc\u51fa\u9884\u652f\u989d\u5ea6-\u9519\u8bef1:" + e2);
                        return;
                    }
                }
                this.exportService.fail(id, "\u5bfc\u51fa\u9884\u652f\u989d\u5ea6,\u6570\u636e\u4e3a\u7a7a:");
                return;
            }
            catch (Exception e3) {
                e3.printStackTrace();
                logger.error(e3.getMessage(), (Throwable)e3);
                this.exportService.fail(id, "\u5bfc\u51fa\u9884\u652f\u989d\u5ea6-\u9519\u8bef2:" + e3);
                return;
            }
        });
        return new RestResponse("0", "\u5bfc\u51fa\u9884\u652f\u989d\u5ea6\u6210\u529f");
    }

    public RestResponse<Object> exportRebateDetail(RebateDetailQueryReqDto reqDto) {
        String exportTypeName = ExportTypeEnum.REBATE_FLOW.getName();
        BaseExportService baseExportService = new BaseExportService(exportTypeName, ExportTypeEnum.REBATE_FLOW);
        baseExportService.executor(req -> {
            try {
                ArrayList rList = Lists.newArrayList();
                Long total = null;
                double num = 0.0;
                Integer pageNum = 1;
                Integer pageSize = 5000;
                while (total == null || (double)pageNum.intValue() <= num) {
                    logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u67e5\u8be2{}\u53c2\u6570:{},UUID:{}", new Object[]{exportTypeName, JSONObject.toJSONString((Object)reqDto), baseExportService.getId()});
                    PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iRebateDetailQueryV2Api.queryRebateDetailByPage(reqDto, pageNum, pageSize));
                    if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                        logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u67e5\u8be2{}\u7ed3\u679c:{},UUID:{}", new Object[]{exportTypeName, JSONObject.toJSONString((Object)pageInfo.getList()), baseExportService.getId()});
                    }
                    if (total == null) {
                        total = pageInfo.getTotal();
                        num = Math.ceil(Double.valueOf(total.longValue()) / (double)pageSize.intValue());
                        logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u521d\u59cb\u5316UUID:{},\u67e5\u8be2{}\u603b\u6570:{},\u4e00\u5171\u9700\u8981\u5206\u6279:{}\u6b21", new Object[]{baseExportService.getId(), exportTypeName, total, num});
                    }
                    pageNum = pageNum + 1;
                    if (!CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) continue;
                    for (RebateDetailExtRespDto respDto : pageInfo.getList()) {
                        RebateFlowExportVo vo = new RebateFlowExportVo();
                        vo.setUserName(respDto.getUserName());
                        vo.setChangeAmount(respDto.getChangeAmount());
                        vo.setBalanceSnapshot(respDto.getBalanceSnapshot());
                        vo.setTypeName(RebateTypeEnum.getByCode((Integer)Integer.valueOf(respDto.getType())).getDesc());
                        vo.setCreateTime(respDto.getCreateTime());
                        vo.setBusinessNo(respDto.getBusinessNo());
                        vo.setExpiredTime(respDto.getExpiredTime());
                        vo.setCustomerCode(respDto.getCustomerCode());
                        vo.setRebateAccountNo(respDto.getRebateAccountNo());
                        vo.setRemark(respDto.getRemark());
                        vo.setOrganizationName(respDto.getMerchantName());
                        rList.add(vo);
                    }
                    pageInfo.getList().clear();
                }
                logger.info(exportTypeName + "\u5217\u8868\u67e5\u8be2\u6570\u636e\u8f6c\u6362\u7ed3\u679c\u5927\u5c0f:{},UUID:{}", (Object)rList.size(), (Object)baseExportService.getId());
                if (CollectionUtils.isNotEmpty((Collection)rList)) {
                    baseExportService.exportUrl(rList, RebateFlowExportVo.class);
                } else {
                    this.exportService.fail(baseExportService.getId(), "\u5bfc\u51fa" + ExportTypeEnum.REBATE_FLOW.getName() + "\u5217\u8868,\u6570\u636e\u4e3a\u7a7a");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.info("\u5bfc\u51fa{}\u5217\u8868-\u9519\u8bef:{}", (Object)exportTypeName, (Object)e.getMessage());
                this.exportService.fail(baseExportService.getId(), "\u5bfc\u51fa" + exportTypeName + "\u5217\u8868\u9519\u8bef\u3010" + e.getMessage() + "\u3011");
            }
            return null;
        }, null);
        return new RestResponse("0", exportTypeName + "\u6210\u529f");
    }

    public Object exportBalance(BalanceQueryReqDto reqDto) {
        String exportTypeName = ExportTypeEnum.REBATE_BALANCE.getName();
        BaseExportService baseExportService = new BaseExportService(exportTypeName, ExportTypeEnum.REBATE_BALANCE);
        baseExportService.executor(req -> {
            try {
                ArrayList rList = Lists.newArrayList();
                Long total = null;
                double num = 0.0;
                Integer pageNum = 1;
                Integer pageSize = 5000;
                while (total == null || (double)pageNum.intValue() <= num) {
                    logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u67e5\u8be2{}\u53c2\u6570:{},UUID:{}", new Object[]{exportTypeName, JSONObject.toJSONString((Object)reqDto), baseExportService.getId()});
                    PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.balanceQueryV2Api.queryBalanceByPage(reqDto, pageNum, pageSize));
                    if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                        logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u67e5\u8be2{}\u7ed3\u679c:{},UUID:{}", new Object[]{exportTypeName, JSONObject.toJSONString((Object)pageInfo.getList()), baseExportService.getId()});
                    }
                    if (total == null) {
                        total = pageInfo.getTotal();
                        num = Math.ceil(Double.valueOf(total.longValue()) / (double)pageSize.intValue());
                        logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u521d\u59cb\u5316UUID:{},\u67e5\u8be2{}\u603b\u6570:{},\u4e00\u5171\u9700\u8981\u5206\u6279:{}\u6b21", new Object[]{baseExportService.getId(), exportTypeName, total, num});
                    }
                    pageNum = pageNum + 1;
                    if (!CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) continue;
                    for (BalanceExtRespDto balanceExtRespDto : pageInfo.getList()) {
                        RebateBalanceExportVo vo = new RebateBalanceExportVo();
                        vo.setBalance(balanceExtRespDto.getBalance());
                        vo.setUserName(balanceExtRespDto.getUserName());
                        vo.setCustomerCode(balanceExtRespDto.getCustomerCode());
                        rList.add(vo);
                    }
                    pageInfo.getList().clear();
                }
                logger.info(exportTypeName + "\u5217\u8868\u67e5\u8be2\u6570\u636e\u8f6c\u6362\u7ed3\u679c\u5927\u5c0f:{},UUID:{}", (Object)rList.size(), (Object)baseExportService.getId());
                if (CollectionUtils.isNotEmpty((Collection)rList)) {
                    baseExportService.exportUrl(rList, RebateBalanceExportVo.class);
                } else {
                    this.exportService.fail(baseExportService.getId(), "\u5bfc\u51fa" + ExportTypeEnum.REBATE_BALANCE.getName() + "\u5217\u8868,\u6570\u636e\u4e3a\u7a7a");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.info("\u5bfc\u51fa{}\u5217\u8868-\u9519\u8bef:{}", (Object)exportTypeName, (Object)e.getMessage());
                this.exportService.fail(baseExportService.getId(), "\u5bfc\u51fa" + exportTypeName + "\u5217\u8868\u9519\u8bef\u3010" + e.getMessage() + "\u3011");
            }
            return null;
        }, null);
        return new RestResponse("0", exportTypeName + "\u6210\u529f");
    }
}

