/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl.operation;

import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.constant.enums.YesOrNoEnum;
import com.dtyunxi.tcbj.module.export.biz.abs.ReportExportAbstract;
import com.dtyunxi.tcbj.module.export.biz.constant.ExportTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.dto.request.CreditRepayPlanExportReqDto;
import com.dtyunxi.tcbj.module.export.biz.impl.operation.CurrentCommonService;
import com.dtyunxi.tcbj.module.export.biz.vo.operation.CreditRepayPlanExportVo;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditRepayPlanSearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.PageDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditRepayPlanRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditRepayPlanStatusEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditTermTypeEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.query.ICreditRepayPlanQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CreditRepayPlanExportService
extends ReportExportAbstract<CreditRepayPlanRespDto, CreditRepayPlanExportReqDto, CreditRepayPlanExportVo> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ICreditRepayPlanQueryApi creditRepayPlanQueryApi;
    @Resource
    private CurrentCommonService currentCommonService;

    @Override
    public ExportTypeEnum getExportType() {
        return ExportTypeEnum.CREDIT_REPAY_PLAN;
    }

    @Override
    public PageInfo<CreditRepayPlanRespDto> queryData(CreditRepayPlanExportReqDto repayPlanExportReqDto) {
        CreditRepayPlanSearchReqDto creditEntitySearchReqDto = new CreditRepayPlanSearchReqDto();
        creditEntitySearchReqDto.setPageNum(Integer.valueOf(repayPlanExportReqDto.getPageNum()));
        creditEntitySearchReqDto.setPageSize(Integer.valueOf(repayPlanExportReqDto.getPageSize()));
        creditEntitySearchReqDto.setCustomerCode(repayPlanExportReqDto.getCustomerCode());
        creditEntitySearchReqDto.setCustomerName(repayPlanExportReqDto.getCustomerName());
        creditEntitySearchReqDto.setFormCode(repayPlanExportReqDto.getFormCode());
        creditEntitySearchReqDto.setCreditAccountCode(repayPlanExportReqDto.getCreditAccountCode());
        creditEntitySearchReqDto.setBeginTimeStart(repayPlanExportReqDto.getBeginTimeStart());
        creditEntitySearchReqDto.setBeginTimeEnd(repayPlanExportReqDto.getBeginTimeEnd());
        creditEntitySearchReqDto.setOverdueTimeStart(repayPlanExportReqDto.getOverdueTimeStart());
        creditEntitySearchReqDto.setOverdueTimeEnd(repayPlanExportReqDto.getOverdueTimeEnd());
        creditEntitySearchReqDto.setDue1(repayPlanExportReqDto.getDue1());
        creditEntitySearchReqDto.setDue2(repayPlanExportReqDto.getDue2());
        creditEntitySearchReqDto.setDue2(repayPlanExportReqDto.getDue2());
        creditEntitySearchReqDto.setOrgId(repayPlanExportReqDto.getOrgId());
        return (PageInfo)RestResponseHelper.extractData((RestResponse)this.creditRepayPlanQueryApi.queryPage((PageDto)creditEntitySearchReqDto));
    }

    @Override
    public CreditRepayPlanExportReqDto definePrams(CreditRepayPlanExportReqDto repayPlanExportReqDto) {
        List<Long> currentOrgId = this.currentCommonService.getCurrentOrgId();
        this.logger.info("[\u6388\u4fe1\u8d26\u5355\u5bfc\u51fa]\uff0c\u7ec4\u7ec7id\uff1a{}", currentOrgId);
        if (CollectionUtils.isNotEmpty(currentOrgId)) {
            repayPlanExportReqDto.setOrgId(currentOrgId.get(0));
        }
        return repayPlanExportReqDto;
    }

    @Override
    public Gson buildGson() {
        return new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").create();
    }

    @Override
    public List<CreditRepayPlanExportVo> getExportDtoList(List<CreditRepayPlanRespDto> exportDtoList, Class<CreditRepayPlanExportVo> vo) {
        ArrayList repayPlanExportVos = Lists.newArrayList();
        if (CollectionUtils.isEmpty(exportDtoList)) {
            return repayPlanExportVos;
        }
        for (CreditRepayPlanRespDto creditRepayPlanRespDto : exportDtoList) {
            CreditRepayPlanExportVo creditRepayPlanExportVo = new CreditRepayPlanExportVo();
            creditRepayPlanExportVo.setRepayPlanNo(creditRepayPlanRespDto.getRepayPlanNo());
            creditRepayPlanExportVo.setFormCode(creditRepayPlanRespDto.getFormCode());
            creditRepayPlanExportVo.setCustomerName(creditRepayPlanRespDto.getCustomerName());
            creditRepayPlanExportVo.setCreditAccountCode(creditRepayPlanRespDto.getCreditAccountCode());
            creditRepayPlanExportVo.setBeginDateTypeName(creditRepayPlanRespDto.getBeginDateTypeName());
            creditRepayPlanExportVo.setStartDate(creditRepayPlanRespDto.getStartDate());
            String creditTermTypeName = Optional.ofNullable(CreditTermTypeEnum.getType((Integer)creditRepayPlanRespDto.getCreditTermType())).map(CreditTermTypeEnum::getDesc).orElse("");
            creditRepayPlanExportVo.setCreditTermTypeName(creditTermTypeName);
            creditRepayPlanExportVo.setCycleTotalNum(creditRepayPlanRespDto.getCycleTotalNum());
            creditRepayPlanExportVo.setCycleNum(creditRepayPlanRespDto.getCycleNum());
            creditRepayPlanExportVo.setPaidAmount(creditRepayPlanRespDto.getPaidAmount());
            creditRepayPlanExportVo.setRefundAmount(creditRepayPlanRespDto.getRefundAmount());
            creditRepayPlanExportVo.setReceivableAmount(creditRepayPlanRespDto.getReceivableAmount());
            creditRepayPlanExportVo.setReceivedAmount(creditRepayPlanRespDto.getReceivedAmount());
            String creditRepayPlanStatusName = Optional.ofNullable(CreditRepayPlanStatusEnum.toName((Integer)creditRepayPlanRespDto.getCreditRepayPlanStatus())).orElse("");
            creditRepayPlanExportVo.setCreditRepayPlanStatusName(creditRepayPlanStatusName);
            creditRepayPlanExportVo.setEndDate(creditRepayPlanRespDto.getEndDate());
            creditRepayPlanExportVo.setIsOverdueName(YesOrNoEnum.YES.getCode().equals(creditRepayPlanRespDto.getIsOverdue()) ? YesOrNoEnum.NO.getValue() : YesOrNoEnum.YES.getValue());
            creditRepayPlanExportVo.setOverdueTime(creditRepayPlanRespDto.getOverdueTime());
            repayPlanExportVos.add(creditRepayPlanExportVo);
        }
        return repayPlanExportVos;
    }
}

