/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.company.CompanyVerifyRespDto;
import com.dtyunxi.tcbj.module.export.biz.constant.ImportLogStatusEnum;
import com.dtyunxi.tcbj.module.export.biz.constant.ImportLogTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.dto.request.ImportReqDto;
import com.dtyunxi.tcbj.module.export.biz.dto.response.CustomerInfoUpdateImportDto;
import com.dtyunxi.tcbj.module.export.biz.dto.response.CustomerItemAuthImportDto;
import com.dtyunxi.tcbj.module.export.biz.impl.CustomerAddImportService;
import com.dtyunxi.tcbj.module.export.biz.impl.ImportLogService;
import com.dtyunxi.tcbj.module.export.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.tcbj.module.export.dao.eo.ImportLogEo;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.constant.SubjectTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerExtApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.CompanyInfoDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerStatusReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerExtDetailRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerTypeRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerStatusQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.entity.NacosPropertiesOrgEntity;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerAreaListExtReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.ICustomerQueryV3Api;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmployeeRegionQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.IAuthItemRuleApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.AuthItemRuleReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.CustomerAuthItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.AuthItemRuleRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.CustomerAuthItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BrandRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailBaseInfoRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopExtQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.api.util.BeanPropertyNullUtil;
import com.dtyunxi.yundt.module.bitem.biz.service.IAuthItemRuleService;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.ICustomerExtService;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.demo.center.data.query.IAreaExtQueryApi;
import com.yx.tcbj.center.api.ItemBrandAuthApi;
import com.yx.tcbj.center.api.dto.request.ItemShopQueryReqDto;
import com.yx.tcbj.center.api.query.IItemAuthExpandQueryApi;
import com.yx.tcbj.center.api.query.IItemCenterQueryApi;
import com.yx.tcbj.center.customer.api.ICustomerExtThreeApi;
import com.yx.tcbj.center.customer.api.dto.request.ComputeCustomerNameRateReqDto;
import com.yx.tcbj.center.customer.api.dto.request.CustomerBatchUpReqDto;
import com.yx.tcbj.center.customer.api.dto.request.CustomerExtReqDto;
import com.yx.tcbj.center.customer.api.dto.response.store.StoreRespDto;
import com.yx.tcbj.center.customer.api.query.ICustomerExtThreeQueryApi;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import com.yx.tcbj.center.customer.api.query.IStoreQueryApi;
import com.yx.tcbj.center.price.api.IPrBaseDiscountApi;
import com.yx.tcbj.center.price.api.dto.request.PrBaseDiscountAddEditReqDto;
import com.yx.tcbj.center.price.api.dto.request.PrBaseDiscountBrandReqDto;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.similarity.JaroWinklerSimilarity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CustomerInfoUpdateImportService {
    public final Logger logger = LoggerFactory.getLogger(CustomerInfoUpdateImportService.class);
    @Resource
    private IContext context;
    @Resource
    private ImportLogService importLogService;
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Resource
    private IEmployeeRegionQueryApi employeeRegionQueryApi;
    @Resource
    private ICustomerQueryV3Api customerQueryV3Api;
    @Resource
    private ICustomerExtApi customerExtApi;
    @Resource
    private ICustomerExtService customerExtService;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private HttpServletRequest request;
    @Resource
    private NacosPropertiesOrgEntity nacosPropertiesOrgEntity;
    @Resource
    private CustomerAddImportService customerAddImportService;
    @Resource
    private IAreaExtQueryApi areaExtQueryApi;
    @Resource
    private ICustomerExtThreeQueryApi customerExtThreeQueryApi;
    @Resource
    private IShopExtQueryApi shopExtQueryApi;
    @Resource
    private IItemCenterQueryApi itemCenterQueryApi;
    @Resource
    private IAuthItemRuleApi authItemRuleApi;
    @Resource
    private IAuthItemRuleService authItemRuleService;
    @Resource
    private ItemBrandAuthApi itemBrandAuthApi;
    @Resource
    private IPrBaseDiscountApi prBaseDiscountApi;
    @Resource
    private IStoreQueryApi storeQueryApi;
    @Resource
    private ICustomerStatusQueryApi customerStatusQueryApi;
    @Resource
    private IItemAuthExpandQueryApi itemAuthExpandQueryApi;
    @Resource
    private ICustomerExtThreeApi customerExtThreeApi;
    @Resource
    private IOrganizationQueryExtApi iOrganizationQueryExtApi;
    @Resource
    private IOrganizationQueryApi iOrganizationQueryApi;
    private static final double NAME_MATCHING_RATE_THRESHOLD = 0.6;

    Long getTenantId() {
        Long tenantId = ServiceContext.getContext().getRequestTenantId();
        if (Objects.isNull(tenantId)) {
            tenantId = 1L;
        }
        return tenantId;
    }

    Long getInstanceId() {
        Long instanceId = ServiceContext.getContext().getRequestInstanceId();
        if (Objects.isNull(instanceId)) {
            instanceId = 1254039287584232622L;
        }
        return instanceId;
    }

    public String getHeaderOrgId() {
        String organizationId = this.request.getHeader("yes-req-cus-b2b-organizationId");
        this.logger.info("\u83b7\u53d6\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        return organizationId;
    }

    public void customerInfoUpdateImport(ImportReqDto importReqDto) {
        this.logger.info("\u5ba2\u5546\u7ba1\u7406\u5bfc\u5165\u5ba2\u6237\u4fee\u6539:{}", (Object)JSON.toJSONString((Object)importReqDto));
        String fileUrl = importReqDto.getFileUrl();
        AssertUtil.assertNotBlank((String)fileUrl, (String)"\u5bfc\u5165\u7684\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        AssertUtil.assertNotBlank((String)fileUrl, (String)"\u5bfc\u5165\u7684\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        String b2bOrgIdStr = this.getHeaderOrgId();
        if (StringUtils.isEmpty((CharSequence)b2bOrgIdStr)) {
            b2bOrgIdStr = this.nacosPropertiesOrgEntity.orgId();
            this.logger.info("nacos\u914d\u7f6e\u7684\u7ec4\u7ec7ID\uff1a{}", (Object)b2bOrgIdStr);
        }
        AssertUtil.assertNotBlank((String)b2bOrgIdStr, (String)"\u8bf7\u6c42\u5934[yes-req-cus-b2b-organizationId]\u503c\u4e3a\u7a7a");
        Long b2bOrgId = Long.valueOf(b2bOrgIdStr);
        List importDtos = Lists.newArrayList();
        try {
            InputStream is = this.getInputStream(fileUrl);
            ExcelImportResult objectExcelImportResult = EasyPoiExportUtil.importExcel(is, 0, 1, CustomerInfoUpdateImportDto.class);
            importDtos = objectExcelImportResult.getList();
            importDtos = BeanPropertyNullUtil.getAllFieldNullList((List)importDtos);
        }
        catch (Exception e) {
            throw new BizException("\u5bfc\u5165\u5ba2\u6237\u4fee\u6539\u89e3\u6790\u5931\u8d25\uff1a" + e.getMessage());
        }
        Long requestTenantId = this.getTenantId();
        Long requestInstanceId = this.getInstanceId();
        this.logger.info("\u5bfc\u5165\u7684\u6570\u636e==>{}", (Object)JSONObject.toJSONString((Object)importDtos));
        ImportLogEo initLog = ImportLogEo.newInstance();
        initLog.setImportFileUrl(importReqDto.getFileUrl());
        String fileName = importReqDto.getFileName();
        if (StringUtils.isEmpty((CharSequence)importReqDto.getFileName())) {
            fileName = StringUtils.substringAfter((String)importReqDto.getFileUrl(), (String)"cube//");
        }
        initLog.setFileName(fileName);
        initLog.setImportType(ImportLogTypeEnum.CUSTOMER.getCode());
        initLog.setTotalNum(Integer.valueOf(importDtos.size()));
        initLog.setOrganizationId(b2bOrgId);
        initLog.setInstanceId(requestInstanceId);
        initLog.setTenantId(requestTenantId);
        Long importLogId = this.importLogService.init(initLog);
        List finalImportDtos = importDtos;
        CompletableFuture.runAsync(() -> {
            try {
                this.logger.info("\u5f02\u6b65\u5bfc\u5165\u5ba2\u6237\u4fee\u6539\u5f00\u59cb,\u65e5\u5fd7id[{}],\u65f6\u95f4[{}]", (Object)importLogId, (Object)System.currentTimeMillis());
                this.doImportSyn(requestTenantId, requestInstanceId, finalImportDtos, importLogId, null, b2bOrgId);
                this.logger.info("\u5f02\u6b65\u5bfc\u5165\u5ba2\u6237\u4fee\u6539\u7ed3\u675f,\u65e5\u5fd7id[{}],\u65f6\u95f4[{}]", (Object)importLogId, (Object)System.currentTimeMillis());
            }
            catch (Exception e) {
                this.importLogService.fail(importLogId, e.getMessage(), "", finalImportDtos.size());
                e.printStackTrace();
                this.logger.info("\u5f02\u6b65\u5bfc\u5165\u5ba2\u6237\u4fee\u6539\u65e5\u5fd7id[{}],\u5f02\u5e38\u4fe1\u606f{}", (Object)importLogId, (Object)e.getMessage());
            }
        });
    }

    private InputStream getInputStream(String fileUrl) throws IOException {
        URL url = new URL(fileUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        return conn.getInputStream();
    }

    private void doImportSyn(Long requestTenantId, Long requestInstanceId, List<CustomerInfoUpdateImportDto> importDtos, Long importLogId, Long sellerId, Long orgId) {
        Object customerTypeDtos;
        List customerTypeList;
        this.checkData(importDtos, sellerId, orgId, requestTenantId, requestInstanceId);
        List successList = importDtos.stream().filter(dto -> StringUtils.isEmpty((CharSequence)dto.getErrorReason())).collect(Collectors.toList());
        this.logger.info("\u7b5b\u9009\u6210\u529f\u7684\u6570\u636e:{}", (Object)successList.size());
        Map<String, Object> customerTypeInfoMap = new HashMap<String, CustomerTypeRespDto>();
        if (CollectionUtils.isNotEmpty(successList) && CollectionUtils.isNotEmpty(customerTypeList = successList.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getCustomerTypeName())).map(CustomerInfoUpdateImportDto::getCustomerTypeName).collect(Collectors.toList())) && CollectionUtils.isNotEmpty((Collection)(customerTypeDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryV3Api.getCustomerTypeByNames(customerTypeList))))) {
            customerTypeInfoMap = customerTypeDtos.stream().collect(Collectors.toMap(CustomerTypeRespDto::getName, Function.identity(), (k1, k2) -> k1));
        }
        String failReason = "";
        for (CustomerInfoUpdateImportDto importDto : importDtos) {
            if (StringUtils.isNotEmpty((CharSequence)importDto.getErrorReason())) continue;
            try {
                this.updateCustomer(importDto, orgId, requestTenantId, requestInstanceId, customerTypeInfoMap);
            }
            catch (Error | Exception e) {
                e.printStackTrace();
                this.logger.info("\u5ba2\u6237\u4fee\u6539\u5931\u8d25:{}", (Object)e.getMessage());
                importDto.setErrorReason(e.getMessage());
            }
        }
        List errorList = importDtos.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getErrorReason())).collect(Collectors.toList());
        int errorSize = errorList.size();
        int totalSize = importDtos.size();
        this.logger.info("\u66f4\u65b0\u5bfc\u5165\u5ba2\u6237\u4fee\u6539\u5931\u8d25\u6570:{},\u603b\u6570:{}", (Object)errorSize, (Object)totalSize);
        if (errorSize == 0) {
            this.importLogService.success(importLogId, ImportLogStatusEnum.SUCCEED, totalSize, "", "", 0);
        } else {
            String title = "\u5bfc\u5165\u5ba2\u6237\u4fee\u6539\u8fd4\u56de\u7ed3\u679c";
            String fileName = title + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmssSSS");
            String exportUrl = "";
            try {
                Thread.sleep(2000L);
                exportUrl = EasyPoiExportUtil.getExportUrl(importDtos, CustomerInfoUpdateImportDto.class, null, fileName, "xls");
            }
            catch (Exception e) {
                e.printStackTrace();
                failReason = failReason + "\u5bfc\u51fa\u5f02\u5e38\uff1a" + e.getMessage();
                this.logger.info(failReason);
            }
            if (errorSize < totalSize) {
                this.importLogService.success(importLogId, ImportLogStatusEnum.PART_SUCCESS, totalSize - errorSize, failReason, exportUrl, errorSize);
            } else {
                this.importLogService.fail(importLogId, failReason, exportUrl, errorSize);
            }
        }
    }

    private void checkData(List<CustomerInfoUpdateImportDto> importDtos, Long sellerId, Long orgId, Long requestTenantId, Long requestInstanceId) {
        List allCustomerStatuses = null;
        try {
            CustomerStatusReqDto statusQuery = new CustomerStatusReqDto();
            statusQuery.setRecordStatus(Integer.valueOf(1));
            allCustomerStatuses = (List)RestResponseHelper.extractData((RestResponse)this.customerStatusQueryApi.queryByList(JSON.toJSONString((Object)statusQuery)));
            this.logger.info("\u83b7\u53d6\u5230\u6709\u6548\u7684\u5ba2\u6237\u72b6\u6001\u5217\u8868, \u6570\u91cf: {}", (Object)(CollectionUtils.isNotEmpty((Collection)allCustomerStatuses) ? allCustomerStatuses.size() : 0));
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u5ba2\u6237\u72b6\u6001\u5217\u8868\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
        }
        HashMap<String, List<Object>> organizationAreaMap = new HashMap<String, List<Object>>();
        try {
            CustomerAreaListExtReqDto customerAreaQuery = new CustomerAreaListExtReqDto();
            customerAreaQuery.setOrgInfoId(orgId);
            List allAreas = (List)RestResponseHelper.extractData((RestResponse)this.employeeRegionQueryApi.queryCustomerAreaByNames(customerAreaQuery));
            if (CollectionUtils.isNotEmpty((Collection)allAreas)) {
                organizationAreaMap.put("all", allAreas);
                Map<Integer, List<CustomerAreaRespDto>> levelAreaMap = allAreas.stream().collect(Collectors.groupingBy(CustomerAreaRespDto::getLevel));
                if (levelAreaMap.containsKey(1)) {
                    organizationAreaMap.put("level1", levelAreaMap.get(1));
                }
                if (levelAreaMap.containsKey(2)) {
                    organizationAreaMap.put("level2", levelAreaMap.get(2));
                }
                this.logger.info("\u83b7\u53d6\u5230\u7ec4\u7ec7\u533a\u57df\u4fe1\u606f\uff0c\u4e00\u7ea7\u533a\u57df\u6570\u91cf\uff1a{}\uff0c\u4e8c\u7ea7\u533a\u57df\u6570\u91cf\uff1a{}", (Object)levelAreaMap.getOrDefault(1, Collections.emptyList()).size(), (Object)levelAreaMap.getOrDefault(2, Collections.emptyList()).size());
            } else {
                this.logger.warn("\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7[{}]\u4e0b\u7684\u533a\u57df\u4fe1\u606f", (Object)orgId);
            }
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u7ec4\u7ec7\u533a\u57df\u4fe1\u606f\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
        }
        for (CustomerInfoUpdateImportDto importDto : importDtos) {
            String[] areaNameArr;
            List uniqueAreaNames;
            StringBuffer errorMsg = new StringBuffer();
            this.preProcessImportData(importDto);
            if (StringUtils.isEmpty((CharSequence)importDto.getCode())) {
                errorMsg.append("\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a;");
            } else {
                CustomerExtReqDto reqDto = new CustomerExtReqDto();
                reqDto.setCodes((List)Lists.newArrayList((Object[])new String[]{importDto.getCode()}));
                List customerRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerInfoByOrg(reqDto));
                if (CollectionUtils.isEmpty((Collection)customerRespDtoList)) {
                    errorMsg.append("\u5ba2\u6237\u7f16\u7801\u4e0d\u5b58\u5728;");
                } else {
                    CustomerRespDto existingCustomer = (CustomerRespDto)customerRespDtoList.get(0);
                    boolean hasRegionUpdate = StringUtils.isNotEmpty((CharSequence)importDto.getRegionName());
                    boolean hasSalesAreaUpdate = StringUtils.isNotEmpty((CharSequence)importDto.getSalesArea());
                    boolean hasLargeAreaUpdate = StringUtils.isNotEmpty((CharSequence)importDto.getLargeArea());
                    if ((hasSalesAreaUpdate || hasLargeAreaUpdate) && !hasRegionUpdate) {
                        errorMsg.append("\u9500\u552e\u533a\u548c\u5927\u533a\u53ea\u80fd\u4e0e\u533a\u57df\u4e00\u8d77\u4fee\u6539\uff0c\u4e0d\u80fd\u5355\u72ec\u5bfc\u5165;");
                    }
                    if (hasRegionUpdate) {
                        String[] areaNameArr2 = importDto.getRegionName().split(";");
                        List<String> areaNameList = Arrays.stream(areaNameArr2).distinct().collect(Collectors.toList());
                        importDto.setRegionNameList(areaNameList);
                        List allAreas = organizationAreaMap.getOrDefault("all", Collections.emptyList());
                        if (CollectionUtils.isEmpty(allAreas)) {
                            errorMsg.append("\u672a\u627e\u5230\u7ec4\u7ec7\u533a\u57df\u4fe1\u606f\uff0c\u65e0\u6cd5\u9a8c\u8bc1\u533a\u57df;");
                        } else {
                            Set existingAreaNames = allAreas.stream().map(CustomerAreaRespDto::getName).collect(Collectors.toSet());
                            List invalidAreas = areaNameList.stream().filter(areaName -> !existingAreaNames.contains(areaName)).collect(Collectors.toList());
                            if (CollectionUtils.isNotEmpty(invalidAreas)) {
                                errorMsg.append("\u4ee5\u4e0b\u533a\u57df\u540d\u79f0\u4e0d\u5b58\u5728\uff1a").append(String.join((CharSequence)"\u3001", invalidAreas)).append(";");
                            } else {
                                Map<String, String> areaNameToCodeMap = allAreas.stream().collect(Collectors.toMap(CustomerAreaRespDto::getName, CustomerAreaRespDto::getCode, (k1, k2) -> k1));
                                List<String> areaCodeList = areaNameList.stream().map(areaNameToCodeMap::get).collect(Collectors.toList());
                                importDto.setRegionCodeList(areaCodeList);
                                Map<String, Integer> areaLevelMap = allAreas.stream().collect(Collectors.toMap(CustomerAreaRespDto::getName, CustomerAreaRespDto::getLevel, (k1, k2) -> k1));
                                if (!hasSalesAreaUpdate || !hasLargeAreaUpdate) {
                                    try {
                                        List selectedAreas = allAreas.stream().filter(area -> areaNameList.contains(area.getName())).collect(Collectors.toList());
                                        Map<Integer, List<CustomerAreaRespDto>> levelToAreasMap = selectedAreas.stream().collect(Collectors.groupingBy(CustomerAreaRespDto::getLevel));
                                        if (levelToAreasMap.containsKey(2)) {
                                            List parentAreas;
                                            Set parentCodes = levelToAreasMap.get(2).stream().map(CustomerAreaRespDto::getParentCode).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
                                            if (!parentCodes.isEmpty() && CollectionUtils.isNotEmpty((Collection)(parentAreas = (List)RestResponseHelper.extractData((RestResponse)this.employeeRegionQueryApi.queryCustomerAreaByCodes(new ArrayList(parentCodes)))))) {
                                                parentAreas.sort(Comparator.comparing(CustomerAreaRespDto::getLevel));
                                                if (!hasSalesAreaUpdate && !parentAreas.isEmpty()) {
                                                    importDto.setSalesArea(((CustomerAreaRespDto)parentAreas.get(0)).getName());
                                                    this.logger.info("\u6839\u636e\u4e8c\u7ea7\u533a\u57df\u81ea\u52a8\u8bbe\u7f6e\u9500\u552e\u533a: {}", (Object)((CustomerAreaRespDto)parentAreas.get(0)).getName());
                                                }
                                                if (!hasLargeAreaUpdate && parentAreas.size() > 1) {
                                                    importDto.setLargeArea(((CustomerAreaRespDto)parentAreas.get(1)).getName());
                                                    this.logger.info("\u6839\u636e\u4e8c\u7ea7\u533a\u57df\u81ea\u52a8\u8bbe\u7f6e\u5927\u533a: {}", (Object)((CustomerAreaRespDto)parentAreas.get(1)).getName());
                                                }
                                            }
                                        } else if (levelToAreasMap.containsKey(1)) {
                                            List<CustomerAreaRespDto> level1Areas = levelToAreasMap.get(1);
                                            if (!hasSalesAreaUpdate && !level1Areas.isEmpty()) {
                                                importDto.setSalesArea(level1Areas.get(0).getName());
                                                this.logger.info("\u6839\u636e\u4e00\u7ea7\u533a\u57df\u81ea\u52a8\u8bbe\u7f6e\u9500\u552e\u533a: {}", (Object)level1Areas.get(0).getName());
                                            }
                                            if (!hasLargeAreaUpdate && level1Areas.size() > 1) {
                                                importDto.setLargeArea(level1Areas.get(1).getName());
                                                this.logger.info("\u6839\u636e\u4e00\u7ea7\u533a\u57df\u81ea\u52a8\u8bbe\u7f6e\u5927\u533a: {}", (Object)level1Areas.get(1).getName());
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        this.logger.warn("\u81ea\u52a8\u8bbe\u7f6e\u9500\u552e\u533a\u548c\u5927\u533a\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
                                    }
                                }
                                long level1Count = areaNameList.stream().filter(name -> areaLevelMap.getOrDefault(name, 0) == 1).count();
                                long level2Count = areaNameList.stream().filter(name -> areaLevelMap.getOrDefault(name, 0) == 2).count();
                                this.logger.info("\u5ba2\u6237[{}]\u533a\u57df\u9a8c\u8bc1\u901a\u8fc7\uff0c\u4e00\u7ea7\u533a\u57df\u6570\u91cf\uff1a{}\uff0c\u4e8c\u7ea7\u533a\u57df\u6570\u91cf\uff1a{}", new Object[]{importDto.getCode(), level1Count, level2Count});
                            }
                        }
                    }
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getStandardDiscountRate())) {
                try {
                    BigDecimal standardDiscount = this.convertToDiscount(importDto.getStandardDiscountRate());
                    if (standardDiscount == null) {
                        errorMsg.append("\u6807\u51c6\u6263\u7387\u683c\u5f0f\u9519\u8bef;");
                    } else {
                        importDto.setStandardDiscountValue(standardDiscount);
                    }
                }
                catch (NumberFormatException e) {
                    errorMsg.append("\u6807\u51c6\u6263\u7387\u683c\u5f0f\u9519\u8bef;");
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getRegionName()) && (uniqueAreaNames = Arrays.stream(areaNameArr = importDto.getRegionName().split(";")).distinct().collect(Collectors.toList())).size() < areaNameArr.length) {
                this.logger.warn("\u5ba2\u6237\u533a\u57df\u5b58\u5728\u91cd\u590d\u8bb0\u5f55: {}", (Object)importDto.getRegionName());
                errorMsg.append("\u5ba2\u6237\u533a\u57df\u5b58\u5728\u91cd\u590d\u503c\uff0c\u5df2\u81ea\u52a8\u5904\u7406;");
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getMultiBrandDiscount())) {
                String[] brandDiscounts;
                for (String brandDiscount : brandDiscounts = importDto.getMultiBrandDiscount().replace("\uff0c", ",").split(",")) {
                    if (!brandDiscount.contains(":")) {
                        errorMsg.append("\u591a\u54c1\u724c\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u4e3a\u3010\u201c\u54c1\u724c\u540d\u79f0:\u6263\u7387,\u201d\uff0c\u5982\u5065\u529b\u591a:60,\u5065\u5b89\u9002:60\u3011");
                        break;
                    }
                    String[] parts = brandDiscount.split(":");
                    if (parts.length != 2) {
                        errorMsg.append("\u591a\u54c1\u724c\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u4e3a\u3010\u201c\u54c1\u724c\u540d\u79f0:\u6263\u7387,\u201d\uff0c\u5982\u5065\u529b\u591a:60,\u5065\u5b89\u9002:60\u3011");
                        break;
                    }
                    try {
                        BigDecimal discountRate = this.convertToDiscount(parts[1].trim());
                        if (discountRate != null) continue;
                        errorMsg.append("\u591a\u54c1\u724c\u6263\u7387\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u4e3a\u3010\u201c\u54c1\u724c\u540d\u79f0:\u6263\u7387,\u201d\uff0c\u5982\u5065\u529b\u591a:60,\u5065\u5b89\u9002:60\u3011");
                    }
                    catch (NumberFormatException e) {
                        errorMsg.append("\u591a\u54c1\u724c\u6263\u7387\u5fc5\u987b\u4e3a\u6570\u5b57;");
                    }
                    break;
                }
            }
            if (Objects.nonNull(importDto.getCustomerEffectiveTime()) && Objects.nonNull(importDto.getCustomerExpirationTime()) && importDto.getCustomerExpirationTime().before(importDto.getCustomerEffectiveTime())) {
                errorMsg.append("\u5ba2\u6237\u5931\u6548\u65f6\u95f4\u5fc5\u987b\u665a\u4e8e\u5ba2\u6237\u751f\u6548\u65f6\u95f4;");
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getDeliveryMethod())) {
                Integer deliverMethod = this.getDeliverMethodByName(importDto.getDeliveryMethod());
                if (deliverMethod == null) {
                    errorMsg.append("\u53d1\u8d27\u65b9\u5f0f\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u4e3a\u5546\u5bb6\u53d1\u8d27\u6216\u5382\u5bb6\u53d1\u8d27;");
                } else {
                    importDto.setDeliverMethod(deliverMethod);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getMinOrderQuantity())) {
                int minOrderQuantity = StringUtils.equals((CharSequence)importDto.getMinOrderQuantity(), (CharSequence)"\u662f") ? 1 : 0;
                importDto.setMinOrderQuantityValue(minOrderQuantity);
            }
            if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
                importDto.setErrorReason(errorMsg.toString());
            }
            importDto.setSellerId(sellerId);
            importDto.setOrgId(orgId);
            importDto.setInstanceId(requestInstanceId);
        }
    }

    private void preProcessImportData(CustomerInfoUpdateImportDto importDto) {
        Integer deliverMethod;
        if (StringUtils.isNotEmpty((CharSequence)importDto.getDeliveryMethod()) && (deliverMethod = this.getDeliverMethodByName(importDto.getDeliveryMethod())) != null) {
            importDto.setDeliverMethod(deliverMethod);
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getMinOrderQuantity())) {
            try {
                Integer minOrderQuantity = Integer.parseInt(importDto.getMinOrderQuantity().trim());
                importDto.setMinOrderQuantityValue(minOrderQuantity);
            }
            catch (NumberFormatException e) {
                this.logger.warn("\u6574\u7bb1\u8d77\u8ba2[{}]\u683c\u5f0f\u9519\u8bef", (Object)importDto.getMinOrderQuantity());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getStandardDiscountRate())) {
            try {
                BigDecimal standardDiscount = this.convertToDiscount(importDto.getStandardDiscountRate());
                if (standardDiscount != null) {
                    importDto.setStandardDiscountValue(standardDiscount);
                }
            }
            catch (Exception e) {
                this.logger.warn("\u6807\u51c6\u6263\u7387[{}]\u683c\u5f0f\u9519\u8bef", (Object)importDto.getStandardDiscountRate());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getMultiBrandDiscount())) {
            importDto.setMultiBrandDiscount(importDto.getMultiBrandDiscount().replace("\uff0c", ","));
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getRegionName())) {
            importDto.setRegionName(importDto.getRegionName().replace("\uff1b", ";"));
            importDto.setRegionName(importDto.getRegionName().trim());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getSalesArea())) {
            importDto.setSalesArea(importDto.getSalesArea().trim());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getLargeArea())) {
            importDto.setLargeArea(importDto.getLargeArea().trim());
        }
    }

    private void updateCustomer(CustomerInfoUpdateImportDto importDto, Long orgId, Long requestTenantId, Long requestInstanceId, Map<String, CustomerTypeRespDto> customerTypeInfoMap) {
        CompanyVerifyRespDto companyVerifyRespDto;
        String regionNames;
        Integer deliverMethod;
        CustomerExtReqDto customerQuery = new CustomerExtReqDto();
        customerQuery.setCodes((List)Lists.newArrayList((Object[])new String[]{importDto.getCode()}));
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerInfoByOrg(customerQuery));
        if (CollectionUtils.isEmpty((Collection)customerRespDtos)) {
            throw new BizException("\u5ba2\u6237\u7f16\u7801\u4e0d\u5b58\u5728;");
        }
        CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtos.get(0);
        boolean hasRegionUpdate = CollectionUtils.isNotEmpty(importDto.getRegionCodeList());
        boolean hasSalesAreaUpdate = StringUtils.isNotEmpty((CharSequence)importDto.getSalesArea());
        boolean hasLargeAreaUpdate = StringUtils.isNotEmpty((CharSequence)importDto.getLargeArea());
        if ((hasSalesAreaUpdate || hasLargeAreaUpdate) && !hasRegionUpdate) {
            throw new BizException("\u9500\u552e\u533a\u548c\u5927\u533a\u53ea\u80fd\u4e0e\u533a\u57df\u4e00\u8d77\u4fee\u6539\uff0c\u4e0d\u80fd\u5355\u72ec\u5bfc\u5165;");
        }
        CustomerTypeRespDto customerTypeRespDto = null;
        if (StringUtils.isNotEmpty((CharSequence)importDto.getCustomerTypeName())) {
            if (customerTypeInfoMap.isEmpty() || !customerTypeInfoMap.containsKey(importDto.getCustomerTypeName())) {
                throw new BizException("\u5ba2\u6237\u7c7b\u578b\u6570\u636e\u9519\u8bef;");
            }
            customerTypeRespDto = customerTypeInfoMap.get(importDto.getCustomerTypeName());
        }
        if (CollectionUtils.isNotEmpty(importDto.getRegionNameList())) {
            CustomerAreaListExtReqDto customerAreaQuery = new CustomerAreaListExtReqDto();
            customerAreaQuery.setNameList(importDto.getRegionNameList());
            customerAreaQuery.setOrgInfoId(orgId);
            List areaList = (List)RestResponseHelper.extractData((RestResponse)this.employeeRegionQueryApi.queryCustomerAreaByNames(customerAreaQuery));
            if (CollectionUtils.isEmpty((Collection)areaList)) {
                throw new BizException("\u5ba2\u6237\u533a\u57df\u6570\u636e\u9519\u8bef;");
            }
            List foundAreaNames = areaList.stream().map(CustomerAreaRespDto::getName).collect(Collectors.toList());
            List missingAreas = importDto.getRegionNameList().stream().filter(areaName -> !foundAreaNames.contains(areaName)).collect(Collectors.toList());
            if (!missingAreas.isEmpty()) {
                throw new BizException("\u4ee5\u4e0b\u533a\u57df\u540d\u79f0\u4e0d\u5b58\u5728\uff1a" + String.join((CharSequence)"\u3001", missingAreas));
            }
            if (CollectionUtils.isEmpty(areaList = areaList.stream().filter(dto -> dto.getOrgInfoId() != null && dto.getOrgInfoId().equals(orgId)).collect(Collectors.toList()))) {
                throw new BizException("\u5ba2\u6237\u533a\u57df\u7ec4\u7ec7\u6570\u636e\u9519\u8bef;");
            }
            Map<Integer, List<CustomerAreaRespDto>> levelAreaMap = areaList.stream().collect(Collectors.groupingBy(CustomerAreaRespDto::getLevel));
            if ((StringUtils.isEmpty((CharSequence)importDto.getSalesArea()) || StringUtils.isEmpty((CharSequence)importDto.getLargeArea())) && CollectionUtils.isNotEmpty(importDto.getRegionNameList())) {
                try {
                    if (levelAreaMap.containsKey(2)) {
                        List parentAreas;
                        Set parentCodes = levelAreaMap.get(2).stream().filter(area -> StringUtils.isNotEmpty((CharSequence)area.getParentCode())).map(CustomerAreaRespDto::getParentCode).collect(Collectors.toSet());
                        if (!parentCodes.isEmpty() && CollectionUtils.isNotEmpty((Collection)(parentAreas = (List)RestResponseHelper.extractData((RestResponse)this.employeeRegionQueryApi.queryCustomerAreaByCodes(new ArrayList(parentCodes)))))) {
                            parentAreas.sort(Comparator.comparing(CustomerAreaRespDto::getLevel));
                            if (StringUtils.isEmpty((CharSequence)importDto.getSalesArea()) && parentAreas.size() > 0) {
                                importDto.setSalesArea(((CustomerAreaRespDto)parentAreas.get(0)).getName());
                                this.logger.info("\u66f4\u65b0\u5ba2\u6237\u65f6\u6839\u636e\u4e8c\u7ea7\u533a\u57df\u81ea\u52a8\u8bbe\u7f6e\u9500\u552e\u533a: {}", (Object)((CustomerAreaRespDto)parentAreas.get(0)).getName());
                            }
                            if (StringUtils.isEmpty((CharSequence)importDto.getLargeArea()) && parentAreas.size() > 1) {
                                importDto.setLargeArea(((CustomerAreaRespDto)parentAreas.get(1)).getName());
                                this.logger.info("\u66f4\u65b0\u5ba2\u6237\u65f6\u6839\u636e\u4e8c\u7ea7\u533a\u57df\u81ea\u52a8\u8bbe\u7f6e\u5927\u533a: {}", (Object)((CustomerAreaRespDto)parentAreas.get(1)).getName());
                            }
                        }
                    } else if (levelAreaMap.containsKey(1)) {
                        List<CustomerAreaRespDto> level1Areas = levelAreaMap.get(1);
                        if (StringUtils.isEmpty((CharSequence)importDto.getSalesArea()) && level1Areas.size() > 0) {
                            importDto.setSalesArea(level1Areas.get(0).getName());
                            this.logger.info("\u66f4\u65b0\u5ba2\u6237\u65f6\u6839\u636e\u4e00\u7ea7\u533a\u57df\u81ea\u52a8\u8bbe\u7f6e\u9500\u552e\u533a: {}", (Object)level1Areas.get(0).getName());
                        }
                        if (StringUtils.isEmpty((CharSequence)importDto.getLargeArea()) && level1Areas.size() > 1) {
                            importDto.setLargeArea(level1Areas.get(1).getName());
                            this.logger.info("\u66f4\u65b0\u5ba2\u6237\u65f6\u6839\u636e\u4e00\u7ea7\u533a\u57df\u81ea\u52a8\u8bbe\u7f6e\u5927\u533a: {}", (Object)level1Areas.get(1).getName());
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.warn("\u66f4\u65b0\u5ba2\u6237\u65f6\u81ea\u52a8\u8bbe\u7f6e\u9500\u552e\u533a\u548c\u5927\u533a\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
                }
            }
            this.logger.info("\u5ba2\u6237[{}]\u533a\u57df\u9a8c\u8bc1\u901a\u8fc7\uff0c\u4e00\u7ea7\u533a\u57df\u6570\u91cf\uff1a{}\uff0c\u4e8c\u7ea7\u533a\u57df\u6570\u91cf\uff1a{}", new Object[]{importDto.getCode(), levelAreaMap.getOrDefault(1, Collections.emptyList()).size(), levelAreaMap.getOrDefault(2, Collections.emptyList()).size()});
            List<String> areaCodeList = areaList.stream().map(CustomerAreaRespDto::getCode).collect(Collectors.toList());
            importDto.setRegionCodeList(areaCodeList);
        }
        CompanyInfoDto companyInfoDto = null;
        if (StringUtils.isNotEmpty((CharSequence)importDto.getCreditCode())) {
            try {
                block87: {
                    StoreRespDto storeRespDto;
                    this.logger.info("\u67e5\u8be2\u793e\u4f1a\u7edf\u4e00\u4fe1\u7528\u7801CreditCode={},orgId={},requestTenantId={},requestInstanceId={}", new Object[]{importDto.getCreditCode(), orgId, requestTenantId, requestInstanceId});
                    ArrayList creditCodes = Lists.newArrayList((Object[])new String[]{importDto.getCreditCode()});
                    List storeRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.storeQueryApi.querySocialCreditNums((List)creditCodes));
                    if (CollectionUtils.isEmpty((Collection)storeRespDtos)) {
                        this.logger.info("\u901a\u8fc7\u793e\u4f1a\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801\u67e5\u8be2\u4e0d\u5230\u516c\u53f8\u4fe1\u606f\uff0c\u5c1d\u8bd5\u901a\u8fc7\u4f01\u4e1a\u540d\u79f0\u67e5\u8be2:{}", (Object)importDto.getCreditCode());
                        try {
                            storeRespDto = this.customerAddImportService.queryCompanyByCreditCode(importDto.getCreditCode());
                            if (storeRespDto != null && !BeanPropertyNullUtil.isAllFieldNull((Object)storeRespDto)) {
                                this.logger.info("\u901a\u8fc7\u5929\u773c\u67e5\u67e5\u8be2\u5230\u516c\u53f8\u4fe1\u606f: {}", (Object)JSON.toJSONString((Object)storeRespDto));
                                companyInfoDto = new CompanyInfoDto();
                                companyInfoDto.setOrgName(storeRespDto.getStoreName());
                                companyInfoDto.setCreditCode(storeRespDto.getSocialCreditNum());
                                companyInfoDto.setLegalName(storeRespDto.getLegalPersonName());
                                if (StringUtils.isNotEmpty((CharSequence)storeRespDto.getProvince())) {
                                    companyInfoDto.setProvince(storeRespDto.getProvince());
                                    companyInfoDto.setProvinceCode(storeRespDto.getProvinceCode());
                                }
                                if (StringUtils.isNotEmpty((CharSequence)storeRespDto.getCity())) {
                                    companyInfoDto.setCity(storeRespDto.getCity());
                                    companyInfoDto.setCityCode(storeRespDto.getCityCode());
                                }
                                if (StringUtils.isNotEmpty((CharSequence)storeRespDto.getDistrict())) {
                                    companyInfoDto.setDistrict(storeRespDto.getDistrict());
                                    companyInfoDto.setDistrictCode(storeRespDto.getDistrictCode());
                                }
                                if (StringUtils.isNotEmpty((CharSequence)storeRespDto.getStoreAddr())) {
                                    companyInfoDto.setAddress(storeRespDto.getStoreAddr());
                                }
                                break block87;
                            }
                            this.logger.info("\u5929\u773c\u67e5\u672a\u67e5\u8be2\u5230\u516c\u53f8\u4fe1\u606f\uff0c\u5c1d\u8bd5\u901a\u8fc7\u539f\u6709\u65b9\u5f0f\u67e5\u8be2");
                            companyInfoDto = (CompanyInfoDto)RestResponseHelper.extractData((RestResponse)this.customerQueryV3Api.queryCompanyInfoByCreditCode(importDto.getCreditCode(), orgId, requestTenantId, requestInstanceId, null));
                        }
                        catch (Exception e) {
                            this.logger.error("\u901a\u8fc7\u5929\u773c\u67e5\u67e5\u8be2\u516c\u53f8\u4fe1\u606f\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
                            companyInfoDto = (CompanyInfoDto)RestResponseHelper.extractData((RestResponse)this.customerQueryV3Api.queryCompanyInfoByCreditCode(importDto.getCreditCode(), orgId, requestTenantId, requestInstanceId, null));
                        }
                    } else {
                        storeRespDto = (StoreRespDto)storeRespDtos.get(0);
                        companyInfoDto = new CompanyInfoDto();
                        companyInfoDto.setOrgName(storeRespDto.getStoreName());
                        companyInfoDto.setCreditCode(storeRespDto.getSocialCreditNum());
                        companyInfoDto.setLegalName(storeRespDto.getLegalPersonName());
                        if (StringUtils.isNotEmpty((CharSequence)storeRespDto.getProvince())) {
                            companyInfoDto.setProvince(storeRespDto.getProvince());
                            companyInfoDto.setProvinceCode(storeRespDto.getProvinceCode());
                        }
                        if (StringUtils.isNotEmpty((CharSequence)storeRespDto.getCity())) {
                            companyInfoDto.setCity(storeRespDto.getCity());
                            companyInfoDto.setCityCode(storeRespDto.getCityCode());
                        }
                        if (StringUtils.isNotEmpty((CharSequence)storeRespDto.getDistrict())) {
                            companyInfoDto.setDistrict(storeRespDto.getDistrict());
                            companyInfoDto.setDistrictCode(storeRespDto.getDistrictCode());
                        }
                        if (StringUtils.isNotEmpty((CharSequence)storeRespDto.getStoreAddr())) {
                            companyInfoDto.setAddress(storeRespDto.getStoreAddr());
                        }
                        this.logger.info("\u901a\u8fc7\u793e\u4f1a\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801\u67e5\u8be2\u5230\u516c\u53f8\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)storeRespDto));
                    }
                }
                this.logger.info("\u67e5\u8be2\u793e\u4f1a\u7edf\u4e00\u4fe1\u7528\u7801\u516c\u53f8\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)companyInfoDto));
            }
            catch (Exception e) {
                throw new BizException("\u793e\u4f1a\u7edf\u4e00\u4fe1\u7528\u7801\u516c\u53f8\u4fe1\u606f:" + e.getMessage());
            }
        }
        CustomerReqDto updateCustomerDto = new CustomerReqDto();
        CubeBeanUtils.copyProperties((Object)updateCustomerDto, (Object)customerRespDto, (String[])new String[]{"companyInfoDto", "regionCodeList", "regionNameList", "salesmanIds"});
        updateCustomerDto.setId(customerRespDto.getId());
        updateCustomerDto.setMerchantId(orgId);
        updateCustomerDto.setInstanceId(requestInstanceId);
        updateCustomerDto.setTenantId(requestTenantId);
        updateCustomerDto.setOrgId(orgId);
        updateCustomerDto.setRegionCodeList(customerRespDto.getRegionCodeList());
        HashMap<String, String> extendFields = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)importDto.getSalesArea())) {
            extendFields.put("salesArea", importDto.getSalesArea());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getLargeArea())) {
            extendFields.put("largeArea", importDto.getLargeArea());
        }
        if (importDto.getDeliverMethod() != null) {
            updateCustomerDto.setDeliverMethod(importDto.getDeliverMethod());
            this.logger.info("\u8bbe\u7f6e\u5ba2\u6237\u53d1\u8d27\u65b9\u5f0f: {}", (Object)importDto.getDeliverMethod());
        } else if (StringUtils.isNotEmpty((CharSequence)importDto.getDeliveryMethod()) && (deliverMethod = this.getDeliverMethodByName(importDto.getDeliveryMethod())) != null) {
            updateCustomerDto.setDeliverMethod(deliverMethod);
            this.logger.info("\u4ece\u5b57\u7b26\u4e32\u89e3\u6790\u8bbe\u7f6e\u5ba2\u6237\u53d1\u8d27\u65b9\u5f0f: {}", (Object)deliverMethod);
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getMinOrderQuantity())) {
            extendFields.put("minOrderQuantity", importDto.getMinOrderQuantity());
        }
        if (importDto.getStandardDiscountValue() != null) {
            extendFields.put("standardDiscountRate", importDto.getStandardDiscountValue().toString());
        } else if (StringUtils.isNotEmpty((CharSequence)importDto.getStandardDiscountRate())) {
            extendFields.put("standardDiscountRate", importDto.getStandardDiscountRate());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getMultiBrandDiscount())) {
            extendFields.put("multiBrandDiscount", importDto.getMultiBrandDiscount());
        }
        if (!extendFields.isEmpty()) {
            String extendFieldsJson = JSON.toJSONString(extendFields);
            updateCustomerDto.setExtension(extendFieldsJson);
        }
        if (StringUtils.isNotEmpty((CharSequence)(regionNames = customerRespDto.getRegionNames()))) {
            String[] regionNameArr = regionNames.split(",");
            List<String> regionNameList = Arrays.asList(regionNameArr);
            updateCustomerDto.setRegionNameList(regionNameList);
        }
        if (StringUtils.isNotEmpty((CharSequence)customerRespDto.getSalesmanIds())) {
            String[] salesmanIdArr = customerRespDto.getSalesmanIds().split(",");
            List<String> salesmanIdList = Arrays.asList(salesmanIdArr);
            List salesmanIds = salesmanIdList.stream().map(Long::valueOf).collect(Collectors.toList());
            updateCustomerDto.setSalesmanIds(salesmanIds);
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getName()) && !customerRespDto.getName().equals(importDto.getName())) {
            this.logger.info("\u68c0\u6d4b\u5230\u5ba2\u6237\u540d\u79f0\u53d8\u66f4\uff0c\u539f\u540d\u79f0: [{}]\uff0c\u65b0\u540d\u79f0: [{}]", (Object)customerRespDto.getName(), (Object)importDto.getName());
            try {
                RestResponse customerRestResp = this.customerExtQueryApi.queryById(customerRespDto.getId());
                CustomerExtDetailRespDto customerExtDetailRespDto = (CustomerExtDetailRespDto)RestResponseHelper.extractData((RestResponse)customerRestResp);
                CompanyInfoDto detailRespDtoCompanyInfoDto = customerExtDetailRespDto.getCompanyInfoDto();
                if (!(StringUtils.isNotEmpty((CharSequence)customerRespDto.getName()) && Objects.nonNull(detailRespDtoCompanyInfoDto) && StringUtils.isNotEmpty((CharSequence)detailRespDtoCompanyInfoDto.getCreditCode()))) {
                    this.logger.warn("\u5ba2\u6237\u7f3a\u5c11\u5fc5\u8981\u7684\u9a8c\u8bc1\u4fe1\u606f\uff0c\u65e0\u6cd5\u9a8c\u8bc1\u540d\u79f0\u53d8\u66f4 - \u5ba2\u6237ID: {}, \u793e\u4f1a\u4fe1\u7528\u4ee3\u7801: {}", (Object)customerRespDto.getId(), (Object)(detailRespDtoCompanyInfoDto != null ? detailRespDtoCompanyInfoDto.getCreditCode() : "null"));
                    throw new BizException("\u7f3a\u5c11\u5fc5\u8981\u7684\u5ba2\u6237\u4fe1\u606f\uff0c\u65e0\u6cd5\u9a8c\u8bc1\u540d\u79f0\u53d8\u66f4");
                }
                this.logger.info("\u5ba2\u6237\u540d\u79f0\u53d8\u66f4\u9a8c\u8bc1\u4fe1\u606f - \u5ba2\u6237ID: [{}], \u7f16\u7801: [{}], \u793e\u4f1a\u4fe1\u7528\u4ee3\u7801: [{}], \u4f01\u4e1a\u7ec4\u7ec7\u540d\u79f0: [{}]", new Object[]{customerRespDto.getId(), importDto.getCode(), detailRespDtoCompanyInfoDto.getCreditCode(), detailRespDtoCompanyInfoDto.getOrgName()});
                this.validateCustomerNameMatching(detailRespDtoCompanyInfoDto.getCreditCode(), importDto.getName(), detailRespDtoCompanyInfoDto.getOrgName());
                this.logger.info("\u5ba2\u6237[{}]\u540d\u79f0\u53d8\u66f4\u9a8c\u8bc1\u901a\u8fc7\uff0c\u5141\u8bb8\u4ece[{}]\u66f4\u6539\u4e3a[{}]", new Object[]{importDto.getCode(), customerRespDto.getName(), importDto.getName()});
                CustomerSearchReqDto reqDto = new CustomerSearchReqDto();
                reqDto.setName(importDto.getName());
                PageInfo customerRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryByNewPage(reqDto, Integer.valueOf(1), Integer.valueOf(100)));
                AssertUtil.isTrue((boolean)CollectionUtils.isEmpty((Collection)customerRespDtoPageInfo.getList()), (String)"\u4fee\u6539\u5ba2\u6237\u540d\u79f0\u5df2\u5b58\u5728");
            }
            catch (BizException e) {
                throw e;
            }
            catch (Exception e) {
                this.logger.error("\u9a8c\u8bc1\u5ba2\u6237\u540d\u79f0\u53d8\u66f4\u65f6\u53d1\u751f\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
                throw new BizException("\u9a8c\u8bc1\u5ba2\u6237\u540d\u79f0\u53d8\u66f4\u65f6\u53d1\u751f\u5f02\u5e38: " + e.getMessage());
            }
            updateCustomerDto.setName(importDto.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getEasCode())) {
            updateCustomerDto.setEasCode(importDto.getEasCode());
        }
        if (CollectionUtils.isNotEmpty(importDto.getRegionCodeList())) {
            updateCustomerDto.setRegionCodeList(importDto.getRegionCodeList());
        }
        if (CollectionUtils.isNotEmpty(importDto.getRegionNameList())) {
            updateCustomerDto.setRegionNameList(importDto.getRegionNameList());
        }
        if (Objects.nonNull(customerTypeRespDto)) {
            updateCustomerDto.setCustomerTypeId(customerTypeRespDto.getId());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getAddress())) {
            updateCustomerDto.setAddress(importDto.getAddress());
        }
        if (Objects.nonNull(importDto.getCustomerEffectiveTime())) {
            updateCustomerDto.setEffectiveStartTime(importDto.getCustomerEffectiveTime());
            updateCustomerDto.setStartDate(importDto.getCustomerEffectiveTime());
        }
        if (Objects.nonNull(importDto.getCustomerExpirationTime())) {
            updateCustomerDto.setEffectiveEndTime(importDto.getCustomerExpirationTime());
            updateCustomerDto.setEndDate(importDto.getCustomerExpirationTime());
        }
        CompanyInfoDto newCompanyInfo = new CompanyInfoDto();
        CompanyInfoDto oldCompanyInfoDto = customerRespDto.getCompanyInfoDto();
        if (oldCompanyInfoDto != null) {
            CubeBeanUtils.copyProperties((Object)newCompanyInfo, (Object)oldCompanyInfoDto, (String[])new String[0]);
        }
        if (Objects.nonNull(companyInfoDto)) {
            CubeBeanUtils.copyProperties((Object)newCompanyInfo, (Object)companyInfoDto, (String[])new String[0]);
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getSubjectType())) {
            newCompanyInfo.setSubjectType(this.toSubjectType(importDto.getSubjectType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getCreditCode())) {
            newCompanyInfo.setCreditCode(importDto.getCreditCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getBusinessLicenseType())) {
            newCompanyInfo.setBusinessLicenseType(this.toBusinessLicenseType(importDto.getBusinessLicenseType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getBusinessTermType())) {
            newCompanyInfo.setBusinessTermType(this.toBusinessTermType(importDto.getBusinessTermType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getTermBeginTime())) {
            Date termBeginTime = DateUtil.parseDate((String)importDto.getTermBeginTime(), (String)"EEE MMM dd HH:mm:ss zzz yyyy");
            newCompanyInfo.setTermBeginTime(termBeginTime);
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getTermEndTime())) {
            Date termEndTime = DateUtil.parseDate((String)importDto.getTermEndTime(), (String)"EEE MMM dd HH:mm:ss zzz yyyy");
            newCompanyInfo.setTermEndTime(termEndTime);
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getOrgAddress())) {
            newCompanyInfo.setAddress(importDto.getOrgAddress());
        }
        updateCustomerDto.setCompanyInfoDto(newCompanyInfo);
        if (StringUtils.isNotEmpty((CharSequence)importDto.getCreditCode()) && StringUtils.isNotEmpty((CharSequence)newCompanyInfo.getOrgName()) && StringUtils.isNotEmpty((CharSequence)newCompanyInfo.getLegalName()) && 1 != (companyVerifyRespDto = this.customerAddImportService.queryStoreVerify(newCompanyInfo.getCreditCode(), newCompanyInfo.getOrgName(), newCompanyInfo.getLegalName())).getResult()) {
            throw new BizException(companyVerifyRespDto.getRemark());
        }
        if (companyInfoDto != null) {
            updateCustomerDto.setProvince(companyInfoDto.getProvince());
            updateCustomerDto.setProvinceCode(companyInfoDto.getProvinceCode());
            updateCustomerDto.setCity(companyInfoDto.getCity());
            updateCustomerDto.setCityCode(companyInfoDto.getCityCode());
            updateCustomerDto.setCounty(companyInfoDto.getDistrict());
            updateCustomerDto.setCountyCode(companyInfoDto.getDistrictCode());
            if (StringUtils.isEmpty((CharSequence)updateCustomerDto.getAddress()) && StringUtils.isNotEmpty((CharSequence)companyInfoDto.getAddress())) {
                updateCustomerDto.setAddress(companyInfoDto.getAddress());
            }
        }
        ServiceContext.getContext().setAttachment("yes.req.tenantId", requestTenantId.toString());
        ServiceContext.getContext().setAttachment("yes.req.instanceId", requestInstanceId.toString());
        this.logger.info("\u4fee\u6539\u5ba2\u6237\u8bf7\u6c42\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)updateCustomerDto));
        RestResponseHelper.extractData((RestResponse)this.customerExtApi.update(updateCustomerDto));
        this.logger.info("\u5ba2\u6237\u57fa\u672c\u4fe1\u606f\u66f4\u65b0\u6210\u529f, ID: {}, \u7f16\u7801: {}", (Object)customerRespDto.getId(), (Object)importDto.getCode());
        if (StringUtils.isNotEmpty((CharSequence)importDto.getMinOrderQuantity())) {
            try {
                Integer ifWholeCasePurchase;
                CustomerBatchUpReqDto batchUpReqDto;
                block88: {
                    batchUpReqDto = new CustomerBatchUpReqDto();
                    batchUpReqDto.setCustomerCodes((List)Lists.newArrayList((Object[])new String[]{importDto.getCode()}));
                    batchUpReqDto.setBelongMerchantId(orgId);
                    ifWholeCasePurchase = null;
                    if (importDto.getMinOrderQuantityValue() != null) {
                        ifWholeCasePurchase = importDto.getMinOrderQuantityValue() > 0 ? 1 : 0;
                    } else {
                        try {
                            int minOrderQty = Integer.parseInt(importDto.getMinOrderQuantity().trim());
                            ifWholeCasePurchase = minOrderQty > 0 ? 1 : 0;
                        }
                        catch (NumberFormatException e) {
                            this.logger.error("\u89e3\u6790\u6574\u7bb1\u8d77\u8ba2\u503c\u5931\u8d25: {}", (Object)e.getMessage());
                            String value = importDto.getMinOrderQuantity().trim();
                            if ("\u662f".equals(value) || "1".equals(value) || "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value)) {
                                ifWholeCasePurchase = 1;
                            }
                            if (!"\u5426".equals(value) && !"0".equals(value) && !"false".equalsIgnoreCase(value) && !"no".equalsIgnoreCase(value)) break block88;
                            ifWholeCasePurchase = 0;
                        }
                    }
                }
                if (ifWholeCasePurchase != null) {
                    batchUpReqDto.setIfWholeCasePurchase(ifWholeCasePurchase);
                    this.logger.info("\u8c03\u7528\u6279\u91cf\u8bbe\u7f6e\u6574\u7bb1\u8d77\u8ba2API\uff0c\u5ba2\u6237\u7f16\u7801: {}, \u6574\u7bb1\u8d77\u8ba2\u503c: {}", (Object)importDto.getCode(), (Object)ifWholeCasePurchase);
                    RestResponseHelper.extractData((RestResponse)this.customerExtThreeApi.batchUpCusIfWholePurchase(batchUpReqDto));
                    this.logger.info("\u8bbe\u7f6e\u6574\u7bb1\u8d77\u8ba2\u6210\u529f");
                } else {
                    this.logger.warn("\u65e0\u6cd5\u8bc6\u522b\u6574\u7bb1\u8d77\u8ba2\u503c: {}, \u8df3\u8fc7\u8bbe\u7f6e", (Object)importDto.getMinOrderQuantity());
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bbe\u7f6e\u6574\u7bb1\u8d77\u8ba2\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getStandardDiscountRate())) {
            this.updateCustomerDiscounts(customerRespDto.getId(), importDto, orgId, requestTenantId, requestInstanceId);
        }
        if (StringUtils.isNotEmpty((CharSequence)importDto.getCreditCode())) {
            if (StringUtils.isNotEmpty((CharSequence)importDto.getCreditCode()) && !importDto.getCreditCode().equals(oldCompanyInfoDto != null ? oldCompanyInfoDto.getCreditCode() : null)) {
                this.logger.info("\u68c0\u6d4b\u5230\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u53d8\u66f4\uff0c\u8fdb\u884c\u9a8c\u8bc1 - \u5ba2\u6237: [{}], \u65e7\u4ee3\u7801: [{}], \u65b0\u4ee3\u7801: [{}]", new Object[]{customerRespDto.getName(), oldCompanyInfoDto != null ? oldCompanyInfoDto.getCreditCode() : "null", importDto.getCreditCode()});
                try {
                    CheckCreditByCustomerCodeReqDto checkDto = new CheckCreditByCustomerCodeReqDto();
                    checkDto.setCreditCode(importDto.getCreditCode());
                    checkDto.setOrgName(companyInfoDto != null && StringUtils.isNotEmpty((CharSequence)companyInfoDto.getOrgName()) ? companyInfoDto.getOrgName() : newCompanyInfo.getOrgName());
                    checkDto.setCusName(importDto.getName() != null ? importDto.getName() : customerRespDto.getName());
                    this.checkCreditByCustomerCode(checkDto);
                    this.logger.info("\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u9a8c\u8bc1\u901a\u8fc7: {}", (Object)importDto.getCreditCode());
                }
                catch (Exception e) {
                    this.logger.error("\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u9a8c\u8bc1\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
                    throw new BizException("\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u9a8c\u8bc1\u5931\u8d25: " + e.getMessage());
                }
            }
            newCompanyInfo.setCreditCode(importDto.getCreditCode());
        }
    }

    private Integer getDeliverMethodByName(String deliveryMethodName) {
        if (StringUtils.isEmpty((CharSequence)deliveryMethodName)) {
            return null;
        }
        if ("\u5546\u5bb6\u53d1\u8d27".equals(deliveryMethodName.trim())) {
            return 1;
        }
        if ("\u5382\u5bb6\u53d1\u8d27".equals(deliveryMethodName.trim())) {
            return 2;
        }
        try {
            return Integer.parseInt(deliveryMethodName.trim());
        }
        catch (NumberFormatException e) {
            this.logger.warn("\u65e0\u6cd5\u8bc6\u522b\u7684\u53d1\u8d27\u65b9\u5f0f: {}", (Object)deliveryMethodName);
            return null;
        }
    }

    private void updateCustomerDiscounts(Long customerId, CustomerInfoUpdateImportDto importDto, Long orgId, Long requestTenantId, Long requestInstanceId) {
        try {
            this.logger.info("\u5f00\u59cb\u66f4\u65b0\u5ba2\u6237\u6807\u51c6\u6263\u7387\u548c\u591a\u54c1\u724c\u6263\u7387, \u5ba2\u6237ID: {}", (Object)customerId);
            PrBaseDiscountAddEditReqDto discountAddEditReqDto = new PrBaseDiscountAddEditReqDto();
            discountAddEditReqDto.setCustomerId(customerId);
            discountAddEditReqDto.setCustomerName(importDto.getName());
            discountAddEditReqDto.setCustomerCode(importDto.getCode());
            discountAddEditReqDto.setMerchantId(orgId);
            discountAddEditReqDto.setOrgInfoId(orgId);
            discountAddEditReqDto.setTenantId(requestTenantId);
            discountAddEditReqDto.setInstanceId(requestInstanceId);
            if (StringUtils.isNotEmpty((CharSequence)importDto.getStandardDiscountRate())) {
                try {
                    BigDecimal standardDiscount = this.convertToDiscount(importDto.getStandardDiscountRate());
                    if (standardDiscount == null) {
                        this.logger.error("\u6807\u51c6\u6263\u7387[{}]\u8f6c\u6362\u5931\u8d25", (Object)importDto.getStandardDiscountRate());
                        return;
                    }
                    discountAddEditReqDto.setStandardDiscount(standardDiscount);
                    importDto.setStandardDiscountValue(standardDiscount);
                    this.logger.info("\u6807\u51c6\u6263\u7387[{}]\u8f6c\u6362\u4e3a: {}", (Object)importDto.getStandardDiscountRate(), (Object)standardDiscount);
                }
                catch (NumberFormatException e) {
                    this.logger.error("\u6807\u51c6\u6263\u7387[{}]\u683c\u5f0f\u9519\u8bef", (Object)importDto.getStandardDiscountRate());
                    return;
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)importDto.getMultiBrandDiscount())) {
                List<PrBaseDiscountBrandReqDto> brandDiscounts = this.parseBrandDiscounts(importDto.getMultiBrandDiscount());
                if (!brandDiscounts.isEmpty()) {
                    discountAddEditReqDto.setBrandDiscountList(brandDiscounts);
                }
            } else {
                discountAddEditReqDto.setBrandDiscountList(new ArrayList());
            }
            this.logger.info("\u66f4\u65b0\u5ba2\u6237\u6807\u51c6\u6263\u7387\u548c\u591a\u54c1\u724c\u6263\u7387, \u53c2\u6570: {}", (Object)JSON.toJSONString((Object)discountAddEditReqDto));
            RestResponseHelper.extractData((RestResponse)this.prBaseDiscountApi.updateOrInsert((List)Lists.newArrayList((Object[])new PrBaseDiscountAddEditReqDto[]{discountAddEditReqDto})));
            this.logger.info("\u5ba2\u6237[{}]\u6807\u51c6\u6263\u7387\u548c\u591a\u54c1\u724c\u6263\u7387\u66f4\u65b0\u6210\u529f", (Object)importDto.getName());
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u5ba2\u6237\u6807\u51c6\u6263\u7387\u548c\u591a\u54c1\u724c\u6263\u7387\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private List<PrBaseDiscountBrandReqDto> parseBrandDiscounts(String multiBrandDiscountStr) {
        ArrayList<PrBaseDiscountBrandReqDto> result = new ArrayList<PrBaseDiscountBrandReqDto>();
        if (StringUtils.isEmpty((CharSequence)multiBrandDiscountStr)) {
            return result;
        }
        try {
            String[] brandDiscounts;
            for (String brandDiscount : brandDiscounts = multiBrandDiscountStr.replace("\uff0c", ",").split(",")) {
                String[] parts = brandDiscount.split(":");
                if (parts.length != 2) continue;
                String brandName = parts[0].trim();
                String discountRateStr = parts[1].trim();
                try {
                    BigDecimal discountRate = this.convertToDiscount(discountRateStr);
                    if (discountRate == null) {
                        this.logger.error("\u54c1\u724c[{}]\u6263\u7387[{}]\u8f6c\u6362\u5931\u8d25", (Object)brandName, (Object)discountRateStr);
                        continue;
                    }
                    PrBaseDiscountBrandReqDto brandDiscountDto = new PrBaseDiscountBrandReqDto();
                    brandDiscountDto.setBrandName(brandName);
                    brandDiscountDto.setBrandDiscount(discountRate);
                    try {
                        ArrayList<String> brandNameList = new ArrayList<String>();
                        brandNameList.add(brandName);
                        List nonExistingBrands = (List)RestResponseHelper.extractData((RestResponse)this.itemBrandAuthApi.checkBrandsExist(brandNameList));
                        if (CollectionUtils.isEmpty((Collection)nonExistingBrands)) {
                            Long brandId = this.getBrandIdByName(brandName);
                            if (brandId == null) continue;
                            brandDiscountDto.setBrandId(brandId);
                            result.add(brandDiscountDto);
                            this.logger.info("\u54c1\u724c[{}]\u6263\u7387[{}]\u8f6c\u6362\u4e3a: {}", new Object[]{brandName, discountRateStr, discountRate});
                            continue;
                        }
                        this.logger.warn("\u54c1\u724c[{}]\u4e0d\u5b58\u5728\uff0c\u5ffd\u7565\u8be5\u54c1\u724c\u6263\u7387", (Object)brandName);
                    }
                    catch (Exception e) {
                        this.logger.error("\u83b7\u53d6\u54c1\u724c[{}]ID\u5f02\u5e38: {}", (Object)brandName, (Object)e.getMessage());
                    }
                }
                catch (NumberFormatException e) {
                    this.logger.error("\u54c1\u724c[{}]\u6263\u7387[{}]\u683c\u5f0f\u9519\u8bef: {}", new Object[]{brandName, discountRateStr, e.getMessage()});
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u89e3\u6790\u591a\u54c1\u724c\u6263\u7387\u5f02\u5e38: {}", (Object)e.getMessage());
        }
        return result;
    }

    private Long getBrandIdByName(String brandName) {
        try {
            List brands = (List)RestResponseHelper.extractData((RestResponse)this.itemBrandAuthApi.queryBrandsByName(brandName));
            if (CollectionUtils.isNotEmpty((Collection)brands)) {
                return ((BrandRespDto)brands.get(0)).getId();
            }
        }
        catch (Exception e) {
            this.logger.error("u6839u636eu540du79f0u67e5u8be2u54c1u724cIDu5f02u5e38: {}", (Object)e.getMessage());
        }
        return null;
    }

    private String toSubjectType(String name) {
        if (SubjectTypeEnum.COMPANY.getName().equals(name)) {
            return SubjectTypeEnum.COMPANY.getType();
        }
        if (SubjectTypeEnum.INDIVIDUAL.getName().equals(name)) {
            return SubjectTypeEnum.INDIVIDUAL.getType();
        }
        if (SubjectTypeEnum.ZOOID.getName().equals(name)) {
            return SubjectTypeEnum.ZOOID.getType();
        }
        return "";
    }

    private Integer toBusinessLicenseType(String name) {
        if ("\u591a\u8bc1\u5408\u4e00\u8425\u4e1a\u6267\u7167".equals(name)) {
            return 1;
        }
        if ("\u666e\u901a\u8425\u4e1a\u6267\u7167".equals(name)) {
            return 2;
        }
        return 0;
    }

    private String toBusinessTermType(String name) {
        if ("\u77ed\u671f\u6709\u6548".equals(name)) {
            return "1";
        }
        if ("\u957f\u671f\u6709\u6548".equals(name)) {
            return "2";
        }
        return "0";
    }

    public void customerItemAuthImport(ImportReqDto importReqDto) {
        this.logger.info("\u5546\u54c1\u6388\u6743\u5bfc\u5165\uff1a{}", (Object)JSON.toJSONString((Object)importReqDto));
        AssertUtil.assertNotBlank((String)importReqDto.getFileUrl(), (String)"\u5bfc\u5165\u7684\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        String b2bOrgIdStr = this.getHeaderOrgId();
        if (StringUtils.isEmpty((CharSequence)b2bOrgIdStr)) {
            b2bOrgIdStr = this.nacosPropertiesOrgEntity.orgId();
            this.logger.info("nacos\u914d\u7f6e\u7684\u7ec4\u7ec7ID\uff1a{}", (Object)b2bOrgIdStr);
        }
        AssertUtil.assertNotBlank((String)b2bOrgIdStr, (String)"\u8bf7\u6c42\u5934[yes-req-cus-b2b-organizationId]\u503c\u4e3a\u7a7a");
        Long b2bOrgId = Long.valueOf(b2bOrgIdStr);
        Long requestTenantId = this.getTenantId();
        Long requestInstanceId = this.getInstanceId();
        List<CustomerItemAuthImportDto> importDtoList = new ArrayList();
        try {
            InputStream is = this.getInputStream(importReqDto.getFileUrl());
            ExcelImportResult objectExcelImportResult = EasyPoiExportUtil.importExcel(is, 0, 1, CustomerItemAuthImportDto.class);
            importDtoList = objectExcelImportResult.getList();
            importDtoList = BeanPropertyNullUtil.getAllFieldNullList(importDtoList);
            this.logger.info("\u5546\u54c1\u6388\u6743\u5bfc\u5165\u6570\u636e\u539f\u59cb\u6570\u91cf\uff1a{}", (Object)importDtoList.size());
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u5165\u5546\u54c1\u6388\u6743\u89e3\u6790\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new BizException("\u5bfc\u5165\u5546\u54c1\u6388\u6743\u89e3\u6790\u5931\u8d25\uff1a" + e.getMessage());
        }
        if (CollectionUtils.isEmpty(importDtoList)) {
            this.logger.warn("\u5bfc\u5165\u5546\u54c1\u6388\u6743\u6570\u636e\u4e3a\u7a7a");
            throw new BizException("\u5bfc\u5165\u5546\u54c1\u6388\u6743\u6570\u636e\u4e3a\u7a7a");
        }
        Map<String, Long> duplicateCounts = importDtoList.stream().collect(Collectors.groupingBy(dto -> dto.getCustomerCode() + ":" + dto.getItemCode(), Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (!duplicateCounts.isEmpty()) {
            this.logger.warn("\u68c0\u6d4b\u5230\u5bfc\u5165\u6570\u636e\u4e2d\u5b58\u5728\u91cd\u590d\u8bb0\u5f55: {}", (Object)JSON.toJSONString(duplicateCounts));
        }
        long emptyCustomerCodeCount = importDtoList.stream().filter(dto -> StringUtils.isEmpty((CharSequence)dto.getCustomerCode())).count();
        long emptyItemCodeCount = importDtoList.stream().filter(dto -> StringUtils.isEmpty((CharSequence)dto.getItemCode())).count();
        if (emptyCustomerCodeCount > 0L || emptyItemCodeCount > 0L) {
            this.logger.warn("\u5bfc\u5165\u6570\u636e\u4e2d\u5b58\u5728\u7a7a\u7684\u5ba2\u6237\u7f16\u7801\u6570\u91cf[{}]\u6216\u5546\u54c1\u7f16\u7801\u6570\u91cf[{}]", (Object)emptyCustomerCodeCount, (Object)emptyItemCodeCount);
        }
        this.logger.info("\u5546\u54c1\u6388\u6743\u5bfc\u5165\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(importDtoList));
        this.validateImportData(importDtoList);
        ImportLogEo initLog = ImportLogEo.newInstance();
        initLog.setImportFileUrl(importReqDto.getFileUrl());
        String fileName = importReqDto.getFileName();
        if (StringUtils.isEmpty((CharSequence)importReqDto.getFileName())) {
            fileName = StringUtils.substringAfter((String)importReqDto.getFileUrl(), (String)"cube//");
        }
        initLog.setFileName(fileName);
        initLog.setImportType(ImportLogTypeEnum.ITEM_AUTHORIZE.getCode());
        initLog.setTotalNum(Integer.valueOf(importDtoList.size()));
        initLog.setOrganizationId(b2bOrgId);
        initLog.setInstanceId(requestInstanceId);
        initLog.setTenantId(requestTenantId);
        Long importLogId = this.importLogService.init(initLog);
        List<CustomerItemAuthImportDto> finalImportDtos = importDtoList;
        CompletableFuture.runAsync(() -> {
            block9: {
                try {
                    this.logger.info("\u5546\u54c1\u6388\u6743\u5bfc\u5165\u5f00\u59cb,\u65e5\u5fd7id[{}],\u65f6\u95f4[{}]", (Object)importLogId, (Object)System.currentTimeMillis());
                    List<CustomerItemAuthImportDto> errorList = this.doCustomerItemAuthImport(finalImportDtos, b2bOrgId, requestTenantId, requestInstanceId);
                    this.logger.info("\u5546\u54c1\u6388\u6743\u5bfc\u5165\u7ed3\u675f,\u65e5\u5fd7id[{}],\u65f6\u95f4[{}]", (Object)importLogId, (Object)System.currentTimeMillis());
                    if (CollectionUtils.isEmpty(errorList)) {
                        this.logger.info("\u5546\u54c1\u6388\u6743\u5bfc\u5165\u5168\u90e8\u6210\u529f\uff0c\u8bb0\u5f55\u6570: {}", (Object)finalImportDtos.size());
                        this.importLogService.success(importLogId, ImportLogStatusEnum.SUCCEED, finalImportDtos.size(), "", "", 0);
                        break block9;
                    }
                    int errorCount = errorList.size();
                    int successCount = finalImportDtos.size() - errorCount;
                    if (successCount > 0) {
                        this.logger.info("\u5546\u54c1\u6388\u6743\u5bfc\u5165\u90e8\u5206\u6210\u529f\uff0c\u6210\u529f\u6570: {}, \u5931\u8d25\u6570: {}", (Object)successCount, (Object)errorCount);
                    } else {
                        this.logger.warn("\u5546\u54c1\u6388\u6743\u5bfc\u5165\u5168\u90e8\u5931\u8d25\uff0c\u5931\u8d25\u6570: {}", (Object)errorCount);
                    }
                    String exportUrl = "";
                    try {
                        String title = "\u5546\u54c1\u6388\u6743\u5bfc\u5165\u5f02\u5e38\u7ed3\u679c";
                        String errorFileName = title + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmssSSS");
                        exportUrl = EasyPoiExportUtil.getExportUrl(errorList, CustomerItemAuthImportDto.class, title, errorFileName, "xls");
                        this.logger.info("\u751f\u6210\u5f02\u5e38\u7ed3\u679c\u6587\u4ef6\u6210\u529f: {}", (Object)exportUrl);
                    }
                    catch (Exception e) {
                        this.logger.error("\u5546\u54c1\u6388\u6743\u5bfc\u5165\u5f02\u5e38\u7ed3\u679c\u751f\u6210\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
                    }
                    if (successCount > 0) {
                        String failReason = "\u5bfc\u5165\u5904\u7406\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u8be6\u89c1\u9519\u8bef\u6587\u4ef6";
                        this.importLogService.success(importLogId, ImportLogStatusEnum.PART_SUCCESS, successCount, failReason, exportUrl, errorCount);
                    } else {
                        this.importLogService.fail(importLogId, "\u5bfc\u5165\u5904\u7406\u5168\u90e8\u5931\u8d25\uff0c\u8be6\u89c1\u9519\u8bef\u6587\u4ef6", exportUrl, errorCount);
                    }
                }
                catch (Exception e) {
                    this.logger.error("\u5546\u54c1\u6388\u6743\u5bfc\u5165\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
                    this.importLogService.fail(importLogId, e.getMessage(), "", finalImportDtos.size());
                }
            }
        });
        this.logger.info("\u5546\u54c1\u6388\u6743\u5bfc\u5165\u4efb\u52a1\u5df2\u63d0\u4ea4\u5904\u7406\uff0c\u5171{}\u6761\u8bb0\u5f55", (Object)importDtoList.size());
    }

    private void validateImportData(List<CustomerItemAuthImportDto> importDtoList) {
        if (CollectionUtils.isEmpty(importDtoList)) {
            this.logger.warn("\u9a8c\u8bc1\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        this.logger.info("\u5f00\u59cb\u9a8c\u8bc1\u5bfc\u5165\u6570\u636e\uff0c\u8bb0\u5f55\u6570: {}", (Object)importDtoList.size());
        HashMap<String, Integer> uniqueKeyCountMap = new HashMap<String, Integer>();
        for (CustomerItemAuthImportDto dto2 : importDtoList) {
            if (!StringUtils.isNotEmpty((CharSequence)dto2.getCustomerCode()) || !StringUtils.isNotEmpty((CharSequence)dto2.getItemCode())) continue;
            String uniqueKey = dto2.getCustomerCode() + ":" + dto2.getItemCode();
            uniqueKeyCountMap.put(uniqueKey, uniqueKeyCountMap.getOrDefault(uniqueKey, 0) + 1);
        }
        for (CustomerItemAuthImportDto dto2 : importDtoList) {
            String uniqueKey;
            int count;
            StringBuilder errorMsg = new StringBuilder();
            if (StringUtils.isEmpty((CharSequence)dto2.getCustomerCode())) {
                errorMsg.append("\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;");
            }
            if (StringUtils.isEmpty((CharSequence)dto2.getItemCode())) {
                errorMsg.append("\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;");
            }
            if (StringUtils.isNotEmpty((CharSequence)dto2.getCustomerCode()) && StringUtils.isNotEmpty((CharSequence)dto2.getItemCode()) && (count = uniqueKeyCountMap.getOrDefault(uniqueKey = dto2.getCustomerCode() + ":" + dto2.getItemCode(), 0).intValue()) > 1) {
                errorMsg.append("\u5ba2\u6237\u7f16\u7801\u4e0e\u5546\u54c1\u7f16\u7801\u7ec4\u5408\u91cd\u590d;");
                uniqueKeyCountMap.put(uniqueKey, count - 1);
            }
            if (errorMsg.length() <= 0) continue;
            dto2.setErrorReason(errorMsg.toString());
        }
        long errorRecords = importDtoList.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getErrorReason())).count();
        this.logger.info("\u5bfc\u5165\u6570\u636e\u9a8c\u8bc1\u5b8c\u6210: \u603b\u8bb0\u5f55\u6570[{}], \u6709\u6548\u8bb0\u5f55\u6570[{}], \u9519\u8bef\u8bb0\u5f55\u6570[{}]", new Object[]{importDtoList.size(), (long)importDtoList.size() - errorRecords, errorRecords});
    }

    private List<CustomerItemAuthImportDto> doCustomerItemAuthImport(List<CustomerItemAuthImportDto> importDtoList, Long orgId, Long tenantId, Long instanceId) {
        this.logger.info("\u5546\u54c1\u6388\u6743\u5bfc\u5165doCustomerItemAuthImport\uff1a{}", (Object)JSON.toJSONString(importDtoList));
        this.logger.info("orgId\uff1a{}", (Object)orgId);
        ArrayList errorList = Lists.newArrayList();
        int totalCount = importDtoList.size();
        int errorCount = 0;
        int successCount = 0;
        List customerCodeList = importDtoList.stream().filter(dto -> StringUtils.isEmpty((CharSequence)dto.getErrorReason())).map(CustomerItemAuthImportDto::getCustomerCode).distinct().collect(Collectors.toList());
        List<String> itemCodeList = importDtoList.stream().filter(dto -> StringUtils.isEmpty((CharSequence)dto.getErrorReason())).map(CustomerItemAuthImportDto::getItemCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(customerCodeList) || CollectionUtils.isEmpty(itemCodeList)) {
            this.logger.info("\u6ca1\u6709\u6709\u6548\u7684\u5ba2\u6237\u7f16\u7801\u6216\u5546\u54c1\u7f16\u7801\uff0c\u8df3\u8fc7\u6388\u6743\u5904\u7406");
            return importDtoList.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getErrorReason())).collect(Collectors.toList());
        }
        Map<Object, Object> customerMap = new HashMap();
        try {
            CustomerExtReqDto customerReqDto = new CustomerExtReqDto();
            customerReqDto.setCodes(customerCodeList);
            customerReqDto.setTenantId(tenantId);
            customerReqDto.setInstanceId(instanceId);
            customerReqDto.setOrgId(orgId);
            List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerInfoByOrg(customerReqDto));
            if (CollectionUtils.isNotEmpty((Collection)customerRespDtos)) {
                customerMap = customerRespDtos.stream().collect(Collectors.toMap(CustomerRespDto::getCode, Function.identity(), (k1, k2) -> k1));
            }
            this.logger.info("\u67e5\u8be2\u5230\u6709\u6548\u5ba2\u6237\u6570\u91cf: {}", (Object)customerMap.size());
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
        }
        Map<Object, Object> itemMap = new HashMap();
        try {
            itemMap = this.queryAllowSaleItems(itemCodeList, orgId);
            this.logger.info("\u67e5\u8be2\u5230\u6709\u6548\u5546\u54c1\u6570\u91cf: {}", (Object)itemMap.size());
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
        }
        HashMap<String, Boolean> customerExists = new HashMap<String, Boolean>();
        HashMap<String, Boolean> itemExists = new HashMap<String, Boolean>();
        HashMap<String, Boolean> itemInAllowSale = new HashMap<String, Boolean>();
        for (CustomerItemAuthImportDto dto2 : importDtoList) {
            ItemDetailBaseInfoRespDto item2;
            if (StringUtils.isNotEmpty((CharSequence)dto2.getErrorReason())) {
                errorList.add(dto2);
                ++errorCount;
                continue;
            }
            StringBuilder errorMsg = new StringBuilder();
            if (!customerExists.containsKey(dto2.getCustomerCode())) {
                boolean exists = customerMap.containsKey(dto2.getCustomerCode());
                customerExists.put(dto2.getCustomerCode(), exists);
            }
            if (!((Boolean)customerExists.get(dto2.getCustomerCode())).booleanValue()) {
                errorMsg.append("\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\u6216\u4e0d\u5c5e\u4e8e\u5f53\u524d\u7ec4\u7ec7;");
            }
            if (!itemInAllowSale.containsKey(dto2.getItemCode())) {
                boolean inAllowSale = itemMap.containsKey(dto2.getItemCode());
                itemInAllowSale.put(dto2.getItemCode(), inAllowSale);
                if (!inAllowSale && !itemExists.containsKey(dto2.getItemCode())) {
                    boolean exists = this.checkItemExists(dto2.getItemCode(), orgId);
                    itemExists.put(dto2.getItemCode(), exists);
                }
            }
            if (!((Boolean)itemInAllowSale.get(dto2.getItemCode())).booleanValue()) {
                if (itemExists.containsKey(dto2.getItemCode()) && ((Boolean)itemExists.get(dto2.getItemCode())).booleanValue()) {
                    errorMsg.append("\u5546\u54c1\u4e0d\u5728\u9500\u552e\u8303\u56f4\u5185;");
                } else {
                    errorMsg.append("\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728;");
                }
            }
            if (((Boolean)itemInAllowSale.get(dto2.getItemCode())).booleanValue() && CollectionUtils.isEmpty((Collection)(item2 = (ItemDetailBaseInfoRespDto)itemMap.get(dto2.getItemCode())).getItemSkuList())) {
                errorMsg.append("\u5546\u54c1\u6ca1\u6709SKU\u4fe1\u606f;");
            }
            if (errorMsg.length() <= 0) continue;
            dto2.setErrorReason(errorMsg.toString());
            errorList.add(dto2);
            ++errorCount;
        }
        Map<String, List<CustomerItemAuthImportDto>> validRecordsByCustomer = importDtoList.stream().filter(dto -> StringUtils.isEmpty((CharSequence)dto.getErrorReason())).collect(Collectors.groupingBy(CustomerItemAuthImportDto::getCustomerCode));
        this.logger.info("\u6709\u6548\u5ba2\u6237\u7ec4\u6570: {}, \u5f00\u59cb\u5904\u7406\u6388\u6743", (Object)validRecordsByCustomer.size());
        for (Map.Entry<String, List<CustomerItemAuthImportDto>> entry : validRecordsByCustomer.entrySet()) {
            String customerCode = entry.getKey();
            List<CustomerItemAuthImportDto> dtoList = entry.getValue();
            try {
                CustomerRespDto customer = (CustomerRespDto)customerMap.get(customerCode);
                if (customer == null) {
                    this.logger.warn("\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff08\u4e8c\u6b21\u68c0\u67e5\uff09: {}", (Object)customerCode);
                    for (CustomerItemAuthImportDto dto3 : dtoList) {
                        dto3.setErrorReason("\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\u6216\u4e0d\u5c5e\u4e8e\u5f53\u524d\u7ec4\u7ec7;");
                        errorList.add(dto3);
                        ++errorCount;
                    }
                    continue;
                }
                this.logger.info("\u5f00\u59cb\u5904\u7406\u5ba2\u6237[{}]\u7684\u6388\u6743\uff0c\u5546\u54c1\u6570\u91cf: {}", (Object)customerCode, (Object)dtoList.size());
                ArrayList authItemReqDtoList = new ArrayList();
                ArrayList<CustomerItemAuthImportDto> skippedItems = new ArrayList<CustomerItemAuthImportDto>();
                for (CustomerItemAuthImportDto itemAuthImportDto : dtoList) {
                    ItemDetailBaseInfoRespDto item3 = (ItemDetailBaseInfoRespDto)itemMap.get(itemAuthImportDto.getItemCode());
                    if (item3 == null) {
                        this.logger.warn("\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728\uff08\u4e8c\u6b21\u68c0\u67e5\uff09: {}", (Object)itemAuthImportDto.getItemCode());
                        itemAuthImportDto.setErrorReason("\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728\u6216\u4e0d\u5728\u9500\u552e\u8303\u56f4\u5185;");
                        skippedItems.add(itemAuthImportDto);
                        continue;
                    }
                    if (CollectionUtils.isEmpty((Collection)item3.getItemSkuList())) {
                        this.logger.warn("\u5546\u54c1[{}]\u6ca1\u6709SKU\u4fe1\u606f", (Object)itemAuthImportDto.getItemCode());
                        itemAuthImportDto.setErrorReason("\u5546\u54c1\u6ca1\u6709SKU\u4fe1\u606f;");
                        skippedItems.add(itemAuthImportDto);
                        continue;
                    }
                    item3.getItemSkuList().forEach(r -> {
                        CustomerAuthItemReqDto authItemReqDto = new CustomerAuthItemReqDto();
                        authItemReqDto.setItemId(item3.getId());
                        authItemReqDto.setItemCode(item3.getCode());
                        authItemReqDto.setItemName(item3.getName());
                        authItemReqDto.setSkuId(r.getId());
                        authItemReqDto.setSkuCode(r.getCode());
                        authItemReqDtoList.add(authItemReqDto);
                    });
                }
                errorList.addAll(skippedItems);
                errorCount += skippedItems.size();
                if (CollectionUtils.isEmpty(authItemReqDtoList)) {
                    this.logger.warn("\u5ba2\u6237[{}]\u6ca1\u6709\u6709\u6548\u7684\u5546\u54c1\u6388\u6743\u8bb0\u5f55", (Object)customerCode);
                    for (CustomerItemAuthImportDto dto4 : dtoList) {
                        if (skippedItems.contains(dto4)) continue;
                        dto4.setErrorReason("\u6ca1\u6709\u6709\u6548\u7684\u5546\u54c1\u6388\u6743\u8bb0\u5f55;");
                        errorList.add(dto4);
                        ++errorCount;
                    }
                    continue;
                }
                AuthItemRuleRespDto alreadyAuthItemRule = null;
                try {
                    alreadyAuthItemRule = (AuthItemRuleRespDto)RestResponseHelper.extractData((RestResponse)this.authItemRuleService.queryByCustomerId(customer.getId()));
                }
                catch (Exception e) {
                    this.logger.error("\u67e5\u8be2\u5ba2\u6237[{}]\u73b0\u6709\u6388\u6743\u4fe1\u606f\u5f02\u5e38: {}", new Object[]{customerCode, e.getMessage(), e});
                    for (CustomerItemAuthImportDto dto5 : dtoList) {
                        if (skippedItems.contains(dto5)) continue;
                        dto5.setErrorReason("\u67e5\u8be2\u73b0\u6709\u6388\u6743\u4fe1\u606f\u5f02\u5e38: " + e.getMessage() + ";");
                        errorList.add(dto5);
                        ++errorCount;
                    }
                    continue;
                }
                AuthItemRuleReqDto authItemRuleReqDto = new AuthItemRuleReqDto();
                authItemRuleReqDto.setCustomerAuthItemReqDtos(authItemReqDtoList);
                authItemRuleReqDto.setAuthType(Integer.valueOf(2));
                authItemRuleReqDto.setCustomerCode(customer.getCode());
                authItemRuleReqDto.setCustomerId(customer.getId());
                authItemRuleReqDto.setCustomerName(customer.getName());
                authItemRuleReqDto.setOrganizationId(orgId);
                try {
                    if (alreadyAuthItemRule == null || alreadyAuthItemRule.getId() == null) {
                        this.logger.info("\u65b0\u589e\u6388\u6743\uff1a\u5ba2\u6237[{}], \u5546\u54c1\u6570\u91cf[{}]", (Object)customer.getCode(), (Object)authItemReqDtoList.size());
                        RestResponseHelper.extractData((RestResponse)this.authItemRuleApi.addAuthItemRule(authItemRuleReqDto));
                        this.logger.info("\u5ba2\u6237[{}]\u65b0\u589e\u6388\u6743\u6210\u529f", (Object)customer.getCode());
                    } else {
                        authItemRuleReqDto.setId(alreadyAuthItemRule.getId());
                        if (alreadyAuthItemRule.getAuthType() == 2 && CollectionUtils.isNotEmpty((Collection)alreadyAuthItemRule.getCustomerAuthItemRespDtos())) {
                            List importedItemCodes = authItemReqDtoList.stream().map(CustomerAuthItemReqDto::getItemCode).distinct().collect(Collectors.toList());
                            List existingItems = alreadyAuthItemRule.getCustomerAuthItemRespDtos().stream().filter(item -> !importedItemCodes.contains(item.getItemCode())).collect(Collectors.toList());
                            this.logger.info("\u5ba2\u6237[{}]\u5df2\u6709\u6388\u6743\u5546\u54c1\u6570\u91cf[{}], \u672c\u6b21\u65b0\u589e\u5546\u54c1\u6570\u91cf[{}]", new Object[]{customer.getCode(), existingItems.size(), importedItemCodes.size()});
                            if (CollectionUtils.isNotEmpty(existingItems)) {
                                for (CustomerAuthItemRespDto existingItem : existingItems) {
                                    CustomerAuthItemReqDto authItemReqDto = (CustomerAuthItemReqDto)BeanUtil.copyProperties((Object)existingItem, CustomerAuthItemReqDto.class, (String[])new String[0]);
                                    authItemRuleReqDto.getCustomerAuthItemReqDtos().add(authItemReqDto);
                                }
                            }
                        }
                        this.logger.info("\u66f4\u65b0\u6388\u6743\uff1a\u5ba2\u6237[{}], \u5546\u54c1\u603b\u6570\u91cf[{}]", (Object)customer.getCode(), (Object)authItemRuleReqDto.getCustomerAuthItemReqDtos().size());
                        RestResponseHelper.extractData((RestResponse)this.authItemRuleApi.modifyAuthItemRule(authItemRuleReqDto));
                        this.logger.info("\u5ba2\u6237[{}]\u66f4\u65b0\u6388\u6743\u6210\u529f", (Object)customer.getCode());
                    }
                    int validItemCount = dtoList.size() - skippedItems.size();
                    successCount += validItemCount;
                }
                catch (Exception e) {
                    this.logger.error("\u5904\u7406\u5ba2\u6237[{}]\u6388\u6743\u5f02\u5e38\uff1a{}", new Object[]{customerCode, e.getMessage(), e});
                    for (CustomerItemAuthImportDto dto6 : dtoList) {
                        if (skippedItems.contains(dto6) || !StringUtils.isEmpty((CharSequence)dto6.getErrorReason())) continue;
                        dto6.setErrorReason("\u6388\u6743\u64cd\u4f5c\u5f02\u5e38\uff1a" + e.getMessage() + ";");
                        errorList.add(dto6);
                        ++errorCount;
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("\u5904\u7406\u5ba2\u6237[{}]\u6388\u6743\u8fc7\u7a0b\u5f02\u5e38\uff1a{}", new Object[]{customerCode, e.getMessage(), e});
                for (CustomerItemAuthImportDto dto3 : dtoList) {
                    dto3.setErrorReason("\u6388\u6743\u5904\u7406\u5f02\u5e38\uff1a" + e.getMessage() + ";");
                    errorList.add(dto3);
                    ++errorCount;
                }
            }
        }
        this.logger.info("\u5546\u54c1\u6388\u6743\u5bfc\u5165\u5b8c\u6210, \u603b\u8bb0\u5f55\u6570[{}], \u6210\u529f\u6570[{}], \u5931\u8d25\u6570[{}]", new Object[]{totalCount, successCount, errorCount});
        return errorList;
    }

    private Map<String, ItemDetailBaseInfoRespDto> queryAllowSaleItems(List<String> itemCodeList, Long orgId) {
        HashMap<String, ItemDetailBaseInfoRespDto> map = new HashMap<String, ItemDetailBaseInfoRespDto>();
        if (CollectionUtils.isEmpty(itemCodeList)) {
            this.logger.warn("\u67e5\u8be2\u5141\u8d2d\u5546\u54c1\u4f20\u5165\u7684\u5546\u54c1\u7f16\u7801\u5217\u8868\u4e3a\u7a7a");
            return map;
        }
        this.logger.info("\u5f00\u59cb\u67e5\u8be2\u5141\u8d2d\u5546\u54c1\uff0c\u5546\u54c1\u7f16\u7801\u6570\u91cf: {}", (Object)itemCodeList.size());
        try {
            List shopBaseDtoList = (List)RestResponseHelper.extractData((RestResponse)this.shopExtQueryApi.queryShopListBySellerOrgId(orgId));
            if (CollectionUtils.isEmpty((Collection)shopBaseDtoList)) {
                this.logger.warn("\u7ec4\u7ec7[{}]\u4e0b\u672a\u627e\u5230\u4efb\u4f55\u5e97\u94fa\uff0c\u65e0\u6cd5\u67e5\u8be2\u5141\u8d2d\u5546\u54c1", (Object)orgId);
                return map;
            }
            Long shopId = ((ShopBaseDto)shopBaseDtoList.get(0)).getId();
            this.logger.info("\u67e5\u8be2\u7ec4\u7ec7[{}]\u4e0b\u7684\u5e97\u94fa\u6210\u529f\uff0c\u5e97\u94faID: {}, \u5e97\u94fa\u540d\u79f0: {}", new Object[]{orgId, shopId, ((ShopBaseDto)shopBaseDtoList.get(0)).getName()});
            int batchSize = 100;
            List batchedItemCodes = Lists.partition(itemCodeList, (int)batchSize);
            this.logger.info("\u5546\u54c1\u7f16\u7801\u6570\u91cf[{}]\uff0c\u5206\u4e3a[{}]\u6279\u6b21\u67e5\u8be2", (Object)itemCodeList.size(), (Object)batchedItemCodes.size());
            for (int i = 0; i < batchedItemCodes.size(); ++i) {
                List batchItemCodes = (List)batchedItemCodes.get(i);
                this.logger.info("\u5f00\u59cb\u67e5\u8be2\u7b2c[{}]\u6279\u5546\u54c1\uff0c\u5546\u54c1\u7f16\u7801\u6570\u91cf: {}", (Object)(i + 1), (Object)batchItemCodes.size());
                ItemShopQueryReqDto itemShopQueryReqDto = new ItemShopQueryReqDto();
                itemShopQueryReqDto.setItemCodes(batchItemCodes);
                itemShopQueryReqDto.setShopId(shopId);
                itemShopQueryReqDto.setTargetType(Integer.valueOf(2));
                try {
                    List itemInfoList = (List)RestResponseHelper.extractData((RestResponse)this.itemCenterQueryApi.queryShopItemList(itemShopQueryReqDto));
                    if (CollectionUtils.isNotEmpty((Collection)itemInfoList)) {
                        Map batchMap = itemInfoList.stream().collect(Collectors.toMap(ItemDetailBaseInfoRespDto::getCode, Function.identity(), (k1, k2) -> k1));
                        map.putAll(batchMap);
                        List notFoundCodes = batchItemCodes.stream().filter(code -> !batchMap.containsKey(code)).collect(Collectors.toList());
                        if (!notFoundCodes.isEmpty()) {
                            this.logger.warn("\u7b2c[{}]\u6279\u4e2d[{}]\u4e2a\u5546\u54c1\u7f16\u7801\u4e0d\u5728\u5141\u8d2d\u8303\u56f4\u5185: {}", new Object[]{i + 1, notFoundCodes.size(), notFoundCodes.size() <= 10 ? notFoundCodes : notFoundCodes.subList(0, 10) + "\u7b49" + notFoundCodes.size() + "\u4e2a"});
                        }
                        this.logger.info("\u7b2c[{}]\u6279\u67e5\u8be2\u6210\u529f\uff0c\u627e\u5230[{}]\u4e2a\u5141\u8d2d\u5546\u54c1", (Object)(i + 1), (Object)batchMap.size());
                        continue;
                    }
                    this.logger.warn("\u7b2c[{}]\u6279\u67e5\u8be2\u672a\u627e\u5230\u4efb\u4f55\u5141\u8d2d\u5546\u54c1", (Object)(i + 1));
                    continue;
                }
                catch (Exception e) {
                    this.logger.error("\u67e5\u8be2\u7b2c[{}]\u6279\u5141\u8d2d\u5546\u54c1\u5f02\u5e38: {}", new Object[]{i + 1, e.getMessage(), e});
                }
            }
            this.logger.info("\u5141\u8d2d\u5546\u54c1\u67e5\u8be2\u5b8c\u6210\uff0c\u5171\u627e\u5230[{}]\u4e2a\u5141\u8d2d\u5546\u54c1", (Object)map.size());
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u5141\u8d2d\u5546\u54c1\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
        }
        return map;
    }

    private boolean checkItemExists(String itemCode, Long orgId) {
        if (StringUtils.isEmpty((CharSequence)itemCode)) {
            this.logger.warn("\u68c0\u67e5\u5546\u54c1\u662f\u5426\u5b58\u5728\u65f6\u4f20\u5165\u7684\u5546\u54c1\u7f16\u7801\u4e3a\u7a7a");
            return false;
        }
        try {
            List shopBaseDtoList = (List)RestResponseHelper.extractData((RestResponse)this.shopExtQueryApi.queryShopListBySellerOrgId(orgId));
            if (CollectionUtils.isEmpty((Collection)shopBaseDtoList)) {
                this.logger.warn("\u7ec4\u7ec7[{}]\u4e0b\u672a\u627e\u5230\u5e97\u94fa\uff0c\u65e0\u6cd5\u68c0\u67e5\u5546\u54c1\u662f\u5426\u5b58\u5728", (Object)orgId);
                return false;
            }
            Long shopId = ((ShopBaseDto)shopBaseDtoList.get(0)).getId();
            this.logger.info("\u67e5\u8be2\u5230\u5e97\u94faID: {}, \u5f00\u59cb\u68c0\u67e5\u5546\u54c1[{}]\u662f\u5426\u5b58\u5728", (Object)shopId, (Object)itemCode);
            ItemShopQueryReqDto itemShopQueryReqDto = new ItemShopQueryReqDto();
            itemShopQueryReqDto.setItemCodes((List)Lists.newArrayList((Object[])new String[]{itemCode}));
            itemShopQueryReqDto.setShopId(shopId);
            List itemInfoList = (List)RestResponseHelper.extractData((RestResponse)this.itemCenterQueryApi.queryShopItemList(itemShopQueryReqDto));
            boolean exists = CollectionUtils.isNotEmpty((Collection)itemInfoList);
            if (exists) {
                this.logger.info("\u5546\u54c1[{}]\u5b58\u5728\uff0c\u4f46\u4e0d\u5728\u5141\u8d2d\u8303\u56f4\u5185", (Object)itemCode);
            } else {
                this.logger.warn("\u5546\u54c1[{}]\u4e0d\u5b58\u5728", (Object)itemCode);
            }
            return exists;
        }
        catch (Exception e) {
            this.logger.error("\u68c0\u67e5\u5546\u54c1[{}]\u662f\u5426\u5b58\u5728\u65f6\u53d1\u751f\u5f02\u5e38: {}", new Object[]{itemCode, e.getMessage(), e});
            return false;
        }
    }

    public void testCustomerInfoUpdateImport() {
        CustomerInfoUpdateImportDto testDto = new CustomerInfoUpdateImportDto();
        testDto.setCode("YD00001");
        testDto.setName("\u957f\u6c99\u53bf\u548c\u96c5\u76ca\u4e30\u5927\u836f\u623f");
        testDto.setSalesArea("\u9500\u552e\u4e2d\u5fc3");
        testDto.setLargeArea("\u534e\u5357\u533a");
        testDto.setRegionName("\u5e7f\u897f\u4e00\u533a");
        testDto.setCustomerTypeName("\u5355\u4f53\u836f\u5e97");
        testDto.setEasCode("lbx219271929");
        testDto.setCustomerEffectiveTime(this.parseDate("2025/4/17"));
        testDto.setCustomerExpirationTime(this.parseDate("2026/4/17"));
        testDto.setSubjectType("\u4f01\u4e1a");
        testDto.setCreditCode("91430121MAC26NPQ8H");
        testDto.setBusinessLicenseType("\u591a\u8bc1\u5408\u4e00\u8425\u4e1a\u6267\u7167");
        testDto.setBusinessTermType("\u957f\u671f\u6709\u6548");
        testDto.setOrgAddress("\u7ecf\u6d4e\u5f00\u53d1\u533a\u5609\u9675\u6c5f\u8def120\u53f7\u884c\u653f\u697c\u4e09\u697c");
        testDto.setStandardDiscountRate("50.55");
        testDto.setMultiBrandDiscount("\u5065\u529b\u591a:10%\uff0c\u5065\u89c6\u4f73:20%\uff0cLife-space:33%");
        try {
            BigDecimal standardDiscount = this.convertToDiscount(testDto.getStandardDiscountRate());
            this.logger.info("\u6807\u51c6\u6263\u7387\u8f6c\u6362\u6d4b\u8bd5: {}% -> {}", (Object)testDto.getStandardDiscountRate(), (Object)standardDiscount);
        }
        catch (Exception e) {
            this.logger.error("\u6807\u51c6\u6263\u7387\u8f6c\u6362\u6d4b\u8bd5\u5931\u8d25: {}", (Object)e.getMessage());
        }
        try {
            List<PrBaseDiscountBrandReqDto> brandDiscounts = this.parseBrandDiscounts(testDto.getMultiBrandDiscount());
            this.logger.info("\u591a\u54c1\u724c\u6263\u7387\u8f6c\u6362\u6d4b\u8bd5:");
            for (PrBaseDiscountBrandReqDto dto : brandDiscounts) {
                this.logger.info("\u54c1\u724c: {}, \u6263\u7387: {}", (Object)dto.getBrandName(), (Object)dto.getBrandDiscount());
            }
        }
        catch (Exception e) {
            this.logger.error("\u591a\u54c1\u724c\u6263\u7387\u8f6c\u6362\u6d4b\u8bd5\u5931\u8d25: {}", (Object)e.getMessage());
        }
        this.logger.info("\u6d4b\u8bd5\u5ba2\u6237\u4fee\u6539\u5bfc\u5165\u529f\u80fd\u5b8c\u6210");
    }

    private Date parseDate(String dateStr) {
        if (StringUtils.isEmpty((CharSequence)dateStr)) {
            return null;
        }
        Date date = this.parseMultiFormatDate(dateStr);
        if (date == null) {
            this.logger.warn("\u89e3\u6790\u65e5\u671f\u5931\u8d25: {}", (Object)dateStr);
        }
        return date;
    }

    private BigDecimal convertToDiscount(String discountStr) {
        if (StringUtils.isEmpty((CharSequence)discountStr)) {
            return null;
        }
        String standardDiscountStr = discountStr.trim();
        try {
            if (standardDiscountStr.endsWith("%")) {
                standardDiscountStr = standardDiscountStr.substring(0, standardDiscountStr.length() - 1);
                return new BigDecimal(standardDiscountStr);
            }
            return new BigDecimal(standardDiscountStr);
        }
        catch (NumberFormatException e) {
            this.logger.error("\u6263\u7387\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38: {}", (Object)e.getMessage());
            return null;
        }
    }

    private void validateCustomerNameMatching(String creditCode, String cusName, String orgName) {
        block8: {
            if (StringUtils.isEmpty((CharSequence)creditCode) || StringUtils.isEmpty((CharSequence)orgName) || StringUtils.isEmpty((CharSequence)cusName)) {
                this.logger.warn("\u9a8c\u8bc1\u5ba2\u6237\u540d\u79f0\u5339\u914d\u5ea6\u53c2\u6570\u4e0d\u5b8c\u6574: creditCode={}, cusName={}, orgName={}", new Object[]{creditCode, cusName, orgName});
                throw new BizException("\u9a8c\u8bc1\u5ba2\u6237\u540d\u79f0\u5339\u914d\u5ea6\u53c2\u6570\u4e0d\u5b8c\u6574\uff0c\u8bf7\u786e\u4fdd\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u3001\u5ba2\u6237\u540d\u79f0\u548c\u4f01\u4e1a\u7ec4\u7ec7\u540d\u79f0\u90fd\u5df2\u586b\u5199");
            }
            try {
                double similarity = ObjectSimilarityUtil.computeSimilarity(cusName, orgName);
                this.logger.info("\u5ba2\u6237\u540d\u79f0[{}]\u4e0e\u4f01\u4e1a\u7ec4\u7ec7\u540d\u79f0[{}]\u7684\u76f8\u4f3c\u5ea6\u4e3a: {}", new Object[]{cusName, orgName, similarity});
                if (similarity < 0.6) {
                    this.logger.warn("\u5ba2\u6237\u540d\u79f0\u76f8\u4f3c\u5ea6\u8fc7\u4f4e: {}\uff0c\u4f4e\u4e8e\u9608\u503c: {}", (Object)similarity, (Object)0.6);
                    throw new BizException("\u5ba2\u6237\u540d\u79f0\u4e0e\u4f01\u4e1a\u7ec4\u7ec7\u540d\u79f0\u76f8\u4f3c\u5ea6\u8fc7\u4f4e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4e3a\u540c\u4e00\u5ba2\u6237");
                }
                try {
                    ComputeCustomerNameRateReqDto reqDto = ComputeCustomerNameRateReqDto.builder().orgName(orgName).cusName(cusName).creditCode(creditCode).build();
                    this.logger.info("\u8c03\u7528API\u9a8c\u8bc1\u5ba2\u6237\u540d\u79f0\u5339\u914d\u5ea6: {}", (Object)JSON.toJSONString((Object)reqDto));
                    RestResponseHelper.checkOrThrow((RestResponse)this.customerExtThreeApi.computeCustomerNameRate(reqDto));
                    this.logger.info("\u5ba2\u6237\u540d\u79f0\u5339\u914d\u5ea6API\u9a8c\u8bc1\u901a\u8fc7");
                }
                catch (Exception e) {
                    this.logger.error("\u8c03\u7528API\u9a8c\u8bc1\u5ba2\u6237\u540d\u79f0\u5339\u914d\u5ea6\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
                    if (similarity >= 0.8) {
                        this.logger.warn("API\u9a8c\u8bc1\u5931\u8d25\uff0c\u4f46\u5ba2\u6237\u540d\u79f0\u76f8\u4f3c\u5ea6\u8db3\u591f\u9ad8({}>=0.8)\uff0c\u5141\u8bb8\u66f4\u65b0\u5ba2\u6237\u4fe1\u606f", (Object)similarity);
                        break block8;
                    }
                    throw new BizException("\u5ba2\u6237\u540d\u79f0\u5339\u914d\u5ea6\u9a8c\u8bc1\u5931\u8d25: " + e.getMessage());
                }
            }
            catch (BizException e) {
                throw e;
            }
            catch (Exception e) {
                this.logger.error("\u9a8c\u8bc1\u5ba2\u6237\u540d\u79f0\u5339\u914d\u5ea6\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
                throw new BizException("\u9a8c\u8bc1\u5ba2\u6237\u540d\u79f0\u5339\u914d\u5ea6\u51fa\u73b0\u5f02\u5e38: " + e.getMessage());
            }
        }
    }

    private Date parseMultiFormatDate(String dateStr) {
        String[] dateFormats;
        if (StringUtils.isEmpty((CharSequence)dateStr)) {
            return null;
        }
        for (String format : dateFormats = new String[]{"yyyy-MM-dd", "yyyy/MM/dd", "dd/MM/yyyy", "MM/dd/yyyy", "yyyy\u5e74MM\u6708dd\u65e5", "EEE MMM dd HH:mm:ss zzz yyyy", "yyyy.MM.dd"}) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                sdf.setLenient(false);
                return sdf.parse(dateStr.trim());
            }
            catch (ParseException parseException) {
            }
        }
        this.logger.warn("\u65e0\u6cd5\u89e3\u6790\u65e5\u671f\u5b57\u7b26\u4e32: {}", (Object)dateStr);
        return null;
    }

    private void checkCreditByCustomerCode(CheckCreditByCustomerCodeReqDto dto) {
        if (dto == null) {
            this.logger.error("\u68c0\u67e5\u4fe1\u7528\u4ee3\u7801\u53c2\u6570\u4e3a\u7a7a");
            throw new BizException("\u68c0\u67e5\u4fe1\u7528\u4ee3\u7801\u53c2\u6570\u4e3a\u7a7a");
        }
        this.logger.info("\u5f00\u59cb\u6821\u9a8c\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801 - \u4fe1\u7528\u4ee3\u7801:[{}], \u5ba2\u6237\u540d\u79f0:[{}], \u4f01\u4e1a\u540d\u79f0:[{}]", new Object[]{dto.getCreditCode(), dto.getCusName(), dto.getOrgName()});
        if (StringUtils.isEmpty((CharSequence)dto.getCreditCode())) {
            this.logger.error("\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e3a\u7a7a");
            throw new BizException("\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)dto.getCusName()) && StringUtils.isEmpty((CharSequence)dto.getOrgName())) {
            this.logger.error("\u5ba2\u6237\u540d\u79f0\u548c\u4f01\u4e1a\u540d\u79f0\u5747\u4e3a\u7a7a");
            throw new BizException("\u5ba2\u6237\u540d\u79f0\u548c\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        try {
            ComputeCustomerNameRateReqDto reqDto = new ComputeCustomerNameRateReqDto();
            reqDto.setCreditCode(dto.getCreditCode());
            if (StringUtils.isNotEmpty((CharSequence)dto.getCusName())) {
                reqDto.setCusName(dto.getCusName());
            }
            if (StringUtils.isNotEmpty((CharSequence)dto.getOrgName())) {
                reqDto.setOrgName(dto.getOrgName());
            }
            RestResponseHelper.checkOrThrow((RestResponse)this.customerExtThreeApi.computeCustomerNameRate(reqDto));
            this.logger.info("\u5ba2\u6237\u540d\u79f0\u5339\u914d\u7387\u9a8c\u8bc1\u901a\u8fc7: {}", (Object)JSONObject.toJSONString((Object)reqDto));
        }
        catch (BizException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.error("\u8ba1\u7b97\u5ba2\u6237\u540d\u79f0\u5339\u914d\u7387\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
            throw new BizException("\u9a8c\u8bc1\u5ba2\u6237\u540d\u79f0\u5339\u914d\u7387\u5f02\u5e38: " + e.getMessage());
        }
    }

    private static class CheckCreditByCustomerCodeReqDto {
        private String creditCode;
        private String cusName;
        private String orgName;

        private CheckCreditByCustomerCodeReqDto() {
        }

        public String getCreditCode() {
            return this.creditCode;
        }

        public void setCreditCode(String creditCode) {
            this.creditCode = creditCode;
        }

        public String getCusName() {
            return this.cusName;
        }

        public void setCusName(String cusName) {
            this.cusName = cusName;
        }

        public String getOrgName() {
            return this.orgName;
        }

        public void setOrgName(String orgName) {
            this.orgName = orgName;
        }
    }

    private static class ObjectSimilarityUtil {
        private static final JaroWinklerSimilarity SIMILARITY = new JaroWinklerSimilarity();

        private ObjectSimilarityUtil() {
        }

        public static double computeSimilarity(String str1, String str2) {
            if (StringUtils.isEmpty((CharSequence)str1) || StringUtils.isEmpty((CharSequence)str2)) {
                return 0.0;
            }
            return SIMILARITY.apply((CharSequence)str1, (CharSequence)str2);
        }
    }
}

