/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.source.biz.service.calculator.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.center.source.api.constant.ClueWarehouseGroupTypeEnum;
import com.dtyunxi.cube.center.source.api.constant.EnableEnum;
import com.dtyunxi.cube.center.source.api.constant.SgDictEnum;
import com.dtyunxi.cube.center.source.api.constant.SourceFindOptTypeEnum;
import com.dtyunxi.cube.center.source.api.constant.SourceStatusEnum;
import com.dtyunxi.cube.center.source.api.dto.response.ClueActRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.ClueDeliveryWarehouseBlackRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.ClueWarehouseGroupActRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.ClueWarehouseGroupRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.ClueWarehouseItemBlackListRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.OrderItemRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.PhysicsWarehouseDisableRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.SourceOrderResultRespDto;
import com.dtyunxi.cube.center.source.api.exception.SourceAssert;
import com.dtyunxi.cube.center.source.api.exception.SourceExceptionCode;
import com.dtyunxi.cube.center.source.biz.service.IClueDeliveryWarehouseBlackService;
import com.dtyunxi.cube.center.source.biz.service.IClueWarehouseItemBlackListService;
import com.dtyunxi.cube.center.source.biz.service.calculator.SourceOrderGroupCalculator;
import com.dtyunxi.cube.center.source.biz.service.calculator.SourceOrderGroupRuleCalculator;
import com.dtyunxi.cube.center.source.biz.service.impl.WarehouseDataQuery;
import com.dtyunxi.cube.center.source.biz.utils.SourceExecuteUtils;
import com.dtyunxi.cube.center.source.biz.vo.ClueWarehouseGroupTypeGroupVo;
import com.dtyunxi.cube.center.source.biz.vo.SourceExecuteContextVo;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.basics.CsInventoryBasicsQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehousePageRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsLogicWarehouseQualityEnum;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehouseDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgPhysicsWarehouseDto;
import com.yunxi.dg.base.center.share.enums.WarehouseClassifyEnum;
import com.yunxi.dg.base.commons.dto.BaseDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SourceOrderGroupCalculatorImpl
implements SourceOrderGroupCalculator {
    private static final Logger logger = LoggerFactory.getLogger(SourceOrderGroupCalculatorImpl.class);
    private static final boolean normalGroupFlag = false;
    @Resource
    private WarehouseDataQuery warehouseDataQuery;
    @Resource
    private SourceOrderGroupCalculator sourceOrderGroupCalculator;
    @Resource
    private IClueDeliveryWarehouseBlackService clueDeliveryWarehouseBlackService;
    @Resource
    private SourceOrderGroupRuleCalculator sourceOrderGroupRuleCalculator;
    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Resource
    private IClueWarehouseItemBlackListService clueWarehouseItemBlackListService;

    @Override
    public SourceOrderResultRespDto calculationSourceGroup(SourceExecuteContextVo sourceExecuteContextVo) {
        SourceOrderResultRespDto sourceOrderResultRespDto = this.buildSourceResultByOrderDetailRespDto(sourceExecuteContextVo.getOrderDetailRespDto());
        try {
            ClueActRespDto clueActRespDto = sourceExecuteContextVo.getCurrentClueActRespDto();
            List<Object> csLogicWarehousePageRespDtoList = Lists.newArrayList();
            List logicWarehouseList = sourceExecuteContextVo.getShareChannelWarehouseRespDto().getLogicWarehouseList();
            List<String> logicWarehouseCodes = logicWarehouseList.stream().map(CsLogicWarehouseRespDto::getWarehouseCode).collect(Collectors.toList());
            if (Objects.equals(sourceExecuteContextVo.getOrderDetailRespDto().getSgSourceCanSplit(), 0) && CollectionUtils.isNotEmpty(sourceExecuteContextVo.getRdcLogicWarehousePageRespDtoList())) {
                List rdcLogicCodeList = sourceExecuteContextVo.getRdcLogicWarehousePageRespDtoList().stream().map(CsLogicWarehouseRespDto::getWarehouseCode).collect(Collectors.toList());
                logicWarehouseCodes = logicWarehouseCodes.stream().filter(s -> rdcLogicCodeList.contains(s)).collect(Collectors.toList());
                logger.info("\u6307\u5b9a\u4f9b\u8d27\u4ed3\u4e0b\u7684\u903b\u8f91\u4ed3\u548c\u6e20\u9053\u4ed3\u4e0b\u7684\u903b\u8f91\u4ed3\u4ea4\u96c6={}", JSON.toJSON(logicWarehouseCodes));
                if (CollectionUtils.isEmpty(logicWarehouseCodes)) {
                    SourceExecuteUtils.completionSourceOrderResultRespDtoByFailMsg(SourceFindOptTypeEnum.CAL_WAREHOUSE_GROUP, sourceExecuteContextVo, sourceOrderResultRespDto, "\u5927\u5ba2\u6237\u6307\u5b9a\u4f9b\u8d27\u4ed3\u4e0b\u7684\u903b\u8f91\u4ed3\u548c\u6e20\u9053\u4ed3\u4e0b\u7684\u903b\u8f91\u4ed3\u4ea4\u96c6\u4fe1\u606f\u4e3a\u7a7a");
                    return sourceOrderResultRespDto;
                }
            }
            csLogicWarehousePageRespDtoList = this.warehouseDataQuery.queryCsLogicWarehousePageRespDtoListByCodeList(logicWarehouseCodes);
            if (CollectionUtils.isEmpty((Collection)(csLogicWarehousePageRespDtoList = csLogicWarehousePageRespDtoList.stream().filter(e -> Objects.equals(CsLogicWarehouseQualityEnum.QUALIFIED.getCode(), e.getWarehouseQuality()) && Objects.equals(e.getWarehouseClassify(), WarehouseClassifyEnum.LOGIC.getCode())).collect(Collectors.toList())))) {
                SourceExecuteUtils.completionSourceOrderResultRespDtoByFailMsg(SourceFindOptTypeEnum.CAL_WAREHOUSE_GROUP, sourceExecuteContextVo, sourceOrderResultRespDto, "\u83b7\u53d6\u4e0d\u5230\u6e20\u9053\u4ed3\u5173\u8054\u7684\u5408\u683c\u903b\u8f91\u4ed3\u6570\u636e");
                return sourceOrderResultRespDto;
            }
            String cargoEscheatageCode = sourceExecuteContextVo.getOrderDetailRespDto().getCargoEscheatageCode();
            if (StringUtils.isNotEmpty((CharSequence)cargoEscheatageCode)) {
                csLogicWarehousePageRespDtoList = csLogicWarehousePageRespDtoList.stream().filter(e -> Objects.equals(e.getCargoEscheatageId(), cargoEscheatageCode)).collect(Collectors.toList());
            }
            if (CollectionUtils.isEmpty(csLogicWarehousePageRespDtoList)) {
                SourceExecuteUtils.completionSourceOrderResultRespDtoByFailMsg(SourceFindOptTypeEnum.CAL_WAREHOUSE_GROUP, sourceExecuteContextVo, sourceOrderResultRespDto, "\u8d27\u8865\u5bfb\u6e90\u672a\u5339\u914d\u5230\u8d27\u6743\u7ec4\u7ec7[" + cargoEscheatageCode + "]\u4e0b\u7684\u903b\u8f91\u4ed3");
                return sourceOrderResultRespDto;
            }
            List<Object> afterFilterWarehouseList = csLogicWarehousePageRespDtoList;
            if (Objects.equals(clueActRespDto.getWarehouseBlackList(), EnableEnum.ENABLE.code)) {
                List<ClueDeliveryWarehouseBlackRespDto> deliveryWarehouseBlackRespDtoList = this.clueDeliveryWarehouseBlackService.queryByClueId(sourceExecuteContextVo.getCurrentClueActRespDto().getId());
                afterFilterWarehouseList = this.afterFilterDeliveryWarehouseBlack(afterFilterWarehouseList, deliveryWarehouseBlackRespDtoList);
            }
            afterFilterWarehouseList = this.afterFilterWarehouse(afterFilterWarehouseList, sourceExecuteContextVo.getPhysicsWarehouseDisableRespDtoList());
            sourceExecuteContextVo.setCurrentClueFilterCsRelWarehouseRespDtoList(afterFilterWarehouseList);
            if (CollectionUtils.isEmpty(afterFilterWarehouseList)) {
                SourceExecuteUtils.completionSourceOrderResultRespDtoByFailMsg(SourceFindOptTypeEnum.CAL_WAREHOUSE_GROUP, sourceExecuteContextVo, sourceOrderResultRespDto, "\u903b\u8f91\u4ed3\u88ab\u7981\u7528:" + this.buildWarehouseListString(csLogicWarehousePageRespDtoList));
                return sourceOrderResultRespDto;
            }
            String organizationCode = sourceExecuteContextVo.getOrderDetailRespDto().getOrganizationCode();
            Collections.sort(afterFilterWarehouseList, (o1, o2) -> {
                if (Objects.equals(o1.getCargoEscheatageId(), organizationCode)) {
                    return -1;
                }
                if (Objects.equals(o2.getCargoEscheatageId(), organizationCode)) {
                    return 1;
                }
                return 0;
            });
            List<ClueWarehouseGroupTypeGroupVo> clueWarehouseGroupTypeGroupVos = this.sourceOrderGroupCalculator.groupByClueGroupType(clueActRespDto, afterFilterWarehouseList, sourceExecuteContextVo.getOrderDetailRespDto(), sourceExecuteContextVo);
            logger.info("\u8fc7\u6ee4\u540e\u7684\u903b\u8f91\u4ed3={}", JSON.toJSON(clueWarehouseGroupTypeGroupVos));
            if (CollectionUtils.isEmpty(clueWarehouseGroupTypeGroupVos)) {
                SourceExecuteUtils.completionSourceOrderResultRespDtoByFailMsg(SourceFindOptTypeEnum.CAL_WAREHOUSE_GROUP, sourceExecuteContextVo, sourceOrderResultRespDto, "\u7b56\u7565\u903b\u8f91\u4ed3\u5206\u7ec4\u5931\u8d25:" + clueActRespDto.getClueCode());
                return sourceOrderResultRespDto;
            }
            SourceExecuteUtils.saveOrderResourceLog(SourceFindOptTypeEnum.CAL_WAREHOUSE_GROUP, sourceExecuteContextVo, clueWarehouseGroupTypeGroupVos);
            List<ClueWarehouseItemBlackListRespDto> clueWarehouseItemBlackListRespDtos = this.clueWarehouseItemBlackListService.queryByClueId(sourceExecuteContextVo.getCurrentClueActRespDto().getId());
            sourceExecuteContextVo.getCurrentClueActRespDto().setClueItemBlacklist(clueWarehouseItemBlackListRespDtos);
            return this.sourceOrderGroupRuleCalculator.calculationSourceGroupRule(clueWarehouseGroupTypeGroupVos, sourceExecuteContextVo);
        }
        catch (Exception e2) {
            logger.error(e2.getMessage(), (Throwable)e2);
            SourceExecuteUtils.completionSourceOrderResultRespDtoByFailMsg(SourceFindOptTypeEnum.CAL_WAREHOUSE_GROUP, sourceExecuteContextVo, sourceOrderResultRespDto, e2.getMessage());
            return sourceOrderResultRespDto;
        }
    }

    private void getTargeAndTotalPhysicsCodeSet(SourceExecuteContextVo sourceExecuteContextVo, List<DgLogicWarehouseDto> csLogicWarehousePageRespDtoList, String organizationCode) {
        List<Object> rdcLogicWarehouseCodeList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(sourceExecuteContextVo.getRdcLogicWarehousePageRespDtoList())) {
            rdcLogicWarehouseCodeList = sourceExecuteContextVo.getRdcLogicWarehousePageRespDtoList().stream().filter(dto -> Objects.equals(dto.getOrganizationCode(), organizationCode)).map(CsLogicWarehouseRespDto::getWarehouseCode).collect(Collectors.toList());
        }
        Map<String, DgPhysicsWarehouseDto> physicsWarehousePageRespDtoMap = sourceExecuteContextVo.getCurrentBeforeClueGroupTypePhysicsRespDtoList().stream().collect(Collectors.toMap(DgPhysicsWarehouseDto::getWarehouseCode, v1 -> v1));
        for (DgLogicWarehouseDto csLogicWarehousePageRespDto : csLogicWarehousePageRespDtoList) {
            DgPhysicsWarehouseDto csPhysicsWarehousePageRespDto;
            if (rdcLogicWarehouseCodeList.contains(csLogicWarehousePageRespDto.getWarehouseCode())) {
                sourceExecuteContextVo.getCurrentTargePhysicsRespDtoSet().add(csLogicWarehousePageRespDto.getPhysicsWarehouseCode());
            }
            if (!Objects.nonNull(csPhysicsWarehousePageRespDto = physicsWarehousePageRespDtoMap.get(csLogicWarehousePageRespDto.getPhysicsWarehouseCode())) || !this.decideWarehouseIsTotal(csPhysicsWarehousePageRespDto)) continue;
            sourceExecuteContextVo.getCurrentTotalPhysicsRespDtoSet().add(csLogicWarehousePageRespDto.getPhysicsWarehouseCode());
        }
        logger.info("\u76ee\u6807\u4ed3\u4e0b\u7684\u7269\u7406\u4ed3:{}", (Object)JSON.toJSONString(sourceExecuteContextVo.getCurrentTargePhysicsRespDtoSet()));
        logger.info("\u603b\u4ed3\u4e0b\u7684\u7269\u7406\u4ed3:{}", (Object)JSON.toJSONString(sourceExecuteContextVo.getCurrentTotalPhysicsRespDtoSet()));
    }

    @Override
    public List<ClueWarehouseGroupTypeGroupVo> groupByClueGroupType(ClueActRespDto clueActRespDto, List<DgLogicWarehouseDto> csLogicWarehousePageRespDtoList, OrderDetailRespDto orderDetailRespDto, SourceExecuteContextVo sourceExecuteContextVo) {
        if (CollectionUtils.isEmpty((Collection)clueActRespDto.getClueWarehouseGroupActRespDtoList())) {
            return null;
        }
        ArrayList<ClueWarehouseGroupTypeGroupVo> groupTypeGroupVos = new ArrayList<ClueWarehouseGroupTypeGroupVo>();
        LinkedList<DgLogicWarehouseDto> filterList = new LinkedList<DgLogicWarehouseDto>();
        CubeBeanUtils.copyCollection(filterList, csLogicWarehousePageRespDtoList, DgLogicWarehouseDto.class);
        List<String> physicsCodeList = filterList.stream().map(DgLogicWarehouseDto::getPhysicsWarehouseCode).distinct().collect(Collectors.toList());
        List<DgPhysicsWarehouseDto> physicsWarehouseDtoList = this.warehouseDataQuery.queryPhysicsWarehouseByIds(physicsCodeList);
        logger.info("\u83b7\u53d6\u903b\u8f91\u4ed3\u4e0b\u7684\u5bf9\u5e94\u7269\u7406\u4ed3:{}" + JSON.toJSONString(physicsWarehouseDtoList));
        sourceExecuteContextVo.setCurrentBeforeClueGroupTypePhysicsRespDtoList(physicsWarehouseDtoList);
        this.getTargeAndTotalPhysicsCodeSet(sourceExecuteContextVo, csLogicWarehousePageRespDtoList, orderDetailRespDto.getOrganizationCode());
        this.groupByWarehouseGroupSort(clueActRespDto, orderDetailRespDto, sourceExecuteContextVo, groupTypeGroupVos, filterList, physicsWarehouseDtoList);
        return groupTypeGroupVos;
    }

    private void groupByFixedSort(ClueActRespDto clueActRespDto, OrderDetailRespDto orderDetailRespDto, SourceExecuteContextVo sourceExecuteContextVo, List<ClueWarehouseGroupTypeGroupVo> groupTypeGroupVos, List<DgLogicWarehouseDto> filterList, List<DgPhysicsWarehouseDto> physicsWarehouseDtoList) {
        Map<String, ClueWarehouseGroupActRespDto> matchGroupMap = clueActRespDto.getClueWarehouseGroupActRespDtoList().stream().collect(Collectors.toMap(ClueWarehouseGroupRespDto::getWarehouseGroupType, v1 -> v1));
        if (matchGroupMap.containsKey(ClueWarehouseGroupTypeEnum.TARGET.getCode())) {
            groupTypeGroupVos.add(this.buildClueWarehouseGroupTypeGroupVo(matchGroupMap.get(ClueWarehouseGroupTypeEnum.TARGET.getCode()), ClueWarehouseGroupTypeEnum.TARGET, this.filterWarehouseGroupType4TargetRdc(sourceExecuteContextVo.getRdcLogicWarehousePageRespDtoList(), filterList, orderDetailRespDto.getOrganizationCode())));
        }
        if (matchGroupMap.containsKey(ClueWarehouseGroupTypeEnum.OLD_BATCH.getCode())) {
            groupTypeGroupVos.add(this.buildClueWarehouseGroupTypeGroupVo(matchGroupMap.get(ClueWarehouseGroupTypeEnum.OLD_BATCH.getCode()), ClueWarehouseGroupTypeEnum.OLD_BATCH, this.filterWarehouseGroupType4OldBatch(filterList, orderDetailRespDto, sourceExecuteContextVo.getDictDtoMap(), sourceExecuteContextVo.getCurrentClueActRespDto())));
        }
        if (matchGroupMap.containsKey(ClueWarehouseGroupTypeEnum.TOTAL.getCode())) {
            groupTypeGroupVos.add(this.buildClueWarehouseGroupTypeGroupVo(matchGroupMap.get(ClueWarehouseGroupTypeEnum.TOTAL.getCode()), ClueWarehouseGroupTypeEnum.TOTAL, this.filterWarehouseGroupType4Total(filterList, physicsWarehouseDtoList)));
        }
        if (matchGroupMap.containsKey(ClueWarehouseGroupTypeEnum.OTHER.getCode())) {
            groupTypeGroupVos.add(this.buildClueWarehouseGroupTypeGroupVo(matchGroupMap.get(ClueWarehouseGroupTypeEnum.OTHER.getCode()), ClueWarehouseGroupTypeEnum.OTHER, this.filterWarehouseGroupType4Other(filterList)));
        }
        if (matchGroupMap.containsKey(ClueWarehouseGroupTypeEnum.TARGET_SAME_PHYSICS.getCode())) {
            groupTypeGroupVos.add(this.buildClueWarehouseGroupTypeGroupVo(matchGroupMap.get(ClueWarehouseGroupTypeEnum.TARGET_SAME_PHYSICS.getCode()), ClueWarehouseGroupTypeEnum.TARGET_SAME_PHYSICS, this.filterWarehouseGroupType4TargetSamePhysics(filterList, sourceExecuteContextVo.getCurrentTargePhysicsRespDtoSet())));
        }
    }

    private void groupByWarehouseGroupSort(ClueActRespDto clueActRespDto, OrderDetailRespDto orderDetailRespDto, SourceExecuteContextVo sourceExecuteContextVo, List<ClueWarehouseGroupTypeGroupVo> groupTypeGroupVos, List<DgLogicWarehouseDto> filterList, List<DgPhysicsWarehouseDto> physicsWarehouseDtoList) {
        clueActRespDto.getClueWarehouseGroupActRespDtoList().forEach(dto -> {
            switch (ClueWarehouseGroupTypeEnum.forCode((String)dto.getWarehouseGroupType())) {
                case TARGET: {
                    groupTypeGroupVos.add(this.buildClueWarehouseGroupTypeGroupVo((ClueWarehouseGroupActRespDto)dto, ClueWarehouseGroupTypeEnum.TARGET, this.filterWarehouseGroupType4TargetRdc(sourceExecuteContextVo.getRdcLogicWarehousePageRespDtoList(), filterList, orderDetailRespDto.getOrganizationCode())));
                    break;
                }
                case OLD_BATCH: {
                    groupTypeGroupVos.add(this.buildClueWarehouseGroupTypeGroupVo((ClueWarehouseGroupActRespDto)dto, ClueWarehouseGroupTypeEnum.OLD_BATCH, this.filterWarehouseGroupType4OldBatch(filterList, orderDetailRespDto, sourceExecuteContextVo.getDictDtoMap(), sourceExecuteContextVo.getCurrentClueActRespDto())));
                    break;
                }
                case TOTAL: {
                    groupTypeGroupVos.add(this.buildClueWarehouseGroupTypeGroupVo((ClueWarehouseGroupActRespDto)dto, ClueWarehouseGroupTypeEnum.TOTAL, this.filterWarehouseGroupType4Total(filterList, physicsWarehouseDtoList)));
                    break;
                }
                case OTHER: {
                    groupTypeGroupVos.add(this.buildClueWarehouseGroupTypeGroupVo((ClueWarehouseGroupActRespDto)dto, ClueWarehouseGroupTypeEnum.OTHER, this.filterWarehouseGroupType4Other(filterList)));
                    break;
                }
                case TARGET_SAME_PHYSICS: {
                    groupTypeGroupVos.add(this.buildClueWarehouseGroupTypeGroupVo((ClueWarehouseGroupActRespDto)dto, ClueWarehouseGroupTypeEnum.TARGET_SAME_PHYSICS, this.filterWarehouseGroupType4TargetSamePhysics(filterList, sourceExecuteContextVo.getCurrentTargePhysicsRespDtoSet())));
                    break;
                }
                default: {
                    throw SourceExceptionCode.SOURCE_EXECUTE_GROUP_TYPE_FOR_ERROR.buildBizException(new String[]{dto.getWarehouseGroupType()});
                }
            }
        });
    }

    private ClueWarehouseGroupTypeGroupVo buildClueWarehouseGroupTypeGroupVo(ClueWarehouseGroupActRespDto clueWarehouseGroupActRespDto, ClueWarehouseGroupTypeEnum typeEnum, List<DgLogicWarehouseDto> csLogicWarehousePageRespDtoList) {
        ClueWarehouseGroupTypeGroupVo clueWarehouseGroupTypeGroupVo = new ClueWarehouseGroupTypeGroupVo();
        clueWarehouseGroupTypeGroupVo.setClueWarehouseGroupTypeEnum(typeEnum);
        clueWarehouseGroupTypeGroupVo.setCsLogicWarehousePageRespDtoList(csLogicWarehousePageRespDtoList);
        clueWarehouseGroupTypeGroupVo.setClueWarehouseGroupActRespDto(clueWarehouseGroupActRespDto);
        return clueWarehouseGroupTypeGroupVo;
    }

    private List<DgLogicWarehouseDto> filterWarehouseGroupType4TargetRdc(List<CsLogicWarehouseRespDto> rdcLogicWarehousePageRespDtoList, List<DgLogicWarehouseDto> csLogicWarehousePageRespDtoList, String organizationCode) {
        ArrayList<DgLogicWarehouseDto> logicWarehousePageRespDtoList = new ArrayList<DgLogicWarehouseDto>();
        ArrayList removeList = new ArrayList();
        List<Object> rdcLogicWarehouseCodeList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(rdcLogicWarehousePageRespDtoList)) {
            rdcLogicWarehouseCodeList = rdcLogicWarehousePageRespDtoList.stream().filter(dto -> Objects.equals(dto.getOrganizationCode(), organizationCode)).map(CsLogicWarehouseRespDto::getWarehouseCode).collect(Collectors.toList());
        }
        logger.info("\u540c\u7ec4\u7ec7\u4e0b\u4f9b\u8d27\u4ed3\u4e0b\u7684\u903b\u8f91\u4ed3={}", JSON.toJSON((Object)rdcLogicWarehouseCodeList));
        ArrayList finalRdcLogicWarehouseCodeList = rdcLogicWarehouseCodeList;
        csLogicWarehousePageRespDtoList.forEach(csLogicWarehousePageRespDto -> {
            if (finalRdcLogicWarehouseCodeList.contains(csLogicWarehousePageRespDto.getWarehouseCode())) {
                removeList.add(csLogicWarehousePageRespDto);
                logicWarehousePageRespDtoList.add((DgLogicWarehouseDto)csLogicWarehousePageRespDto);
            }
        });
        removeList.forEach(csLogicWarehousePageRespDtoList::remove);
        return logicWarehousePageRespDtoList;
    }

    private boolean decideWarehouseIsTarget(OrderDetailRespDto orderDetailRespDto, CsLogicWarehousePageRespDto csLogicWarehousePageRespDto) {
        return Objects.equals(orderDetailRespDto.getLinkOrderLogicWarehouseCode(), csLogicWarehousePageRespDto.getWarehouseCode());
    }

    private boolean decideWarehouseIsOldBatch(DictDto spaceValue, DictDto spaceType, CsInventoryBasicsQueryRespDto csLogicWarehousePageRespDto) {
        SourceAssert.notBlank((String)csLogicWarehousePageRespDto.getBatch(), (SourceExceptionCode)SourceExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{csLogicWarehousePageRespDto.getLongCode() + "\u5e93\u5b58\u6279\u6b21\u53f7\u5f02\u5e38"});
        if (!"month".equals(spaceType.getValue())) {
            throw SourceExceptionCode.NORMAL_EXCEPTION.buildBizException(new String[]{"\u901a\u7528\u914d\u7f6e-\u65e7\u6279\u6b21-\u65e5\u671f\u7c7b\u578b\u9519\u8bef"});
        }
        Date produceTime = csLogicWarehousePageRespDto.getProduceTime();
        if (produceTime == null) {
            logger.info("\u6279\u6b21\u4e3a:{},\u751f\u4ea7\u65e5\u671f\u4e3a\u7a7a", (Object)csLogicWarehousePageRespDto.getBatch());
            return false;
        }
        String currBatchDateString = DateUtil.getDateFormat((Date)produceTime, (String)"yyyyMM");
        Date batchDate = DateUtil.parseDate((String)currBatchDateString, (String)"yyyyMM");
        Date addDate = DateUtil.addMonths((Date)batchDate, (int)Integer.parseInt(spaceValue.getValue()));
        return addDate.compareTo(DateUtil.getMonthBegin()) < 0;
    }

    private boolean decideWarehouseIsTotal(DgPhysicsWarehouseDto physicsWarehousePageRespDto) {
        return "0".equals(String.valueOf(physicsWarehousePageRespDto.getRdcFlag()));
    }

    private List<DgLogicWarehouseDto> filterWarehouseGroupType4OldBatch(List<DgLogicWarehouseDto> csLogicWarehousePageRespDtoList, OrderDetailRespDto orderDetailRespDto, Map<String, DictDto> dictDtoMap, ClueActRespDto currentClueActRespDto) {
        List<String> skuCodeList;
        List<String> warehouseCodeList = csLogicWarehousePageRespDtoList.stream().map(DgLogicWarehouseDto::getWarehouseCode).collect(Collectors.toList());
        List<CsInventoryBasicsQueryRespDto> csInventoryBasicsQueryRespDtoList = this.warehouseDataQuery.queryCsLogicInventoryBalance(warehouseCodeList, skuCodeList = orderDetailRespDto.getOrderItemRespDtoList().stream().map(OrderItemRespDto::getItemSkuCode).collect(Collectors.toList()));
        if (CollectionUtils.isEmpty(csInventoryBasicsQueryRespDtoList)) {
            return new ArrayList<DgLogicWarehouseDto>();
        }
        Map<Long, List<CsInventoryBasicsQueryRespDto>> csInventoryBasicsQueryRespDtoMap = csInventoryBasicsQueryRespDtoList.stream().collect(Collectors.groupingBy(CsInventoryBasicsQueryRespDto::getWarehouseId));
        DictDto spaceValue = dictDtoMap.get(SgDictEnum.SOURCE_SETTING_OLD_BATCH.getCode());
        DictDto spaceType = dictDtoMap.get(SgDictEnum.SOURCE_SETTING_OLD_BATCH_TYPE.getCode());
        SourceAssert.notNull((Object)spaceValue, (SourceExceptionCode)SourceExceptionCode.SOURCE_EXECUTE_DATA_QUERY_EMPTY, (String[])new String[]{"\u901a\u7528\u914d\u7f6e-\u65e7\u6279\u6b21\u6570\u503c", ""});
        SourceAssert.notNull((Object)spaceType, (SourceExceptionCode)SourceExceptionCode.SOURCE_EXECUTE_DATA_QUERY_EMPTY, (String[])new String[]{"\u901a\u7528\u914d\u7f6e-\u65e7\u6279\u6b21\u7c7b\u578b", ""});
        if (Objects.equals(currentClueActRespDto.getClueOldBatch(), EnableEnum.ENABLE.code)) {
            spaceValue.setValue(currentClueActRespDto.getClueOldBatchMonth() + "");
        }
        Map<Long, DgLogicWarehouseDto> warehousePageRespDtoMap = csLogicWarehousePageRespDtoList.stream().collect(Collectors.toMap(BaseDto::getId, v1 -> v1));
        ArrayList<DgLogicWarehouseDto> logicWarehousePageRespDtoList = new ArrayList<DgLogicWarehouseDto>();
        ArrayList removeList = new ArrayList();
        csInventoryBasicsQueryRespDtoMap.forEach((warehouseId, dtoList) -> {
            List afterFilterList = dtoList.stream().filter(dto -> Objects.nonNull(dto.getAvailable()) && BigDecimal.ZERO.compareTo(dto.getAvailable()) < 0).collect(Collectors.toList());
            for (CsInventoryBasicsQueryRespDto dto2 : afterFilterList) {
                if (!this.decideWarehouseIsOldBatch(spaceValue, spaceType, dto2)) continue;
                DgLogicWarehouseDto csLogicWarehousePageRespDto = (DgLogicWarehouseDto)Optional.ofNullable(warehousePageRespDtoMap.get(dto2.getWarehouseId())).orElseThrow(() -> SourceExceptionCode.NORMAL_EXCEPTION.buildBizException(new String[]{"\u4ed3\u5e93\u5e93\u5b58\u6570\u636e\u5339\u914d\u5f02\u5e38"}));
                removeList.add(csLogicWarehousePageRespDto);
                logicWarehousePageRespDtoList.add(csLogicWarehousePageRespDto);
                break;
            }
        });
        removeList.forEach(csLogicWarehousePageRespDtoList::remove);
        return logicWarehousePageRespDtoList;
    }

    private List<DgLogicWarehouseDto> filterWarehouseGroupType4Total(List<DgLogicWarehouseDto> csLogicWarehousePageRespDtoList, List<DgPhysicsWarehouseDto> physicsWarehouseDtoList) {
        Map<String, DgPhysicsWarehouseDto> physicsWarehousePageRespDtoMap = physicsWarehouseDtoList.stream().collect(Collectors.toMap(DgPhysicsWarehouseDto::getWarehouseCode, v1 -> v1));
        ArrayList<DgLogicWarehouseDto> logicWarehousePageRespDtoList = new ArrayList<DgLogicWarehouseDto>();
        ArrayList removeList = new ArrayList();
        csLogicWarehousePageRespDtoList.forEach(csLogicWarehousePageRespDto -> {
            DgPhysicsWarehouseDto csPhysicsWarehousePageRespDto = (DgPhysicsWarehouseDto)physicsWarehousePageRespDtoMap.get(csLogicWarehousePageRespDto.getPhysicsWarehouseCode());
            SourceAssert.notNull((Object)csPhysicsWarehousePageRespDto, (SourceExceptionCode)SourceExceptionCode.SOURCE_EXECUTE_DATA_QUERY_EMPTY, (String[])new String[]{csLogicWarehousePageRespDto.getWarehouseName() + "\u903b\u8f91\u4ed3\u5173\u8054\u7269\u7406\u4ed3\u4fe1\u606f", csLogicWarehousePageRespDto.getPhysicsWarehouseCode()});
            if (this.decideWarehouseIsTotal(csPhysicsWarehousePageRespDto)) {
                removeList.add(csLogicWarehousePageRespDto);
                logicWarehousePageRespDtoList.add((DgLogicWarehouseDto)csLogicWarehousePageRespDto);
            }
        });
        removeList.forEach(csLogicWarehousePageRespDtoList::remove);
        return logicWarehousePageRespDtoList;
    }

    private List<DgLogicWarehouseDto> filterWarehouseGroupType4Other(List<DgLogicWarehouseDto> csLogicWarehousePageRespDtoList) {
        ArrayList<DgLogicWarehouseDto> logicWarehousePageRespDtoList = new ArrayList<DgLogicWarehouseDto>();
        CubeBeanUtils.copyCollection(logicWarehousePageRespDtoList, csLogicWarehousePageRespDtoList, DgLogicWarehouseDto.class);
        csLogicWarehousePageRespDtoList.clear();
        return logicWarehousePageRespDtoList;
    }

    private List<DgLogicWarehouseDto> filterWarehouseGroupType4TargetSamePhysics(List<DgLogicWarehouseDto> csLogicWarehousePageRespDtoList, Set<String> targetSamePhysicsSet) {
        ArrayList<DgLogicWarehouseDto> logicWarehousePageRespDtoList = new ArrayList<DgLogicWarehouseDto>();
        ArrayList removeList = new ArrayList();
        csLogicWarehousePageRespDtoList.forEach(csLogicWarehousePageRespDto -> {
            if (targetSamePhysicsSet.contains(csLogicWarehousePageRespDto.getPhysicsWarehouseCode())) {
                removeList.add(csLogicWarehousePageRespDto);
                logicWarehousePageRespDtoList.add((DgLogicWarehouseDto)csLogicWarehousePageRespDto);
            }
        });
        removeList.forEach(csLogicWarehousePageRespDtoList::remove);
        return logicWarehousePageRespDtoList;
    }

    private List<DgLogicWarehouseDto> afterFilterDeliveryWarehouseBlack(List<DgLogicWarehouseDto> csLogicWarehousePageRespDtoList, List<ClueDeliveryWarehouseBlackRespDto> deliveryWarehouseBlackRespDtoList) {
        if (CollectionUtils.isNotEmpty(deliveryWarehouseBlackRespDtoList)) {
            Map<Long, ClueDeliveryWarehouseBlackRespDto> blackLogicMap = deliveryWarehouseBlackRespDtoList.stream().collect(Collectors.toMap(ClueDeliveryWarehouseBlackRespDto::getWarehouseId, v1 -> v1));
            csLogicWarehousePageRespDtoList = csLogicWarehousePageRespDtoList.stream().filter(dto -> !blackLogicMap.containsKey(dto.getId())).collect(Collectors.toList());
        }
        return csLogicWarehousePageRespDtoList;
    }

    private List<DgLogicWarehouseDto> afterFilterWarehouse(List<DgLogicWarehouseDto> csLogicWarehousePageRespDtoList, List<PhysicsWarehouseDisableRespDto> physicsWarehouseDisableRespDtoList) {
        if (CollectionUtils.isNotEmpty(physicsWarehouseDisableRespDtoList)) {
            Map<Long, PhysicsWarehouseDisableRespDto> blackPhysicsMap = physicsWarehouseDisableRespDtoList.stream().collect(Collectors.toMap(PhysicsWarehouseDisableRespDto::getWarehouseId, v1 -> v1));
            csLogicWarehousePageRespDtoList = csLogicWarehousePageRespDtoList.stream().filter(dto -> !blackPhysicsMap.containsKey(dto.getId())).collect(Collectors.toList());
        }
        return csLogicWarehousePageRespDtoList;
    }

    private SourceOrderResultRespDto buildSourceResultByOrderDetailRespDto(OrderDetailRespDto orderDetailRespDto) {
        SourceOrderResultRespDto sourceOrderResultRespDto = new SourceOrderResultRespDto();
        CubeBeanUtils.copyProperties((Object)sourceOrderResultRespDto, (Object)orderDetailRespDto, (String[])new String[0]);
        sourceOrderResultRespDto.setSgStatus(SourceStatusEnum.SOURCING.getCode());
        return sourceOrderResultRespDto;
    }

    private String buildWarehouseListString(List<DgLogicWarehouseDto> afterFilterWarehouseList) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\u3010");
        stringBuilder.append(String.join((CharSequence)"\uff0c", afterFilterWarehouseList.stream().map(DgLogicWarehouseDto::getWarehouseCode).collect(Collectors.toList()).toArray(new String[afterFilterWarehouseList.size()])));
        stringBuilder.append("\u3011");
        return stringBuilder.toString();
    }
}

