/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.source.biz.service.calculator.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.center.source.api.constant.EnableEnum;
import com.dtyunxi.cube.center.source.api.constant.SgDictEnum;
import com.dtyunxi.cube.center.source.api.constant.SourceFindOptTypeEnum;
import com.dtyunxi.cube.center.source.api.constant.SourceStatusEnum;
import com.dtyunxi.cube.center.source.api.dto.request.OrderItemReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.SaleOrderOldBatchMatchReqDto;
import com.dtyunxi.cube.center.source.api.dto.response.ClueActRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.ClueWarehouseGroupRuleRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.FreightCostRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.OrderAddrRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.OrderItemRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.OrderItemResultRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.SourceOrderResultRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.WarehouseDeliveryThresholdRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.WarehouseProvideGoodsRangeRespDto;
import com.dtyunxi.cube.center.source.api.exception.SourceAssert;
import com.dtyunxi.cube.center.source.api.exception.SourceExceptionCode;
import com.dtyunxi.cube.center.source.biz.service.calculator.SourceOrderGroupRuleCalculator;
import com.dtyunxi.cube.center.source.biz.service.calculator.SourceOrderGroupRuleTypeCalculator;
import com.dtyunxi.cube.center.source.biz.service.impl.GeneralDataQuery;
import com.dtyunxi.cube.center.source.biz.service.impl.WarehouseDataQuery;
import com.dtyunxi.cube.center.source.biz.utils.SourceExecuteUtils;
import com.dtyunxi.cube.center.source.biz.vo.ClueWarehouseGroupTypeGroupVo;
import com.dtyunxi.cube.center.source.biz.vo.SourceExecuteContextVo;
import com.dtyunxi.cube.center.source.biz.vo.SourceGroupRuleScoreResultGroupVo;
import com.dtyunxi.cube.center.source.biz.vo.WarehouseAddressVo;
import com.dtyunxi.cube.center.source.biz.vo.WarehouseDeliveryThresholdVo;
import com.dtyunxi.cube.center.source.biz.vo.WarehouseInventoryVo;
import com.dtyunxi.cube.center.source.biz.vo.WarehouseOutboundOrderVo;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.WarehouseThresholdRespDto;
import com.dtyunxi.yundt.cube.center.data.api.IPcpDictApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.PcpRegionRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.basics.CsInventoryBasicsQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsWarehouseAddressRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ChannelWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehouseDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgPhysicsWarehouseDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgWarehouseAddressDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SourceOrderGroupRuleCalculatorImpl
implements SourceOrderGroupRuleCalculator {
    private static final Logger logger = LoggerFactory.getLogger(SourceOrderGroupRuleCalculatorImpl.class);
    @Value(value="${center.source.execute.scoreTestFlag:false}")
    private boolean isTest = false;
    @Value(value="${center.source.execute.needBatchNo:false}")
    private boolean needBatchNo = false;
    @Value(value="${center.source.execute.oldBatchNoFlag:false}")
    private boolean oldBatchNoFlag = false;
    @Resource
    private WarehouseDataQuery warehouseDataQuery;
    @Resource
    private GeneralDataQuery generalDataQuery;
    @Resource
    private SourceOrderGroupRuleTypeCalculator sourceOrderGroupRuleTypeCalculator;
    @Resource
    private IPcpDictApi pcpDictApi;
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;

    @Override
    public SourceOrderResultRespDto calculationSourceGroupRule(List<ClueWarehouseGroupTypeGroupVo> clueWarehouseGroupTypeGroupVoList, SourceExecuteContextVo sourceExecuteContextVo) {
        SourceOrderResultRespDto sourceOrderResultRespDto = this.buildSourceResultByOrderDetailRespDto(sourceExecuteContextVo.getOrderDetailRespDto());
        if (this.isTest) {
            for (ClueWarehouseGroupTypeGroupVo clueWarehouseGroupTypeGroupVo : clueWarehouseGroupTypeGroupVoList) {
                if (!CollectionUtils.isNotEmpty(clueWarehouseGroupTypeGroupVo.getCsLogicWarehousePageRespDtoList())) continue;
                this.testResultByOneWarehouse(clueWarehouseGroupTypeGroupVo.getCsLogicWarehousePageRespDtoList().get(0), sourceOrderResultRespDto);
                SourceExecuteUtils.saveOrderResourceLog(SourceFindOptTypeEnum.SOURCE_ACCESS_WAREHOUSE, sourceExecuteContextVo, SourceFindOptTypeEnum.SOURCE_ACCESS_WAREHOUSE.getDesc() + " " + SourceExecuteUtils.buildWarehouseAccessListString(Collections.singletonList(clueWarehouseGroupTypeGroupVo.getCsLogicWarehousePageRespDtoList().get(0))));
                return sourceOrderResultRespDto;
            }
        }
        OrderAddrRespDto orderAddrRespDto = sourceExecuteContextVo.getOrderDetailRespDto().getOrderAddrRespDto();
        List<String> warehouseCodes = sourceExecuteContextVo.getCurrentBeforeClueGroupTypePhysicsRespDtoList().stream().map(DgPhysicsWarehouseDto::getWarehouseCode).distinct().collect(Collectors.toList());
        sourceExecuteContextVo.setOrderAddressPcpRegionRespDtoMap(this.queryOrderPcpRegionRespDtoMap(Stream.of(orderAddrRespDto.getCountyCode(), orderAddrRespDto.getCityCode()).filter(Objects::nonNull).collect(Collectors.toList())));
        sourceExecuteContextVo.setCurrentFreightCostRespDtoList(this.queryFreightCostRespDtoList(warehouseCodes, orderAddrRespDto.getProvinceCode(), orderAddrRespDto.getCityCode(), orderAddrRespDto.getCountyCode()));
        sourceExecuteContextVo.setCurrentWarehouseProvideGoodsRangeRespDtoList(this.queryWarehouseProvideGoodsRangeRespDtoList(warehouseCodes, orderAddrRespDto.getProvinceCode(), orderAddrRespDto.getCityCode(), orderAddrRespDto.getCountyCode()));
        sourceExecuteContextVo.setCurrentCsWarehouseDeliveryThresholdVoMap(this.queryWarehouseDeliveryThresholdList(sourceExecuteContextVo.getCurrentBeforeClueGroupTypePhysicsRespDtoList()));
        ArrayList<OrderItemResultRespDto> orderItemResultRespDtoList = new ArrayList<OrderItemResultRespDto>();
        for (ClueWarehouseGroupTypeGroupVo clueWarehouseGroupTypeGroupVo : clueWarehouseGroupTypeGroupVoList) {
            List<OrderItemResultRespDto> resultRespDtoList = this.calculationSourceGroupRuleScore(clueWarehouseGroupTypeGroupVo, sourceExecuteContextVo);
            Optional.ofNullable(resultRespDtoList).ifPresent(orderItemResultRespDtoList::addAll);
            if (!sourceExecuteContextVo.getSurplusOrderItemRespDtoList().isEmpty()) continue;
            break;
        }
        sourceOrderResultRespDto.setOrderItemResultRespDtoList(orderItemResultRespDtoList);
        if (CollectionUtils.isNotEmpty(orderItemResultRespDtoList)) {
            SourceExecuteUtils.saveOrderResourceLog(SourceFindOptTypeEnum.SOURCE_ACCESS_WAREHOUSE, sourceExecuteContextVo, SourceFindOptTypeEnum.SOURCE_ACCESS_WAREHOUSE.getDesc() + " " + SourceExecuteUtils.buildWarehouseAccessListStringByResultItemList(orderItemResultRespDtoList));
        }
        if (sourceExecuteContextVo.getSurplusOrderItemRespDtoList().isEmpty()) {
            sourceOrderResultRespDto.setSgStatus(SourceStatusEnum.SOURCE_SUCCESS.getCode());
        } else {
            List<OrderItemRespDto> surplusOrderItemRespDtoList = sourceExecuteContextVo.getSurplusOrderItemRespDtoList();
            if (sourceExecuteContextVo.isHitItemBlackFlag()) {
                String itemBlackMsg = SourceExecuteUtils.buildSourceItemBlackByResultItemList(sourceExecuteContextVo);
                SourceExecuteUtils.completionSourceOrderResultRespDtoByFailMsg(SourceFindOptTypeEnum.SOURCE_ACCESS_WAREHOUSE, sourceExecuteContextVo, sourceOrderResultRespDto, itemBlackMsg);
            }
            String msg = SourceExecuteUtils.buildWarehouseItemMatchErrorListString(surplusOrderItemRespDtoList, orderItemResultRespDtoList, sourceExecuteContextVo);
            SourceExecuteUtils.completionSourceOrderResultRespDtoByFailMsg(SourceFindOptTypeEnum.SOURCE_ACCESS_WAREHOUSE, sourceExecuteContextVo, sourceOrderResultRespDto, msg);
        }
        return sourceOrderResultRespDto;
    }

    @Override
    public List<OrderItemResultRespDto> calculationSourceGroupRuleScore(ClueWarehouseGroupTypeGroupVo clueWarehouseGroupTypeGroupVo, SourceExecuteContextVo sourceExecuteContextVo) {
        List<DgLogicWarehouseDto> csLogicWarehousePageRespDtoList = clueWarehouseGroupTypeGroupVo.getCsLogicWarehousePageRespDtoList();
        if (CollectionUtils.isEmpty(csLogicWarehousePageRespDtoList)) {
            return null;
        }
        if (CollectionUtils.isEmpty((Collection)clueWarehouseGroupTypeGroupVo.getClueWarehouseGroupActRespDto().getClueWarehouseGroupRuleRespDtoList())) {
            return null;
        }
        sourceExecuteContextVo.setCurrentWarehouseGroupInventoryDtoMap(this.queryWarehouseInventoryList(sourceExecuteContextVo.getOrderDetailRespDto(), csLogicWarehousePageRespDtoList, sourceExecuteContextVo));
        sourceExecuteContextVo.setCurrentCsPhysicsWarehouseAddressVoMap(this.queryPhysicsWarehouseRegionMap(csLogicWarehousePageRespDtoList));
        sourceExecuteContextVo.setCurrentWarehouseOutboundOrderVoMap(this.queryWarehouseOutboundOrderVoMap(csLogicWarehousePageRespDtoList));
        sourceExecuteContextVo.setCurrentWarehouseGroupTotalInventoryDtoMap(this.assembleCurrentWarehouseGroupTotalInventoryDtoMap(sourceExecuteContextVo.getCurrentWarehouseGroupInventoryDtoMap()));
        ArrayList totalScoreVoList = new ArrayList();
        clueWarehouseGroupTypeGroupVo.getClueWarehouseGroupActRespDto().getClueWarehouseGroupRuleRespDtoList().forEach(clueWarehouseGroupRuleRespDto -> {
            List<SourceGroupRuleScoreResultGroupVo> sourceGroupRuleScoreResultGroupVoList = this.sourceOrderGroupRuleTypeCalculator.calculationWarehouseListScore((ClueWarehouseGroupRuleRespDto)clueWarehouseGroupRuleRespDto, csLogicWarehousePageRespDtoList, sourceExecuteContextVo);
            Optional.ofNullable(sourceGroupRuleScoreResultGroupVoList).ifPresent(totalScoreVoList::addAll);
        });
        Map<Long, SourceGroupRuleScoreResultGroupVo> scoreResultGroupVoMap = totalScoreVoList.stream().collect(Collectors.toMap(vo -> vo.getCsLogicWarehousePageRespDto().getId(), v1 -> v1, (v1, v2) -> {
            v1.setWarehouseResultScore(v1.getWarehouseResultScore().add(v2.getWarehouseResultScore()));
            return v1;
        }));
        ArrayList<SourceGroupRuleScoreResultGroupVo> afterScoreVoList = new ArrayList<SourceGroupRuleScoreResultGroupVo>(scoreResultGroupVoMap.values());
        String organizationCode = sourceExecuteContextVo.getOrderDetailRespDto().getOrganizationCode();
        afterScoreVoList.sort((o1, o2) -> {
            if (o2.getWarehouseResultScore().compareTo(o1.getWarehouseResultScore()) != 0) {
                return o2.getWarehouseResultScore().compareTo(o1.getWarehouseResultScore());
            }
            if (Objects.equals(o1.getCsLogicWarehousePageRespDto().getCargoEscheatageId(), organizationCode)) {
                return -1;
            }
            if (Objects.equals(o2.getCsLogicWarehousePageRespDto().getCargoEscheatageId(), organizationCode)) {
                return 1;
            }
            return 0;
        });
        logger.info("\u3010\u5bfb\u6e90\u8ba1\u7b97-\u5b50\u89c4\u5219\u8ba1\u7b97-\u4ed3\u5e93\u5f97\u5206\u7ed3\u679c\u3011afterScoreVoList={}", (Object)JSON.toJSONString(afterScoreVoList));
        SourceExecuteUtils.saveOrderResourceGroupRuleScoreResultLog(SourceFindOptTypeEnum.CAL_WAREHOUSE_GROUP_SON_RULE, sourceExecuteContextVo, clueWarehouseGroupTypeGroupVo, afterScoreVoList);
        if (this.oldBatchNoFlag) {
            return this.itemOldBatchWarehouseMatch(afterScoreVoList, sourceExecuteContextVo, clueWarehouseGroupTypeGroupVo);
        }
        return this.itemWarehouseMatch(afterScoreVoList, sourceExecuteContextVo, clueWarehouseGroupTypeGroupVo);
    }

    private List<OrderItemResultRespDto> itemWarehouseMatch(List<SourceGroupRuleScoreResultGroupVo> afterScoreVoList, SourceExecuteContextVo sourceExecuteContextVo, ClueWarehouseGroupTypeGroupVo clueWarehouseGroupTypeGroupVo) {
        ArrayList<OrderItemResultRespDto> orderItemResultRespDtoList = new ArrayList<OrderItemResultRespDto>();
        Map<Long, Map<String, List<WarehouseInventoryVo>>> currentWarehouseGroupInventoryDtoMap = sourceExecuteContextVo.getCurrentWarehouseGroupInventoryDtoMap();
        Map<Long, Map<String, WarehouseInventoryVo>> currentWarehouseGroupTotalInventoryDtoMap = sourceExecuteContextVo.getCurrentWarehouseGroupTotalInventoryDtoMap();
        afterScoreVoList.forEach(vo -> {
            Map warehouseInventoryMap = (Map)currentWarehouseGroupInventoryDtoMap.get(vo.getCsLogicWarehousePageRespDto().getId());
            Map warehouseTotalInventoryMap = (Map)currentWarehouseGroupTotalInventoryDtoMap.get(vo.getCsLogicWarehousePageRespDto().getId());
            this.matchItemResultByInventoryMap(sourceExecuteContextVo, orderItemResultRespDtoList, warehouseInventoryMap, warehouseTotalInventoryMap);
        });
        logger.info("\u3010\u5bfb\u6e90\u8ba1\u7b97-\u5339\u914d\u5546\u54c1-\u5339\u914d\u7ed3\u679c\u3011orderItemResultRespDtoList={}", (Object)JSON.toJSONString(orderItemResultRespDtoList));
        if (CollectionUtils.isNotEmpty(orderItemResultRespDtoList)) {
            List<String> matchItems = SourceExecuteUtils.buildWarehouseItemMatchListString(orderItemResultRespDtoList);
            Optional.ofNullable(matchItems).ifPresent(items -> items.forEach(msg -> SourceExecuteUtils.saveOrderResourceLog(SourceFindOptTypeEnum.MATCH_ITEM_GROUP, sourceExecuteContextVo, "\u6309\u3010" + clueWarehouseGroupTypeGroupVo.getClueWarehouseGroupTypeEnum().getDesc() + "\u3011-" + msg)));
        }
        sourceExecuteContextVo.setSurplusOrderItemRespDtoList(sourceExecuteContextVo.getSurplusOrderItemRespDtoList().stream().filter(vo -> vo.getItemNum().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList()));
        return orderItemResultRespDtoList;
    }

    private List<OrderItemResultRespDto> itemOldBatchWarehouseMatch(List<SourceGroupRuleScoreResultGroupVo> afterScoreVoList, SourceExecuteContextVo sourceExecuteContextVo, ClueWarehouseGroupTypeGroupVo clueWarehouseGroupTypeGroupVo) {
        ArrayList<OrderItemResultRespDto> orderItemResultRespDtoList = new ArrayList<OrderItemResultRespDto>();
        boolean singleWarehouseDelivery = EnableEnum.ENABLE.getCode().equals(sourceExecuteContextVo.getCurrentClueActRespDto().getSingleWarehouseDelivery());
        ArrayList totalSortWarehouseInventoryVos = Lists.newArrayList();
        ArrayList matchWarehouseInventoryList = Lists.newArrayList();
        this.sortOldBatchByClue(sourceExecuteContextVo, afterScoreVoList, totalSortWarehouseInventoryVos, matchWarehouseInventoryList);
        for (OrderItemRespDto itemDto : sourceExecuteContextVo.getSurplusOrderItemRespDtoList()) {
            for (WarehouseInventoryVo currentWarehouseInventoryVo : totalSortWarehouseInventoryVos) {
                ArrayList warehouseInventoryVos;
                if (!itemDto.getItemSkuCode().equals(currentWarehouseInventoryVo.getLongCode())) continue;
                ArrayList arrayList = warehouseInventoryVos = singleWarehouseDelivery ? this.getWarehouseInventoryVo(itemDto, currentWarehouseInventoryVo, matchWarehouseInventoryList) : Lists.newArrayList((Object[])new WarehouseInventoryVo[]{currentWarehouseInventoryVo});
                if (CollectionUtils.isEmpty((Collection)warehouseInventoryVos)) continue;
                for (WarehouseInventoryVo warehouseInventoryVo : warehouseInventoryVos) {
                    if (itemDto.getItemNum().compareTo(BigDecimal.ZERO) <= 0 || warehouseInventoryVo.getSurplusStock().compareTo(BigDecimal.ZERO) <= 0) continue;
                    OrderItemResultRespDto itemResultRespDto = this.consumerWarehouseBatchInventoryVo(itemDto, warehouseInventoryVo);
                    Optional.ofNullable(itemResultRespDto).ifPresent(orderItemResultRespDtoList::add);
                }
            }
        }
        String msgBatch = "";
        if (CollectionUtils.isNotEmpty(orderItemResultRespDtoList)) {
            msgBatch = SourceExecuteUtils.buildWarehouseItemBatchMatchListString(orderItemResultRespDtoList);
        }
        Map<String, OrderItemResultRespDto> orderItemResultRespDtoMap = orderItemResultRespDtoList.stream().collect(Collectors.toMap(dto -> dto.getDeliveryLogicWarehouseCode() + "_" + dto.getLinkItemSkuCode() + "_" + dto.getDeliveryItemBatchNo() + "_" + dto.getLinkOrderItemId(), v1 -> v1, (v1, v2) -> {
            v1.setDeliveryItemNum(v1.getDeliveryItemNum().add(v2.getDeliveryItemNum()));
            v1.setZtWarehouseItemNum(this.ofNullBigDecimal(v1.getZtWarehouseItemNum()).add(this.ofNullBigDecimal(v2.getZtWarehouseItemNum())));
            v1.setZtDeliveryWarehouseItemNum(this.ofNullBigDecimal(v1.getZtDeliveryWarehouseItemNum()).add(this.ofNullBigDecimal(v2.getZtDeliveryWarehouseItemNum())));
            v1.setWarehouseItemNum(this.ofNullBigDecimal(v1.getWarehouseItemNum()).add(this.ofNullBigDecimal(v2.getWarehouseItemNum())));
            return v1;
        }));
        orderItemResultRespDtoList = new ArrayList<OrderItemResultRespDto>(orderItemResultRespDtoMap.values());
        logger.info("\u3010\u5bfb\u6e90\u8ba1\u7b97-\u65e7\u6279\u6b21\u5339\u914d\u5546\u54c1-\u5339\u914d\u7ed3\u679c\u3011orderItemResultRespDtoList={}", (Object)JSON.toJSONString(orderItemResultRespDtoList));
        if (CollectionUtils.isNotEmpty(orderItemResultRespDtoList) && Objects.nonNull((Object)clueWarehouseGroupTypeGroupVo)) {
            List<String> matchItems = SourceExecuteUtils.buildWarehouseItemMatchListString(orderItemResultRespDtoList);
            Optional.ofNullable(matchItems).ifPresent(items -> items.forEach(msg -> SourceExecuteUtils.saveOrderResourceLog(SourceFindOptTypeEnum.MATCH_ITEM_GROUP, sourceExecuteContextVo, "\u6309\u3010" + clueWarehouseGroupTypeGroupVo.getClueWarehouseGroupTypeEnum().getDesc() + "\u3011-" + msg)));
            SourceExecuteUtils.saveOrderResourceLog(SourceFindOptTypeEnum.MATCH_ITEM_GROUP, sourceExecuteContextVo, "\u3010" + clueWarehouseGroupTypeGroupVo.getClueWarehouseGroupTypeEnum().getDesc() + "\u3011" + msgBatch);
        }
        sourceExecuteContextVo.setSurplusOrderItemRespDtoList(sourceExecuteContextVo.getSurplusOrderItemRespDtoList().stream().filter(vo -> vo.getItemNum().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList()));
        return orderItemResultRespDtoList;
    }

    private BigDecimal ofNullBigDecimal(BigDecimal val) {
        return val == null ? BigDecimal.ZERO : val;
    }

    private List<WarehouseInventoryVo> getWarehouseInventoryVo(OrderItemRespDto itemDto, WarehouseInventoryVo currentWarehouseInventoryVo, List<List<WarehouseInventoryVo>> matchWarehouseInventoryList) {
        for (List<WarehouseInventoryVo> warehouseInventoryVos : matchWarehouseInventoryList) {
            if (warehouseInventoryVos.stream().allMatch(e -> !Objects.equals(e.getBatch(), currentWarehouseInventoryVo.getBatch()) || !Objects.equals(e.getLongCode(), currentWarehouseInventoryVo.getLongCode()))) {
                logger.info("[\u5355\u4ed3\u53d1\u8d27]\u5224\u65ad\u6279\u6b21\u53f7\u662f\u5426\u7b26\u5408\u6761\u4ef6\uff0c\u5546\u54c1\u7f16\u53f7\uff1a{},\u5546\u54c1\u6279\u6b21\uff1a{}", (Object)itemDto.getItemSkuCode(), (Object)currentWarehouseInventoryVo.getBatch());
                continue;
            }
            BigDecimal totalNum = warehouseInventoryVos.stream().filter(e -> Objects.equals(itemDto.getItemSkuCode(), e.getLongCode())).map(WarehouseInventoryVo::getSurplusStock).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            logger.info("[\u5355\u4ed3\u53d1\u8d27]\uff0c\u6821\u9a8c\u662f\u5426\u6ee1\u8db3\u5355\u4ed3\u53d1\u8d27\uff0c\u5546\u54c1\u7f16\u53f7\uff1a{},\u5546\u54c1\u6240\u9700\u8981\u6570\u91cf\uff1a{},\u5f53\u524d\u4ed3\u5e93\u7f16\u53f7\uff1a{},\u5f53\u524d\u4ed3\u5e93\u6ee1\u8db3\u53ef\u5206\u914d\u6570\u91cf\uff1a{}", new Object[]{itemDto.getItemSkuCode(), itemDto.getItemNum(), warehouseInventoryVos.get(0).getWarehouseCode(), totalNum});
            if (itemDto.getItemNum().compareTo(totalNum) > 0) continue;
            return warehouseInventoryVos.stream().filter(e -> Objects.equals(itemDto.getItemSkuCode(), e.getLongCode())).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    private void sortOldBatchByClue(SourceExecuteContextVo sourceExecuteContextVo, List<SourceGroupRuleScoreResultGroupVo> afterScoreVoList, List<WarehouseInventoryVo> totalSortWarehouseInventoryVos, List<List<WarehouseInventoryVo>> warehouseInventoryGroup) {
        Map<String, DictDto> dictDtoMap = sourceExecuteContextVo.getDictDtoMap();
        DictDto spaceValue = dictDtoMap.get(SgDictEnum.SOURCE_SETTING_OLD_BATCH.getCode());
        int clueOldBatchMonth = Integer.parseInt(spaceValue.getValue());
        int clueNotOldBatchMonth = 0;
        ClueActRespDto currentClueActRespDto = sourceExecuteContextVo.getCurrentClueActRespDto();
        if (Objects.equals(currentClueActRespDto.getClueOldBatch(), EnableEnum.ENABLE.code)) {
            clueOldBatchMonth = currentClueActRespDto.getClueOldBatchMonth();
        }
        if (Objects.equals(currentClueActRespDto.getClueOldBatch(), EnableEnum.ENABLE.code) && Objects.equals(currentClueActRespDto.getClueNotOldBatch(), EnableEnum.ENABLE.code)) {
            clueNotOldBatchMonth = currentClueActRespDto.getClueNotOldBatchMonth();
        }
        logger.info("\u5bfb\u6e90\u65e7\u6279\u6b21\u4f18\u5148\u914d\u7f6eclueOldBatchMonth={},clueNotOldBatchMonth={}", (Object)clueOldBatchMonth, (Object)clueNotOldBatchMonth);
        Map<Long, Map<String, List<WarehouseInventoryVo>>> currentWarehouseGroupInventoryDtoMap = sourceExecuteContextVo.getCurrentWarehouseGroupInventoryDtoMap();
        ArrayList matchWarehouseInventoryList = Lists.newArrayList();
        for (SourceGroupRuleScoreResultGroupVo scoreResultGroupVo : afterScoreVoList) {
            Map<String, List<WarehouseInventoryVo>> warehouseInventoryMap = currentWarehouseGroupInventoryDtoMap.get(scoreResultGroupVo.getCsLogicWarehousePageRespDto().getId());
            if (null == warehouseInventoryMap) continue;
            matchWarehouseInventoryList.add(warehouseInventoryMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
        }
        ArrayList totalWarehouseNotOldBatchList = Lists.newArrayList();
        ArrayList totalRemainingOldBatchList = Lists.newArrayList();
        TreeMap<Date, ArrayList> totalOldBatchMap = new TreeMap<Date, ArrayList>();
        for (List currentAllBatchInventoryList : matchWarehouseInventoryList) {
            Object warehouseInventoryVo2;
            ArrayList currentWarehousenotOldBatchList = Lists.newArrayList();
            ArrayList currentRemainingOldBatchList = Lists.newArrayList();
            TreeMap<Date, ArrayList> currentOldBatchMap = new TreeMap<Date, ArrayList>();
            for (Object warehouseInventoryVo2 : currentAllBatchInventoryList) {
                Date produceTime = warehouseInventoryVo2.getProduceTime();
                if (Objects.nonNull(produceTime)) {
                    String currBatchDateString = DateUtil.getDateFormat((Date)produceTime, (String)"yyyyMM");
                    Date batchDate = DateUtil.parseDate((String)currBatchDateString, (String)"yyyyMM");
                    Date addDate = DateUtil.addMonths((Date)batchDate, (int)clueOldBatchMonth);
                    if (addDate.compareTo(DateUtil.getMonthBegin()) < 0) {
                        if (currentOldBatchMap.containsKey(batchDate)) {
                            ((List)currentOldBatchMap.get(batchDate)).add(warehouseInventoryVo2);
                        } else {
                            currentOldBatchMap.put(batchDate, Lists.newArrayList((Object[])new WarehouseInventoryVo[]{warehouseInventoryVo2}));
                        }
                        if (totalOldBatchMap.containsKey(batchDate)) {
                            ((List)totalOldBatchMap.get(batchDate)).add(warehouseInventoryVo2);
                            continue;
                        }
                        totalOldBatchMap.put(batchDate, Lists.newArrayList((Object[])new WarehouseInventoryVo[]{warehouseInventoryVo2}));
                        continue;
                    }
                    int notOldMonth = clueOldBatchMonth - clueNotOldBatchMonth;
                    addDate = DateUtil.addMonths((Date)batchDate, (int)notOldMonth);
                    if (addDate.compareTo(DateUtil.getMonthBegin()) < 0) {
                        currentWarehousenotOldBatchList.add(warehouseInventoryVo2);
                        totalWarehouseNotOldBatchList.add(warehouseInventoryVo2);
                        continue;
                    }
                    currentRemainingOldBatchList.add(warehouseInventoryVo2);
                    totalRemainingOldBatchList.add(warehouseInventoryVo2);
                    continue;
                }
                currentRemainingOldBatchList.add(warehouseInventoryVo2);
                totalRemainingOldBatchList.add(warehouseInventoryVo2);
            }
            logger.info("[\u5355\u4ed3\u65e7\u6279\u6b21\u6392\u5e8f]\uff0c\u5bfb\u6e90\u65e7\u6279\u6b21\u96c6\u5408={}", (Object)JSON.toJSONString(currentOldBatchMap));
            logger.info("[\u5355\u4ed3\u65e7\u6279\u6b21\u6392\u5e8f]\uff0c\u5bfb\u6e90\u975e\u65e7\u6279\u6b21\u524dX\u6708\u7ec4\u5408\u96c6\u5408={}", (Object)JSON.toJSONString((Object)currentWarehousenotOldBatchList));
            logger.info("[\u5355\u4ed3\u65e7\u6279\u6b21\u6392\u5e8f]\uff0c\u5bfb\u6e90\u975e\u65e7\u6279\u6b21\u5269\u4f59\u96c6\u5408={}", (Object)JSON.toJSONString((Object)currentRemainingOldBatchList));
            ArrayList currentSortWarehouseInventoryVos = Lists.newArrayList();
            warehouseInventoryVo2 = currentOldBatchMap.values().iterator();
            while (warehouseInventoryVo2.hasNext()) {
                List warehouseInventoryVos = (List)warehouseInventoryVo2.next();
                currentSortWarehouseInventoryVos.addAll(warehouseInventoryVos);
            }
            if (sourceExecuteContextVo.isZtStatusFlag()) {
                List<WarehouseInventoryVo> ztSortWarehouseInventoryVos = this.getZtSortWarehouseInventoryVos(currentSortWarehouseInventoryVos, currentWarehousenotOldBatchList, currentRemainingOldBatchList);
                currentSortWarehouseInventoryVos.clear();
                Optional.ofNullable(ztSortWarehouseInventoryVos).ifPresent(currentSortWarehouseInventoryVos::addAll);
            } else {
                Optional.ofNullable(currentWarehousenotOldBatchList).ifPresent(currentSortWarehouseInventoryVos::addAll);
                Optional.ofNullable(currentRemainingOldBatchList).ifPresent(currentSortWarehouseInventoryVos::addAll);
            }
            logger.info("[\u5355\u4ed3\u6279\u6b21\u6392\u5e8f]\uff0c\u6240\u6709\u6279\u6b21\u6392\u5e8f={}", (Object)JSON.toJSONString((Object)currentSortWarehouseInventoryVos));
            warehouseInventoryGroup.add(currentSortWarehouseInventoryVos);
        }
        logger.info("[\u6240\u6709\u65e7\u6279\u6b21\u6392\u5e8f],\u5bfb\u6e90\u65e7\u6279\u6b21\u96c6\u5408={}", (Object)JSON.toJSONString(totalOldBatchMap));
        logger.info("[\u6240\u6709\u65e7\u6279\u6b21\u6392\u5e8f],\u5bfb\u6e90\u975e\u65e7\u6279\u6b21\u524dX\u6708\u7ec4\u5408\u96c6\u5408={}", (Object)JSON.toJSONString((Object)totalWarehouseNotOldBatchList));
        logger.info("[\u6240\u6709\u65e7\u6279\u6b21\u6392\u5e8f],\u5bfb\u6e90\u975e\u65e7\u6279\u6b21\u5269\u4f59\u96c6\u5408={}", (Object)JSON.toJSONString((Object)totalRemainingOldBatchList));
        for (List warehouseInventoryVos : totalOldBatchMap.values()) {
            totalSortWarehouseInventoryVos.addAll(warehouseInventoryVos);
        }
        if (sourceExecuteContextVo.isZtStatusFlag()) {
            List<WarehouseInventoryVo> ztSortWarehouseInventoryVos = this.getZtSortWarehouseInventoryVos(totalSortWarehouseInventoryVos, totalWarehouseNotOldBatchList, totalRemainingOldBatchList);
            totalSortWarehouseInventoryVos.clear();
            Optional.ofNullable(ztSortWarehouseInventoryVos).ifPresent(totalSortWarehouseInventoryVos::addAll);
        } else {
            Optional.ofNullable(totalWarehouseNotOldBatchList).ifPresent(totalSortWarehouseInventoryVos::addAll);
            Optional.ofNullable(totalRemainingOldBatchList).ifPresent(totalSortWarehouseInventoryVos::addAll);
        }
        logger.info("[\u6240\u6709\u6279\u6b21\u6392\u5e8f],\u6240\u6709\u6279\u6b21\u6392\u5e8f={}", (Object)JSON.toJSONString(totalSortWarehouseInventoryVos));
    }

    private List<WarehouseInventoryVo> getZtSortWarehouseInventoryVos(List<WarehouseInventoryVo> totalSortWarehouseInventoryVos, List<WarehouseInventoryVo> totalWarehouseNotOldBatchList, List<WarehouseInventoryVo> totalRemainingOldBatchList) {
        LinkedHashMap<String, List<WarehouseInventoryVo>> warehouseGroupBatchMap;
        ArrayList oldBatchAllInventoryList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(totalSortWarehouseInventoryVos)) {
            ArrayList oldBatchLogicInventoryList = Lists.newArrayList();
            ArrayList oldBatchZtInventoryList = Lists.newArrayList();
            TreeMap<Date, ArrayList> dateTreeMap = new TreeMap<Date, ArrayList>();
            for (WarehouseInventoryVo warehouseInventoryVo : totalSortWarehouseInventoryVos) {
                String currBatchDateString;
                Date batchDate;
                Date produceTime = DateUtil.getToday();
                if (Objects.nonNull(warehouseInventoryVo.getProduceTime())) {
                    produceTime = warehouseInventoryVo.getProduceTime();
                }
                if (dateTreeMap.containsKey(batchDate = DateUtil.parseDate((String)(currBatchDateString = DateUtil.getDateFormat((Date)produceTime, (String)"yyyyMM")), (String)"yyyyMM"))) {
                    ((List)dateTreeMap.get(batchDate)).add(warehouseInventoryVo);
                    continue;
                }
                dateTreeMap.put(batchDate, Lists.newArrayList((Object[])new WarehouseInventoryVo[]{warehouseInventoryVo}));
            }
            for (List list : dateTreeMap.values()) {
                LinkedHashMap<String, List<WarehouseInventoryVo>> warehouseGroupBatchMap2 = this.getWarehouseGroupMap(list);
                for (List<WarehouseInventoryVo> inventoryVoList : warehouseGroupBatchMap2.values()) {
                    this.splitLogicAndZtBatchList(oldBatchLogicInventoryList, oldBatchZtInventoryList, oldBatchAllInventoryList, inventoryVoList);
                }
            }
            logger.info("\u65e7\u6279\u6b21\u6309\u6708\u4efd\u5206\u7ec4\u62c6\u5206\u540e\u7684\u903b\u8f91\u4ed3\u6279\u6b21={}", JSON.toJSON((Object)oldBatchLogicInventoryList));
            logger.info("\u65e7\u6279\u6b21\u6309\u6708\u4efd\u5206\u7ec4\u62c6\u5206\u540e\u7684\u5728\u9014\u4ed3\u6279\u6b21={}", JSON.toJSON((Object)oldBatchZtInventoryList));
        }
        if (CollectionUtils.isNotEmpty(totalWarehouseNotOldBatchList)) {
            ArrayList notOldBatchLogicInventoryList = Lists.newArrayList();
            ArrayList notOldBatchZtInventoryList = Lists.newArrayList();
            warehouseGroupBatchMap = this.getWarehouseGroupMap(totalWarehouseNotOldBatchList);
            for (List list : warehouseGroupBatchMap.values()) {
                this.splitLogicAndZtBatchList(notOldBatchLogicInventoryList, notOldBatchZtInventoryList, oldBatchAllInventoryList, list);
            }
            logger.info("\u975e\u65e7\u6279\u6b21\u62c6\u5206\u540e\u7684\u903b\u8f91\u4ed3\u6279\u6b21={}", JSON.toJSON((Object)notOldBatchLogicInventoryList));
            logger.info("\u975e\u65e7\u6279\u6b21\u62c6\u5206\u540e\u7684\u5728\u9014\u4ed3\u6279\u6b21={}", JSON.toJSON((Object)notOldBatchZtInventoryList));
        }
        if (CollectionUtils.isNotEmpty(totalRemainingOldBatchList)) {
            ArrayList remainingBatchLogicInventoryList = Lists.newArrayList();
            ArrayList remainingBatchZtInventoryList = Lists.newArrayList();
            warehouseGroupBatchMap = this.getWarehouseGroupMap(totalRemainingOldBatchList);
            for (List list : warehouseGroupBatchMap.values()) {
                this.splitLogicAndZtBatchList(remainingBatchLogicInventoryList, remainingBatchZtInventoryList, oldBatchAllInventoryList, list);
            }
            logger.info("\u5269\u4f59\u6279\u6b21\u62c6\u5206\u540e\u7684\u903b\u8f91\u4ed3\u6279\u6b21={}", JSON.toJSON((Object)remainingBatchLogicInventoryList));
            logger.info("\u5269\u4f59\u6279\u6b21\u62c6\u5206\u540e\u7684\u5728\u9014\u4ed3\u6279\u6b21={}", JSON.toJSON((Object)remainingBatchZtInventoryList));
        }
        return oldBatchAllInventoryList;
    }

    private LinkedHashMap<String, List<WarehouseInventoryVo>> getWarehouseGroupMap(List<WarehouseInventoryVo> inventoryVos) {
        LinkedHashMap<String, List<WarehouseInventoryVo>> warehouseGroupBatchMap = new LinkedHashMap<String, List<WarehouseInventoryVo>>();
        for (WarehouseInventoryVo inventoryVo : inventoryVos) {
            if (warehouseGroupBatchMap.containsKey(inventoryVo.getWarehouseCode())) {
                warehouseGroupBatchMap.get(inventoryVo.getWarehouseCode()).add(inventoryVo);
                continue;
            }
            warehouseGroupBatchMap.put(inventoryVo.getWarehouseCode(), Lists.newArrayList((Object[])new WarehouseInventoryVo[]{inventoryVo}));
        }
        return warehouseGroupBatchMap;
    }

    private List<WarehouseInventoryVo> splitLogicAndZtBatchList(List<WarehouseInventoryVo> oldBatchLogicInventoryList, List<WarehouseInventoryVo> oldBatchZtInventoryList, List<WarehouseInventoryVo> oldBatchAllInventoryList, List<WarehouseInventoryVo> inventoryVos) {
        for (WarehouseInventoryVo warehouseInventoryVo : inventoryVos) {
            int ztNumFlag = warehouseInventoryVo.getSurplusStock().compareTo(warehouseInventoryVo.getZtSaleable());
            if (ztNumFlag == 0) {
                oldBatchZtInventoryList.add(warehouseInventoryVo);
                continue;
            }
            if (ztNumFlag <= 0) continue;
            WarehouseInventoryVo logicBatchVo = new WarehouseInventoryVo();
            CubeBeanUtils.copyProperties((Object)((Object)logicBatchVo), (Object)((Object)warehouseInventoryVo), (String[])new String[0]);
            if (warehouseInventoryVo.getZtSaleable().compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal logicAvailableNum = logicBatchVo.getSurplusStock().subtract(logicBatchVo.getZtSaleable());
                logicBatchVo.setSurplusStock(logicAvailableNum);
                logicBatchVo.setZtSaleable(BigDecimal.ZERO);
                logicBatchVo.setZtSurplusStock(BigDecimal.ZERO);
                WarehouseInventoryVo ztBatchVo = new WarehouseInventoryVo();
                CubeBeanUtils.copyProperties((Object)((Object)ztBatchVo), (Object)((Object)warehouseInventoryVo), (String[])new String[0]);
                ztBatchVo.setSurplusStock(ztBatchVo.getZtSaleable());
                oldBatchZtInventoryList.add(ztBatchVo);
            }
            oldBatchLogicInventoryList.add(logicBatchVo);
        }
        if (CollectionUtils.isNotEmpty(oldBatchLogicInventoryList)) {
            oldBatchLogicInventoryList = oldBatchLogicInventoryList.stream().sorted(Comparator.comparing(CsInventoryBasicsQueryRespDto::getProduceTime)).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(oldBatchZtInventoryList)) {
            oldBatchZtInventoryList = oldBatchZtInventoryList.stream().sorted(Comparator.comparing(CsInventoryBasicsQueryRespDto::getProduceTime)).collect(Collectors.toList());
        }
        Optional.ofNullable(oldBatchLogicInventoryList).ifPresent(oldBatchAllInventoryList::addAll);
        Optional.ofNullable(oldBatchZtInventoryList).ifPresent(oldBatchAllInventoryList::addAll);
        return oldBatchAllInventoryList;
    }

    private List<OrderItemResultRespDto> itemWarehouseMatchByOne(DgLogicWarehouseDto csLogicWarehousePageRespDto, SourceExecuteContextVo sourceExecuteContextVo, ClueWarehouseGroupTypeGroupVo clueWarehouseGroupTypeGroupVo) {
        ArrayList<OrderItemResultRespDto> orderItemResultRespDtoList = new ArrayList<OrderItemResultRespDto>();
        Map<Long, Map<String, WarehouseInventoryVo>> currentWarehouseGroupTotalInventoryDtoMap = sourceExecuteContextVo.getCurrentWarehouseGroupTotalInventoryDtoMap();
        Map<Long, Map<String, List<WarehouseInventoryVo>>> currentWarehouseGroupInventoryDtoMap = sourceExecuteContextVo.getCurrentWarehouseGroupInventoryDtoMap();
        Map<String, List<WarehouseInventoryVo>> warehouseInventoryMap = currentWarehouseGroupInventoryDtoMap.get(csLogicWarehousePageRespDto.getId());
        if (Objects.nonNull(warehouseInventoryMap) && !warehouseInventoryMap.isEmpty()) {
            for (String skuCode : warehouseInventoryMap.keySet()) {
                List<WarehouseInventoryVo> warehouseInventoryVos = warehouseInventoryMap.get(skuCode);
                warehouseInventoryVos = warehouseInventoryVos.stream().sorted(Comparator.comparing(CsInventoryBasicsQueryRespDto::getProduceTime)).collect(Collectors.toList());
                warehouseInventoryMap.put(skuCode, warehouseInventoryVos);
            }
        }
        Map<String, WarehouseInventoryVo> warehouseTotalInventoryMap = currentWarehouseGroupTotalInventoryDtoMap.get(csLogicWarehousePageRespDto.getId());
        this.matchItemResultByInventoryMap(sourceExecuteContextVo, orderItemResultRespDtoList, warehouseInventoryMap, warehouseTotalInventoryMap);
        logger.info("\u3010\u5bfb\u6e90\u8ba1\u7b97-\u5339\u914d\u5546\u54c1-\u5339\u914d\u7ed3\u679c\u3011itemWarehouseMatchByOne.orderItemResultRespDtoList={}", (Object)JSON.toJSONString(orderItemResultRespDtoList));
        if (CollectionUtils.isNotEmpty(orderItemResultRespDtoList)) {
            List<String> matchItems = SourceExecuteUtils.buildWarehouseItemMatchListString(orderItemResultRespDtoList);
            Optional.ofNullable(matchItems).ifPresent(items -> items.forEach(msg -> SourceExecuteUtils.saveOrderResourceLog(SourceFindOptTypeEnum.MATCH_ITEM_GROUP, sourceExecuteContextVo, "\u6309\u3010" + clueWarehouseGroupTypeGroupVo.getClueWarehouseGroupTypeEnum().getDesc() + "\u3011-" + msg)));
        }
        sourceExecuteContextVo.setSurplusOrderItemRespDtoList(sourceExecuteContextVo.getSurplusOrderItemRespDtoList().stream().filter(vo -> vo.getItemNum().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList()));
        return orderItemResultRespDtoList;
    }

    private void matchItemResultByInventoryMap(SourceExecuteContextVo sourceExecuteContextVo, List<OrderItemResultRespDto> orderItemResultRespDtoList, Map<String, List<WarehouseInventoryVo>> warehouseInventoryMap, Map<String, WarehouseInventoryVo> warehouseTotalInventoryMap) {
        Optional.ofNullable(warehouseInventoryMap).ifPresent(map -> {
            List<OrderItemRespDto> orderItemRespDtoList = sourceExecuteContextVo.getSurplusOrderItemRespDtoList();
            orderItemRespDtoList.forEach(itemDto -> {
                BigDecimal totalSurplusStock = BigDecimal.ZERO;
                WarehouseInventoryVo totalInventoryVo = Optional.ofNullable(warehouseTotalInventoryMap.get(itemDto.getItemSkuCode())).orElse(null);
                if (Objects.nonNull((Object)totalInventoryVo)) {
                    totalSurplusStock = totalInventoryVo.getSurplusStock();
                }
                ClueActRespDto currentClueActRespDto = sourceExecuteContextVo.getCurrentClueActRespDto();
                if (EnableEnum.ENABLE.getCode().equals(currentClueActRespDto.getSingleWarehouseDelivery()) && itemDto.getItemNum().compareTo(totalSurplusStock) > 0) {
                    return;
                }
                List<OrderItemResultRespDto> orderItemResultRespDtos = this.consumerWarehouseInventoryVoList((OrderItemRespDto)itemDto, Optional.ofNullable(map.get(itemDto.getItemSkuCode())).orElse(new ArrayList()), totalInventoryVo);
                if (null != orderItemResultRespDtos) {
                    Optional.ofNullable(orderItemResultRespDtos).ifPresent(orderItemResultRespDtoList::addAll);
                }
            });
        });
    }

    private List<OrderItemResultRespDto> consumerWarehouseInventoryVoList(OrderItemRespDto itemRespDto, List<WarehouseInventoryVo> warehouseInventoryVoList, WarehouseInventoryVo totalInventoryVo) {
        if (Objects.nonNull((Object)totalInventoryVo)) {
            itemRespDto.setDeliveryLogicWarehouseId(totalInventoryVo.getWarehouseId());
            itemRespDto.setDeliveryLogicWarehouseCode(totalInventoryVo.getWarehouseCode());
            itemRespDto.setWarehouseItemNum(totalInventoryVo.getSurplusStock());
            itemRespDto.setZtWarehouseItemNum(totalInventoryVo.getZtSaleable());
        }
        if (itemRespDto.getItemNum().compareTo(BigDecimal.ZERO) <= 0) {
            return null;
        }
        ArrayList<OrderItemResultRespDto> orderItemResultRespDtoList = new ArrayList<OrderItemResultRespDto>();
        if (this.needBatchNo && StringUtils.isNotBlank((CharSequence)itemRespDto.getItemBatchNo())) {
            List batchNoInventoryList = warehouseInventoryVoList.stream().filter(vo -> Objects.equals(itemRespDto.getItemBatchNo(), vo.getBatch())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty((Collection)batchNoInventoryList)) {
                if (batchNoInventoryList.size() > 1) {
                    throw SourceExceptionCode.NORMAL_EXCEPTION.buildBizException(new String[]{warehouseInventoryVoList.get(0).getWarehouseCode() + "\u4ed3\u5e93" + itemRespDto.getItemSkuCode() + "\u5e93\u5b58\u6570\u636e" + itemRespDto.getItemBatchNo() + "\u6279\u6b21\u6570\u636e\u91cd\u590d"});
                }
                OrderItemResultRespDto itemResultRespDto = this.consumerWarehouseInventoryVo(itemRespDto, (WarehouseInventoryVo)((Object)batchNoInventoryList.get(0)), totalInventoryVo);
                Optional.ofNullable(itemResultRespDto).ifPresent(orderItemResultRespDtoList::add);
            }
            if (itemRespDto.getItemNum().compareTo(BigDecimal.ZERO) <= 0) {
                return orderItemResultRespDtoList;
            }
            List noMatchBatchNoInventoryList = warehouseInventoryVoList.stream().filter(vo -> !Objects.equals(itemRespDto.getItemBatchNo(), vo.getBatch())).collect(Collectors.toList());
            for (WarehouseInventoryVo vo2 : noMatchBatchNoInventoryList) {
                OrderItemResultRespDto itemResultRespDto = this.consumerWarehouseInventoryVo(itemRespDto, vo2, totalInventoryVo);
                Optional.ofNullable(itemResultRespDto).ifPresent(orderItemResultRespDtoList::add);
            }
        } else {
            logger.info("\u6d4b\u8bd5\uff1aitemRespDto:{},warehouseInventoryVoList:{}", (Object)JSON.toJSONString((Object)itemRespDto), (Object)JSON.toJSONString(warehouseInventoryVoList));
            for (WarehouseInventoryVo vo3 : warehouseInventoryVoList) {
                OrderItemResultRespDto itemResultRespDto = this.consumerWarehouseInventoryVo(itemRespDto, vo3, totalInventoryVo);
                if (!Objects.nonNull(itemResultRespDto)) continue;
                Optional.ofNullable(itemResultRespDto).ifPresent(orderItemResultRespDtoList::add);
            }
        }
        Map<String, OrderItemResultRespDto> orderItemResultRespDtoMap = orderItemResultRespDtoList.stream().filter(vo -> vo.getDeliveryItemNum().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toMap(dto -> dto.getLinkItemSkuCode() + "_" + dto.getDeliveryItemBatchNo(), v1 -> v1, (v1, v2) -> {
            v1.setDeliveryItemNum(v1.getDeliveryItemNum().add(v2.getDeliveryItemNum()));
            v1.setZtWarehouseItemNum(this.ofNullBigDecimal(v1.getZtWarehouseItemNum()).add(this.ofNullBigDecimal(v2.getZtWarehouseItemNum())));
            v1.setZtDeliveryWarehouseItemNum(this.ofNullBigDecimal(v1.getZtDeliveryWarehouseItemNum()).add(this.ofNullBigDecimal(v2.getZtDeliveryWarehouseItemNum())));
            v1.setWarehouseItemNum(this.ofNullBigDecimal(v1.getWarehouseItemNum()).add(this.ofNullBigDecimal(v2.getWarehouseItemNum())));
            return v1;
        }));
        return new ArrayList<OrderItemResultRespDto>(orderItemResultRespDtoMap.values());
    }

    private OrderItemResultRespDto consumerWarehouseInventoryVo(OrderItemRespDto itemRespDto, WarehouseInventoryVo warehouseInventoryVo, WarehouseInventoryVo totalInventoryVo) {
        if (itemRespDto.getItemNum().compareTo(BigDecimal.ZERO) <= 0) {
            return null;
        }
        if (warehouseInventoryVo.getSurplusStock().compareTo(BigDecimal.ZERO) <= 0) {
            return null;
        }
        OrderItemResultRespDto orderItemResultRespDto = this.buildOrderItemRespDto(itemRespDto, warehouseInventoryVo);
        if (itemRespDto.getItemNum().compareTo(totalInventoryVo.getSurplusStock()) > 0) {
            this.deliveryItem(orderItemResultRespDto, itemRespDto, warehouseInventoryVo, totalInventoryVo, totalInventoryVo.getSurplusStock());
        } else if (itemRespDto.getItemNum().compareTo(warehouseInventoryVo.getSurplusStock()) < 0) {
            this.deliveryItem(orderItemResultRespDto, itemRespDto, warehouseInventoryVo, totalInventoryVo, itemRespDto.getItemNum());
        } else if (itemRespDto.getItemNum().compareTo(warehouseInventoryVo.getSurplusStock()) > 0) {
            this.deliveryItem(orderItemResultRespDto, itemRespDto, warehouseInventoryVo, totalInventoryVo, warehouseInventoryVo.getSurplusStock());
        } else {
            this.deliveryItem(orderItemResultRespDto, itemRespDto, warehouseInventoryVo, totalInventoryVo, itemRespDto.getItemNum());
        }
        return orderItemResultRespDto;
    }

    private OrderItemResultRespDto consumerWarehouseBatchInventoryVo(OrderItemRespDto itemRespDto, WarehouseInventoryVo warehouseInventoryVo) {
        OrderItemResultRespDto orderItemResultRespDto = this.buildOrderItemRespDto(itemRespDto, warehouseInventoryVo);
        if (itemRespDto.getItemNum().compareTo(warehouseInventoryVo.getSurplusStock()) > 0) {
            this.deliveryItemBatch(orderItemResultRespDto, itemRespDto, warehouseInventoryVo, warehouseInventoryVo.getSurplusStock());
        } else if (itemRespDto.getItemNum().compareTo(warehouseInventoryVo.getSurplusStock()) < 0) {
            this.deliveryItemBatch(orderItemResultRespDto, itemRespDto, warehouseInventoryVo, itemRespDto.getItemNum());
        } else if (itemRespDto.getItemNum().compareTo(warehouseInventoryVo.getSurplusStock()) > 0) {
            this.deliveryItemBatch(orderItemResultRespDto, itemRespDto, warehouseInventoryVo, warehouseInventoryVo.getSurplusStock());
        } else {
            this.deliveryItemBatch(orderItemResultRespDto, itemRespDto, warehouseInventoryVo, itemRespDto.getItemNum());
        }
        return orderItemResultRespDto;
    }

    private void deliveryItem(OrderItemResultRespDto orderItemResultRespDto, OrderItemRespDto itemRespDto, WarehouseInventoryVo warehouseInventoryVo, WarehouseInventoryVo totalInventoryVo, BigDecimal subtractStock) {
        orderItemResultRespDto.setDeliveryItemNum(subtractStock);
        orderItemResultRespDto.setWarehouseItemNum(warehouseInventoryVo.getSurplusStock());
        orderItemResultRespDto.setZtWarehouseItemNum(warehouseInventoryVo.getZtSaleable());
        orderItemResultRespDto.setDeliveryItemBatchNo(warehouseInventoryVo.getBatch());
        warehouseInventoryVo.setUsedStock(warehouseInventoryVo.getUsedStock().add(subtractStock));
        totalInventoryVo.setUsedStock(totalInventoryVo.getUsedStock().add(subtractStock));
        itemRespDto.setItemNum(itemRespDto.getItemNum().subtract(subtractStock));
        totalInventoryVo.setSurplusStock(totalInventoryVo.getSurplusStock().subtract(subtractStock));
        warehouseInventoryVo.setSurplusStock(warehouseInventoryVo.getSurplusStock().subtract(subtractStock));
        BigDecimal surplusStock = warehouseInventoryVo.getSurplusStock();
        if (surplusStock.compareTo(warehouseInventoryVo.getZtSaleable()) >= 0) {
            orderItemResultRespDto.setZtDeliveryWarehouseItemNum(BigDecimal.ZERO);
        } else {
            BigDecimal ztDeliveryWarehouseItemNum = warehouseInventoryVo.getZtSurplusStock().subtract(surplusStock);
            orderItemResultRespDto.setZtDeliveryWarehouseItemNum(ztDeliveryWarehouseItemNum);
            warehouseInventoryVo.setZtSurplusStock(surplusStock);
        }
    }

    private void deliveryItemBatch(OrderItemResultRespDto orderItemResultRespDto, OrderItemRespDto itemRespDto, WarehouseInventoryVo warehouseInventoryVo, BigDecimal subtractStock) {
        orderItemResultRespDto.setDeliveryItemNum(subtractStock);
        orderItemResultRespDto.setWarehouseItemNum(warehouseInventoryVo.getSurplusStock());
        orderItemResultRespDto.setZtWarehouseItemNum(warehouseInventoryVo.getZtSaleable());
        orderItemResultRespDto.setDeliveryItemBatchNo(warehouseInventoryVo.getBatch());
        warehouseInventoryVo.setUsedStock(warehouseInventoryVo.getUsedStock().add(subtractStock));
        itemRespDto.setItemNum(itemRespDto.getItemNum().subtract(subtractStock));
        warehouseInventoryVo.setSurplusStock(warehouseInventoryVo.getSurplusStock().subtract(subtractStock));
        BigDecimal surplusStock = warehouseInventoryVo.getSurplusStock();
        if (surplusStock.compareTo(warehouseInventoryVo.getZtSaleable()) >= 0) {
            orderItemResultRespDto.setZtDeliveryWarehouseItemNum(BigDecimal.ZERO);
            itemRespDto.setZtWarehouseItemNum(BigDecimal.ZERO);
        } else {
            BigDecimal ztDeliveryWarehouseItemNum = warehouseInventoryVo.getZtSurplusStock().subtract(surplusStock);
            orderItemResultRespDto.setZtDeliveryWarehouseItemNum(ztDeliveryWarehouseItemNum);
            warehouseInventoryVo.setZtSurplusStock(surplusStock);
            itemRespDto.setZtWarehouseItemNum(itemRespDto.getZtWarehouseItemNum().add(ztDeliveryWarehouseItemNum));
        }
    }

    private OrderItemResultRespDto buildOrderItemRespDto(OrderItemRespDto itemRespDto, WarehouseInventoryVo warehouseInventoryVo) {
        OrderItemResultRespDto orderItemResultRespDto = new OrderItemResultRespDto();
        CubeBeanUtils.copyProperties((Object)orderItemResultRespDto, (Object)itemRespDto, (String[])new String[0]);
        orderItemResultRespDto.setId(null);
        orderItemResultRespDto.setDeliveryItemNum(BigDecimal.ZERO);
        orderItemResultRespDto.setDeliveryLogicWarehouseId(warehouseInventoryVo.getWarehouseId());
        orderItemResultRespDto.setDeliveryLogicWarehouseCode(warehouseInventoryVo.getWarehouseCode());
        orderItemResultRespDto.setDeliveryLogicWarehouseName(warehouseInventoryVo.getWarehouseName());
        if (this.needBatchNo && Objects.equals(itemRespDto.getItemBatchNo(), warehouseInventoryVo.getBatch())) {
            orderItemResultRespDto.setDeliveryItemBatchNo(itemRespDto.getItemBatchNo());
        }
        orderItemResultRespDto.setLinkItemSkuCode(itemRespDto.getItemSkuCode());
        orderItemResultRespDto.setWarehouseItemNum(BigDecimal.ZERO);
        orderItemResultRespDto.setZtWarehouseItemNum(BigDecimal.ZERO);
        itemRespDto.setZtWarehouseItemNum(BigDecimal.ZERO);
        orderItemResultRespDto.setZtDeliveryWarehouseItemNum(BigDecimal.ZERO);
        return orderItemResultRespDto;
    }

    private Map<String, PcpRegionRespDto> queryOrderPcpRegionRespDtoMap(List<String> regionCodes) {
        List<PcpRegionRespDto> pcpRegionRespDtoList = this.generalDataQuery.queryPcpRegionRespDtoListByCodes(regionCodes);
        SourceAssert.notEmpty(pcpRegionRespDtoList, (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_EMPTY, (String[])new String[]{"\u8ba2\u5355\u6536\u8d27\u5730\u5740\u7ecf\u7eac\u5ea6"});
        return pcpRegionRespDtoList.stream().collect(Collectors.toMap(PcpRegionRespDto::getCode, v1 -> v1));
    }

    private List<FreightCostRespDto> queryFreightCostRespDtoList(List<String> warehouseCodes, String provinceCode, String cityCode, String areaCode) {
        return Optional.ofNullable(this.generalDataQuery.queryListByWarehouseCodesAndRegionCode(warehouseCodes, provinceCode, cityCode, areaCode)).orElse(new ArrayList());
    }

    private List<WarehouseProvideGoodsRangeRespDto> queryWarehouseProvideGoodsRangeRespDtoList(List<String> warehouseCodes, String provinceCode, String cityCode, String areaCode) {
        return Optional.ofNullable(this.generalDataQuery.queryWarehouseProvideGoodsRangeRespDtoListByWarehouseCode(warehouseCodes, provinceCode, cityCode, areaCode)).orElse(new ArrayList());
    }

    private Map<String, WarehouseAddressVo> queryPhysicsWarehouseRegionMap(List<DgLogicWarehouseDto> csLogicWarehousePageRespDtoList) {
        List<DgWarehouseAddressDto> csWarehouseAddressRespDtoList = this.warehouseDataQuery.queryCsWarehouseAddressList(csLogicWarehousePageRespDtoList.stream().map(DgLogicWarehouseDto::getPhysicsWarehouseCode).collect(Collectors.toList()));
        SourceAssert.notEmpty(csWarehouseAddressRespDtoList, (SourceExceptionCode)SourceExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u67e5\u8be2\u4e0d\u5230\u7269\u7406\u4ed3\u5730\u5740\u4fe1\u606f"});
        HashSet<String> areaCodeSet = new HashSet<String>();
        for (DgWarehouseAddressDto csWarehouseAddressRespDto : csWarehouseAddressRespDtoList) {
            if (StringUtils.isEmpty((CharSequence)csWarehouseAddressRespDto.getDistrictCode())) {
                areaCodeSet.add(csWarehouseAddressRespDto.getCityCode());
                continue;
            }
            areaCodeSet.add(csWarehouseAddressRespDto.getDistrictCode());
        }
        List<PcpRegionRespDto> pcpRegionRespDtoList = this.generalDataQuery.queryPcpRegionRespDtoListByCodes(areaCodeSet.stream().collect(Collectors.toList()));
        SourceAssert.notEmpty(pcpRegionRespDtoList, (SourceExceptionCode)SourceExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u67e5\u8be2\u4e0d\u5230\u533a\u57df\u4fe1\u606f"});
        Map<String, PcpRegionRespDto> pcpRegionRespDtoMap = pcpRegionRespDtoList.stream().collect(Collectors.toMap(PcpRegionRespDto::getCode, v1 -> v1, (v1, v2) -> v1));
        return csWarehouseAddressRespDtoList.stream().filter(vo -> CsValidFlagEnum.ENABLE.getCode().equals(vo.getValidFlag())).map(dto -> {
            WarehouseAddressVo warehouseAddressVo = new WarehouseAddressVo();
            CubeBeanUtils.copyProperties((Object)((Object)warehouseAddressVo), (Object)dto, (String[])new String[0]);
            PcpRegionRespDto pcpRegionRespDto = null;
            pcpRegionRespDto = StringUtils.isNotEmpty((CharSequence)warehouseAddressVo.getDistrictCode()) ? (PcpRegionRespDto)pcpRegionRespDtoMap.get(warehouseAddressVo.getDistrictCode()) : (PcpRegionRespDto)pcpRegionRespDtoMap.get(warehouseAddressVo.getCityCode());
            SourceAssert.notNull((Object)pcpRegionRespDto, (SourceExceptionCode)SourceExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u5339\u914d\u4e0d\u5230\u4ed3\u5e93\u533a\u57df\u4fe1\u606f"});
            warehouseAddressVo.setPcpRegionRespDto(pcpRegionRespDto);
            return warehouseAddressVo;
        }).collect(Collectors.toMap(CsWarehouseAddressRespDto::getWarehouseCode, v1 -> v1, (v1, v2) -> v1));
    }

    private Map<String, WarehouseOutboundOrderVo> queryWarehouseOutboundOrderVoMap(List<DgLogicWarehouseDto> csLogicWarehousePageRespDtoList) {
        List<WarehouseThresholdRespDto> warehouseThresholdRespDtos = this.warehouseDataQuery.queryWarehouseOutboundOrder(csLogicWarehousePageRespDtoList.stream().map(DgLogicWarehouseDto::getWarehouseCode).collect(Collectors.toList()));
        SourceAssert.notEmpty(warehouseThresholdRespDtos, (SourceExceptionCode)SourceExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u67e5\u8be2\u4e0d\u5230\u903b\u8f91\u4ed3\u51fa\u5e93\u5355\u91cf\u4fe1\u606f"});
        Map<String, List<WarehouseThresholdRespDto>> physicsWarehouseMap = warehouseThresholdRespDtos.stream().collect(Collectors.groupingBy(WarehouseThresholdRespDto::getWarehouseCode));
        HashMap<String, WarehouseOutboundOrderVo> map = new HashMap<String, WarehouseOutboundOrderVo>();
        for (String physicsWarehouseCode : physicsWarehouseMap.keySet()) {
            List<WarehouseThresholdRespDto> thresholdRespDtos = physicsWarehouseMap.get(physicsWarehouseCode);
            Integer outboundCount = thresholdRespDtos.stream().mapToInt(WarehouseThresholdRespDto::getOrderCount).sum();
            WarehouseOutboundOrderVo warehouseOutboundOrderVo = new WarehouseOutboundOrderVo();
            warehouseOutboundOrderVo.setOutboundCount(new BigDecimal(outboundCount));
            warehouseOutboundOrderVo.setWarehouseCode(thresholdRespDtos.get(0).getWarehouseCode());
            map.put(physicsWarehouseCode, warehouseOutboundOrderVo);
        }
        return map;
    }

    private Map<String, WarehouseDeliveryThresholdVo> queryWarehouseDeliveryThresholdList(List<DgPhysicsWarehouseDto> csPhysicsWarehousePageRespDtoList) {
        List<String> warehouseCodes = csPhysicsWarehousePageRespDtoList.stream().map(DgPhysicsWarehouseDto::getWarehouseCode).distinct().collect(Collectors.toList());
        List<WarehouseDeliveryThresholdRespDto> warehouseDeliveryThresholdRespDtoList = this.generalDataQuery.queryListWarehouseDeliveryThresholdByWarehouseCodes(warehouseCodes);
        Map<String, DgPhysicsWarehouseDto> physicsWarehousePageRespDtoMap = csPhysicsWarehousePageRespDtoList.stream().collect(Collectors.toMap(DgPhysicsWarehouseDto::getWarehouseCode, v1 -> v1));
        return warehouseDeliveryThresholdRespDtoList.stream().map(dto -> {
            WarehouseDeliveryThresholdVo warehouseDeliveryThresholdVo = new WarehouseDeliveryThresholdVo();
            CubeBeanUtils.copyProperties((Object)((Object)warehouseDeliveryThresholdVo), (Object)dto, (String[])new String[0]);
            DgPhysicsWarehouseDto physicsWarehousePageRespDto = (DgPhysicsWarehouseDto)physicsWarehousePageRespDtoMap.get(dto.getPhysicsWarehouseCode());
            SourceAssert.notNull((Object)physicsWarehousePageRespDto, (SourceExceptionCode)SourceExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u5339\u914d\u4e0d\u5230\u4ed3\u5e93\u9608\u503c\u4fe1\u606f"});
            warehouseDeliveryThresholdVo.setWarehouseId(physicsWarehousePageRespDto.getId());
            return warehouseDeliveryThresholdVo;
        }).collect(Collectors.toMap(WarehouseDeliveryThresholdRespDto::getPhysicsWarehouseCode, v1 -> v1));
    }

    private Map<Long, Map<String, List<WarehouseInventoryVo>>> queryWarehouseInventoryList(OrderDetailRespDto orderDetailRespDto, List<DgLogicWarehouseDto> csLogicWarehousePageRespDtoList, SourceExecuteContextVo sourceExecuteContextVo) {
        List<String> warehouseCodes = csLogicWarehousePageRespDtoList.stream().map(DgLogicWarehouseDto::getWarehouseCode).collect(Collectors.toList());
        List<String> skuCodes = orderDetailRespDto.getOrderItemRespDtoList().stream().map(OrderItemRespDto::getItemSkuCode).collect(Collectors.toList());
        Map<String, DictDto> dictDtoMap = sourceExecuteContextVo.getDictDtoMap();
        boolean transitSwitchFlag = false;
        if (dictDtoMap.containsKey(SgDictEnum.IN_TRANSIT_INVENTORY_SWITCH.getCode())) {
            String transitSwitchValue = dictDtoMap.get(SgDictEnum.IN_TRANSIT_INVENTORY_SWITCH.getCode()).getValue();
            transitSwitchFlag = Objects.equals(transitSwitchValue, "1");
        }
        Integer intransitStockStatus = sourceExecuteContextVo.getCurrentClueActRespDto().getIntransitStockStatus();
        boolean flag = Objects.equals(intransitStockStatus, 1);
        Integer day = 0;
        boolean ztFlag = transitSwitchFlag && flag;
        sourceExecuteContextVo.setZtStatusFlag(ztFlag);
        if (ztFlag) {
            day = this.getIntransitDay(dictDtoMap, day);
            List<String> logicWarehouseCodes = warehouseCodes;
            ArrayList ztWarehouseCodes = Lists.newArrayList();
            this.setSourceIntransitStock(sourceExecuteContextVo, skuCodes, dictDtoMap, day, logicWarehouseCodes, ztWarehouseCodes);
        }
        List<WarehouseInventoryVo> warehouseInventoryVoList = this.warehouseDataQuery.queryCsLogicInventoryBalanceByRuleVo(warehouseCodes, skuCodes, sourceExecuteContextVo);
        if (sourceExecuteContextVo.isZtStatusFlag()) {
            warehouseInventoryVoList = this.warehouseDataQuery.queryCsLogicInventoryGroupZt(warehouseInventoryVoList, sourceExecuteContextVo);
        }
        warehouseInventoryVoList = this.warehouseDataQuery.matchFilterItemBlackList(warehouseInventoryVoList, sourceExecuteContextVo);
        Map<Long, List<WarehouseInventoryVo>> tempInventoryMap = warehouseInventoryVoList.stream().collect(Collectors.groupingBy(CsInventoryBasicsQueryRespDto::getWarehouseId));
        HashMap<Long, Map<String, List<WarehouseInventoryVo>>> currentWarehouseGroupInventoryDtoMap = new HashMap<Long, Map<String, List<WarehouseInventoryVo>>>();
        tempInventoryMap.forEach((k, v) -> currentWarehouseGroupInventoryDtoMap.put((Long)k, v.stream().collect(Collectors.groupingBy(CsInventoryBasicsQueryRespDto::getLongCode))));
        return currentWarehouseGroupInventoryDtoMap;
    }

    private void setSourceIntransitStock(SourceExecuteContextVo sourceExecuteContextVo, List<String> skuCodes, Map<String, DictDto> dictDtoMap, Integer day, List<String> logicWarehouseCodes, List<String> ztWarehouseCodes) {
        if (dictDtoMap.containsKey(SgDictEnum.SOURCE_SETTING_SUPPLY_RELATIONSHIP.getCode())) {
            DictDto dictDto = dictDtoMap.get(SgDictEnum.SOURCE_SETTING_SUPPLY_RELATIONSHIP.getCode());
            int supplyFlag = StringUtils.isEmpty((CharSequence)dictDto.getValue()) ? 0 : Integer.valueOf(dictDto.getValue());
            logger.info("\u9700\u8981\u4f9b\u8d27\u5173\u7cfb\u7684\u5728\u9014\u5224\u65ad={}", (Object)supplyFlag);
            if (supplyFlag == 1) {
                if (CollectionUtils.isNotEmpty(sourceExecuteContextVo.getCurrentChannelZtLogicCodeSet())) {
                    ztWarehouseCodes = Lists.newArrayList(sourceExecuteContextVo.getCurrentChannelZtLogicCodeSet());
                    logicWarehouseCodes = Lists.newArrayList();
                } else {
                    ztWarehouseCodes = Lists.newArrayList();
                    logicWarehouseCodes = Lists.newArrayList();
                }
                logger.info("\u4f9b\u8d27\u5173\u7cfb\u7684\u903b\u8f91\u4ed3={}", (Object)JSON.toJSONString((Object)logicWarehouseCodes));
                logger.info("\u4f9b\u8d27\u5173\u7cfb\u7684\u5728\u9014\u4ed3={}", (Object)JSON.toJSONString((Object)ztWarehouseCodes));
            }
        }
        sourceExecuteContextVo.setIntransitCargoRespDtoList(this.warehouseDataQuery.queryZtCargoBatchNum(logicWarehouseCodes, skuCodes, day, ztWarehouseCodes));
    }

    private Map<Long, Map<String, WarehouseInventoryVo>> assembleCurrentWarehouseGroupTotalInventoryDtoMap(Map<Long, Map<String, List<WarehouseInventoryVo>>> currentWarehouseGroupInventoryDtoMap) {
        HashMap<Long, Map<String, WarehouseInventoryVo>> currentWarehouseGroupTotalInventoryDtoMap = new HashMap<Long, Map<String, WarehouseInventoryVo>>();
        currentWarehouseGroupInventoryDtoMap.forEach((warehouseId, map) -> {
            HashMap inventoryMap = new HashMap();
            currentWarehouseGroupTotalInventoryDtoMap.put((Long)warehouseId, inventoryMap);
            map.forEach((skuCode, inventoryVoList) -> {
                WarehouseInventoryVo warehouseInventoryVo = new WarehouseInventoryVo();
                if (CollectionUtils.isNotEmpty((Collection)inventoryVoList)) {
                    CubeBeanUtils.copyProperties((Object)((Object)warehouseInventoryVo), inventoryVoList.get(0), (String[])new String[0]);
                    warehouseInventoryVo.setSurplusStock(inventoryVoList.stream().map(WarehouseInventoryVo::getSurplusStock).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                    warehouseInventoryVo.setZtSaleable(inventoryVoList.stream().filter(dto -> Objects.nonNull(dto.getZtSaleable())).map(WarehouseInventoryVo::getZtSaleable).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                    inventoryMap.put(skuCode, warehouseInventoryVo);
                }
            });
        });
        return currentWarehouseGroupTotalInventoryDtoMap;
    }

    private SourceOrderResultRespDto buildSourceResultByOrderDetailRespDto(OrderDetailRespDto orderDetailRespDto) {
        SourceOrderResultRespDto sourceOrderResultRespDto = new SourceOrderResultRespDto();
        CubeBeanUtils.copyProperties((Object)sourceOrderResultRespDto, (Object)orderDetailRespDto, (String[])new String[0]);
        sourceOrderResultRespDto.setSgStatus(SourceStatusEnum.SOURCING.getCode());
        return sourceOrderResultRespDto;
    }

    private void testResultByOneWarehouse(DgLogicWarehouseDto csLogicWarehousePageRespDto, SourceOrderResultRespDto sourceOrderResultRespDto) {
        sourceOrderResultRespDto.setSgStatus(SourceStatusEnum.SOURCE_SUCCESS.getCode());
        sourceOrderResultRespDto.setOrderItemResultRespDtoList(sourceOrderResultRespDto.getOrderItemRespDtoList().stream().map(dto -> {
            OrderItemResultRespDto orderItemResultRespDto = new OrderItemResultRespDto();
            CubeBeanUtils.copyProperties((Object)orderItemResultRespDto, (Object)dto, (String[])new String[0]);
            orderItemResultRespDto.setId(null);
            orderItemResultRespDto.setDeliveryItemNum(dto.getItemNum());
            orderItemResultRespDto.setDeliveryLogicWarehouseId(csLogicWarehousePageRespDto.getId());
            orderItemResultRespDto.setDeliveryLogicWarehouseCode(csLogicWarehousePageRespDto.getWarehouseCode());
            orderItemResultRespDto.setDeliveryLogicWarehouseName(csLogicWarehousePageRespDto.getWarehouseName());
            orderItemResultRespDto.setDeliveryItemBatchNo(dto.getItemBatchNo());
            orderItemResultRespDto.setLinkItemSkuCode(dto.getItemSkuCode());
            return orderItemResultRespDto;
        }).collect(Collectors.toList()));
    }

    @Override
    public List<OrderItemResultRespDto> saleOrderOldBatchMatch(SaleOrderOldBatchMatchReqDto reqDto) {
        logger.info("\u9500\u552e\u5355\u5339\u914d\u65e7\u6279\u6b21\u5728\u9014\u53ef\u552e\u5e93\u5b58\u5165\u53c2={}", JSON.toJSON((Object)reqDto));
        AssertUtils.notEmpty((String)reqDto.getLinkOrderNo(), (String)"\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty((Collection)reqDto.getOrderItemReqDtoList(), (String)"\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty((Object)reqDto.getLogicWarehouseId(), (String)"\u53d1\u8d27\u903b\u8f91\u4ed3\u4e0d\u80fd\u4e3a\u7a7a");
        List dictDtoList = (List)RestResponseHelper.extractData((RestResponse)this.pcpDictApi.queryByGroupCode("COMMON_CONFIG"));
        Map<String, DictDto> dictDtoMap = dictDtoList.stream().collect(Collectors.toMap(DictDto::getCode, v1 -> v1, (v1, v2) -> v1));
        boolean transitSwitchFlag = false;
        if (dictDtoMap.containsKey(SgDictEnum.IN_TRANSIT_INVENTORY_SWITCH.getCode())) {
            String transitSwitchValue = dictDtoMap.get(SgDictEnum.IN_TRANSIT_INVENTORY_SWITCH.getCode()).getValue();
            transitSwitchFlag = Objects.equals(transitSwitchValue, "1");
        }
        logger.info("\u901a\u7528\u914d\u7f6e\u662f\u5426\u5f00\u542f\u5728\u9014\u53ef\u552e={}", (Object)transitSwitchFlag);
        ArrayList orderItemResultRespDtoList = new ArrayList();
        CubeBeanUtils.copyCollection(orderItemResultRespDtoList, (Collection)reqDto.getOrderItemReqDtoList(), OrderItemResultRespDto.class);
        if (!transitSwitchFlag) {
            return Lists.newArrayList();
        }
        SourceExecuteContextVo sourceExecuteContextVo = this.buildSourceExecuteContextVo(reqDto);
        sourceExecuteContextVo.setDictDtoMap(dictDtoMap);
        sourceExecuteContextVo.setZtStatusFlag(transitSwitchFlag);
        List<ChannelWarehouseRespDto> channelWarehouseRespDtos = this.warehouseDataQuery.queryChannelWarehouseByChannelCode(reqDto.getLinkOrderChannelWarehouseCode());
        if (CollectionUtils.isEmpty(channelWarehouseRespDtos)) {
            throw SourceExceptionCode.SOURCE_EXECUTE_DATA_QUERY_ERROR.buildBizException(new String[]{"\u5171\u4eab\u4e2d\u5fc3\u6e20\u9053\u4ed3"});
        }
        ChannelWarehouseRespDto shareChannelWarehouseRespDto = channelWarehouseRespDtos.get(0);
        sourceExecuteContextVo.setShareChannelWarehouseRespDto(shareChannelWarehouseRespDto);
        List logicWarehouseList = shareChannelWarehouseRespDto.getLogicWarehouseList();
        if (CollectionUtils.isEmpty((Collection)logicWarehouseList)) {
            throw SourceExceptionCode.SOURCE_EXECUTE_DATA_QUERY_ERROR.buildBizException(new String[]{"\u5171\u4eab\u4e2d\u5fc3\u6e20\u9053\u4ed3\u5173\u8054\u7684\u903b\u8f91\u4ed3\u4fe1\u606f"});
        }
        ArrayList warehouseCodes = Lists.newArrayList((Object[])new String[]{reqDto.getLogicWarehouseCode()});
        List<String> skuCodes = reqDto.getOrderItemReqDtoList().stream().map(OrderItemReqDto::getItemSkuCode).distinct().collect(Collectors.toList());
        Set<String> ztCodeSet = logicWarehouseList.stream().filter(dto -> Objects.equals(dto.getWarehouseClassify(), CsWarehouseClassifyEnum.IN_TRANSIT.getCode())).map(CsLogicWarehouseRespDto::getWarehouseCode).collect(Collectors.toSet());
        sourceExecuteContextVo.setCurrentChannelZtLogicCodeSet(ztCodeSet);
        logger.info("\u5728\u9014\u4ed3\u7c7b\u578b\u903b\u8f91\u4ed3\u96c6\u5408:{}", (Object)JSON.toJSONString(ztCodeSet));
        Integer day = 0;
        day = this.getIntransitDay(dictDtoMap, day);
        ArrayList logicWarehouseCodes = Lists.newArrayList((Object[])new String[]{reqDto.getLogicWarehouseCode()});
        ArrayList ztWarehouseCodes = Lists.newArrayList();
        this.setSourceIntransitStock(sourceExecuteContextVo, skuCodes, dictDtoMap, day, logicWarehouseCodes, ztWarehouseCodes);
        List<WarehouseInventoryVo> warehouseInventoryVoList = this.warehouseDataQuery.queryCsLogicInventoryBalanceByRuleVo(warehouseCodes, skuCodes, sourceExecuteContextVo);
        if (transitSwitchFlag) {
            warehouseInventoryVoList = this.warehouseDataQuery.queryCsLogicInventoryGroupZt(warehouseInventoryVoList, sourceExecuteContextVo);
        }
        Map<Long, List<WarehouseInventoryVo>> tempInventoryMap = warehouseInventoryVoList.stream().collect(Collectors.groupingBy(CsInventoryBasicsQueryRespDto::getWarehouseId));
        HashMap<Long, Map<String, List<WarehouseInventoryVo>>> currentWarehouseGroupInventoryDtoMap = new HashMap<Long, Map<String, List<WarehouseInventoryVo>>>();
        tempInventoryMap.forEach((k, v) -> currentWarehouseGroupInventoryDtoMap.put((Long)k, v.stream().collect(Collectors.groupingBy(CsInventoryBasicsQueryRespDto::getLongCode))));
        sourceExecuteContextVo.setCurrentWarehouseGroupInventoryDtoMap(currentWarehouseGroupInventoryDtoMap);
        sourceExecuteContextVo.setCurrentClueActRespDto(new ClueActRespDto());
        ArrayList<SourceGroupRuleScoreResultGroupVo> afterScoreVoList = new ArrayList<SourceGroupRuleScoreResultGroupVo>();
        SourceGroupRuleScoreResultGroupVo scoreResultGroupVo = new SourceGroupRuleScoreResultGroupVo();
        DgLogicWarehouseDto dgLogicWarehouseDto = new DgLogicWarehouseDto();
        dgLogicWarehouseDto.setId(reqDto.getLogicWarehouseId());
        scoreResultGroupVo.setCsLogicWarehousePageRespDto(dgLogicWarehouseDto);
        afterScoreVoList.add(scoreResultGroupVo);
        List<OrderItemResultRespDto> orderItemResultRespDtos = this.itemOldBatchWarehouseMatch(afterScoreVoList, sourceExecuteContextVo, null);
        logger.info("\u9500\u552e\u8ba2\u5355\u5bfb\u6e90\u5339\u914d\u5e93\u5b58\u8fd4\u56de\u7ed3\u679c={}", JSON.toJSON(orderItemResultRespDtos));
        return orderItemResultRespDtos;
    }

    private SourceExecuteContextVo buildSourceExecuteContextVo(SaleOrderOldBatchMatchReqDto saleOrderOldBatchMatchReqDto) {
        SourceExecuteContextVo contextVo = new SourceExecuteContextVo();
        List<OrderItemRespDto> surplusOrderItemRespDtoList = saleOrderOldBatchMatchReqDto.getOrderItemReqDtoList().stream().map(saleOrderItemExtRespDto -> {
            OrderItemRespDto orderItemRespDto = new OrderItemRespDto();
            CubeBeanUtils.copyProperties((Object)orderItemRespDto, (Object)saleOrderItemExtRespDto, (String[])new String[0]);
            orderItemRespDto.setOrigItemNum(orderItemRespDto.getItemNum());
            return orderItemRespDto;
        }).collect(Collectors.toList());
        contextVo.setSurplusOrderItemRespDtoList(surplusOrderItemRespDtoList);
        return contextVo;
    }

    private Integer getIntransitDay(Map<String, DictDto> dictDtoMap, Integer day) {
        DictDto dictDto;
        String value;
        Map map;
        Integer status;
        boolean flag;
        if (dictDtoMap.containsKey(SgDictEnum.INVENTORY_AVAILABLE_IN_TRANSIT_DAY.getCode()) && (flag = Objects.equals(status = Integer.valueOf((map = (Map)JSON.parseObject((String)(value = (dictDto = dictDtoMap.get(SgDictEnum.INVENTORY_AVAILABLE_IN_TRANSIT_DAY.getCode())).getValue()), Map.class)).get("status").toString()), 1))) {
            day = Integer.valueOf(map.get("day").toString());
        }
        return day;
    }
}

