/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.source.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.center.source.api.dto.request.ClueWarehouseGroupReqDto;
import com.dtyunxi.cube.center.source.api.dto.response.ClueWarehouseGroupRespDto;
import com.dtyunxi.cube.center.source.api.exception.SourceAssert;
import com.dtyunxi.cube.center.source.api.exception.SourceExceptionCode;
import com.dtyunxi.cube.center.source.biz.service.IClueWarehouseGroupService;
import com.dtyunxi.cube.center.source.dao.das.ClueWarehouseGroupDas;
import com.dtyunxi.cube.center.source.dao.eo.ClueWarehouseGroupEo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ClueWarehouseGroupServiceImpl
implements IClueWarehouseGroupService {
    @Resource
    private ClueWarehouseGroupDas clueWarehouseGroupDas;

    @Override
    public Long addClueWarehouseGroup(ClueWarehouseGroupReqDto addReqDto) {
        ClueWarehouseGroupEo clueWarehouseGroupEo = new ClueWarehouseGroupEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)clueWarehouseGroupEo);
        this.clueWarehouseGroupDas.insert((BaseEo)clueWarehouseGroupEo);
        return clueWarehouseGroupEo.getId();
    }

    @Override
    public int addClueWarehouseGroupList(List<? extends ClueWarehouseGroupReqDto> addReqDtoList) {
        ArrayList clueWarehouseGroupEoList = new ArrayList();
        DtoHelper.dtoList2EoList(addReqDtoList, clueWarehouseGroupEoList, ClueWarehouseGroupEo.class);
        return this.clueWarehouseGroupDas.insertBatch(clueWarehouseGroupEoList);
    }

    @Override
    public void modifyClueWarehouseGroup(ClueWarehouseGroupReqDto modifyReqDto) {
        ClueWarehouseGroupEo clueWarehouseGroupEo = new ClueWarehouseGroupEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)clueWarehouseGroupEo);
        this.clueWarehouseGroupDas.updateSelective((BaseEo)clueWarehouseGroupEo);
    }

    @Override
    public void modifyClueWarehouseGroupBySelect(ClueWarehouseGroupEo updateEo, ClueWarehouseGroupEo selectEo) {
        UpdateWrapper updateWrapper = new UpdateWrapper((Object)selectEo);
        if (updateWrapper.isEmptyOfWhere()) {
            throw new BizException("-1", "\u66f4\u65b0\u6761\u4ef6\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        this.clueWarehouseGroupDas.getMapper().update((Object)updateEo, (Wrapper)updateWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeClueWarehouseGroup(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.clueWarehouseGroupDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ClueWarehouseGroupRespDto queryById(Long id) {
        ClueWarehouseGroupEo clueWarehouseGroupEo = (ClueWarehouseGroupEo)this.clueWarehouseGroupDas.selectByPrimaryKey(id);
        if (clueWarehouseGroupEo == null) {
            return null;
        }
        ClueWarehouseGroupRespDto clueWarehouseGroupRespDto = new ClueWarehouseGroupRespDto();
        DtoHelper.eo2Dto((BaseEo)clueWarehouseGroupEo, (BaseVo)clueWarehouseGroupRespDto);
        return clueWarehouseGroupRespDto;
    }

    @Override
    public PageInfo<ClueWarehouseGroupRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ClueWarehouseGroupReqDto clueWarehouseGroupReqDto = (ClueWarehouseGroupReqDto)JSON.parseObject((String)filter, ClueWarehouseGroupReqDto.class);
        ClueWarehouseGroupEo clueWarehouseGroupEo = new ClueWarehouseGroupEo();
        DtoHelper.dto2Eo((BaseVo)clueWarehouseGroupReqDto, (BaseEo)clueWarehouseGroupEo);
        PageInfo eoPageInfo = this.clueWarehouseGroupDas.selectPage((BaseEo)clueWarehouseGroupEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ClueWarehouseGroupRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<ClueWarehouseGroupRespDto> queryByClueIdList(Set<Long> clueIdList) {
        SourceAssert.notEmpty(clueIdList, (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u7b56\u7565id\u96c6\u5408"});
        List clueWarehouseGroupEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.clueWarehouseGroupDas.filter().in((Object)"sg_clue_id", clueIdList)).eq((Object)"dr", (Object)0)).orderByAsc((Object)"warehouse_group_priority_level")).list(Integer.valueOf(1000));
        if (CollectionUtils.isEmpty((Collection)clueWarehouseGroupEoList)) {
            return null;
        }
        ArrayList<ClueWarehouseGroupRespDto> dtoList = new ArrayList<ClueWarehouseGroupRespDto>();
        DtoHelper.eoList2DtoList((Collection)clueWarehouseGroupEoList, dtoList, ClueWarehouseGroupRespDto.class);
        return dtoList;
    }
}

