/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.source.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.center.source.api.dto.request.DismantleWhiteReqDto;
import com.dtyunxi.cube.center.source.api.dto.response.DismantleWhiteRespDto;
import com.dtyunxi.cube.center.source.api.exception.SourceAssert;
import com.dtyunxi.cube.center.source.api.exception.SourceExceptionCode;
import com.dtyunxi.cube.center.source.biz.service.IDismantleWhiteService;
import com.dtyunxi.cube.center.source.dao.das.DismantleWhiteDas;
import com.dtyunxi.cube.center.source.dao.eo.DismantleWhiteEo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DismantleWhiteServiceImpl
implements IDismantleWhiteService {
    @Resource
    private DismantleWhiteDas dismantleWhiteDas;

    @Override
    public Long addDismantleWhite(DismantleWhiteReqDto addReqDto) {
        DismantleWhiteEo dismantleWhite = (DismantleWhiteEo)((ExtQueryChainWrapper)this.dismantleWhiteDas.filter().eq((Object)"customer_id", (Object)addReqDto.getCustomerId())).one();
        if (dismantleWhite != null) {
            throw SourceExceptionCode.DATA_EXISTENCE.buildBizException();
        }
        DismantleWhiteEo dismantleWhiteEo = new DismantleWhiteEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)dismantleWhiteEo);
        this.dismantleWhiteDas.insert((BaseEo)dismantleWhiteEo);
        return dismantleWhiteEo.getId();
    }

    @Override
    public void modifyDismantleWhite(DismantleWhiteReqDto modifyReqDto) {
        DismantleWhiteEo dismantleWhiteEo = new DismantleWhiteEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)dismantleWhiteEo);
        this.dismantleWhiteDas.updateSelective((BaseEo)dismantleWhiteEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeDismantleWhite(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.dismantleWhiteDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public DismantleWhiteRespDto queryById(Long id) {
        DismantleWhiteEo dismantleWhiteEo = (DismantleWhiteEo)this.dismantleWhiteDas.selectByPrimaryKey(id);
        if (dismantleWhiteEo == null) {
            return null;
        }
        DismantleWhiteRespDto dismantleWhiteRespDto = new DismantleWhiteRespDto();
        DtoHelper.eo2Dto((BaseEo)dismantleWhiteEo, (BaseVo)dismantleWhiteRespDto);
        return dismantleWhiteRespDto;
    }

    @Override
    public PageInfo<DismantleWhiteRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        DismantleWhiteReqDto dismantleWhiteReqDto = (DismantleWhiteReqDto)JSON.parseObject((String)filter, DismantleWhiteReqDto.class);
        DismantleWhiteEo dismantleWhiteEo = new DismantleWhiteEo();
        DtoHelper.dto2Eo((BaseVo)dismantleWhiteReqDto, (BaseEo)dismantleWhiteEo);
        PageInfo eoPageInfo = this.dismantleWhiteDas.selectPage((BaseEo)dismantleWhiteEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, DismantleWhiteRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSaveDismantleWhite(List<DismantleWhiteReqDto> lists) {
        SourceAssert.notEmpty(lists, (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_EMPTY, (String[])new String[]{"\u5ba2\u6237id\u96c6\u5408"});
        List customerIds = lists.stream().map(DismantleWhiteReqDto::getCustomerId).collect(Collectors.toList());
        List dismantleWhiteList = ((ExtQueryChainWrapper)this.dismantleWhiteDas.filter().in((Object)"customer_id", customerIds)).list(Integer.valueOf(lists.size()));
        if (CollectionUtils.isNotEmpty((Collection)dismantleWhiteList)) {
            dismantleWhiteList.forEach(i -> this.dismantleWhiteDas.logicDeleteById(i.getId()));
        }
        List eoList = lists.stream().map(i -> {
            DismantleWhiteEo eo = new DismantleWhiteEo();
            DtoHelper.dto2Eo((BaseVo)i, (BaseEo)eo);
            eo.setCreatePerson(i.getOperator());
            eo.setUpdatePerson(i.getOperator());
            return eo;
        }).collect(Collectors.toList());
        this.dismantleWhiteDas.insertBatch(eoList);
    }

    @Override
    public List<DismantleWhiteRespDto> queryList(DismantleWhiteReqDto queryDto) {
        ExtQueryChainWrapper filter = this.dismantleWhiteDas.filter();
        Integer size = 10000;
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getCustomerIds())) {
            filter.in((Object)"customer_id", (Collection)queryDto.getCustomerIds());
            size = queryDto.getCustomerIds().size();
        } else if (Objects.nonNull(queryDto.getCustomerId())) {
            filter.eq((Object)"customer_id", (Object)queryDto.getCustomerId());
            size = 10;
        }
        List list = filter.list(size);
        ArrayList respDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)list, (Collection)respDtoList, DismantleWhiteRespDto.class);
        return respDtoList;
    }

    @Override
    public PageInfo<DismantleWhiteRespDto> queryPage(DismantleWhiteReqDto queryDto) {
        DismantleWhiteEo dismantleWhiteEo = new DismantleWhiteEo();
        DtoHelper.dto2Eo((BaseVo)queryDto, (BaseEo)dismantleWhiteEo);
        ArrayList sqlFilters = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getCustomerIds())) {
            dismantleWhiteEo.setCustomerId(null);
            sqlFilters.add(SqlFilter.in((String)"customer_id", (Object)queryDto.getCustomerIds()));
        }
        dismantleWhiteEo.setSqlFilters((List)sqlFilters);
        dismantleWhiteEo.setOrderByDesc("customer_id");
        PageInfo eoPageInfo = this.dismantleWhiteDas.selectPage((BaseEo)dismantleWhiteEo, queryDto.getPageNum(), queryDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, DismantleWhiteRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

