/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.source.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.center.source.api.dto.request.ClueWarehouseItemBlackListReqDto;
import com.dtyunxi.cube.center.source.api.dto.response.ClueItemBlackListCityDto;
import com.dtyunxi.cube.center.source.api.dto.response.ClueWarehouseItemBlackListRespDto;
import com.dtyunxi.cube.center.source.api.exception.SourceAssert;
import com.dtyunxi.cube.center.source.api.exception.SourceExceptionCode;
import com.dtyunxi.cube.center.source.biz.service.IClueWarehouseItemBlackListService;
import com.dtyunxi.cube.center.source.dao.das.ClueWarehouseItemBlackListDas;
import com.dtyunxi.cube.center.source.dao.eo.ClueWarehouseItemBlackListEo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ClueWarehouseItemBlackListServiceImpl
implements IClueWarehouseItemBlackListService {
    @Resource
    private ClueWarehouseItemBlackListDas clueWarehouseItemBlackListDas;

    @Override
    public Long addClueWarehouseItemBlackList(ClueWarehouseItemBlackListReqDto addReqDto) {
        addReqDto.setReceiveCity(JSON.toJSONString((Object)addReqDto.getReceiveCityCodeList()));
        ClueWarehouseItemBlackListEo clueWarehouseItemBlackListEo = new ClueWarehouseItemBlackListEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)clueWarehouseItemBlackListEo);
        this.clueWarehouseItemBlackListDas.insert((BaseEo)clueWarehouseItemBlackListEo);
        return clueWarehouseItemBlackListEo.getId();
    }

    @Override
    public int addClueWarehouseItemBlackListBatch(List<ClueWarehouseItemBlackListReqDto> addReqDtoList) {
        for (ClueWarehouseItemBlackListReqDto clueWarehouseItemBlackListReqDto : addReqDtoList) {
            clueWarehouseItemBlackListReqDto.setReceiveCity(JSON.toJSONString((Object)clueWarehouseItemBlackListReqDto.getReceiveCityCodeList()));
        }
        ArrayList clueWarehouseItemBlackListEos = Lists.newArrayList();
        DtoHelper.dtoList2EoList(addReqDtoList, (Collection)clueWarehouseItemBlackListEos, ClueWarehouseItemBlackListEo.class);
        return this.clueWarehouseItemBlackListDas.insertBatch((List)clueWarehouseItemBlackListEos);
    }

    @Override
    public void modifyClueWarehouseItemBlackList(ClueWarehouseItemBlackListReqDto modifyReqDto) {
        ClueWarehouseItemBlackListEo clueWarehouseItemBlackListEo = new ClueWarehouseItemBlackListEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)clueWarehouseItemBlackListEo);
        this.clueWarehouseItemBlackListDas.updateSelective((BaseEo)clueWarehouseItemBlackListEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeClueWarehouseItemBlackList(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.clueWarehouseItemBlackListDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ClueWarehouseItemBlackListRespDto queryById(Long id) {
        ClueWarehouseItemBlackListEo clueWarehouseItemBlackListEo = (ClueWarehouseItemBlackListEo)this.clueWarehouseItemBlackListDas.selectByPrimaryKey(id);
        ClueWarehouseItemBlackListRespDto clueWarehouseItemBlackListRespDto = new ClueWarehouseItemBlackListRespDto();
        DtoHelper.eo2Dto((BaseEo)clueWarehouseItemBlackListEo, (BaseVo)clueWarehouseItemBlackListRespDto);
        if (StringUtils.isNotEmpty((CharSequence)clueWarehouseItemBlackListEo.getReceiveCity())) {
            List clueItemBlackListCityDtos = JSON.parseArray((String)clueWarehouseItemBlackListEo.getReceiveCity(), ClueItemBlackListCityDto.class);
            clueWarehouseItemBlackListRespDto.setReceiveCityCodeList(clueItemBlackListCityDtos);
        }
        return clueWarehouseItemBlackListRespDto;
    }

    @Override
    public List<ClueWarehouseItemBlackListRespDto> queryByClueIdList(Set<Long> clueIdList) {
        SourceAssert.notEmpty(clueIdList, (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u7b56\u7565id\u96c6\u5408"});
        List clueWarehouseGroupEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.clueWarehouseItemBlackListDas.filter().in((Object)"sg_clue_id", clueIdList)).eq((Object)"dr", (Object)0)).list(Integer.valueOf(1000));
        if (CollectionUtils.isEmpty((Collection)clueWarehouseGroupEoList)) {
            return null;
        }
        ArrayList<ClueWarehouseItemBlackListRespDto> dtoList = new ArrayList<ClueWarehouseItemBlackListRespDto>();
        DtoHelper.eoList2DtoList((Collection)clueWarehouseGroupEoList, dtoList, ClueWarehouseItemBlackListRespDto.class);
        for (ClueWarehouseItemBlackListRespDto clueWarehouseItemBlackListRespDto : dtoList) {
            if (!StringUtils.isNotEmpty((CharSequence)clueWarehouseItemBlackListRespDto.getReceiveCity())) continue;
            List clueItemBlackListCityDtos = JSON.parseArray((String)clueWarehouseItemBlackListRespDto.getReceiveCity(), ClueItemBlackListCityDto.class);
            clueWarehouseItemBlackListRespDto.setReceiveCityCodeList(clueItemBlackListCityDtos);
        }
        return dtoList;
    }

    @Override
    public PageInfo<ClueWarehouseItemBlackListRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ClueWarehouseItemBlackListReqDto ClueWarehouseItemBlackListReqDto2 = (ClueWarehouseItemBlackListReqDto)JSON.parseObject((String)filter, ClueWarehouseItemBlackListReqDto.class);
        ClueWarehouseItemBlackListEo ClueWarehouseItemBlackListEo2 = new ClueWarehouseItemBlackListEo();
        DtoHelper.dto2Eo((BaseVo)ClueWarehouseItemBlackListReqDto2, (BaseEo)ClueWarehouseItemBlackListEo2);
        PageInfo eoPageInfo = this.clueWarehouseItemBlackListDas.selectPage((BaseEo)ClueWarehouseItemBlackListEo2, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ClueWarehouseItemBlackListRespDto.class);
        for (ClueWarehouseItemBlackListRespDto clueWarehouseItemBlackListRespDto : dtoList) {
            if (!StringUtils.isNotEmpty((CharSequence)clueWarehouseItemBlackListRespDto.getReceiveCity())) continue;
            List clueItemBlackListCityDtos = JSON.parseArray((String)clueWarehouseItemBlackListRespDto.getReceiveCity(), ClueItemBlackListCityDto.class);
            clueWarehouseItemBlackListRespDto.setReceiveCityCodeList(clueItemBlackListCityDtos);
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void modifyClueWarehouseItemBlackListBySelect(ClueWarehouseItemBlackListEo updateEo, ClueWarehouseItemBlackListEo selectEo) {
        UpdateWrapper updateWrapper = new UpdateWrapper((Object)selectEo);
        if (updateWrapper.isEmptyOfWhere()) {
            throw new BizException("-1", "\u66f4\u65b0\u6761\u4ef6\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        this.clueWarehouseItemBlackListDas.getMapper().update((Object)updateEo, (Wrapper)updateWrapper);
    }

    @Override
    public List<ClueWarehouseItemBlackListRespDto> queryByClueId(Long clueId) {
        ClueWarehouseItemBlackListEo clueDeliveryWarehouseBlackEo = new ClueWarehouseItemBlackListEo();
        clueDeliveryWarehouseBlackEo.setSgClueId(clueId);
        List eos = this.clueWarehouseItemBlackListDas.select((BaseEo)clueDeliveryWarehouseBlackEo);
        ArrayList<ClueWarehouseItemBlackListRespDto> dtoList = new ArrayList<ClueWarehouseItemBlackListRespDto>();
        DtoHelper.eoList2DtoList((Collection)eos, dtoList, ClueWarehouseItemBlackListRespDto.class);
        return dtoList;
    }
}

