/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.source.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.center.source.api.dto.request.SourceLogReqDto;
import com.dtyunxi.cube.center.source.api.dto.response.SourceLogDetailRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.SourceLogRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.SourceLogSpecificRespDto;
import com.dtyunxi.cube.center.source.api.exception.SourceAssert;
import com.dtyunxi.cube.center.source.api.exception.SourceExceptionCode;
import com.dtyunxi.cube.center.source.biz.service.ISourceLogDetailService;
import com.dtyunxi.cube.center.source.biz.service.ISourceLogService;
import com.dtyunxi.cube.center.source.dao.das.SourceLogDas;
import com.dtyunxi.cube.center.source.dao.eo.SourceLogEo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SourceLogServiceImpl
implements ISourceLogService {
    @Resource
    private SourceLogDas sourceLogDas;
    @Resource
    private ISourceLogDetailService sourceLogDetailService;

    @Override
    public Long addSourceLog(SourceLogReqDto addReqDto) {
        SourceLogEo sourceLogEo = new SourceLogEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)sourceLogEo);
        this.sourceLogDas.insert((BaseEo)sourceLogEo);
        return sourceLogEo.getId();
    }

    @Override
    public void modifySourceLog(SourceLogReqDto modifyReqDto) {
        SourceLogEo sourceLogEo = new SourceLogEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)sourceLogEo);
        this.sourceLogDas.updateSelective((BaseEo)sourceLogEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeSourceLog(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.sourceLogDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public SourceLogRespDto queryById(Long id) {
        SourceLogEo sourceLogEo = (SourceLogEo)this.sourceLogDas.selectByPrimaryKey(id);
        if (sourceLogEo == null) {
            return null;
        }
        SourceLogRespDto sourceLogRespDto = new SourceLogRespDto();
        DtoHelper.eo2Dto((BaseEo)sourceLogEo, (BaseVo)sourceLogRespDto);
        return sourceLogRespDto;
    }

    @Override
    public SourceLogSpecificRespDto querySpecificById(Long id) {
        SourceAssert.notNull((Object)id, (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u5bfb\u6e90\u65e5\u5fd7id"});
        SourceLogEo oneEo = (SourceLogEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.sourceLogDas.filter().eq((Object)"id", (Object)id)).eq((Object)"dr", (Object)0)).one();
        List<SourceLogDetailRespDto> respDtoList = this.sourceLogDetailService.queryByLogId(id);
        SourceLogSpecificRespDto respDto = new SourceLogSpecificRespDto();
        CubeBeanUtils.copyProperties((Object)respDto, (Object)oneEo, (String[])new String[0]);
        respDto.setSourceLogDetailRespDtoList(respDtoList);
        return respDto;
    }

    @Override
    public SourceLogSpecificRespDto querySpecificByOrderId(Long sgOrderId) {
        SourceAssert.notNull((Object)sgOrderId, (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u5bfb\u6e90\u65e5\u5fd7id"});
        SourceLogEo oneEo = (SourceLogEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.sourceLogDas.filter().eq((Object)"sg_order_id", (Object)sgOrderId)).eq((Object)"dr", (Object)0)).one();
        SourceAssert.notNull((Object)oneEo, (SourceExceptionCode)SourceExceptionCode.SOURCE_EXECUTE_DATA_QUERY_EMPTY, (String[])new String[]{"\u5173\u8054\u5bfb\u6e90\u65e5\u5fd7", String.valueOf(sgOrderId)});
        return this.querySpecificById(oneEo.getId());
    }

    @Override
    public PageInfo<SourceLogRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        SourceLogReqDto sourceLogReqDto = (SourceLogReqDto)JSON.parseObject((String)filter, SourceLogReqDto.class);
        SourceLogEo sourceLogEo = new SourceLogEo();
        DtoHelper.dto2Eo((BaseVo)sourceLogReqDto, (BaseEo)sourceLogEo);
        PageInfo eoPageInfo = this.sourceLogDas.selectPage((BaseEo)sourceLogEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, SourceLogRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

