/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.source.biz.service.calculator.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.center.source.api.constant.ClueWarehouseGroupRuleTypeEnum;
import com.dtyunxi.cube.center.source.api.constant.SgDictEnum;
import com.dtyunxi.cube.center.source.api.dto.response.ClueWarehouseGroupRuleDeliveryRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.ClueWarehouseGroupRuleRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.FreightCostRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.OrderItemRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.WarehouseProvideGoodsRangeRespDto;
import com.dtyunxi.cube.center.source.api.exception.SourceAssert;
import com.dtyunxi.cube.center.source.api.exception.SourceExceptionCode;
import com.dtyunxi.cube.center.source.biz.service.calculator.SourceOrderGroupRuleTypeCalculator;
import com.dtyunxi.cube.center.source.biz.utils.SourceExecuteUtils;
import com.dtyunxi.cube.center.source.biz.vo.SourceExecuteContextVo;
import com.dtyunxi.cube.center.source.biz.vo.SourceGroupRuleScoreResultGroupVo;
import com.dtyunxi.cube.center.source.biz.vo.WarehouseAddressVo;
import com.dtyunxi.cube.center.source.biz.vo.WarehouseDeliveryThresholdVo;
import com.dtyunxi.cube.center.source.biz.vo.WarehouseInventoryVo;
import com.dtyunxi.cube.center.source.biz.vo.WarehouseOutboundOrderVo;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.PcpRegionRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.basics.CsInventoryBasicsQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderItemExtRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehouseDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgPhysicsWarehouseDto;
import com.yunxi.dg.base.commons.dto.BaseDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SourceOrderGroupRuleTypeCalculatorImpl
implements SourceOrderGroupRuleTypeCalculator {
    private static final Logger logger = LoggerFactory.getLogger(SourceOrderGroupRuleTypeCalculatorImpl.class);
    @Autowired
    private ISaleOrderQueryApi saleOrderQueryApi;

    @Override
    public List<SourceGroupRuleScoreResultGroupVo> calculationWarehouseListScore(ClueWarehouseGroupRuleRespDto clueWarehouseGroupRuleRespDto, List<DgLogicWarehouseDto> csLogicWarehousePageRespDtoList, SourceExecuteContextVo sourceExecuteContextVo) {
        List<SourceGroupRuleScoreResultGroupVo> sourceGroupRuleScoreResultGroupVoList = null;
        ClueWarehouseGroupRuleTypeEnum clueWarehouseGroupRuleTypeEnum = ClueWarehouseGroupRuleTypeEnum.forCode((String)clueWarehouseGroupRuleRespDto.getRuleTypeCode());
        switch (clueWarehouseGroupRuleTypeEnum) {
            case WAREHOUSE_ENOUGH: {
                sourceGroupRuleScoreResultGroupVoList = this.calculationWarehouseListScoreByWarehouseEnough(clueWarehouseGroupRuleRespDto, csLogicWarehousePageRespDtoList, sourceExecuteContextVo);
                break;
            }
            case LAT_NEAR: {
                sourceGroupRuleScoreResultGroupVoList = this.calculationWarehouseListScoreLatNear(clueWarehouseGroupRuleRespDto, csLogicWarehousePageRespDtoList, sourceExecuteContextVo);
                break;
            }
            case FREIGHT_CHEAP: {
                sourceGroupRuleScoreResultGroupVoList = this.calculationWarehouseListScoreFreightCheap(clueWarehouseGroupRuleRespDto, csLogicWarehousePageRespDtoList, sourceExecuteContextVo);
                break;
            }
            case WAREHOUSE_DELIVERY_THRESHOLD: {
                sourceGroupRuleScoreResultGroupVoList = this.calculationWarehouseListScoreWarehouseDeliveryThreshold(clueWarehouseGroupRuleRespDto, csLogicWarehousePageRespDtoList, sourceExecuteContextVo);
                break;
            }
            case WAREHOUSE_DELIVERY_RANGE: {
                sourceGroupRuleScoreResultGroupVoList = this.calculationWarehouseListScoreLatWarehouseDeliveryRange(clueWarehouseGroupRuleRespDto, csLogicWarehousePageRespDtoList, sourceExecuteContextVo);
                break;
            }
            case CUSTOMER_BATCH_REVERSE: {
                sourceGroupRuleScoreResultGroupVoList = this.calculationWarehouseListScoreCustomerBatchReverse(clueWarehouseGroupRuleRespDto, csLogicWarehousePageRespDtoList, sourceExecuteContextVo);
                break;
            }
            case WAREHOUSE_PRIORITY: {
                sourceGroupRuleScoreResultGroupVoList = this.calculationWarehouseListScoreWarehousePriority(clueWarehouseGroupRuleRespDto, csLogicWarehousePageRespDtoList, sourceExecuteContextVo);
                break;
            }
            case SPECIFY_SHIPMENT: {
                sourceGroupRuleScoreResultGroupVoList = this.calculationWarehouseListScoreSpecifyShipment(clueWarehouseGroupRuleRespDto, csLogicWarehousePageRespDtoList, sourceExecuteContextVo);
                break;
            }
            case TARGET_WAREHOUSE: {
                sourceGroupRuleScoreResultGroupVoList = this.calculationWarehouseListScoreLatTargetWarehouse(clueWarehouseGroupRuleRespDto, csLogicWarehousePageRespDtoList, sourceExecuteContextVo);
                break;
            }
            case TOTAL_WAREHOUSE: {
                sourceGroupRuleScoreResultGroupVoList = this.calculationWarehouseListScoreLatTotalWarehouse(clueWarehouseGroupRuleRespDto, csLogicWarehousePageRespDtoList, sourceExecuteContextVo);
                break;
            }
            case TARGET_PHYSICS_WAREHOUSE: {
                sourceGroupRuleScoreResultGroupVoList = this.calculationWarehouseListScoreLatTargetPhysicsWarehouse(clueWarehouseGroupRuleRespDto, csLogicWarehousePageRespDtoList, sourceExecuteContextVo);
                break;
            }
            case TOTAL_PHYSICS_WAREHOUSE: {
                sourceGroupRuleScoreResultGroupVoList = this.calculationWarehouseListScoreLatTotalPhysicsWarehouse(clueWarehouseGroupRuleRespDto, csLogicWarehousePageRespDtoList, sourceExecuteContextVo);
                break;
            }
            case DIY_PHYSICS_WAREHOUSE: {
                sourceGroupRuleScoreResultGroupVoList = this.calculationWarehouseListScoreDiyPhysicsWarehouse(clueWarehouseGroupRuleRespDto, csLogicWarehousePageRespDtoList, sourceExecuteContextVo);
                break;
            }
            default: {
                throw SourceExceptionCode.SOURCE_EXECUTE_GROUP_RULE_TYPE_FOR_ERROR.buildBizException();
            }
        }
        logger.info("\u3010\u5bfb\u6e90\u5b50\u89c4\u5219\u8ba1\u7b97\u5206\u503c\u3011ruleId={},ruleName={},scores={}", new Object[]{clueWarehouseGroupRuleRespDto.getId(), clueWarehouseGroupRuleRespDto.getRuleTypeName(), JSON.toJSONString(sourceGroupRuleScoreResultGroupVoList)});
        return sourceGroupRuleScoreResultGroupVoList;
    }

    private SourceGroupRuleScoreResultGroupVo buildSourceGroupRuleScoreResultGroupVo(BigDecimal score, DgLogicWarehouseDto csLogicWarehousePageRespDto, ClueWarehouseGroupRuleRespDto clueWarehouseGroupRuleRespDto) {
        SourceGroupRuleScoreResultGroupVo sourceGroupRuleScoreResultGroupVo = new SourceGroupRuleScoreResultGroupVo();
        sourceGroupRuleScoreResultGroupVo.setWarehouseResultScore(score);
        sourceGroupRuleScoreResultGroupVo.setCsLogicWarehousePageRespDto(csLogicWarehousePageRespDto);
        sourceGroupRuleScoreResultGroupVo.setClueWarehouseGroupRuleRespDto(clueWarehouseGroupRuleRespDto);
        return sourceGroupRuleScoreResultGroupVo;
    }

    private List<SourceGroupRuleScoreResultGroupVo> calculationWarehouseListScoreByWarehouseEnough(ClueWarehouseGroupRuleRespDto clueWarehouseGroupRuleRespDto, List<DgLogicWarehouseDto> csLogicWarehousePageRespDtoList, SourceExecuteContextVo sourceExecuteContextVo) {
        ArrayList<SourceGroupRuleScoreResultGroupVo> sourceGroupRuleScoreResultGroupVoList = new ArrayList<SourceGroupRuleScoreResultGroupVo>();
        csLogicWarehousePageRespDtoList.forEach(csLogicWarehousePageRespDto -> {
            Map<String, List<WarehouseInventoryVo>> warehouseInventoryVoMap = sourceExecuteContextVo.getCurrentWarehouseGroupInventoryDtoMap().get(csLogicWarehousePageRespDto.getId());
            AtomicInteger zeroFlag = new AtomicInteger(0);
            if (warehouseInventoryVoMap == null) {
                zeroFlag.incrementAndGet();
            } else {
                Map<String, OrderItemRespDto> surplusOrderItemRespDtoMap = sourceExecuteContextVo.getSurplusOrderItemRespDtoList().stream().collect(Collectors.toMap(OrderItemRespDto::getItemSkuCode, v1 -> {
                    OrderItemRespDto orderItemRespDto = new OrderItemRespDto();
                    CubeBeanUtils.copyProperties((Object)orderItemRespDto, (Object)v1, (String[])new String[0]);
                    return orderItemRespDto;
                }, (v1, v2) -> {
                    v1.setItemNum(v1.getItemNum().add(v2.getItemNum()));
                    return v1;
                }));
                HashMap inventoryBalanceMap = new HashMap();
                warehouseInventoryVoMap.forEach((k, v) -> inventoryBalanceMap.put(k, v.stream().map(CsInventoryBasicsQueryRespDto::getAvailable).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)));
                surplusOrderItemRespDtoMap.forEach((k, v) -> {
                    BigDecimal avl = (BigDecimal)inventoryBalanceMap.get(k);
                    if (avl == null) {
                        zeroFlag.incrementAndGet();
                    } else if (avl.compareTo(v.getItemNum()) < 0) {
                        zeroFlag.incrementAndGet();
                    }
                });
            }
            if (zeroFlag.get() <= 0) {
                BigDecimal score = this.calculationScoreByRuleScoreProportion(new BigDecimal(100), new BigDecimal(clueWarehouseGroupRuleRespDto.getRuleScoreProportion()));
                sourceGroupRuleScoreResultGroupVoList.add(this.buildSourceGroupRuleScoreResultGroupVo(score, (DgLogicWarehouseDto)csLogicWarehousePageRespDto, clueWarehouseGroupRuleRespDto));
            } else {
                sourceGroupRuleScoreResultGroupVoList.add(this.buildSourceGroupRuleScoreResultGroupVo(BigDecimal.ZERO, (DgLogicWarehouseDto)csLogicWarehousePageRespDto, clueWarehouseGroupRuleRespDto));
            }
        });
        sourceGroupRuleScoreResultGroupVoList.sort((o1, o2) -> o2.getWarehouseResultScore().compareTo(o1.getWarehouseResultScore()));
        return sourceGroupRuleScoreResultGroupVoList;
    }

    private List<SourceGroupRuleScoreResultGroupVo> calculationWarehouseListScoreLatNear(ClueWarehouseGroupRuleRespDto clueWarehouseGroupRuleRespDto, List<DgLogicWarehouseDto> csLogicWarehousePageRespDtoList, SourceExecuteContextVo sourceExecuteContextVo) {
        Map<String, PcpRegionRespDto> pcpRegionRespDtoMap = sourceExecuteContextVo.getOrderAddressPcpRegionRespDtoMap();
        PcpRegionRespDto matchRegionRespDto = Optional.ofNullable(pcpRegionRespDtoMap.get(sourceExecuteContextVo.getOrderDetailRespDto().getOrderAddrRespDto().getCountyCode())).orElse(pcpRegionRespDtoMap.get(sourceExecuteContextVo.getOrderDetailRespDto().getOrderAddrRespDto().getCityCode()));
        SourceAssert.notNull((Object)matchRegionRespDto, (SourceExceptionCode)SourceExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u5f53\u524d\u8ba2\u5355\u533a\u57df/\u5e02\u533a\u7684\u7ecf\u7eac\u5ea6\u4e3a\u7a7a"});
        logger.info("\u5f53\u524d\u8ba2\u5355\u533a\u57df/\u5e02\u533a\u7684\u7ecf\u7eac\u5ea6={}", JSON.toJSON((Object)matchRegionRespDto));
        Map<String, WarehouseAddressVo> currentCsPhysicsWarehouseAddressVoMap = sourceExecuteContextVo.getCurrentCsPhysicsWarehouseAddressVoMap();
        SourceAssert.notNull(currentCsPhysicsWarehouseAddressVoMap, (SourceExceptionCode)SourceExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u7269\u7406\u4ed3\u7684\u6536\u8d27\u5730\u5740\u7ecf\u7eac\u5ea6\u4fe1\u606f\u4e3a\u7a7a"});
        logger.info("\u5f53\u524d\u5206\u7ec4\u7269\u7406\u4ed3\u7684\u6536\u8d27\u5730\u5740\u7ecf\u7eac\u5ea6={}", JSON.toJSON(currentCsPhysicsWarehouseAddressVoMap));
        ArrayList<Map<String, Object>> warehouseRegionScoreList = new ArrayList<Map<String, Object>>();
        csLogicWarehousePageRespDtoList.forEach(csLogicWarehousePageRespDto -> {
            WarehouseAddressVo warehouseAddressVo = (WarehouseAddressVo)((Object)((Object)currentCsPhysicsWarehouseAddressVoMap.get(csLogicWarehousePageRespDto.getPhysicsWarehouseCode())));
            SourceAssert.notNull((Object)((Object)warehouseAddressVo), (SourceExceptionCode)SourceExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u5339\u914d\u4e0d\u5230\u903b\u8f91\u4ed3\u7684\u7269\u7406\u4ed3\u7ecf\u7eac\u5ea6\u4fe1\u606f"});
            BigDecimal centerX = new BigDecimal(Optional.ofNullable(warehouseAddressVo.getPcpRegionRespDto().getLocationX()).orElse("1"));
            BigDecimal centerY = new BigDecimal(Optional.ofNullable(warehouseAddressVo.getPcpRegionRespDto().getLocationY()).orElse("1"));
            BigDecimal targetX = new BigDecimal(Optional.ofNullable(matchRegionRespDto.getLocationX()).orElse("1"));
            BigDecimal targetY = new BigDecimal(Optional.ofNullable(matchRegionRespDto.getLocationY()).orElse("1"));
            HashMap<String, Object> warehouseDistanceMap = new HashMap<String, Object>();
            warehouseDistanceMap.put("dto", csLogicWarehousePageRespDto);
            warehouseDistanceMap.put("middleScore", SourceExecuteUtils.distance(centerX, centerY, targetX, targetY));
            warehouseRegionScoreList.add(warehouseDistanceMap);
        });
        logger.info("\u7269\u7406\u4ed3\u7ecf\u7eac\u5ea6\u8ddd\u79bb\u6392\u5e8f\u524d={}", JSON.toJSON(warehouseRegionScoreList));
        warehouseRegionScoreList.sort(Comparator.comparing(o -> (BigDecimal)o.get("middleScore")));
        logger.info("\u7269\u7406\u4ed3\u7ecf\u7eac\u5ea6\u8ddd\u79bb\u6392\u5e8f\u540e={}", JSON.toJSON(warehouseRegionScoreList));
        DictDto dictDto = sourceExecuteContextVo.getDictDtoMap().get(SgDictEnum.SOURCE_SETTING_LAT_LNG.getCode());
        SourceAssert.notNull((Object)dictDto, (SourceExceptionCode)SourceExceptionCode.SOURCE_EXECUTE_DATA_QUERY_EMPTY, (String[])new String[]{"\u5bfb\u6e90\u8bbe\u7f6e-\u7ecf\u7eac\u5ea6", ""});
        return this.buildSourceGroupRuleScoreResultGroupVosAndCalculation(clueWarehouseGroupRuleRespDto, warehouseRegionScoreList, dictDto);
    }

    private List<SourceGroupRuleScoreResultGroupVo> calculationWarehouseListScoreFreightCheap(ClueWarehouseGroupRuleRespDto clueWarehouseGroupRuleRespDto, List<DgLogicWarehouseDto> csLogicWarehousePageRespDtoList, SourceExecuteContextVo sourceExecuteContextVo) {
        List<FreightCostRespDto> freightCostRespDtoList = sourceExecuteContextVo.getCurrentFreightCostRespDtoList();
        Map<String, FreightCostRespDto> freightCostRespDtoMap = freightCostRespDtoList.stream().collect(Collectors.toMap(FreightCostRespDto::getLogisticsWarehouseCode, v1 -> v1));
        List<DgPhysicsWarehouseDto> csPhysicsWarehousePageRespDtoList = sourceExecuteContextVo.getCurrentBeforeClueGroupTypePhysicsRespDtoList();
        Map<Long, DgPhysicsWarehouseDto> csPhysicsWarehousePageRespDtoMap = csPhysicsWarehousePageRespDtoList.stream().collect(Collectors.toMap(BaseDto::getId, v1 -> v1));
        ArrayList<Map<String, Object>> warehouseFreightScoreList = new ArrayList<Map<String, Object>>();
        csLogicWarehousePageRespDtoList.forEach(csLogicWarehousePageRespDto -> {
            DgPhysicsWarehouseDto csPhysicsWarehousePageRespDto = (DgPhysicsWarehouseDto)csPhysicsWarehousePageRespDtoMap.get(csLogicWarehousePageRespDto.getPhysicsWarehouseCode());
            SourceAssert.notNull((Object)csPhysicsWarehousePageRespDto, (SourceExceptionCode)SourceExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u5339\u914d\u4e0d\u5230\u903b\u8f91\u4ed3\u7684\u7269\u7406\u4ed3\u4fe1\u606f"});
            FreightCostRespDto freightCostRespDto = (FreightCostRespDto)freightCostRespDtoMap.get(csPhysicsWarehousePageRespDto.getWarehouseCode());
            HashMap<String, Object> warehouseDistanceMap = new HashMap<String, Object>();
            warehouseDistanceMap.put("dto", csLogicWarehousePageRespDto);
            warehouseDistanceMap.put("middleScore", Optional.ofNullable(freightCostRespDto).map(FreightCostRespDto::getVolumeUnitPrice).orElse(new BigDecimal(-1)));
            warehouseFreightScoreList.add(warehouseDistanceMap);
        });
        logger.info("\u8fd0\u8d39\u6210\u672c\u6392\u5e8f\u524d={}", JSON.toJSON(warehouseFreightScoreList));
        warehouseFreightScoreList.sort(Comparator.comparing(o -> (BigDecimal)o.get("middleScore")));
        logger.info("\u8fd0\u8d39\u6210\u672c\u6392\u5e8f\u540e={}", JSON.toJSON(warehouseFreightScoreList));
        DictDto dictDto = sourceExecuteContextVo.getDictDtoMap().get(SgDictEnum.SOURCE_SETTING_FREIGHT_COST.getCode());
        SourceAssert.notNull((Object)dictDto, (SourceExceptionCode)SourceExceptionCode.SOURCE_EXECUTE_DATA_QUERY_EMPTY, (String[])new String[]{"\u5bfb\u6e90\u8bbe\u7f6e-\u8fd0\u8d39\u6210\u672c", ""});
        return this.buildSourceGroupRuleScoreResultGroupVosAndCalculation(clueWarehouseGroupRuleRespDto, warehouseFreightScoreList, dictDto);
    }

    private List<SourceGroupRuleScoreResultGroupVo> buildSourceGroupRuleScoreResultGroupVosAndCalculation(ClueWarehouseGroupRuleRespDto clueWarehouseGroupRuleRespDto, List<Map<String, Object>> warehouseScoreList, DictDto spaceDto) {
        BigDecimal freightCostSpace = new BigDecimal(spaceDto.getValue());
        AtomicInteger atomicInteger = new AtomicInteger(-1);
        return warehouseScoreList.stream().map(map -> {
            if (((BigDecimal)map.get("middleScore")).compareTo(BigDecimal.ZERO) < 0) {
                return this.buildSourceGroupRuleScoreResultGroupVo(this.calculationScoreByRuleScoreProportion(BigDecimal.ZERO, new BigDecimal(clueWarehouseGroupRuleRespDto.getRuleScoreProportion())), (DgLogicWarehouseDto)map.get("dto"), clueWarehouseGroupRuleRespDto);
            }
            BigDecimal score = new BigDecimal(100).subtract(new BigDecimal(atomicInteger.incrementAndGet()).multiply(freightCostSpace));
            return this.buildSourceGroupRuleScoreResultGroupVo(this.calculationScoreByRuleScoreProportion(score.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : score, new BigDecimal(clueWarehouseGroupRuleRespDto.getRuleScoreProportion())), (DgLogicWarehouseDto)map.get("dto"), clueWarehouseGroupRuleRespDto);
        }).collect(Collectors.toList());
    }

    private List<SourceGroupRuleScoreResultGroupVo> calculationWarehouseListScoreWarehouseDeliveryThreshold(ClueWarehouseGroupRuleRespDto clueWarehouseGroupRuleRespDto, List<DgLogicWarehouseDto> csLogicWarehousePageRespDtoList, SourceExecuteContextVo sourceExecuteContextVo) {
        Map<String, WarehouseDeliveryThresholdVo> warehouseDisableRespDtoMap = sourceExecuteContextVo.getCurrentCsWarehouseDeliveryThresholdVoMap();
        Map<String, WarehouseOutboundOrderVo> currentWarehouseOutboundOrderVoMap = sourceExecuteContextVo.getCurrentWarehouseOutboundOrderVoMap();
        ArrayList<SourceGroupRuleScoreResultGroupVo> sourceGroupRuleScoreResultGroupVoList = new ArrayList<SourceGroupRuleScoreResultGroupVo>();
        if (warehouseDisableRespDtoMap == null || warehouseDisableRespDtoMap.size() <= 0) {
            csLogicWarehousePageRespDtoList.forEach(dto -> {
                BigDecimal score = this.calculationScoreByRuleScoreProportion(new BigDecimal(100), new BigDecimal(clueWarehouseGroupRuleRespDto.getRuleScoreProportion()));
                sourceGroupRuleScoreResultGroupVoList.add(this.buildSourceGroupRuleScoreResultGroupVo(score, (DgLogicWarehouseDto)dto, clueWarehouseGroupRuleRespDto));
            });
        } else {
            csLogicWarehousePageRespDtoList.forEach(dto -> {
                WarehouseDeliveryThresholdVo warehouseDeliveryThresholdVo = (WarehouseDeliveryThresholdVo)((Object)((Object)warehouseDisableRespDtoMap.get(dto.getPhysicsWarehouseCode())));
                if (Objects.nonNull((Object)warehouseDeliveryThresholdVo) && currentWarehouseOutboundOrderVoMap.containsKey(dto.getPhysicsWarehouseCode())) {
                    WarehouseOutboundOrderVo warehouseOutboundOrderVo = (WarehouseOutboundOrderVo)((Object)((Object)currentWarehouseOutboundOrderVoMap.get(dto.getPhysicsWarehouseCode())));
                    BigDecimal score = this.calculationScoreByRuleScoreProportion(warehouseOutboundOrderVo.getOutboundCount().compareTo(warehouseDeliveryThresholdVo.getThreshold()) < 0 ? new BigDecimal(100) : BigDecimal.ZERO, new BigDecimal(clueWarehouseGroupRuleRespDto.getRuleScoreProportion()));
                    sourceGroupRuleScoreResultGroupVoList.add(this.buildSourceGroupRuleScoreResultGroupVo(score, (DgLogicWarehouseDto)dto, clueWarehouseGroupRuleRespDto));
                } else {
                    BigDecimal score = this.calculationScoreByRuleScoreProportion(new BigDecimal(100), new BigDecimal(clueWarehouseGroupRuleRespDto.getRuleScoreProportion()));
                    sourceGroupRuleScoreResultGroupVoList.add(this.buildSourceGroupRuleScoreResultGroupVo(score, (DgLogicWarehouseDto)dto, clueWarehouseGroupRuleRespDto));
                }
            });
        }
        return sourceGroupRuleScoreResultGroupVoList;
    }

    private List<SourceGroupRuleScoreResultGroupVo> calculationWarehouseListScoreLatWarehouseDeliveryRange(ClueWarehouseGroupRuleRespDto clueWarehouseGroupRuleRespDto, List<DgLogicWarehouseDto> csLogicWarehousePageRespDtoList, SourceExecuteContextVo sourceExecuteContextVo) {
        List<WarehouseProvideGoodsRangeRespDto> warehouseProvideGoodsRangeRespDtoList = sourceExecuteContextVo.getCurrentWarehouseProvideGoodsRangeRespDtoList();
        Map<String, WarehouseProvideGoodsRangeRespDto> warehouseProvideGoodsRangeRespDtoMap = warehouseProvideGoodsRangeRespDtoList.stream().collect(Collectors.toMap(WarehouseProvideGoodsRangeRespDto::getPhysicsWarehouseCode, v1 -> v1));
        List<DgPhysicsWarehouseDto> csPhysicsWarehousePageRespDtoList = sourceExecuteContextVo.getCurrentBeforeClueGroupTypePhysicsRespDtoList();
        Map<String, DgPhysicsWarehouseDto> csPhysicsWarehousePageRespDtoMap = csPhysicsWarehousePageRespDtoList.stream().collect(Collectors.toMap(DgPhysicsWarehouseDto::getWarehouseCode, v1 -> v1));
        ArrayList<SourceGroupRuleScoreResultGroupVo> sourceGroupRuleScoreResultGroupVoList = new ArrayList<SourceGroupRuleScoreResultGroupVo>();
        csLogicWarehousePageRespDtoList.forEach(csLogicWarehousePageRespDto -> {
            DgPhysicsWarehouseDto csPhysicsWarehousePageRespDto = (DgPhysicsWarehouseDto)csPhysicsWarehousePageRespDtoMap.get(csLogicWarehousePageRespDto.getPhysicsWarehouseCode());
            SourceAssert.notNull((Object)csPhysicsWarehousePageRespDto, (SourceExceptionCode)SourceExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u5339\u914d\u4e0d\u5230\u903b\u8f91\u4ed3\u7684\u7269\u7406\u4ed3\u4fe1\u606f"});
            WarehouseProvideGoodsRangeRespDto warehouseProvideGoodsRangeRespDto = (WarehouseProvideGoodsRangeRespDto)warehouseProvideGoodsRangeRespDtoMap.get(csPhysicsWarehousePageRespDto.getWarehouseCode());
            if (warehouseProvideGoodsRangeRespDto == null) {
                sourceGroupRuleScoreResultGroupVoList.add(this.buildSourceGroupRuleScoreResultGroupVo(BigDecimal.ZERO, (DgLogicWarehouseDto)csLogicWarehousePageRespDto, clueWarehouseGroupRuleRespDto));
            } else {
                BigDecimal score = this.calculationScoreByRuleScoreProportion(new BigDecimal(100), new BigDecimal(clueWarehouseGroupRuleRespDto.getRuleScoreProportion()));
                sourceGroupRuleScoreResultGroupVoList.add(this.buildSourceGroupRuleScoreResultGroupVo(score, (DgLogicWarehouseDto)csLogicWarehousePageRespDto, clueWarehouseGroupRuleRespDto));
            }
        });
        return sourceGroupRuleScoreResultGroupVoList;
    }

    private List<SourceGroupRuleScoreResultGroupVo> calculationWarehouseListScoreCustomerBatchReverse(ClueWarehouseGroupRuleRespDto clueWarehouseGroupRuleRespDto, List<DgLogicWarehouseDto> csLogicWarehousePageRespDtoList, SourceExecuteContextVo sourceExecuteContextVo) {
        Map<String, DictDto> dictDtoMap = sourceExecuteContextVo.getDictDtoMap();
        DictDto spaceValue = dictDtoMap.get(SgDictEnum.SOURCE_SETTING_OLD_BATCH_INVERSION.getCode());
        DictDto spaceType = dictDtoMap.get(SgDictEnum.SOURCE_SETTING_OLD_BATCH_INVERSIONTYPE.getCode());
        if (sourceExecuteContextVo.getPreBizSaleOrderRespDto() == null) {
            BizSaleOrderRespDto preBizSaleOrderRespDto = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryNewestOrderByCustomerId(sourceExecuteContextVo.getOrderDetailRespDto().getLinkOrderCustomerId()));
            sourceExecuteContextVo.setPreBizSaleOrderRespDto(preBizSaleOrderRespDto != null ? preBizSaleOrderRespDto : new BizSaleOrderRespDto());
        }
        ArrayList<SourceGroupRuleScoreResultGroupVo> sourceGroupRuleScoreResultGroupVoList = new ArrayList<SourceGroupRuleScoreResultGroupVo>();
        Map<Long, Map<String, List<WarehouseInventoryVo>>> currentWarehouseGroupInventoryDtoMap = sourceExecuteContextVo.getCurrentWarehouseGroupInventoryDtoMap();
        csLogicWarehousePageRespDtoList.forEach(csLogicWarehousePageRespDto -> {
            BigDecimal score = new BigDecimal("100");
            Map warehouseInventoryBatch = (Map)currentWarehouseGroupInventoryDtoMap.get(csLogicWarehousePageRespDto.getId());
            if (CollectionUtils.isNotEmpty((Collection)sourceExecuteContextVo.getPreBizSaleOrderRespDto().getItemList()) && warehouseInventoryBatch != null) {
                for (SaleOrderItemExtRespDto saleOrderItemExtRespDto : sourceExecuteContextVo.getPreBizSaleOrderRespDto().getItemList()) {
                    List warehouseInventoryVos = (List)warehouseInventoryBatch.get(saleOrderItemExtRespDto.getSkuCode());
                    if (!CollectionUtils.isNotEmpty((Collection)warehouseInventoryVos)) continue;
                    String preOrderItemBatchNo = saleOrderItemExtRespDto.getDeliveryItemBatchNo();
                    if (!warehouseInventoryVos.stream().anyMatch(warehouseInventoryVo -> this.identifyPreOrderItemBatchNo((WarehouseInventoryVo)((Object)((Object)warehouseInventoryVo)), preOrderItemBatchNo, spaceValue, spaceType))) continue;
                    score = BigDecimal.ZERO;
                }
            }
            sourceGroupRuleScoreResultGroupVoList.add(this.buildSourceGroupRuleScoreResultGroupVo(score, (DgLogicWarehouseDto)csLogicWarehousePageRespDto, clueWarehouseGroupRuleRespDto));
        });
        return sourceGroupRuleScoreResultGroupVoList;
    }

    private boolean identifyPreOrderItemBatchNo(WarehouseInventoryVo warehouseInventoryVo, String preOrderItemBatchNo, DictDto spaceValue, DictDto spaceType) {
        SourceAssert.notBlank((String)warehouseInventoryVo.getBatch(), (SourceExceptionCode)SourceExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{warehouseInventoryVo.getLongCode() + "\u5e93\u5b58\u6279\u6b21\u53f7\u5f02\u5e38"});
        if (!"month".equals(spaceType.getValue())) {
            throw SourceExceptionCode.NORMAL_EXCEPTION.buildBizException(new String[]{"\u901a\u7528\u914d\u7f6e-\u65e7\u6279\u6b21-\u65e5\u671f\u7c7b\u578b\u9519\u8bef"});
        }
        Date produceTime = warehouseInventoryVo.getProduceTime();
        if (produceTime == null) {
            logger.info("\u6279\u6b21\u4e3a:{},\u751f\u4ea7\u65e5\u671f\u4e3a\u7a7a", (Object)warehouseInventoryVo.getBatch());
            return false;
        }
        String currBatchDateString = DateUtil.getDateFormat((Date)produceTime, (String)"yyyyMM");
        Date crrBatchDate = DateUtil.parseDate((String)currBatchDateString, (String)"yyyyMM");
        String preBatchDateString = preOrderItemBatchNo.substring(0, 6);
        Date preBatchDate = DateUtil.parseDate((String)preBatchDateString, (String)"yyyyMM");
        Date pre = DateUtil.addMonths((Date)preBatchDate, (int)(-Integer.parseInt(spaceValue.getValue()) - 1));
        return DateUtil.getMonthBegin((Date)pre).compareTo(crrBatchDate) > 0;
    }

    private List<SourceGroupRuleScoreResultGroupVo> calculationWarehouseListScoreWarehousePriority(ClueWarehouseGroupRuleRespDto clueWarehouseGroupRuleRespDto, List<DgLogicWarehouseDto> csLogicWarehousePageRespDtoList, SourceExecuteContextVo sourceExecuteContextVo) {
        return null;
    }

    private List<SourceGroupRuleScoreResultGroupVo> buildSourceGroupRuleScoreResultGroupVosAndCalculationByDelivery(ClueWarehouseGroupRuleRespDto clueWarehouseGroupRuleRespDto, List<DgLogicWarehouseDto> csLogicWarehousePageRespDtoList, DictDto spaceDto) {
        BigDecimal warehousePrioritySpace = new BigDecimal(spaceDto.getValue());
        AtomicInteger atomicInteger = new AtomicInteger(-1);
        List deliveryRespDtos = clueWarehouseGroupRuleRespDto.getClueWarehouseGroupRuleDeliveryRespDtos();
        HashMap priorityMap = Maps.newHashMap();
        deliveryRespDtos.sort(Comparator.comparing(delivery -> delivery.getDeliveryWarehousePriorityLevel()));
        deliveryRespDtos.forEach(e -> priorityMap.put(e.getWarehouseCode(), atomicInteger.incrementAndGet()));
        logger.info("[\u6309\u4ed3\u5e93\u4f18\u5148\u7ea7\u6392\u5e8f]\u53d1\u8d27\u4ed3\u987a\u5e8f\u5217\u8868:{}", (Object)JSON.toJSONString((Object)priorityMap));
        return csLogicWarehousePageRespDtoList.stream().map(dto -> {
            Integer priority = (Integer)priorityMap.get(dto.getWarehouseCode());
            if (Objects.isNull(priority)) {
                return this.buildSourceGroupRuleScoreResultGroupVo(this.calculationScoreByRuleScoreProportion(BigDecimal.ZERO, new BigDecimal(clueWarehouseGroupRuleRespDto.getRuleScoreProportion())), (DgLogicWarehouseDto)dto, clueWarehouseGroupRuleRespDto);
            }
            BigDecimal score = new BigDecimal(100).subtract(new BigDecimal(priority).multiply(warehousePrioritySpace));
            return this.buildSourceGroupRuleScoreResultGroupVo(this.calculationScoreByRuleScoreProportion(score.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : score, new BigDecimal(clueWarehouseGroupRuleRespDto.getRuleScoreProportion())), (DgLogicWarehouseDto)dto, clueWarehouseGroupRuleRespDto);
        }).collect(Collectors.toList());
    }

    private List<SourceGroupRuleScoreResultGroupVo> calculationWarehouseListScoreSpecifyShipment(ClueWarehouseGroupRuleRespDto clueWarehouseGroupRuleRespDto, List<DgLogicWarehouseDto> csLogicWarehousePageRespDtoList, SourceExecuteContextVo sourceExecuteContextVo) {
        List<DgLogicWarehouseDto> csLogicWarehouseShipments = sourceExecuteContextVo.getCsLogicWarehouseShipments();
        List warehouseShipmentCodes = Optional.ofNullable(csLogicWarehouseShipments).orElse(Lists.newArrayList()).stream().map(DgLogicWarehouseDto::getWarehouseCode).distinct().collect(Collectors.toList());
        ArrayList<SourceGroupRuleScoreResultGroupVo> sourceGroupRuleScoreResultGroupVoList = new ArrayList<SourceGroupRuleScoreResultGroupVo>();
        logger.info("[\u6307\u5b9a\u627f\u8fd0\u5546\u4f18\u5148\u51fa]\u4ed3\u5e93\u7269\u6d41\u5546\u4fe1\u606f:{}", (Object)JSON.toJSONString(warehouseShipmentCodes));
        csLogicWarehousePageRespDtoList.forEach(dto -> {
            if (warehouseShipmentCodes.contains(dto.getWarehouseCode())) {
                BigDecimal score = this.calculationScoreByRuleScoreProportion(new BigDecimal(100), new BigDecimal(clueWarehouseGroupRuleRespDto.getRuleScoreProportion()));
                sourceGroupRuleScoreResultGroupVoList.add(this.buildSourceGroupRuleScoreResultGroupVo(score, (DgLogicWarehouseDto)dto, clueWarehouseGroupRuleRespDto));
            } else {
                sourceGroupRuleScoreResultGroupVoList.add(this.buildSourceGroupRuleScoreResultGroupVo(BigDecimal.ZERO, (DgLogicWarehouseDto)dto, clueWarehouseGroupRuleRespDto));
            }
        });
        logger.info("[\u6307\u5b9a\u627f\u8fd0\u5546\u4f18\u5148\u51fa]\u5bfb\u6e90\u7ed3\u679c:{}", (Object)JSON.toJSONString(sourceGroupRuleScoreResultGroupVoList));
        return sourceGroupRuleScoreResultGroupVoList;
    }

    private BigDecimal calculationScoreByRuleScoreProportion(BigDecimal oldScore, BigDecimal ruleScoreProportion) {
        return oldScore.multiply(ruleScoreProportion).divide(new BigDecimal(100), 0, 4);
    }

    private List<SourceGroupRuleScoreResultGroupVo> calculationWarehouseListScoreLatTargetWarehouse(ClueWarehouseGroupRuleRespDto clueWarehouseGroupRuleRespDto, List<DgLogicWarehouseDto> csLogicWarehousePageRespDtoList, SourceExecuteContextVo sourceExecuteContextVo) {
        String organizationCode = sourceExecuteContextVo.getOrderDetailRespDto().getOrganizationCode();
        List<CsLogicWarehouseRespDto> rdcLogicWarehousePageRespDtoList = sourceExecuteContextVo.getRdcLogicWarehousePageRespDtoList();
        List targeWarehouseCodeList = Optional.ofNullable(rdcLogicWarehousePageRespDtoList).orElse(Lists.newArrayList()).stream().filter(dto -> Objects.equals(dto.getOrganizationCode(), organizationCode)).map(CsLogicWarehouseRespDto::getWarehouseCode).distinct().collect(Collectors.toList());
        ArrayList<SourceGroupRuleScoreResultGroupVo> sourceGroupRuleScoreResultGroupVoList = new ArrayList<SourceGroupRuleScoreResultGroupVo>();
        csLogicWarehousePageRespDtoList.forEach(csLogicWarehousePageRespDto -> {
            if (targeWarehouseCodeList.contains(csLogicWarehousePageRespDto.getWarehouseCode())) {
                BigDecimal score = this.calculationScoreByRuleScoreProportion(new BigDecimal(100), new BigDecimal(clueWarehouseGroupRuleRespDto.getRuleScoreProportion()));
                sourceGroupRuleScoreResultGroupVoList.add(this.buildSourceGroupRuleScoreResultGroupVo(score, (DgLogicWarehouseDto)csLogicWarehousePageRespDto, clueWarehouseGroupRuleRespDto));
            } else {
                sourceGroupRuleScoreResultGroupVoList.add(this.buildSourceGroupRuleScoreResultGroupVo(BigDecimal.ZERO, (DgLogicWarehouseDto)csLogicWarehousePageRespDto, clueWarehouseGroupRuleRespDto));
            }
        });
        logger.info("[\u76ee\u6807\u4ed3\u4f18\u5148]\u5bfb\u6e90\u7ed3\u679c:{}", (Object)JSON.toJSONString(sourceGroupRuleScoreResultGroupVoList));
        return sourceGroupRuleScoreResultGroupVoList;
    }

    private List<SourceGroupRuleScoreResultGroupVo> calculationWarehouseListScoreLatTotalWarehouse(ClueWarehouseGroupRuleRespDto clueWarehouseGroupRuleRespDto, List<DgLogicWarehouseDto> csLogicWarehousePageRespDtoList, SourceExecuteContextVo sourceExecuteContextVo) {
        List<DgPhysicsWarehouseDto> csPhysicsWarehousePageRespDtoList = sourceExecuteContextVo.getCurrentBeforeClueGroupTypePhysicsRespDtoList();
        Map<String, DgPhysicsWarehouseDto> csPhysicsWarehousePageRespDtoMap = csPhysicsWarehousePageRespDtoList.stream().collect(Collectors.toMap(DgPhysicsWarehouseDto::getWarehouseCode, v1 -> v1));
        ArrayList<SourceGroupRuleScoreResultGroupVo> sourceGroupRuleScoreResultGroupVoList = new ArrayList<SourceGroupRuleScoreResultGroupVo>();
        csLogicWarehousePageRespDtoList.forEach(csLogicWarehousePageRespDto -> {
            DgPhysicsWarehouseDto csPhysicsWarehousePageRespDto = (DgPhysicsWarehouseDto)csPhysicsWarehousePageRespDtoMap.get(csLogicWarehousePageRespDto.getPhysicsWarehouseCode());
            SourceAssert.notNull((Object)csPhysicsWarehousePageRespDto, (SourceExceptionCode)SourceExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u5339\u914d\u4e0d\u5230\u903b\u8f91\u4ed3\u7684\u7269\u7406\u4ed3\u4fe1\u606f"});
            if (Objects.equals(String.valueOf(csPhysicsWarehousePageRespDto.getRdcFlag()), "0")) {
                BigDecimal score = this.calculationScoreByRuleScoreProportion(new BigDecimal(100), new BigDecimal(clueWarehouseGroupRuleRespDto.getRuleScoreProportion()));
                sourceGroupRuleScoreResultGroupVoList.add(this.buildSourceGroupRuleScoreResultGroupVo(score, (DgLogicWarehouseDto)csLogicWarehousePageRespDto, clueWarehouseGroupRuleRespDto));
            } else {
                sourceGroupRuleScoreResultGroupVoList.add(this.buildSourceGroupRuleScoreResultGroupVo(BigDecimal.ZERO, (DgLogicWarehouseDto)csLogicWarehousePageRespDto, clueWarehouseGroupRuleRespDto));
            }
        });
        return sourceGroupRuleScoreResultGroupVoList;
    }

    private List<SourceGroupRuleScoreResultGroupVo> calculationWarehouseListScoreLatTargetPhysicsWarehouse(ClueWarehouseGroupRuleRespDto clueWarehouseGroupRuleRespDto, List<DgLogicWarehouseDto> csLogicWarehousePageRespDtoList, SourceExecuteContextVo sourceExecuteContextVo) {
        Set<String> currentTargePhysicsRespDtoSet = sourceExecuteContextVo.getCurrentTargePhysicsRespDtoSet();
        ArrayList<SourceGroupRuleScoreResultGroupVo> sourceGroupRuleScoreResultGroupVoList = new ArrayList<SourceGroupRuleScoreResultGroupVo>();
        csLogicWarehousePageRespDtoList.forEach(csLogicWarehousePageRespDto -> {
            if (currentTargePhysicsRespDtoSet.contains(csLogicWarehousePageRespDto.getPhysicsWarehouseCode())) {
                BigDecimal score = this.calculationScoreByRuleScoreProportion(new BigDecimal(100), new BigDecimal(clueWarehouseGroupRuleRespDto.getRuleScoreProportion()));
                sourceGroupRuleScoreResultGroupVoList.add(this.buildSourceGroupRuleScoreResultGroupVo(score, (DgLogicWarehouseDto)csLogicWarehousePageRespDto, clueWarehouseGroupRuleRespDto));
            } else {
                sourceGroupRuleScoreResultGroupVoList.add(this.buildSourceGroupRuleScoreResultGroupVo(BigDecimal.ZERO, (DgLogicWarehouseDto)csLogicWarehousePageRespDto, clueWarehouseGroupRuleRespDto));
            }
        });
        logger.info("[\u76ee\u6807\u4ed3\u540c\u7269\u7406\u4ed3\u7684\u903b\u8f91\u4ed3\u4f18\u5148]\u5bfb\u6e90\u7ed3\u679c:{}", (Object)JSON.toJSONString(sourceGroupRuleScoreResultGroupVoList));
        return sourceGroupRuleScoreResultGroupVoList;
    }

    private List<SourceGroupRuleScoreResultGroupVo> calculationWarehouseListScoreLatTotalPhysicsWarehouse(ClueWarehouseGroupRuleRespDto clueWarehouseGroupRuleRespDto, List<DgLogicWarehouseDto> csLogicWarehousePageRespDtoList, SourceExecuteContextVo sourceExecuteContextVo) {
        Set<String> currentTotalPhysicsRespDtoSet = sourceExecuteContextVo.getCurrentTotalPhysicsRespDtoSet();
        ArrayList<SourceGroupRuleScoreResultGroupVo> sourceGroupRuleScoreResultGroupVoList = new ArrayList<SourceGroupRuleScoreResultGroupVo>();
        csLogicWarehousePageRespDtoList.forEach(csLogicWarehousePageRespDto -> {
            if (currentTotalPhysicsRespDtoSet.contains(csLogicWarehousePageRespDto.getPhysicsWarehouseCode())) {
                BigDecimal score = this.calculationScoreByRuleScoreProportion(new BigDecimal(100), new BigDecimal(clueWarehouseGroupRuleRespDto.getRuleScoreProportion()));
                sourceGroupRuleScoreResultGroupVoList.add(this.buildSourceGroupRuleScoreResultGroupVo(score, (DgLogicWarehouseDto)csLogicWarehousePageRespDto, clueWarehouseGroupRuleRespDto));
            } else {
                sourceGroupRuleScoreResultGroupVoList.add(this.buildSourceGroupRuleScoreResultGroupVo(BigDecimal.ZERO, (DgLogicWarehouseDto)csLogicWarehousePageRespDto, clueWarehouseGroupRuleRespDto));
            }
        });
        return sourceGroupRuleScoreResultGroupVoList;
    }

    private List<SourceGroupRuleScoreResultGroupVo> calculationWarehouseListScoreDiyPhysicsWarehouse(ClueWarehouseGroupRuleRespDto clueWarehouseGroupRuleRespDto, List<DgLogicWarehouseDto> csLogicWarehousePageRespDtoList, SourceExecuteContextVo sourceExecuteContextVo) {
        List<SourceGroupRuleScoreResultGroupVo> sourceGroupRuleScoreResultGroupVoList = new ArrayList<SourceGroupRuleScoreResultGroupVo>();
        if (Objects.nonNull(clueWarehouseGroupRuleRespDto.getClueWarehouseGroupRuleDeliveryRespDtos())) {
            DictDto dictDto = sourceExecuteContextVo.getDictDtoMap().get(SgDictEnum.SOURCE_SETTING_DIY_PHYSICS_WAREHOUSE.getCode());
            SourceAssert.notNull((Object)dictDto, (SourceExceptionCode)SourceExceptionCode.SOURCE_EXECUTE_DATA_QUERY_EMPTY, (String[])new String[]{"\u5bfb\u6e90\u8bbe\u7f6e-\u81ea\u5b9a\u4e49\u7269\u7406\u4ed3\u5e93\u4f18\u5148\u7ea7", "\u901a\u7528\u914d\u7f6e"});
            sourceGroupRuleScoreResultGroupVoList = this.buildSourceGroupRuleScoreResultGroupVosAndCalculationByDiyPhysics(clueWarehouseGroupRuleRespDto, csLogicWarehousePageRespDtoList, dictDto);
            logger.info("[\u6309\u7269\u7406\u4ed3\u5e93\u4f18\u5148\u7ea7\u6392\u5e8f]\u5bfb\u6e90\u7ed3\u679c:{}", (Object)JSON.toJSONString(sourceGroupRuleScoreResultGroupVoList));
        }
        return sourceGroupRuleScoreResultGroupVoList;
    }

    private List<SourceGroupRuleScoreResultGroupVo> buildSourceGroupRuleScoreResultGroupVosAndCalculationByDiyPhysics(ClueWarehouseGroupRuleRespDto clueWarehouseGroupRuleRespDto, List<DgLogicWarehouseDto> csLogicWarehousePageRespDtoList, DictDto spaceDto) {
        BigDecimal warehousePrioritySpace = new BigDecimal(spaceDto.getValue());
        AtomicInteger atomicInteger = new AtomicInteger(-1);
        List sourcePhyicsCodeList = csLogicWarehousePageRespDtoList.stream().map(DgLogicWarehouseDto::getPhysicsWarehouseCode).collect(Collectors.toList());
        List<ClueWarehouseGroupRuleDeliveryRespDto> physicsRespDtos = clueWarehouseGroupRuleRespDto.getClueWarehouseGroupRuleDeliveryRespDtos().stream().filter(dto -> sourcePhyicsCodeList.contains(dto.getWarehouseCode()) && Objects.nonNull(dto.getDeliveryWarehousePriorityLevel())).collect(Collectors.toList());
        HashMap priorityMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(physicsRespDtos)) {
            physicsRespDtos.sort(Comparator.comparing(delivery -> delivery.getDeliveryWarehousePriorityLevel()));
            physicsRespDtos.forEach(e -> priorityMap.put(e.getWarehouseCode(), atomicInteger.incrementAndGet()));
            logger.info("[\u6309\u4ed3\u5e93\u4f18\u5148\u7ea7\u6392\u5e8f]\u81ea\u5b9a\u4e49\u7269\u7406\u987a\u5e8f\u5217\u8868:{}", (Object)JSON.toJSONString((Object)priorityMap));
        } else {
            logger.info("[\u6309\u4ed3\u5e93\u4f18\u5148\u7ea7\u6392\u5e8f]\u81ea\u5b9a\u4e49\u7269\u7406\u987a\u5e8f\u5217\u8868\u4e0d\u5339\u914d\u5f53\u524d\u5bfb\u6e90\u8303\u56f4");
        }
        return csLogicWarehousePageRespDtoList.stream().map(dto -> {
            Integer priority = (Integer)priorityMap.get(dto.getPhysicsWarehouseCode());
            if (Objects.isNull(priority)) {
                return this.buildSourceGroupRuleScoreResultGroupVo(this.calculationScoreByRuleScoreProportion(BigDecimal.ZERO, new BigDecimal(clueWarehouseGroupRuleRespDto.getRuleScoreProportion())), (DgLogicWarehouseDto)dto, clueWarehouseGroupRuleRespDto);
            }
            BigDecimal score = new BigDecimal(100).subtract(new BigDecimal(priority).multiply(warehousePrioritySpace));
            logger.info("\u7269\u7406\u4ed3\u987a\u5e8f\u5206\u6570={},{}", (Object)dto.getPhysicsWarehouseCode(), (Object)score);
            return this.buildSourceGroupRuleScoreResultGroupVo(this.calculationScoreByRuleScoreProportion(score.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : score, new BigDecimal(clueWarehouseGroupRuleRespDto.getRuleScoreProportion())), (DgLogicWarehouseDto)dto, clueWarehouseGroupRuleRespDto);
        }).collect(Collectors.toList());
    }
}

