/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.source.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.center.source.api.constant.ClueSuitSelectTypeEnum;
import com.dtyunxi.cube.center.source.api.dto.request.ClueActReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.ClueModifyActReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.ClueReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.ClueSuitAttributeModifyReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.ClueSuitAttributeReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.ClueWarehouseGroupReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.ClueWarehouseGroupRuleDeliveryReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.ClueWarehouseGroupRuleReqDto;
import com.dtyunxi.cube.center.source.api.dto.response.ClueRespDto;
import com.dtyunxi.cube.center.source.api.exception.SourceAssert;
import com.dtyunxi.cube.center.source.api.exception.SourceExceptionCode;
import com.dtyunxi.cube.center.source.biz.service.IClueDeliveryWarehouseBlackService;
import com.dtyunxi.cube.center.source.biz.service.IClueOptService;
import com.dtyunxi.cube.center.source.biz.service.IClueService;
import com.dtyunxi.cube.center.source.biz.service.IClueSuitAttributeService;
import com.dtyunxi.cube.center.source.biz.service.IClueWarehouseGroupRuleDeliveryService;
import com.dtyunxi.cube.center.source.biz.service.IClueWarehouseGroupRuleService;
import com.dtyunxi.cube.center.source.biz.service.IClueWarehouseGroupService;
import com.dtyunxi.cube.center.source.biz.service.IClueWarehouseItemBlackListService;
import com.dtyunxi.cube.center.source.biz.utils.NoGenerateUtil;
import com.dtyunxi.cube.center.source.dao.eo.ClueDeliveryWarehouseBlackEo;
import com.dtyunxi.cube.center.source.dao.eo.ClueSuitAttributeEo;
import com.dtyunxi.cube.center.source.dao.eo.ClueWarehouseGroupEo;
import com.dtyunxi.cube.center.source.dao.eo.ClueWarehouseGroupRuleDeliveryEo;
import com.dtyunxi.cube.center.source.dao.eo.ClueWarehouseGroupRuleEo;
import com.dtyunxi.cube.center.source.dao.eo.ClueWarehouseItemBlackListEo;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.IdGenrator;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ClueOptServiceImpl
implements IClueOptService {
    private static final Logger logger = LoggerFactory.getLogger(ClueOptServiceImpl.class);
    @Resource
    private IClueService clueService;
    @Resource
    private IClueSuitAttributeService clueSuitAttributeService;
    @Resource
    private IClueWarehouseGroupService clueWarehouseGroupService;
    @Resource
    private IClueWarehouseGroupRuleService clueWarehouseGroupRuleService;
    @Resource
    private IClueDeliveryWarehouseBlackService clueDeliveryWarehouseBlackService;
    @Resource
    private IClueWarehouseGroupRuleDeliveryService clueWarehouseGroupRuleDeliveryService;
    @Resource
    private NoGenerateUtil noGenerateUtil;
    @Resource
    private IClueWarehouseItemBlackListService clueWarehouseItemBlackListService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Long> addClueOpt(ClueActReqDto addReqDto) {
        logger.info("\u3010addClueOpt\u3011\u5165\u53c2={}", (Object)JSON.toJSONString((Object)addReqDto));
        this.checkAddClueOptParam(addReqDto);
        addReqDto.setClueCode(this.noGenerateUtil.generateNo("XY", 4));
        Long clueId = this.clueService.addClue((ClueReqDto)addReqDto);
        ArrayList<ClueSuitAttributeReqDto> clueSuitAttributeReqDtoList = new ArrayList<ClueSuitAttributeReqDto>();
        this.addAttribute(clueSuitAttributeReqDtoList, addReqDto.getSuitChannelList());
        this.addAttribute(clueSuitAttributeReqDtoList, addReqDto.getSuitWarehouseList());
        this.addAttribute(clueSuitAttributeReqDtoList, addReqDto.getSuitCustomerList());
        this.addAttribute(clueSuitAttributeReqDtoList, addReqDto.getSuitOrderTypeList());
        this.addAttribute(clueSuitAttributeReqDtoList, addReqDto.getSuitShopList());
        this.addAttribute(clueSuitAttributeReqDtoList, addReqDto.getSuitOrganizationList());
        this.addAttribute(clueSuitAttributeReqDtoList, addReqDto.getSuitChannelWarehouseList());
        this.addAttribute(clueSuitAttributeReqDtoList, addReqDto.getSuitVirtualWarehouseList());
        clueSuitAttributeReqDtoList.forEach(dto -> {
            dto.setSgClueId(clueId);
            if (dto.getSgSuitSelectType().equals(ClueSuitSelectTypeEnum.ALL.getCode())) {
                dto.setSgSuitKey(ClueSuitSelectTypeEnum.ALL.getCode());
            }
            dto.setSgSuitMatchCode(dto.getSgSuitSelectType() + "_" + dto.getSgSuitType() + "_" + dto.getSgSuitKey());
        });
        this.clueSuitAttributeService.addClueSuitAttributeList(clueSuitAttributeReqDtoList);
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getClueDeliveryWarehouseBlackReqDtoList())) {
            addReqDto.getClueDeliveryWarehouseBlackReqDtoList().forEach(dto -> dto.setSgClueId(clueId));
            this.clueDeliveryWarehouseBlackService.addClueDeliveryWarehouseBlackList(addReqDto.getClueDeliveryWarehouseBlackReqDtoList());
        }
        addReqDto.getClueWarehouseGroupActReqDtoList().forEach(dto -> {
            dto.setSgClueId(clueId);
            Long groupId = this.clueWarehouseGroupService.addClueWarehouseGroup((ClueWarehouseGroupReqDto)dto);
            dto.getClueWarehouseGroupRuleReqDtoList().forEach(rule -> {
                rule.setSgClueId(clueId);
                rule.setWarehouseGroupId(groupId);
                Long ruleId = this.clueWarehouseGroupRuleService.addClueWarehouseGroupRule((ClueWarehouseGroupRuleReqDto)rule);
                Optional.ofNullable(rule.getClueWarehouseGroupRuleDeliveryReqDtoList()).orElse(Lists.newArrayList()).forEach(deliveryRule -> {
                    deliveryRule.setSgClueId(clueId);
                    deliveryRule.setWarehouseGroupRuleId(ruleId);
                    this.clueWarehouseGroupRuleDeliveryService.addClueWarehouseGroupRuleDelivery((ClueWarehouseGroupRuleDeliveryReqDto)deliveryRule);
                });
            });
        });
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getClueItemBlacklist())) {
            addReqDto.getClueItemBlacklist().forEach(dto -> dto.setSgClueId(clueId));
            this.clueWarehouseItemBlackListService.addClueWarehouseItemBlackListBatch(addReqDto.getClueItemBlacklist());
        }
        return new RestResponse((Object)clueId);
    }

    private void checkAddClueOptParam(ClueActReqDto clueActReqDto) {
        SourceAssert.notNull((Object)clueActReqDto.getClueName(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u7b56\u7565\u540d\u79f0"});
        SourceAssert.notNull((Object)clueActReqDto.getCluePriorityLevel(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u7b56\u7565\u4f18\u5148\u7ea7"});
        SourceAssert.notEmpty((Collection)clueActReqDto.getClueWarehouseGroupActReqDtoList(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_EMPTY, (String[])new String[]{"\u4ed3\u5e93\u5206\u7ec4\u914d\u7f6e\u96c6\u5408"});
    }

    @Override
    public RestResponse<Long> copyClueOpt(Long id) {
        SourceAssert.notNull((Object)id, (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u7b56\u7565id"});
        ClueRespDto clueRespDto = this.clueService.queryById(id);
        ClueActReqDto clueReqDto = new ClueActReqDto();
        CubeBeanUtils.copyProperties((Object)clueReqDto, (Object)clueRespDto, (String[])new String[0]);
        return new RestResponse((Object)this.clueService.addClue((ClueReqDto)clueReqDto));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Long> modifyClueOpt(ClueModifyActReqDto modifyActReqDto) {
        logger.info("\u3010modifyClueOpt\u3011\u5165\u53c2={}", (Object)JSON.toJSONString((Object)modifyActReqDto));
        this.checkModifyClueOptParam(modifyActReqDto);
        this.clueService.modifyClue((ClueReqDto)modifyActReqDto);
        ArrayList addDto = Lists.newArrayList();
        this.addAttribute((List<ClueSuitAttributeReqDto>)addDto, modifyActReqDto.getSuitChannelList());
        this.addAttribute((List<ClueSuitAttributeReqDto>)addDto, modifyActReqDto.getSuitCustomerList());
        this.addAttribute((List<ClueSuitAttributeReqDto>)addDto, modifyActReqDto.getSuitWarehouseList());
        this.addAttribute((List<ClueSuitAttributeReqDto>)addDto, modifyActReqDto.getSuitOrderTypeList());
        this.addAttribute((List<ClueSuitAttributeReqDto>)addDto, modifyActReqDto.getSuitShopList());
        this.addAttribute((List<ClueSuitAttributeReqDto>)addDto, modifyActReqDto.getSuitOrganizationList());
        this.addAttribute((List<ClueSuitAttributeReqDto>)addDto, modifyActReqDto.getSuitChannelWarehouseList());
        this.addAttribute((List<ClueSuitAttributeReqDto>)addDto, modifyActReqDto.getSuitVirtualWarehouseList());
        ClueSuitAttributeEo updateClueSuitAttributeEo = new ClueSuitAttributeEo();
        updateClueSuitAttributeEo.setDr(1);
        ClueSuitAttributeEo selectClueSuitAttributeEo = new ClueSuitAttributeEo();
        selectClueSuitAttributeEo.setDr(0);
        selectClueSuitAttributeEo.setSgClueId(modifyActReqDto.getId());
        this.clueSuitAttributeService.modifyClueSuitAttributeBySelect(updateClueSuitAttributeEo, selectClueSuitAttributeEo);
        addDto.forEach(dto -> {
            dto.setId(null);
            dto.setSgClueId(modifyActReqDto.getId());
            if (dto.getSgSuitSelectType().equals(ClueSuitSelectTypeEnum.ALL.getCode())) {
                dto.setSgSuitKey(ClueSuitSelectTypeEnum.ALL.getCode());
            }
            dto.setSgSuitMatchCode(dto.getSgSuitSelectType() + "_" + dto.getSgSuitType() + "_" + dto.getSgSuitKey());
        });
        this.clueSuitAttributeService.addClueSuitAttributeList(addDto);
        ClueDeliveryWarehouseBlackEo updateClueDeliveryWarehouseBlackEo = new ClueDeliveryWarehouseBlackEo();
        updateClueDeliveryWarehouseBlackEo.setDr(1);
        ClueDeliveryWarehouseBlackEo selectClueDeliveryWarehouseBlackEo = new ClueDeliveryWarehouseBlackEo();
        selectClueDeliveryWarehouseBlackEo.setDr(0);
        selectClueDeliveryWarehouseBlackEo.setSgClueId(modifyActReqDto.getId());
        this.clueDeliveryWarehouseBlackService.modifyClueDeliveryWarehouseBlackBySelect(updateClueDeliveryWarehouseBlackEo, selectClueDeliveryWarehouseBlackEo);
        if (CollectionUtils.isNotEmpty((Collection)modifyActReqDto.getClueDeliveryWarehouseBlackReqDtoList())) {
            modifyActReqDto.getClueDeliveryWarehouseBlackReqDtoList().forEach(dto -> {
                dto.setId(null);
                dto.setSgClueId(modifyActReqDto.getId());
            });
            this.clueDeliveryWarehouseBlackService.addClueDeliveryWarehouseBlackList(modifyActReqDto.getClueDeliveryWarehouseBlackReqDtoList());
        }
        ClueWarehouseGroupRuleEo updateClueWarehouseGroupRuleEo = new ClueWarehouseGroupRuleEo();
        updateClueWarehouseGroupRuleEo.setDr(1);
        ClueWarehouseGroupRuleEo selectClueWarehouseGroupRuleEo = new ClueWarehouseGroupRuleEo();
        selectClueWarehouseGroupRuleEo.setDr(0);
        selectClueWarehouseGroupRuleEo.setSgClueId(modifyActReqDto.getId());
        this.clueWarehouseGroupRuleService.modifyClueWarehouseGroupRuleBySelect(updateClueWarehouseGroupRuleEo, selectClueWarehouseGroupRuleEo);
        ClueWarehouseGroupEo updateClueWarehouseGroupEo = new ClueWarehouseGroupEo();
        updateClueWarehouseGroupEo.setDr(1);
        ClueWarehouseGroupEo selectClueWarehouseGroupEo = new ClueWarehouseGroupEo();
        selectClueWarehouseGroupEo.setDr(0);
        selectClueWarehouseGroupEo.setSgClueId(modifyActReqDto.getId());
        this.clueWarehouseGroupService.modifyClueWarehouseGroupBySelect(updateClueWarehouseGroupEo, selectClueWarehouseGroupEo);
        ClueWarehouseGroupRuleDeliveryEo updateClueGroupRuleDeliveryEo = new ClueWarehouseGroupRuleDeliveryEo();
        updateClueGroupRuleDeliveryEo.setDr(1);
        ClueWarehouseGroupRuleDeliveryEo selectClueGroupRuleDeliveryEo = new ClueWarehouseGroupRuleDeliveryEo();
        selectClueGroupRuleDeliveryEo.setDr(0);
        selectClueGroupRuleDeliveryEo.setSgClueId(modifyActReqDto.getId());
        this.clueWarehouseGroupRuleDeliveryService.modifyClueWarehouseGroupRuleDeliveryBySelect(updateClueGroupRuleDeliveryEo, selectClueGroupRuleDeliveryEo);
        ArrayList clueWarehouseGroupRuleReqDtoList = new ArrayList();
        modifyActReqDto.getClueWarehouseGroupActReqDtoList().getAdd().forEach(dto -> {
            dto.setId(Long.valueOf(IdGenrator.nextId((long)IdGenrator.getWorkerId(), (long)0L)));
            dto.setSgClueId(modifyActReqDto.getId());
            dto.getClueWarehouseGroupRuleReqDtoList().getAdd().forEach(ruleDto -> {
                ruleDto.setId(null);
                ruleDto.setSgClueId(modifyActReqDto.getId());
                ruleDto.setWarehouseGroupId(dto.getId());
                Long ruleId = this.clueWarehouseGroupRuleService.addClueWarehouseGroupRule((ClueWarehouseGroupRuleReqDto)ruleDto);
                Optional.ofNullable(ruleDto.getClueWarehouseGroupRuleDeliveryReqDtoList()).orElse(Lists.newArrayList()).forEach(deliveryRule -> {
                    deliveryRule.setId(null);
                    deliveryRule.setSgClueId(modifyActReqDto.getId());
                    deliveryRule.setWarehouseGroupRuleId(ruleId);
                    this.clueWarehouseGroupRuleDeliveryService.addClueWarehouseGroupRuleDelivery((ClueWarehouseGroupRuleDeliveryReqDto)deliveryRule);
                });
            });
        });
        this.clueWarehouseGroupService.addClueWarehouseGroupList(modifyActReqDto.getClueWarehouseGroupActReqDtoList().getAdd());
        ClueWarehouseItemBlackListEo updateClueWarehouseItemBlackEo = new ClueWarehouseItemBlackListEo();
        updateClueWarehouseItemBlackEo.setDr(1);
        ClueWarehouseItemBlackListEo selectClueWarehouseItemBlackEo = new ClueWarehouseItemBlackListEo();
        selectClueWarehouseItemBlackEo.setDr(0);
        selectClueWarehouseItemBlackEo.setSgClueId(modifyActReqDto.getId());
        this.clueWarehouseItemBlackListService.modifyClueWarehouseItemBlackListBySelect(updateClueWarehouseItemBlackEo, selectClueWarehouseItemBlackEo);
        if (CollectionUtils.isNotEmpty((Collection)modifyActReqDto.getClueItemBlacklist())) {
            modifyActReqDto.getClueItemBlacklist().forEach(dto -> {
                dto.setId(null);
                dto.setSgClueId(modifyActReqDto.getId());
            });
            this.clueWarehouseItemBlackListService.addClueWarehouseItemBlackListBatch(modifyActReqDto.getClueItemBlacklist());
        }
        return new RestResponse();
    }

    private void checkModifyClueOptParam(ClueModifyActReqDto clueModifyActReqDto) {
        SourceAssert.notNull((Object)clueModifyActReqDto.getId(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u7b56\u7565id"});
    }

    @Override
    public RestResponse<Void> deleteClueOpt(List<Long> clueIdList) {
        SourceAssert.notEmpty(clueIdList, (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u7b56\u7565id\u96c6\u5408"});
        this.clueService.removeClue(String.join((CharSequence)",", (CharSequence[])clueIdList.stream().map(String::valueOf).toArray(String[]::new)), null);
        return new RestResponse();
    }

    @Override
    public RestResponse<Void> openEnable(Long clueId, String enable) {
        SourceAssert.notNull((Object)clueId, (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u7b56\u7565id"});
        SourceAssert.notBlank((String)enable, (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u542f\u7528/\u7981\u7528\u6807\u8bc6"});
        ClueActReqDto clueReqDto = new ClueActReqDto();
        clueReqDto.setId(clueId);
        clueReqDto.setClueEnableStatus(enable);
        this.clueService.modifyClue((ClueReqDto)clueReqDto);
        return new RestResponse();
    }

    private void addAttribute(List<ClueSuitAttributeReqDto> clueSuitAttributeReqDtoList, ClueSuitAttributeModifyReqDto clueSuitAttributeModifyReqDto) {
        if (Objects.nonNull(clueSuitAttributeModifyReqDto)) {
            this.addAttribute(clueSuitAttributeReqDtoList, clueSuitAttributeModifyReqDto.getAdd());
        }
    }

    private void addAttribute(List<ClueSuitAttributeReqDto> clueSuitAttributeReqDtoList, List<ClueSuitAttributeReqDto> addclueSuitAttributeReqDtoList) {
        if (CollectionUtils.isNotEmpty(addclueSuitAttributeReqDtoList)) {
            clueSuitAttributeReqDtoList.addAll(addclueSuitAttributeReqDtoList);
        }
    }
}

