/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.source.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.center.source.api.dto.request.SourceLogDetailReqDto;
import com.dtyunxi.cube.center.source.api.dto.response.SourceLogDetailRespDto;
import com.dtyunxi.cube.center.source.api.exception.SourceAssert;
import com.dtyunxi.cube.center.source.api.exception.SourceExceptionCode;
import com.dtyunxi.cube.center.source.biz.service.ISourceLogDetailService;
import com.dtyunxi.cube.center.source.dao.das.SourceLogDetailDas;
import com.dtyunxi.cube.center.source.dao.eo.SourceLogDetailEo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SourceLogDetailServiceImpl
implements ISourceLogDetailService {
    @Resource
    private SourceLogDetailDas sourceLogDetailDas;

    @Override
    public Long addSourceLogDetail(SourceLogDetailReqDto addReqDto) {
        SourceLogDetailEo sourceLogDetailEo = new SourceLogDetailEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)sourceLogDetailEo);
        this.sourceLogDetailDas.insert((BaseEo)sourceLogDetailEo);
        return sourceLogDetailEo.getId();
    }

    @Override
    public int addSourceLogDetailList(List<? extends SourceLogDetailReqDto> addReqDtoList) {
        ArrayList sourceLogDetailEoList = new ArrayList();
        DtoHelper.dtoList2EoList(addReqDtoList, sourceLogDetailEoList, SourceLogDetailEo.class);
        return this.sourceLogDetailDas.insertBatch(sourceLogDetailEoList);
    }

    @Override
    public void modifySourceLogDetail(SourceLogDetailReqDto modifyReqDto) {
        SourceLogDetailEo sourceLogDetailEo = new SourceLogDetailEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)sourceLogDetailEo);
        this.sourceLogDetailDas.updateSelective((BaseEo)sourceLogDetailEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeSourceLogDetail(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.sourceLogDetailDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public SourceLogDetailRespDto queryById(Long id) {
        SourceLogDetailEo sourceLogDetailEo = (SourceLogDetailEo)this.sourceLogDetailDas.selectByPrimaryKey(id);
        if (sourceLogDetailEo == null) {
            return null;
        }
        SourceLogDetailRespDto sourceLogDetailRespDto = new SourceLogDetailRespDto();
        DtoHelper.eo2Dto((BaseEo)sourceLogDetailEo, (BaseVo)sourceLogDetailRespDto);
        return sourceLogDetailRespDto;
    }

    @Override
    public List<SourceLogDetailRespDto> queryByLogId(Long logId) {
        SourceAssert.notNull((Object)logId, (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u5bfb\u6e90\u65e5\u5fd7id"});
        List eoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.sourceLogDetailDas.filter().eq((Object)"sg_find_log_id", (Object)logId)).eq((Object)"dr", (Object)0)).orderByAsc((Object)"sg_find_opt_sort")).list();
        if (CollectionUtils.isNotEmpty((Collection)eoList)) {
            ArrayList<SourceLogDetailRespDto> respDtoArrayList = new ArrayList<SourceLogDetailRespDto>();
            CubeBeanUtils.copyCollection(respDtoArrayList, (Collection)eoList, SourceLogDetailRespDto.class);
            return respDtoArrayList;
        }
        return null;
    }

    @Override
    public PageInfo<SourceLogDetailRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        SourceLogDetailReqDto sourceLogDetailReqDto = (SourceLogDetailReqDto)JSON.parseObject((String)filter, SourceLogDetailReqDto.class);
        SourceLogDetailEo sourceLogDetailEo = new SourceLogDetailEo();
        DtoHelper.dto2Eo((BaseVo)sourceLogDetailReqDto, (BaseEo)sourceLogDetailEo);
        PageInfo eoPageInfo = this.sourceLogDetailDas.selectPage((BaseEo)sourceLogDetailEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, SourceLogDetailRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

