package com.dtyunxi.finance.api.dto.response;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 快递费合同区域Eo对象
 *
 * @author 天泽
 * @since 2022-11-10
 */
@ApiModel(value = "ExpressCostAreaRespDto", description = "快递费合同区域Eo对象")
public class ExpressCostAreaRespDto extends BaseRespDto {
    /**
     * 主键
     */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
     * 合同id
     */
    @ApiModelProperty(name = "contractId", value = "合同id")
    private Long contractId;
    /**
     * 省份
     */
    @ApiModelProperty(name = "province", value = "省份")
    private String province;
    /**
     * 城市
     */
    @ApiModelProperty(name = "city", value = "城市")
    private String city;
    /**
     * 区/县
     */
    @ApiModelProperty(name = "area", value = "区/县")
    private String area;
    /**
     * 预计到达天数
     */
    @ApiModelProperty(name = "day", value = "预计到达天数")
    private Integer day;
    /**
     * json参数
     */
    @ApiModelProperty(name = "params", value = "json参数")
    private String params;

    @ApiModelProperty(name = "sfDsBkExpressAreaInfo", value = "顺丰电商标快")
    private SfDsBkExpressAreaDto sfDsBkExpressAreaInfo;

    @ApiModelProperty(name = "sfKhTemplateDto", value = "顺丰卡航")
    private SfKhTemplateDto sfKhTemplateDto;

    @ApiModelProperty(name = "sfTkAndStoTemplateDto", value = "顺丰特快和申通快递")
    private SfTkAndStoTemplateDto sfTkAndStoTemplateDto;

    @ApiModelProperty(name = "sfTkPackageTemplateDto", value = "顺丰特快包裹")
    private SfTkPackageTemplateDto sfTkPackageTemplateDto;

    @ApiModelProperty(name = "ztoTemplateDto", value = "中通快递")
    private ZtoTemplateDto ztoTemplateDto;

    @ApiModelProperty(name = "emsTemplateDto", value = "EMS标准快递和EMS快递包裹")
    private EmsTemplateDto emsTemplateDto;

    @ApiModelProperty(name = "sfBkTemplateDto", value = "顺丰标快")
    private SfBkTemplateDto sfBkTemplateDto;

    public SfDsBkExpressAreaDto getSfDsBkExpressAreaInfo() {
        return sfDsBkExpressAreaInfo;
    }

    public void setSfDsBkExpressAreaInfo(SfDsBkExpressAreaDto sfDsBkExpressAreaInfo) {
        this.sfDsBkExpressAreaInfo = sfDsBkExpressAreaInfo;
    }

    public SfKhTemplateDto getSfKhTemplateDto() {
        return sfKhTemplateDto;
    }

    public void setSfKhTemplateDto(SfKhTemplateDto sfKhTemplateDto) {
        this.sfKhTemplateDto = sfKhTemplateDto;
    }

    public SfTkAndStoTemplateDto getSfTkAndStoTemplateDto() {
        return sfTkAndStoTemplateDto;
    }

    public void setSfTkAndStoTemplateDto(SfTkAndStoTemplateDto sfTkAndStoTemplateDto) {
        this.sfTkAndStoTemplateDto = sfTkAndStoTemplateDto;
    }

    public SfTkPackageTemplateDto getSfTkPackageTemplateDto() {
        return sfTkPackageTemplateDto;
    }

    public void setSfTkPackageTemplateDto(SfTkPackageTemplateDto sfTkPackageTemplateDto) {
        this.sfTkPackageTemplateDto = sfTkPackageTemplateDto;
    }

    public ZtoTemplateDto getZtoTemplateDto() {
        return ztoTemplateDto;
    }

    public void setZtoTemplateDto(ZtoTemplateDto ztoTemplateDto) {
        this.ztoTemplateDto = ztoTemplateDto;
    }

    public EmsTemplateDto getEmsTemplateDto() {
        return emsTemplateDto;
    }

    public void setEmsTemplateDto(EmsTemplateDto emsTemplateDto) {
        this.emsTemplateDto = emsTemplateDto;
    }

    public SfBkTemplateDto getSfBkTemplateDto() {
        return sfBkTemplateDto;
    }

    public void setSfBkTemplateDto(SfBkTemplateDto sfBkTemplateDto) {
        this.sfBkTemplateDto = sfBkTemplateDto;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getContractId() {
        return this.contractId;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getProvince() {
        return this.province;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCity() {
        return this.city;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getArea() {
        return this.area;
    }

    public void setDay(Integer day) {
        this.day = day;
    }

    public Integer getDay() {
        return this.day;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public String getParams() {
        return this.params;
    }
}
