package com.dtyunxi.finance.api;

import com.dtyunxi.finance.api.dto.request.ApportionmentConfigSaveReqDto;
import com.dtyunxi.rest.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * 分摊基础配置表服务接口
 *
 * @author jiaye
 * @since 2025-08-20
 */
@Api(tags = {"分摊基础配置表服务"})
@FeignClient(
        contextId = "com-dtyunxi-finance-api-IApportionmentConfigApi",
        name = "${com.dtyunxi.finance.api.name:yundt-cube-center-finance}",
        path = "/v1/apportionment",
        url = "${com.dtyunxi.finance.api:}"
)
public interface IApportionmentConfigApi {


    @PostMapping("/save")
    @ApiOperation(value = "保存分摊基础配置", notes = "保存分摊基础配置")
    RestResponse<Void> saveConfig(@RequestBody @Valid ApportionmentConfigSaveReqDto addReqDto);

    /**
     * 删除分摊基础配置表
     *
     * @param ids        分摊基础配置表删除数据ID
     * @param instanceId 实例ID
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除分摊基础配置表", notes = "删除分摊基础配置表")
    RestResponse<Void> removeApportionmentConfig(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);

}
